/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.compiere.www.WWindowStatus;

public class WStatusArrayList {
    private ArrayList statusArray = new ArrayList();
    public static final String STATUSLIST = "WStatusArrayList";

    public WStatusArrayList(WWindowStatus ws) {
        ws.setStatusName(this.createStatusName());
        this.statusArray.add(ws);
    }

    public static WStatusArrayList get(HttpServletRequest request) {
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return null;
        }
        WStatusArrayList wsl = (WStatusArrayList)sess.getAttribute(STATUSLIST);
        return wsl;
    }

    public void addWSToStatusArray(WWindowStatus ws) {
        ws.setStatusName(this.createStatusName());
        this.statusArray.add(ws);
    }

    public WWindowStatus getWSFromStatusArray(String name) {
        int len = this.statusArray.size();
        if (len == 0) {
            return null;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            WWindowStatus ws = (WWindowStatus)this.statusArray.get(i2);
            if (!ws.getStatusName().equals(name)) continue;
            return ws;
        }
        return null;
    }

    public void deleteFromStatusArray(String name) {
        int len = this.statusArray.size();
        if (len == 0) {
            return;
        }
        int i2 = 0;
        if (i2 < len) {
            WWindowStatus ws = (WWindowStatus)this.statusArray.get(i2);
            if (ws.getStatusName().equals(name)) {
                this.statusArray.remove(i2);
            }
            return;
        }
    }

    public void setStatusArrayItem(int index, WWindowStatus ws) {
        ws.setStatusName("1");
        this.statusArray.set(index, ws);
    }

    public int size() {
        return this.statusArray.size();
    }

    private String createStatusName() {
        int len = this.statusArray.size();
        if (len == 0) {
            return String.valueOf(len + 1);
        }
        int n = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            WWindowStatus ws = (WWindowStatus)this.statusArray.get(i2);
            int j = Integer.parseInt(ws.getStatusName());
            if (j <= n) continue;
            n = j;
        }
        return String.valueOf(++n);
    }
}

