/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WValuePreference
extends HttpServlet {
    private static final long serialVersionUID = 6283213348834944668L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private String errorMessage = null;
    private Properties m_ctx;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_AD_User_ID;
    private int m_AD_Window_ID;
    private String m_Attribute;
    private String m_DisplayAttribute;
    private String m_Value;
    private String m_DisplayValue;
    private int m_DisplayType;
    private MRole m_role;
    private String m_Explination;
    private Boolean m_Client;
    private Boolean m_User;
    private Boolean m_Window;
    private Boolean m_Org;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WValuePreference.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        if (ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String m_UpdateResult = "";
        WebDoc doc = null;
        this.m_ctx = wsc.ctx;
        this.m_AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        this.m_AD_Client_ID = WebUtil.getParameterAsInt(request, "AD_Client_ID");
        this.m_AD_Org_ID = WebUtil.getParameterAsInt(request, "AD_Org_ID");
        this.m_AD_User_ID = WebUtil.getParameterAsInt(request, "AD_User_ID");
        this.m_Attribute = WebUtil.getParameter(request, "Attribute");
        this.m_DisplayAttribute = WebUtil.getParameter(request, "DisplayAtrribute");
        this.m_Value = WebUtil.getParameter(request, "Value");
        this.m_DisplayValue = WebUtil.getParameter(request, "DisplayValue");
        this.m_DisplayType = WebUtil.getParameterAsInt(request, "DisplayType");
        this.m_role = MRole.getDefault(wsc.ctx, false);
        this.m_Client = false;
        this.m_User = false;
        this.m_Window = false;
        this.m_Org = false;
        doc = this.createParameterPage(ws, wsc, request, m_UpdateResult);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDoc doc = null;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String m_UpdateResult = "";
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        this.log.info("This is #1");
        this.m_Client = WebUtil.getParameterAsBoolean(request, "Client");
        this.m_User = WebUtil.getParameterAsBoolean(request, "User");
        this.m_Window = WebUtil.getParameterAsBoolean(request, "Window");
        this.m_Org = WebUtil.getParameterAsBoolean(request, "Org");
        this.log.info("This is #2");
        String m_Action = WebUtil.getParameter(request, "PostAction");
        this.setExplanation();
        this.log.info("This is the m_Action" + m_Action);
        if (m_Action.equals("Delete")) {
            m_UpdateResult = this.delete(this.m_Client, this.m_User, this.m_Window, this.m_Org);
        } else if (m_Action.equals("Add")) {
            m_UpdateResult = this.insert(this.m_Client, this.m_User, this.m_Window, this.m_Org);
        }
        this.log.info("This is the call");
        doc = this.createParameterPage(ws, wsc, request, m_UpdateResult);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createParameterPage(WWindowStatus ws, WebSessionCtx wsc, HttpServletRequest request, String m_UpdateResult) {
        form myForm = null;
        myForm = new form("WValuePreference").setName("valuepreference");
        table table2 = new table("0", "0", "5", "100%", null);
        table2.setID("WValuePrefTable");
        tr line = new tr();
        line.addElement((Element)new td("&nbsp;").setRowSpan(6));
        table2.addElement((Element)line);
        line.addElement((Element)this.getLabel(Msg.translate(this.m_ctx, "Attribute"))).addElement((Element)new td((Element)new input("text", "DisplayAttribute", this.m_DisplayAttribute)));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)this.getLabel(Msg.translate(this.m_ctx, "Key"))).addElement((Element)new td((Element)new input("text", "DisplayAttribute", this.m_DisplayValue)));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td("&nbsp;").setRowSpan(6));
        table tablecheckbox = new table("0", "0", "5", "80%", null);
        line = new tr();
        input checkbox1 = new input("checkbox", "Client", this.m_AD_Client_ID);
        checkbox1.setChecked(this.m_Client.booleanValue());
        checkbox1.setOnClick("updateValuePref('Update');");
        checkbox1.setTagText(Msg.translate(this.m_ctx, "AD_Client_ID"));
        input checkbox2 = new input("checkbox", "Org", this.m_AD_Org_ID);
        checkbox2.setChecked(this.m_Org.booleanValue());
        checkbox2.setOnClick("updateValuePref('Update');");
        checkbox2.setTagText(Msg.translate(this.m_ctx, "AD_Org_ID"));
        input checkbox3 = new input("checkbox", "User", this.m_AD_User_ID);
        checkbox3.setChecked(this.m_User.booleanValue());
        checkbox3.setOnClick("updateValuePref('Update');");
        checkbox3.setTagText(Msg.translate(this.m_ctx, "AD_User_ID"));
        input checkbox4 = new input("checkbox", "Window", this.m_AD_Window_ID);
        checkbox4.setChecked(this.m_Window.booleanValue());
        checkbox4.setOnClick("updateValuePref('Update');");
        checkbox4.setTagText(Msg.translate(this.m_ctx, "AD_Window_ID"));
        line.addElement((Element)new td((Element)checkbox1).setWidth("25%")).addElement((Element)new td((Element)checkbox2).setWidth("25%")).addElement((Element)new td((Element)checkbox3).setWidth("25%")).addElement((Element)new td((Element)checkbox4).setWidth("25%"));
        tablecheckbox.addElement((Element)line);
        table2.addElement((Element)tablecheckbox);
        line = new tr();
        line.addElement((Element)new td("&nbsp;").setRowSpan(6));
        table tableexplination = new table("0", "0", "5", "80%", null);
        this.setExplanation();
        line.addElement((Element)new td(Msg.translate(this.m_ctx, this.m_Explination)).setAlign("center"));
        tableexplination.addElement((Element)line);
        table2.addElement((Element)tableexplination);
        line = new tr();
        line.addElement((Element)new td("&nbsp;").setRowSpan(6));
        table tableresult = new table("0", "0", "5", "80%", null);
        line.addElement((Element)new td(Msg.translate(this.m_ctx, m_UpdateResult)).setAlign("center"));
        tableresult.addElement((Element)line);
        table2.addElement((Element)tableresult);
        line = new tr();
        line.addElement((Element)new td("&nbsp;").setRowSpan(6));
        String textbtn = "Delete";
        if (wsc.ctx != null) {
            textbtn = Msg.getMsg(wsc.ctx, "Delete");
        }
        input restbtn = new input("button", textbtn, "  " + textbtn);
        restbtn.setID(textbtn);
        restbtn.setOnClick("updateValuePref('Delete')");
        restbtn.setClass("deletebtn");
        textbtn = "Submit";
        if (wsc.ctx != null) {
            textbtn = Msg.getMsg(wsc.ctx, "Submit");
        }
        input submitbtn = new input("button", textbtn, "  " + textbtn);
        submitbtn.setID(textbtn);
        submitbtn.setOnClick("updateValuePref('Add')");
        submitbtn.setClass("submitbtn");
        textbtn = "Close";
        if (wsc.ctx != null) {
            textbtn = Msg.getMsg(wsc.ctx, "Close");
        }
        input closebtn = new input("submit", textbtn, "  " + textbtn);
        closebtn.setID(textbtn);
        closebtn.setClass("closebtn");
        closebtn.setOnClick("self.close();return false;");
        table tablebuttons = new table("0", "0", "5", "100%", null);
        tablebuttons.addElement((Element)new tr().addElement((Element)new td(null, "center", "middle", false, (Element)restbtn)).addElement((Element)new td(null, "center", "middle", false, (Element)submitbtn)).addElement((Element)new td(null, "center", "middle", false, (Element)closebtn)));
        table2.addElement((Element)tablebuttons);
        myForm.addElement((Element)table2);
        WebDoc doc = WebDoc.createPopup("Set Value Preference");
        td center = doc.addWindowCenter(false);
        myForm.addElement((Element)new input("hidden", "PostAction", "")).addElement((Element)table2);
        center.addElement((Element)myForm);
        return doc;
    }

    private td createSelectField(String m_columnName, option[] options) {
        select sel = new select(m_columnName, options);
        sel.setID(m_columnName);
        sel.setDisabled(false);
        sel.setClass("Cmandatory");
        return this.createTD((Element)sel);
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        return td2;
    }

    public td getLabel(String mLabel) {
        label myLabel = new label(mLabel + "F", null, Util.maskHTML(mLabel));
        myLabel.setID(mLabel + "L");
        td td2 = new td().addElement((Element)myLabel).setAlign("right").setVAlign("top");
        return td2;
    }

    private void setExplanation() {
        StringBuffer expl = new StringBuffer("For ");
        if (this.m_Client.booleanValue() && this.m_Org.booleanValue()) {
            expl.append("this Client and Organization");
        } else if (this.m_Client.booleanValue() && !this.m_Org.booleanValue()) {
            expl.append("all Organizations of this Client");
        } else if (!this.m_Client.booleanValue() && this.m_Org.booleanValue()) {
            this.m_Org = false;
            expl.append("entire System");
        } else {
            expl.append("entire System");
        }
        if (this.m_User.booleanValue()) {
            expl.append(", this User");
        } else {
            expl.append(", all Users");
        }
        if (this.m_Window.booleanValue()) {
            expl.append(" and this Window");
        } else {
            expl.append(" and all Windows");
        }
        if (Env.getLanguage(this.m_ctx).isBaseLanguage()) {
            this.m_Explination = expl.toString();
        }
    }

    public String delete(Boolean m_Client, Boolean m_User, Boolean m_Window, Boolean m_Org) {
        String m_UpdateResult;
        this.log.info("");
        StringBuffer sql = new StringBuffer("DELETE FROM AD_Preference WHERE ");
        sql.append("AD_Client_ID=").append(m_Client != false ? this.m_AD_Client_ID : 0);
        sql.append(" AND AD_Org_ID=").append(m_Org != false ? this.m_AD_Org_ID : 0);
        if (m_User.booleanValue()) {
            sql.append(" AND AD_User_ID=").append(this.m_AD_User_ID);
        } else {
            sql.append(" AND AD_User_ID IS NULL");
        }
        if (m_Window.booleanValue()) {
            sql.append(" AND AD_Window_ID=").append(this.m_AD_Window_ID);
        } else {
            sql.append(" AND AD_Window_ID IS NULL");
        }
        sql.append(" AND Attribute='").append(this.m_Attribute).append("'");
        this.log.fine(sql.toString());
        int no = DB.executeUpdate(sql.toString(), null);
        if (no > 0) {
            Env.setContext(this.m_ctx, this.getContextKey(m_Window), (String)null);
            m_UpdateResult = no + " Record Deleted";
        } else {
            m_UpdateResult = "Record not found for deletion";
        }
        return m_UpdateResult;
    }

    private String getContextKey(Boolean m_Window) {
        if (m_Window.booleanValue()) {
            return "P" + this.m_AD_Window_ID + "|" + this.m_Attribute;
        }
        return "P|" + this.m_Attribute;
    }

    public String insert(Boolean m_Client, Boolean m_User, Boolean m_Window, Boolean m_Org) {
        this.log.info("");
        int no = 0;
        String m_UpdateResult = this.delete(m_Client, m_User, m_Window, m_Org);
        if (this.m_Value == null || this.m_Value.length() == 0) {
            if (DisplayType.isLookup(this.m_DisplayType)) {
                this.m_Value = "-1";
            } else if (DisplayType.isDate(this.m_DisplayType)) {
                this.m_Value = " ";
            } else {
                m_UpdateResult = m_UpdateResult + " Can not update record";
                return m_UpdateResult;
            }
        }
        int Client_ID = m_Client != false ? this.m_AD_Client_ID : 0;
        int Org_ID = m_Org != false ? this.m_AD_Org_ID : 0;
        int AD_Preference_ID = DB.getNextID(this.m_ctx, "AD_Preference", null);
        StringBuffer sql = new StringBuffer("INSERT INTO AD_Preference (AD_Preference_ID, AD_Client_ID, AD_Org_ID, IsActive, Created,CreatedBy,Updated,UpdatedBy,AD_Window_ID, AD_User_ID, Attribute, Value) VALUES (");
        sql.append(AD_Preference_ID).append(",").append(Client_ID).append(",").append(Org_ID).append(", 'Y',SysDate,").append(this.m_AD_User_ID).append(",SysDate,").append(this.m_AD_User_ID).append(", ");
        if (m_Window.booleanValue()) {
            sql.append(this.m_AD_Window_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        if (m_User.booleanValue()) {
            sql.append(this.m_AD_User_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        sql.append(DB.TO_STRING(this.m_Attribute)).append(",").append(DB.TO_STRING(this.m_Value)).append(")");
        this.log.fine(sql.toString());
        no = DB.executeUpdate(sql.toString(), null);
        m_UpdateResult = no > 0 ? no + " Record Inserted" : "Record not Inserted";
        return m_UpdateResult;
    }
}

