/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h6;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;

public class WWorkflow
extends HttpServlet {
    private static final long serialVersionUID = 7220553249782175533L;
    public static final int SIZE = 3;
    public static final int SPACE = 0;
    public static final int ARROW_FORWARD = -1;
    public static final int ARROW_BACKWARD = -3;
    public static final int ARROW_DOWN = -2;
    public static final String WORKFLOW = "Workflow";
    public static final String NODES = "Nodes";
    public static final String NODES_ID = "Nodes_ID";
    public static final String IMAGE_MAP = "Image_Map";
    public static final String ACTIVE_NODE = "Active_Node";
    public static final String M_Command = "MCommand";
    public static final String J_Command = "JCommand";
    public static final String FIRST = "Start";
    public static final String NEXT = "Next";
    public static final String BACK = "Back";
    public static final String LAST = "End";
    private static final String FORM_NAME = "MForm";
    private static final String TARGET_WINDOW = "WWindow";
    private static final String FORM_ACTION = "/adempiere/WWorkflow";
    private static String AD_Language = null;
    Properties ctx = null;
    private static int s_WindowNo = 1;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WWorkflow.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        this.ctx = wsc.ctx;
        if (this.ctx == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        AD_Language = Env.getAD_Language(this.ctx);
        int AD_Workflow_ID = this.getAD_Workflow_ID(AD_Menu_ID);
        this.loadWorkflow(this.ctx, AD_Workflow_ID, sess);
        MWorkflow wf = (MWorkflow)sess.getAttribute(WORKFLOW);
        MWFNode[] nodes = (MWFNode[])sess.getAttribute(NODES);
        ArrayList nodes_ID = (ArrayList)sess.getAttribute(NODES_ID);
        int[][] imageMap = (int[][])sess.getAttribute(IMAGE_MAP);
        int activeNode = (Integer)sess.getAttribute(ACTIVE_NODE);
        WebDoc doc = this.preparePage("loginInfo");
        doc = this.createLayout(doc, wf, activeNode, nodes, nodes_ID, imageMap);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Properties ctx = wsc.ctx;
        if (ctx == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        MWorkflow wf = (MWorkflow)sess.getAttribute(WORKFLOW);
        MWFNode[] nodes = (MWFNode[])sess.getAttribute(NODES);
        ArrayList nodes_ID = (ArrayList)sess.getAttribute(NODES_ID);
        int[][] imageMap = (int[][])sess.getAttribute(IMAGE_MAP);
        int activeNode = (Integer)sess.getAttribute(ACTIVE_NODE);
        String m_command = request.getParameter(M_Command);
        int j_command = WebUtil.getParameterAsInt(request, J_Command);
        this.executeCommand(m_command, j_command, wf, activeNode, nodes, nodes_ID, sess);
        wf = (MWorkflow)sess.getAttribute(WORKFLOW);
        nodes = (MWFNode[])sess.getAttribute(NODES);
        nodes_ID = (ArrayList)sess.getAttribute(NODES_ID);
        imageMap = (int[][])sess.getAttribute(IMAGE_MAP);
        activeNode = (Integer)sess.getAttribute(ACTIVE_NODE);
        WebDoc doc = this.preparePage("loginInfo");
        doc = this.createLayout(doc, wf, activeNode, nodes, nodes_ID, imageMap);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private int[][] generateImageMap(ArrayList nodes_ID) {
        int rowTotal_count;
        int numOfNode = nodes_ID.size();
        int rowNode_count = (int)Math.ceil((float)numOfNode / 3.0f);
        int ROW = rowTotal_count = 2 * rowNode_count - 1;
        int COL = 5;
        int[][] imageMap = new int[ROW][COL];
        boolean isEmptyRow_Right = true;
        boolean isForwardRow = true;
        int row_Last = ROW - 1;
        int index_Row = 0;
        int index_Node = 0;
        for (index_Row = 0; index_Row < ROW; ++index_Row) {
            int i2;
            int j;
            if (index_Row % 2 != 0) {
                if (isEmptyRow_Right) {
                    imageMap[index_Row][COL - 1] = -2;
                    isEmptyRow_Right = false;
                } else {
                    imageMap[index_Row][0] = -2;
                    isEmptyRow_Right = true;
                }
            }
            if (index_Row % 2 != 0) continue;
            if (isForwardRow) {
                isForwardRow = false;
                if (index_Row == row_Last) {
                    j = 0;
                    for (i2 = index_Node; i2 < numOfNode; ++i2) {
                        imageMap[index_Row][j++] = (Integer)nodes_ID.get(i2);
                        if (i2 == numOfNode - 1) continue;
                        imageMap[index_Row][j++] = -1;
                    }
                    continue;
                }
                for (i2 = 0; i2 < COL; ++i2) {
                    imageMap[index_Row][i2] = i2 % 2 == 0 ? (Integer)nodes_ID.get(index_Node++) : -1;
                }
                continue;
            }
            isForwardRow = true;
            if (index_Row == row_Last) {
                j = 0;
                for (i2 = index_Node; i2 < numOfNode; ++i2) {
                    imageMap[index_Row][COL - 1 - j++] = (Integer)nodes_ID.get(i2);
                    if (i2 == numOfNode - 1) continue;
                    imageMap[index_Row][COL - 1 - j++] = -3;
                }
                continue;
            }
            j = 0;
            for (i2 = 0; i2 < COL; ++i2) {
                imageMap[index_Row][COL - 1 - i2] = i2 % 2 == 0 ? (Integer)nodes_ID.get(index_Node++) : -3;
            }
        }
        return imageMap;
    }

    private table printWorkflow(int activeNode, MWorkflow wf, MWFNode[] nodes, ArrayList nodes_ID, int[][] imageMap) {
        table imageTable = new table();
        int ROW = imageMap.length;
        int COL = imageMap[0].length;
        for (int i2 = 0; i2 < ROW; ++i2) {
            tr aRow = new tr();
            for (int j = 0; j < COL; ++j) {
                td grid = new td();
                grid.setAlign("center");
                img spaceImage = WWorkflow.createWorkflowImage("Spacer", 0, null, true);
                img arrowForwardImage = WWorkflow.createWorkflowImage("ArrowFW_", 0, null, true);
                img arrowBackwardImage = WWorkflow.createWorkflowImage("ArrowBW_", 0, null, true);
                img arrowDownImage = WWorkflow.createWorkflowImage("ArrowDown_", 0, null, true);
                img normalNodeImage = null;
                img activeNodeImage = null;
                if (imageMap[i2][j] <= 0) {
                    if (imageMap[i2][j] == -1) {
                        grid.addElement((Element)arrowForwardImage);
                    }
                    if (imageMap[i2][j] == -3) {
                        grid.addElement((Element)arrowBackwardImage);
                    }
                    if (imageMap[i2][j] == -2) {
                        grid.addElement((Element)arrowDownImage);
                    }
                    if (imageMap[i2][j] == 0) {
                        grid.addElement((Element)spaceImage);
                    }
                } else {
                    int AD_Window_ID = 0;
                    String url = "";
                    String Target_Window = "";
                    String parameters = "";
                    String js_command = "";
                    if (imageMap[i2][j] == activeNode) {
                        AD_Window_ID = nodes[this.getIndex(imageMap[i2][j], nodes_ID)].getAD_Window_ID();
                        url = "'WWindow?AD_Window_ID=" + AD_Window_ID;
                        Target_Window = "'WWindow" + AD_Window_ID + "'";
                        System.out.println("WorkFlow if(true)======" + url);
                        parameters = url + "'," + Target_Window;
                        js_command = "popUp(" + parameters + ");submit()";
                        activeNodeImage = WWorkflow.createWorkflowImage("mWorkFlow_", imageMap[i2][j], js_command, true);
                        grid.addElement((Element)activeNodeImage);
                        grid.addElement((Element)new br());
                        grid.addElement("" + imageMap[i2][j]);
                        grid.addElement((Element)new br());
                        grid.addElement("<font color=blue>" + nodes[this.getIndex(imageMap[i2][j], nodes_ID)].getName() + "</font>");
                    } else {
                        AD_Window_ID = nodes[this.getIndex(imageMap[i2][j], nodes_ID)].getAD_Window_ID();
                        url = "'WWindow?AD_Window_ID=" + AD_Window_ID;
                        Target_Window = "'WWindow" + AD_Window_ID + "'";
                        System.out.println("WorkFlow else======" + url);
                        parameters = url + "'," + Target_Window;
                        js_command = "popUp(" + parameters + ");submit()";
                        normalNodeImage = WWorkflow.createWorkflowImage("mWorkFlow_", imageMap[i2][j], js_command, false);
                        grid.addElement((Element)normalNodeImage);
                        grid.addElement((Element)new br());
                        grid.addElement("" + imageMap[i2][j]);
                        grid.addElement((Element)new br());
                        grid.addElement(nodes[this.getIndex(imageMap[i2][j], nodes_ID)].getName());
                    }
                }
                aRow.addElement((Element)grid);
            }
            imageTable.addElement((Element)aRow);
        }
        return imageTable;
    }

    private table printDescription(int activeNode, MWorkflow wf, MWFNode[] nodes, ArrayList nodes_ID) {
        table desTable = new table();
        String WFName = "";
        String WFDescription = "";
        if (activeNode < 0) {
            WFName = wf.getName();
            WFDescription = wf.getHelp();
        } else {
            WFName = nodes[this.getIndex(activeNode, nodes_ID)].getName();
            WFDescription = nodes[this.getIndex(activeNode, nodes_ID)].getHelp();
        }
        tr aRow = new tr();
        td aGrid = new td();
        aGrid.addElement((Element)new h6(WFName));
        aGrid.addElement((Element)new br());
        aGrid.addElement(WFDescription);
        desTable.addElement((Element)aRow.addElement((Element)aGrid));
        return desTable;
    }

    private int getIndex(int node_ID, ArrayList nodes_ID) {
        int index = 0;
        for (int i2 = 0; i2 < nodes_ID.size(); ++i2) {
            int element_ID = (Integer)nodes_ID.get(i2);
            if (element_ID != node_ID) continue;
            index = i2;
        }
        return index;
    }

    private form printControlPanel(int activeNode, MWorkflow wf, MWFNode[] nodes, ArrayList nodes_ID) {
        form myForm = new form(FORM_ACTION, "post", "application/x-www-form-urlencoded");
        myForm.addElement((Element)new input("hidden", M_Command, ""));
        myForm.addElement((Element)new input("hidden", J_Command, ""));
        myForm.setTarget(TARGET_WINDOW);
        myForm.setName(FORM_NAME);
        boolean isFirst = wf.isFirst(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
        boolean isLast = wf.isLast(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
        int First_Window_ID = wf.getFirstNode().getAD_Window_ID();
        int Last_Window_ID = nodes[nodes.length - 1].getAD_Window_ID();
        int Back_Window_ID = 0;
        int Next_Window_ID = 0;
        int index = 0;
        if (!isFirst) {
            index = activeNode >= 0 ? this.getIndex(activeNode, nodes_ID) - 1 : 0;
            Back_Window_ID = nodes[index].getAD_Window_ID();
        }
        if (!isLast) {
            index = activeNode >= 0 ? this.getIndex(activeNode, nodes_ID) + 1 : 0;
            Next_Window_ID = nodes[index].getAD_Window_ID();
        }
        boolean enableFirst = true;
        boolean enableBack = true;
        boolean enableNext = true;
        boolean enableLast = true;
        if (isFirst) {
            enableBack = false;
            enableFirst = false;
        }
        if (isLast) {
            enableNext = false;
            enableLast = false;
        }
        td firstImage = new td();
        td backImage = new td();
        td nextImage = new td();
        td lastImage = new td();
        String url = "'WWindow?AD_Window_ID=" + First_Window_ID + "'";
        String Target_Window = "'WWindow" + First_Window_ID + "'";
        String parameters = url + "," + Target_Window;
        String js_command = "popUp(" + parameters + ");submit()";
        firstImage.addElement((Element)WWorkflow.createControlButtonImage(FIRST, js_command, enableFirst));
        url = "'WWindow?AD_Window_ID=" + Back_Window_ID + "'";
        Target_Window = "'WWindow" + Back_Window_ID + "'";
        parameters = url + "," + Target_Window;
        js_command = "popUp(" + parameters + ");submit()";
        backImage.addElement((Element)WWorkflow.createControlButtonImage(BACK, js_command, enableBack));
        url = "'WWindow?AD_Window_ID=" + Next_Window_ID + "'";
        Target_Window = "'WWindow" + Next_Window_ID + "'";
        parameters = url + "," + Target_Window;
        js_command = "popUp(" + parameters + ");submit()";
        nextImage.addElement((Element)WWorkflow.createControlButtonImage(NEXT, js_command, enableNext));
        url = "'WWindow?AD_Window_ID=" + Last_Window_ID + "'";
        Target_Window = "'WWindow" + Last_Window_ID + "'";
        parameters = url + "," + Target_Window;
        js_command = "popUp(" + parameters + ");submit()";
        lastImage.addElement((Element)WWorkflow.createControlButtonImage(LAST, js_command, enableLast));
        tr aRow = new tr();
        aRow.addElement((Element)firstImage);
        aRow.addElement((Element)backImage);
        aRow.addElement((Element)nextImage);
        aRow.addElement((Element)lastImage);
        myForm.addElement((Element)new table().addElement((Element)aRow));
        return myForm;
    }

    private static img createControlButtonImage(String name, String js_command, boolean enabled) {
        StringBuffer imgName = new StringBuffer("wf" + name);
        if (!enabled) {
            imgName.append("D");
        }
        imgName.append("24.gif");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (enabled) {
            img2.setAlt(Msg.getMsg(AD_Language, name));
        }
        img2.setID("imgButton");
        if (js_command != null && js_command.length() > 0 && enabled) {
            img2.setOnClick("document.MForm.MCommand.value='" + name + "';" + js_command);
        }
        return img2;
    }

    private static img createWorkflowImage(String name, int activeNode, String js_command, boolean pressed) {
        StringBuffer imgName = new StringBuffer(name);
        imgName.append("WF");
        imgName.append(".gif");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (!imgName.toString().startsWith("Spacer") && !imgName.toString().startsWith("Arrow")) {
            if (!pressed) {
                img2.setID("imgButton");
            } else {
                img2.setID("imgButtonPressed");
            }
        }
        if (js_command != null && js_command.length() > 0 && activeNode != 0) {
            String js_command_front = "document.MForm.JCommand.value='" + activeNode + "'; ";
            js_command_front = js_command_front + "document." + FORM_NAME + ".submit();";
            img2.setOnClick(js_command_front + js_command);
        }
        return img2;
    }

    private WebDoc createLayout(WebDoc doc, MWorkflow wf, int activeNode, MWFNode[] nodes, ArrayList nodes_ID, int[][] imageMap) {
        body b2 = doc.getBody();
        b2.addElement((Element)this.printWorkflow(activeNode, wf, nodes, nodes_ID, imageMap));
        b2.addElement((Element)new hr());
        b2.addElement((Element)this.printDescription(activeNode, wf, nodes, nodes_ID));
        b2.addElement((Element)new br());
        b2.addElement((Element)this.printControlPanel(activeNode, wf, nodes, nodes_ID));
        return doc;
    }

    private void loadWorkflow(Properties ctx, int AD_Workflow_ID, HttpSession sess) {
        MWorkflow wf = new MWorkflow(ctx, AD_Workflow_ID, null);
        MWFNode[] nodes = wf.getNodes(true, Env.getContextAsInt(ctx, "#AD_Client_ID"));
        MWFNode wfn = null;
        ArrayList<Integer> nodes_ID = new ArrayList<Integer>();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            wfn = nodes[i2];
            nodes_ID.add(new Integer(wfn.getAD_WF_Node_ID()));
        }
        int[][] imageMap = this.generateImageMap(nodes_ID);
        sess.setAttribute(WORKFLOW, (Object)wf);
        sess.setAttribute(NODES, (Object)nodes);
        sess.setAttribute(NODES_ID, nodes_ID);
        sess.setAttribute(IMAGE_MAP, (Object)imageMap);
        sess.setAttribute(ACTIVE_NODE, (Object)new Integer(-999));
    }

    private void executeCommand(String m_command, int j_command, MWorkflow wf, int activeNode, MWFNode[] nodes, ArrayList nodes_ID, HttpSession sess) {
        if (j_command != 0) {
            sess.setAttribute(ACTIVE_NODE, (Object)new Integer(j_command));
            return;
        }
        this.debug(m_command, "m_command in executeCommand");
        boolean isFirst = wf.isFirst(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
        boolean isLast = wf.isLast(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
        boolean notReady = false;
        int updatedActiveNode = activeNode;
        if (activeNode < 0) {
            notReady = true;
        }
        if (notReady) {
            updatedActiveNode = (Integer)nodes_ID.get(0);
        } else {
            if (m_command.equals(NEXT)) {
                updatedActiveNode = notReady ? ((Integer)nodes_ID.get(0)).intValue() : wf.getNext(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
            }
            if (m_command.equals(BACK)) {
                updatedActiveNode = notReady ? ((Integer)nodes_ID.get(0)).intValue() : wf.getPrevious(activeNode, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
            }
            if (m_command.equals(FIRST)) {
                updatedActiveNode = (Integer)nodes_ID.get(0);
            }
            if (m_command.equals(LAST)) {
                updatedActiveNode = wf.getLast(0, Env.getContextAsInt(this.ctx, "#AD_Client_ID"));
            }
        }
        sess.setAttribute(ACTIVE_NODE, (Object)new Integer(updatedActiveNode));
    }

    private int getAD_Workflow_ID(int AD_Menu_ID) {
        int AD_Workflow_ID = 0;
        String sql = "SELECT AD_Workflow_ID FROM AD_Menu WHERE AD_Menu_ID=? AND Action='F'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql);
            pstmt.setInt(1, AD_Menu_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                AD_Workflow_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return AD_Workflow_ID;
    }

    private WebDoc preparePage(String loginInfo) {
        WebDoc doc = WebDoc.create(WORKFLOW);
        head header = doc.getHead();
        body b2 = doc.getBody();
        header.addElement((Element)new script("", WebEnv.getBaseDirectory("/js/window.js")));
        header.addElement((Element)new link().setRel("stylesheet").setHref(WebEnv.getBaseDirectory("/css/window.css")));
        String title = "Workflow - " + loginInfo;
        b2.addElement((Element)new script("top.document.title='" + title + "';"));
        return doc;
    }

    private void debug(Object variable, String name) {
        if (variable != null) {
            System.out.println("*************" + name + "=" + variable);
        } else {
            System.out.println("*************" + name + " is null");
        }
    }

    private void printMap(int[][] map) {
        int ROW = map.length;
        int COL = map[0].length;
        for (int row = 0; row < ROW; ++row) {
            for (int col = 0; col < COL; ++col) {
                System.out.print(" " + map[row][col] + " ");
            }
            System.out.println(" ");
        }
    }
}

