/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WAttachment;
import org.compiere.www.WWindowStatus;

public class WZoom
extends HttpServlet {
    private static final long serialVersionUID = 7075820778158654964L;
    private static CLogger log = CLogger.getCLogger(WAttachment.class);
    public static final String P_Record_ID = "AD_Record_ID";
    public static final String P_Table_ID = "AD_Table_ID";
    private static int s_WindowNo = 3;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WZoom.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(false);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (session == null || ws == null) {
            doc = WebDoc.createPopup("No Context");
            doc.addPopupClose(ws.ctx);
        } else {
            Object error = null;
            int AD_Record_ID = WebUtil.getParameterAsInt(request, P_Record_ID);
            int AD_Table_ID = WebUtil.getParameterAsInt(request, P_Table_ID);
            if (AD_Record_ID == 0 || AD_Table_ID == 0) {
                doc = WebDoc.createPopup("Invalid Record ID or Table ID");
                doc.addPopupClose(ws.ctx);
            } else {
                doc = WZoom.createPage(ws.ctx, request, AD_Record_ID, AD_Table_ID);
            }
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession sess = request.getSession(false);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        doc = WebDoc.create("Help - Post Not Implemented");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public static WebDoc createPage(Properties ctx, HttpServletRequest request, int AD_Record_ID, int AD_Table_ID) {
        GridWindowVO mWindowVO;
        String whereClause;
        WebDoc doc = null;
        String TableName = null;
        int AD_Window_ID = 0;
        int PO_Window_ID = 0;
        String sql = "SELECT TableName, AD_Window_ID, PO_Window_ID FROM AD_Table WHERE AD_Table_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                TableName = rs.getString(1);
                AD_Window_ID = rs.getInt(2);
                PO_Window_ID = rs.getInt(3);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (TableName == null || AD_Window_ID == 0) {
            doc = WebDoc.createPopup("No Context");
            doc.addPopupClose(ctx);
            return doc;
        }
        boolean isSOTrx = true;
        if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx(TableName, whereClause = TableName + "_ID=" + AD_Record_ID))) {
            AD_Window_ID = PO_Window_ID;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (ws != null) {
            int WindowNo = ws.mWindow.getWindowNo();
            log.fine("Disposing - WindowNo=" + WindowNo + ", ID=" + ws.mWindow.getAD_Window_ID());
            ws.mWindow.dispose();
            Env.clearWinContext(wsc.ctx, WindowNo);
        }
        if ((mWindowVO = GridWindowVO.create(ctx, s_WindowNo++, AD_Window_ID, 0)) == null) {
            String msg = Msg.translate(ctx, "AD_Window_ID") + " " + Msg.getMsg(ctx, "NotFound") + ", ID=" + AD_Window_ID + "/" + 0;
            doc = WebDoc.createPopup(msg);
            doc.addPopupClose(ctx);
            return doc;
        }
        ws = new WWindowStatus(mWindowVO);
        sess.setAttribute("WWindowStatus", (Object)ws);
        ws.mWindow.initTab(ws.curTab.getTabNo());
        ws.curTab.setQuery(MQuery.getEqualQuery(TableName + "_ID", AD_Record_ID));
        ws.curTab.query(false);
        return doc;
    }
}

