/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.util.Date;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLocator;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.www.WWindow;

public class WebField {
    protected static CLogger log = CLogger.getCLogger(WWindow.class);
    public static final String C_MANDATORY = "Cmandatory";
    public static final String C_ERROR = "Cerror";
    private WebSessionCtx m_wsc;
    private String m_columnName;
    private String m_name;
    private String m_description;
    private String m_callOut;
    private GridTab m_Tab;
    private GridField m_Field;
    private MRole m_Role;
    private Object m_defaultObject;
    private int m_displayType;
    private int m_processID;
    private int m_windowID;
    private int m_tableID;
    private int m_recordID;
    private int m_fieldLength;
    private int m_displayLength;
    private boolean m_longField;
    private boolean m_readOnly;
    private boolean m_mandatory;
    private boolean m_error;
    private boolean m_hasDependents;
    private boolean m_hasCallout;
    private int m_fieldNumber;
    private Object m_dataDisplay;
    private Lookup m_lookup;

    public WebField(WebSessionCtx wsc, String columnName, String name, String description, int displayType, int fieldLength, int displayLength, boolean longField, boolean readOnly, boolean mandatory, boolean error, boolean hasDependents, boolean hasCallout, int AD_Process_ID, int AD_Window_ID, int AD_Record_ID, int AD_Table_ID, int fieldNumber, Object defaultvalue, String callOut, GridTab mTab, GridField mField, MRole mRole) {
        this.m_wsc = wsc;
        this.m_columnName = columnName;
        this.m_name = name == null || name.length() == 0 ? columnName : name;
        if (description != null && description.length() > 0) {
            this.m_description = description;
        }
        this.m_defaultObject = defaultvalue;
        this.m_displayType = displayType;
        this.m_processID = AD_Process_ID;
        this.m_windowID = AD_Window_ID;
        this.m_tableID = AD_Table_ID;
        this.m_recordID = AD_Record_ID;
        this.m_fieldLength = fieldLength;
        this.m_displayLength = displayLength;
        this.m_displayLength = this.m_displayLength <= 22 ? 22 : 44;
        this.m_longField = longField;
        this.m_readOnly = readOnly;
        this.m_mandatory = mandatory;
        this.m_error = error;
        this.m_hasDependents = hasDependents;
        this.m_hasCallout = hasCallout;
        this.m_callOut = callOut;
        this.m_fieldNumber = fieldNumber;
        this.m_Tab = mTab;
        this.m_Field = mField;
        this.m_Role = mRole;
    }

    public td getLabel() {
        if (this.m_displayType == 20 || this.m_displayType == 28) {
            return new td(WebEnv.NBSP);
        }
        label myLabel = new label(this.m_columnName + "F", null, Util.maskHTML(this.m_name));
        myLabel.setID(this.m_columnName + "L");
        if (this.m_description != null) {
            myLabel.setTitle(Util.maskHTML(this.m_description));
        }
        td td2 = new td().addElement((Element)myLabel).setAlign("right").setVAlign("top");
        return td2;
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        if (this.m_longField) {
            td2.setColSpan(3);
        }
        return td2;
    }

    public td getField(Lookup lookup, Object data) {
        String dataValue;
        this.m_lookup = lookup;
        String string = dataValue = data == null ? "" : data.toString();
        if (this.m_displayType == 30 || this.m_displayType == 21 || this.m_displayType == 25 || this.m_displayType == 35) {
            String dataDisplay = "";
            if (lookup != null && data != null) {
                dataDisplay = lookup.getDisplay(data);
            }
            return this.getPopupField(dataDisplay, dataValue);
        }
        if (DisplayType.isLookup(this.m_displayType) || this.m_displayType == 31) {
            return this.getSelectField(lookup, dataValue);
        }
        if (this.m_displayType == 20) {
            return this.getCheckField(dataValue);
        }
        if (this.m_displayType == 28) {
            return this.getButtonField();
        }
        if (DisplayType.isDate(this.m_displayType)) {
            return this.getPopupDateField(data);
        }
        if (DisplayType.isNumeric(this.m_displayType)) {
            return this.getNumberField(data);
        }
        if (this.m_displayType == 14) {
            return this.getTextField(dataValue, 3);
        }
        if (this.m_displayType == 36) {
            return this.getTextField(dataValue, 10);
        }
        if (this.m_displayType == 34) {
            return this.getTextField(dataValue, 15);
        }
        if (this.m_displayType == 33) {
            return this.getAssignmentField(data);
        }
        return this.getStringField(dataValue);
    }

    private td getStringField(String data) {
        input string = null;
        Boolean isEncrypted = false;
        if (this.m_Field != null) {
            isEncrypted = this.m_Field.isEncryptedField();
        }
        string = isEncrypted != false ? new input("password", this.m_columnName, Util.maskHTML(data)) : new input("text", this.m_columnName, Util.maskHTML(data));
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getTextField(String data, int rows) {
        textarea text = new textarea(this.m_columnName, rows, this.m_displayLength).addElement(Util.maskHTML(data));
        text.setID(this.m_columnName + "F");
        text.setDisabled(this.m_readOnly);
        if (this.m_error) {
            text.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            text.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            text.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)text);
    }

    private td getDateField(Object data) {
        String formattedData = "";
        if (data != null) {
            formattedData = this.m_displayType == 16 ? this.m_wsc.dateTimeFormat.format(data) : this.m_wsc.dateFormat.format(data);
        }
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getAssignmentField(Object data) {
        input string = new input("text", this.m_columnName, Util.maskHTML(""));
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(true);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string).addElement("Not Yet Supported");
    }

    private td getNumberField(Object data) {
        String formattedData = "";
        formattedData = data == null ? (this.m_displayType == 12 ? this.m_wsc.amountFormat.format(0.0) : (this.m_displayType == 22 || this.m_displayType == 37 ? this.m_wsc.numberFormat.format(0.0) : (this.m_displayType == 11 ? this.m_wsc.integerFormat.format(0L) : "0"))) : (this.m_displayType == 29 ? this.m_wsc.quantityFormat.format(data) : (this.m_displayType == 11 ? this.m_wsc.integerFormat.format(data) : data.toString()));
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getCheckField(String data) {
        boolean check = data != null && (data.equals("true") || data.equals("Y"));
        input cb = new input("checkbox", this.m_columnName, "true").setChecked(check).addElement(this.m_name);
        cb.setID(this.m_columnName + "F");
        cb.setDisabled(this.m_readOnly);
        if (this.m_error) {
            cb.setClass(C_ERROR);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            cb.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)cb);
    }

    private td getPopupField(String dataDisplay, String dataValue) {
        log.info("0");
        input hidden = new input("hidden", this.m_columnName, dataValue);
        hidden.setID(this.m_columnName + "D");
        input display = null;
        this.m_dataDisplay = null;
        display = new input("text", this.m_columnName + "F", Util.maskHTML(dataDisplay));
        this.m_dataDisplay = dataDisplay;
        display.setID(this.m_columnName + "F");
        display.setReadOnly(this.m_readOnly);
        input button2 = new input("image", this.m_columnName + "B", "x");
        button2.setID(this.m_columnName + "B");
        String gif = "PickOpen10.gif";
        if (this.m_displayType == 21) {
            gif = "Location10.gif";
        } else if (this.m_displayType == 25) {
            gif = "Account10.gif";
        } else if (this.m_columnName.equals("C_BPartner_ID")) {
            gif = "BPartner10.gif";
        } else if (this.m_columnName.equals("M_Product_ID")) {
            gif = "Product10.gif";
        }
        button2.setSrc(WebEnv.getImageDirectory(gif));
        button2.setBorder(1);
        if (this.m_displayType == 21) {
            button2.setOnClick("startLocation('" + this.m_columnName + "');return false;");
        } else if (this.m_displayType == 25) {
            button2.setOnClick("startLookup('" + this.m_columnName + "', " + this.m_processID + ", 1);return false;");
        } else {
            button2.setOnClick("startLookup('" + this.m_columnName + "', " + this.m_processID + ", 1);return false;");
        }
        a buttonFlyout = null;
        String menu = null;
        if (this.m_Field != null && (menu = this.getpopUpMenu()) != null) {
            buttonFlyout = new a("#", "");
            buttonFlyout.addElement((Element)new img(WebEnv.getImageDirectory("menufly10.gif")).setBorder(0));
            buttonFlyout.setID(this.m_columnName + "PV");
            buttonFlyout.setOnMouseOver("dropdownmenu(this, event, 'menu1[" + this.m_fieldNumber + "]')");
            buttonFlyout.setOnMouseOut("delayhidemenu()");
        }
        if (this.m_error) {
            display.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            display.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            display.setOnChange("startUpdate(this)");
        }
        if (this.m_Field != null) {
            div popup = new div(menu);
            popup.setClass("anylinkcss");
            popup.setID("menu1[" + this.m_fieldNumber + "]");
            return this.createTD((Element)hidden).addElement((Element)display).addElement((Element)button2).addElement((Element)buttonFlyout).addElement((Element)popup);
        }
        return this.createTD((Element)hidden).addElement((Element)display).addElement((Element)button2);
    }

    private td getPopupDateField(Object data) {
        String dataValue = data == null ? "" : data.toString();
        input hidden = new input("hidden", this.m_columnName + "D", dataValue);
        hidden.setID(this.m_columnName + "D");
        input display = null;
        String formattedData = "";
        if (data != null) {
            if (this.m_displayType == 16) {
                formattedData = dataValue.equals("@#Date@") ? this.m_wsc.dateTimeFormat.format(new Date()) : this.m_wsc.dateTimeFormat.format(data);
            } else if (this.m_displayType == 15) {
                formattedData = dataValue.equals("@#Date@") ? this.m_wsc.dateFormat.format(new Date()) : this.m_wsc.dateFormat.format(data);
            }
        }
        display = new input("text", this.m_columnName, formattedData);
        display.setID(this.m_columnName + "F" + this.m_fieldNumber);
        display.setReadOnly(this.m_readOnly);
        input button2 = new input("image", this.m_columnName + "B", "x");
        button2.setID(this.m_columnName + "B");
        button2.setSrc(WebEnv.getImageDirectory("Calendar10.gif"));
        if (this.m_displayType == 15) {
            button2.setOnClick("return showCalendar('" + this.m_columnName + "F" + this.m_fieldNumber + "', '%m/%d/%Y');");
        } else if (this.m_displayType == 16) {
            button2.setOnClick("showCalendar('" + this.m_columnName + "F" + this.m_fieldNumber + "', '%b %d, %Y %H:%M:%S %p', '24');return false;");
        }
        if (this.m_error) {
            display.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            display.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            display.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)hidden).addElement((Element)display).addElement((Element)button2.setBorder(0));
    }

    private td getSelectField(Lookup lookup, String dataValue) {
        if (dataValue.length() < 1 && this.m_defaultObject != null) {
            dataValue = this.m_defaultObject.toString();
        }
        String dataDisplay = "";
        if (lookup != null && dataValue != null && dataValue.length() > 0) {
            dataDisplay = lookup.getDisplay(dataValue);
        }
        option[] ops = this.getOptions(lookup, dataValue);
        select sel = new select(this.m_columnName, ops);
        sel.setID(this.m_columnName);
        sel.setDisabled(this.m_readOnly);
        if (this.m_error) {
            sel.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            sel.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            sel.setOnChange("startUpdate(this);");
        }
        a buttonFlyout = null;
        String menu = null;
        if (this.m_Field != null && !this.m_readOnly && (menu = this.getpopUpMenu()) != null) {
            buttonFlyout = new a("#", "");
            buttonFlyout.addElement((Element)new img(WebEnv.getImageDirectory("menufly10.gif")).setBorder(0));
            buttonFlyout.setID(this.m_columnName + "PV");
            buttonFlyout.setOnMouseOver("dropdownmenu(this, event, 'menu1[" + this.m_fieldNumber + "]')");
            buttonFlyout.setOnMouseOut("delayhidemenu()");
        }
        div popup = new div(menu);
        popup.setClass("anylinkcss");
        popup.setID("menu1[" + this.m_fieldNumber + "]");
        return this.createTD((Element)sel).addElement((Element)buttonFlyout).addElement((Element)popup);
    }

    private option[] getOptions(Lookup lookup, String dataValue) {
        if (lookup == null) {
            return new option[0];
        }
        NamePair value = null;
        Object[] list = lookup.getData(this.m_mandatory, true, !this.m_readOnly, false).toArray();
        int size = list.length;
        option[] options = new option[size];
        if (size == 0 && dataValue.length() > 0) {
            value = lookup.getDirect(dataValue, false, false);
            if (value != null) {
                options = new option[2];
                if (dataValue.length() < 1) {
                    options[0] = new option("-1").addElement("&nbsp;").setSelected(true);
                    options[1] = new option(value.getID()).addElement(value.getName());
                    this.m_dataDisplay = value.getName();
                } else {
                    options[0] = new option("-1").addElement("&nbsp;");
                    options[1] = new option(value.getID()).addElement(value.getName()).setSelected(true);
                    this.m_dataDisplay = value.getName();
                }
            }
            return options;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            NamePair p2;
            String name;
            boolean isNumber = list[0] instanceof KeyNamePair;
            String key = null;
            if (this.m_displayType == 31) {
                MLocator loc = (MLocator)list[i2];
                key = String.valueOf(loc.getM_Locator_ID());
                name = Util.maskHTML(loc.getValue());
                if (dataValue.equals(key)) {
                    options[i2] = new option(key).addElement(name).setSelected(true);
                    this.m_dataDisplay = name;
                    continue;
                }
                options[i2] = new option(key).addElement(name);
                continue;
            }
            if (isNumber) {
                p2 = (KeyNamePair)list[i2];
                key = String.valueOf(((KeyNamePair)p2).getKey());
                name = Util.maskHTML(p2.getName());
                if (dataValue.equals(key)) {
                    options[i2] = new option(key).addElement(name).setSelected(true);
                    this.m_dataDisplay = name;
                    continue;
                }
                options[i2] = new option(key).addElement(name);
                continue;
            }
            p2 = (ValueNamePair)list[i2];
            key = ((ValueNamePair)p2).getValue();
            if (key == null || key.length() == 0) {
                key = "??";
            }
            if ((name = p2.getName()) == null || name.length() == 0) {
                name = "???";
            }
            name = Util.maskHTML(name);
            if (dataValue.equals(key)) {
                options[i2] = new option(key).addElement(name).setSelected(true);
                this.m_dataDisplay = name;
                continue;
            }
            options[i2] = new option(key).addElement(name);
        }
        return options;
    }

    private td getButtonField() {
        input button2 = new input("button", this.m_columnName, "  " + Util.maskHTML(this.m_name));
        button2.setID(this.m_columnName);
        button2.setClass("processbtn");
        button2.setDisabled(this.m_readOnly);
        button2.setOnClick("startButton(" + this.m_processID + ", " + this.m_windowID + ", " + this.m_recordID + ", " + this.m_tableID + ", '" + this.m_columnName + "');");
        return this.createTD((Element)button2).setAlign("left");
    }

    private String getpopUpMenu() {
        a buttonZoom = null;
        a buttonValuePref = null;
        String menu = null;
        Boolean tableAccess = false;
        if (this.m_dataDisplay != null) {
            buttonValuePref = new a("#", new img(WebEnv.getImageDirectory("vPreference10.gif")).setBorder(0) + "  Preference");
            buttonValuePref.setID(this.m_columnName + "PV");
            buttonValuePref.setOnClick("startValuePref(" + this.m_displayType + ", '" + Util.maskHTML(this.m_dataDisplay.toString()) + "', '" + this.m_Field.getValue() + "', '" + this.m_Field.getHeader() + "', '" + this.m_Field.getColumnName() + "', " + Env.getAD_User_ID(this.m_wsc.ctx) + ", " + Env.getAD_Org_ID(this.m_wsc.ctx) + ", " + Env.getAD_Client_ID(this.m_wsc.ctx) + ", " + this.m_Field.getAD_Window_ID() + ");return false;");
            menu = "" + buttonValuePref + " \n";
        }
        StringBuffer sql = null;
        int refID = this.m_Field.getAD_Reference_Value_ID();
        Object recordID = 0;
        if (this.m_displayType == 17) {
            sql = new StringBuffer("SELECT AD_Table_ID FROM AD_Table WHERE TableName = 'AD_Reference'");
            recordID = refID;
        } else if (refID > 0) {
            sql = new StringBuffer("SELECT AD_Table_ID FROM AD_Ref_Table WHERE AD_Reference_ID = " + refID);
            recordID = this.m_Field.getValue();
        } else {
            sql = new StringBuffer("SELECT AD_Table_ID FROM AD_Table WHERE TableName = '" + this.m_columnName.replace("_ID", "") + "'");
            recordID = this.m_Field.getValue();
        }
        int tableID = DB.getSQLValue(null, sql.toString());
        tableAccess = this.m_Role.isTableAccess(tableID, false);
        if (tableAccess.booleanValue()) {
            buttonZoom = new a("#", new img(WebEnv.getImageDirectory("Zoom10.gif")).setBorder(0) + "  Zoom");
            buttonZoom.setID(this.m_columnName + "Z");
            buttonZoom.setOnClick("startZoom(" + tableID + ", " + recordID + ");return false;");
            menu = this.m_dataDisplay != null ? menu + "" + buttonZoom + "\n" : "" + buttonZoom + "\n";
        }
        return menu;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public String getFieldName() {
        return this.m_name;
    }

    public boolean isHasDependents() {
        return this.m_hasDependents;
    }

    public boolean isHasCallout() {
        return this.m_hasCallout;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }
}

