/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class JIoEndpoint {
    protected static Logger log = Logger.getLogger(JIoEndpoint.class);
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected ServerSocket serverSocket = null;
    protected int acceptorThreadCount = 0;
    protected Executor executor = null;
    protected int maxThreads = 40;
    protected int threadPriority = 5;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected boolean daemon = true;
    protected String name = "TP";
    protected ServerSocketFactory serverSocketFactory = null;

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.workers != null ? this.curThreads - this.workers.size() : 0;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.address == null ? this.serverSocketFactory.createSocket(this.port, this.backlog) : this.serverSocketFactory.createSocket(this.port, this.backlog, this.address);
            }
            catch (BindException be) {
                throw new BindException(be.getMessage() + ":" + this.port);
            }
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.executor == null) {
                this.workers = new WorkerStack(this.maxThreads);
            }
            for (int i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.daemon);
                acceptorThread.start();
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                log.error((Object)this.sm.getString("endpoint.err.close"), (Throwable)e);
            }
            this.serverSocket = null;
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        Socket s = null;
        try {
            if (this.address == null) {
                s = new Socket("127.0.0.1", this.port);
            } else {
                s = new Socket(this.address, this.port);
                s.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("endpoint.debug.unlock", "" + this.port), (Throwable)e);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean setSocketOptions(Socket socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                socket.setSoLinger(true, this.soLinger);
            }
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            if (this.soTimeout > 0) {
                socket.setSoTimeout(this.soTimeout);
            }
            step = 2;
            this.serverSocketFactory.handshake(socket);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug((Object)this.sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug((Object)this.sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        while (workerThread == null) {
            try {
                WorkerStack workerStack = this.workers;
                synchronized (workerStack) {
                    this.workers.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workerThread = this.createWorkerThread();
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    protected boolean processSocket(Socket socket) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assign(socket);
            } else {
                this.executor.execute(new SocketProcessor(socket));
            }
        }
        catch (Throwable t) {
            log.error((Object)this.sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            this.workers[this.end++] = worker;
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected Socket socket = null;

        protected Worker() {
        }

        synchronized void assign(Socket socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.available = true;
            this.notifyAll();
        }

        private synchronized Socket await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Socket socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        public void run() {
            while (JIoEndpoint.this.running) {
                Socket socket = this.await();
                if (socket == null) continue;
                if (!JIoEndpoint.this.setSocketOptions(socket) || !JIoEndpoint.this.handler.process(socket)) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                socket = null;
                JIoEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(JIoEndpoint.this.getName() + "-" + ++JIoEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected Socket socket = null;

        public SocketProcessor(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            if (!JIoEndpoint.this.setSocketOptions(this.socket) || !JIoEndpoint.this.handler.process(this.socket)) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        public void run() {
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    Socket socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    JIoEndpoint.this.serverSocketFactory.initSocket(socket);
                    if (JIoEndpoint.this.processSocket(socket)) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException x) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error((Object)JIoEndpoint.this.sm.getString("endpoint.accept.fail"), (Throwable)x);
                }
                catch (Throwable t) {
                    log.error((Object)JIoEndpoint.this.sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }

    public static interface Handler {
        public boolean process(Socket var1);
    }
}

