/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.test.TestDeployer;
import org.jboss.wsf.test.TestDeployerJBoss;

public class JBossWSTestHelper {
    private static Logger log = Logger.getLogger(JBossWSTestHelper.class);
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;

    public void deploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().deploy(url);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().undeploy(url);
    }

    public boolean isTargetJBoss50() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss50");
    }

    public boolean isTargetJBoss42() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss42");
    }

    public boolean isTargetJBoss40() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss40");
    }

    public boolean isIntegrationNative() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("JBoss") != -1;
    }

    public boolean isIntegrationMetro() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("Sun") != -1;
    }

    public boolean isIntegrationCXF() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("Apache") != -1;
    }

    private String getImplementationVendor() {
        if (implVendor == null) {
            Service service = Service.create((QName)new QName("dummyService"));
            HandlerResolver obj = service.getHandlerResolver();
            if (obj == null) {
                service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
                obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
            }
            implVendor = obj.getClass().getPackage().getImplementationVendor();
            implTitle = obj.getClass().getPackage().getImplementationTitle();
            implVersion = obj.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    public static String getServerHost() {
        String hostName = System.getProperty("jboss.bind.address", "localhost");
        return hostName;
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private TestDeployer getDeployer() {
        return new TestDeployerJBoss(JBossWSTestHelper.getServer());
    }

    public String getIntegrationTarget() {
        if (integrationTarget == null) {
            String jbossVersion;
            block8: {
                integrationTarget = System.getProperty("jbossws.integration.target");
                if (integrationTarget == null) {
                    throw new IllegalStateException("Cannot obtain jbossws.integration.target");
                }
                jbossVersion = null;
                try {
                    ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
                    jbossVersion = (String)JBossWSTestHelper.getServer().getAttribute(oname, "SpecificationVersion");
                    if (jbossVersion.startsWith("5.0")) {
                        jbossVersion = "jboss50";
                        break block8;
                    }
                    if (jbossVersion.startsWith("4.2")) {
                        jbossVersion = "jboss42";
                        break block8;
                    }
                    if (jbossVersion.startsWith("4.0")) {
                        jbossVersion = "jboss40";
                        break block8;
                    }
                    throw new RuntimeException("Unsupported jboss version: " + jbossVersion);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (jbossVersion != null && !integrationTarget.startsWith(jbossVersion)) {
                throw new IllegalStateException("Integration target mismatch, using: " + jbossVersion);
            }
        }
        return integrationTarget;
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        File file;
        URL url = null;
        try {
            url = new URL(archive);
        }
        catch (MalformedURLException ignore) {
            // empty catch block
        }
        if (url == null && (file = new File(archive)).exists()) {
            url = file.toURL();
        }
        if (url == null && (file = new File("libs/" + archive)).exists()) {
            url = file.toURL();
        }
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain URL for: " + archive);
        }
        return url;
    }
}

