/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.deployment.jboss;

import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.deployment.jboss.JBossBeanDeploymentMBean;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.UnreachableStatementException;

public class JBossBeanDeployment
extends ServiceMBeanSupport
implements JBossBeanDeploymentMBean {
    protected DeploymentInfo di;
    protected KernelDeployment deployment;
    protected AbstractKernelDeployer deployer;

    public JBossBeanDeployment(DeploymentInfo di) {
        this.di = di;
        this.deployment = (KernelDeployment)di.metaData;
    }

    protected void createService() throws Exception {
        Kernel kernel = this.getKernel();
        this.deployer = new AbstractKernelDeployer(kernel, ControllerState.CREATE, ControllerMode.MANUAL);
        try {
            this.deployer.deploy(this.deployment);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot deploy " + this.deployment), (Throwable)t);
        }
    }

    protected void startService() throws Exception {
        try {
            this.deployer.change(this.deployment, ControllerState.INSTALLED);
            this.deployer.validate(this.deployment);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot start " + this.deployment), (Throwable)t);
        }
    }

    protected void stopService() throws Exception {
        try {
            this.deployer.change(this.deployment, ControllerState.CREATE);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot stop " + this.deployment), (Throwable)t);
        }
    }

    protected void destroyService() throws Exception {
        try {
            if (this.deployer != null) {
                this.deployer.undeploy(this.deployment);
            }
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot stop " + this.deployment), (Throwable)t);
        }
        this.deployer = null;
    }

    protected Kernel getKernel() throws DeploymentException {
        try {
            BasicBootstrap bootstrap = new BasicBootstrap();
            bootstrap.run();
            return bootstrap.getKernel();
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)"Unable to boot kernel", (Throwable)t);
            throw new UnreachableStatementException();
        }
    }
}

