/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sqlj;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.sqlj.Adempiere;

public class Currency {
    public static BigDecimal base(BigDecimal p_Amount, int p_C_CurrencyFrom_ID, Timestamp p_ConversionDate, int p_AD_Client_ID, int p_AD_Org_ID) throws SQLException {
        if (p_Amount == null || p_C_CurrencyFrom_ID == 0) {
            return null;
        }
        if (p_Amount.signum() == 0) {
            return p_Amount;
        }
        String sql = "SELECT ac.C_Currency_ID FROM AD_ClientInfo ci INNER JOIN C_AcctSchema ac ON (ci.C_AcctSchema1_ID=ac.C_AcctSchema_ID) WHERE ci.AD_Client_ID=?";
        int C_CurrencyTo_ID = Adempiere.getSQLValue(sql, p_AD_Client_ID);
        if (p_C_CurrencyFrom_ID == C_CurrencyTo_ID) {
            return p_Amount;
        }
        return Currency.convert(p_Amount, p_C_CurrencyFrom_ID, C_CurrencyTo_ID, p_ConversionDate, 0, p_AD_Client_ID, p_AD_Org_ID);
    }

    public static BigDecimal convert(BigDecimal p_Amount, int p_C_CurrencyFrom_ID, int p_C_CurrencyTo_ID, Timestamp p_ConversionDate, int p_C_ConversionType_ID, int p_AD_Client_ID, int p_AD_Org_ID) throws SQLException {
        if (p_Amount == null || p_C_CurrencyFrom_ID == 0 || p_C_CurrencyTo_ID == 0) {
            return null;
        }
        if (p_Amount.signum() == 0 || p_C_CurrencyFrom_ID == p_C_CurrencyTo_ID) {
            return p_Amount;
        }
        BigDecimal rate = Currency.rate(p_C_CurrencyFrom_ID, p_C_CurrencyTo_ID, p_ConversionDate, p_C_ConversionType_ID, p_AD_Client_ID, p_AD_Org_ID);
        if (rate == null) {
            return null;
        }
        return Currency.round(p_Amount.multiply(rate), p_C_CurrencyTo_ID, null);
    }

    public static BigDecimal rate(int p_C_CurrencyFrom_ID, int p_C_CurrencyTo_ID, Timestamp p_ConversionDate, int p_C_ConversionType_ID, int p_AD_Client_ID, int p_AD_Org_ID) throws SQLException {
        if (p_C_CurrencyFrom_ID == p_C_CurrencyTo_ID) {
            return Adempiere.ONE;
        }
        Timestamp ConversionDate = p_ConversionDate;
        if (ConversionDate == null) {
            ConversionDate = new Timestamp(System.currentTimeMillis());
        }
        ConversionDate = Adempiere.trunc(ConversionDate);
        int C_ConversionType_ID = p_C_ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            String sql = "SELECT C_ConversionType_ID FROM C_ConversionType WHERE IsDefault='Y' AND AD_Client_ID IN (0,?) ORDER BY AD_Client_ID DESC";
            C_ConversionType_ID = Adempiere.getSQLValue(sql, p_AD_Client_ID);
        }
        BigDecimal rate = null;
        String sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND C_ConversionType_ID=? AND TRUNC(ValidFrom, 'DD') <= ? AND TRUNC(ValidTo, 'DD') >= ? AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_CurrencyFrom_ID);
        pstmt.setInt(2, p_C_CurrencyTo_ID);
        pstmt.setInt(3, C_ConversionType_ID);
        pstmt.setTimestamp(4, ConversionDate);
        pstmt.setTimestamp(5, ConversionDate);
        pstmt.setInt(6, p_AD_Client_ID);
        pstmt.setInt(7, p_AD_Org_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            rate = rs.getBigDecimal(1);
        }
        rs.close();
        pstmt.close();
        if (rate == null) {
            return null;
        }
        return rate;
    }

    public static BigDecimal round(BigDecimal p_Amount, int p_C_Currency_ID, String p_Costing) throws SQLException {
        if (p_Amount == null) {
            return null;
        }
        if (p_Amount.signum() == 0 || p_C_Currency_ID == 0) {
            return p_Amount;
        }
        boolean costing = p_Costing != null && "Y".equals(p_Costing);
        BigDecimal result = p_Amount;
        String sql = "SELECT StdPrecision, CostingPrecision FROM C_Currency WHERE C_Currency_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Currency_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int index = costing ? 2 : 1;
            int prec = rs.getInt(index);
            if (result.scale() > prec) {
                result = result.setScale(prec, 4);
            }
        }
        rs.close();
        pstmt.close();
        return result;
    }
}

