/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sqlj;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.sqlj.Adempiere;
import org.compiere.sqlj.Currency;

public class Payment {
    public static BigDecimal allocated(int p_C_Payment_ID, int p_C_Currency_ID) throws SQLException {
        BigDecimal PayAmt = null;
        int C_Charge_ID = 0;
        String sql = "SELECT PayAmt, C_Charge_ID FROM C_Payment_v WHERE C_Payment_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Payment_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            PayAmt = rs.getBigDecimal(1);
            C_Charge_ID = rs.getInt(2);
        }
        rs.close();
        pstmt.close();
        if (C_Charge_ID > 0) {
            return PayAmt;
        }
        int C_ConversionType_ID = 0;
        BigDecimal allocatedAmt = Payment.getAllocatedAmt(p_C_Payment_ID, p_C_Currency_ID, C_ConversionType_ID);
        return Currency.round(allocatedAmt, p_C_Currency_ID, null);
    }

    public static BigDecimal available(int p_C_Payment_ID) throws SQLException {
        if (p_C_Payment_ID == 0) {
            return null;
        }
        int C_Currency_ID = 0;
        int C_ConversionType_ID = 0;
        BigDecimal PayAmt = null;
        int C_Charge_ID = 0;
        String sql = "SELECT C_Currency_ID, C_ConversionType_ID, PayAmt, C_Charge_ID FROM C_Payment_v WHERE C_Payment_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Payment_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            C_Currency_ID = rs.getInt(1);
            C_ConversionType_ID = rs.getInt(2);
            PayAmt = rs.getBigDecimal(3);
            C_Charge_ID = rs.getInt(4);
        }
        rs.close();
        pstmt.close();
        if (PayAmt == null) {
            return null;
        }
        if (C_Charge_ID != 0) {
            return Adempiere.ZERO;
        }
        BigDecimal allocatedAmt = Payment.getAllocatedAmt(p_C_Payment_ID, C_Currency_ID, C_ConversionType_ID);
        BigDecimal available = PayAmt.subtract(allocatedAmt);
        return Currency.round(available, C_Currency_ID, null);
    }

    static BigDecimal getAllocatedAmt(int p_C_Payment_ID, int p_C_Currency_ID, int p_C_ConversionType_ID) throws SQLException {
        BigDecimal allocatedAmt = Adempiere.ZERO;
        String sql = "SELECT a.AD_Client_ID, a.AD_Org_ID, al.Amount, a.C_Currency_ID, a.DateTrx FROM C_AllocationLine al  INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID=a.C_AllocationHdr_ID) WHERE al.C_Payment_ID=? AND a.IsActive='Y'";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Payment_ID);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            Timestamp DateTrx;
            int C_CurrencyFrom_ID;
            int AD_Client_ID = rs.getInt(1);
            int AD_Org_ID = rs.getInt(2);
            BigDecimal amount = rs.getBigDecimal(3);
            BigDecimal allocation = Currency.convert(amount, C_CurrencyFrom_ID = rs.getInt(4), p_C_Currency_ID, DateTrx = rs.getTimestamp(5), p_C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
            if (allocation == null) continue;
            allocatedAmt = allocatedAmt.add(allocation);
        }
        rs.close();
        pstmt.close();
        return allocatedAmt;
    }
}

