/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sqlj;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.sqlj.Adempiere;
import org.compiere.sqlj.Compiere;

public class Product {
    private static final BigDecimal UNLIMITED = new BigDecimal(99999.0);

    public static String attributeName(int p_M_AttributeSetInstance_ID) throws SQLException {
        if (p_M_AttributeSetInstance_ID == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String sql = "SELECT asi.Lot, asi.SerNo, asi.GuaranteeDate FROM M_AttributeSetInstance asi WHERE asi.M_AttributeSetInstance_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_AttributeSetInstance_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            String serNo;
            String lot = rs.getString(1);
            if (lot != null && lot.length() > 0) {
                sb.append(lot).append(" ");
            }
            if ((serNo = rs.getString(2)) != null && serNo.length() > 0) {
                sb.append("#").append(serNo).append(" ");
            }
            Date guaranteeDate = null;
            Object guarantee = rs.getObject(3);
            if (guarantee != null && guarantee instanceof Timestamp) {
                Timestamp ts = (Timestamp)guarantee;
                guaranteeDate = new Date(ts.getTime());
            }
            if (guaranteeDate != null) {
                sb.append(guaranteeDate).append(" ");
            }
        }
        rs.close();
        pstmt.close();
        sql = "SELECT ai.Value, a.Name FROM M_AttributeInstance ai INNER JOIN M_Attribute a ON (ai.M_Attribute_ID=a.M_Attribute_ID AND a.IsInstanceAttribute='Y') WHERE ai.M_AttributeSetInstance_ID=?";
        pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_AttributeSetInstance_ID);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            sb.append(rs.getString(1)).append(":").append(rs.getString(2)).append(" ");
        }
        rs.close();
        pstmt.close();
        if (sb.length() == 0) {
            return "";
        }
        sb.insert(0, " (");
        sb.append(")");
        return sb.toString();
    }

    public static BigDecimal bomPriceLimit(int p_M_Product_ID, int p_M_PriceList_Version_ID) throws SQLException {
        return Product.bomPrice(p_M_Product_ID, p_M_PriceList_Version_ID, "PriceLimit");
    }

    public static BigDecimal bomPriceList(int p_M_Product_ID, int p_M_PriceList_Version_ID) throws SQLException {
        return Product.bomPrice(p_M_Product_ID, p_M_PriceList_Version_ID, "PriceList");
    }

    public static BigDecimal bomPriceStd(int p_M_Product_ID, int p_M_PriceList_Version_ID) throws SQLException {
        return Product.bomPrice(p_M_Product_ID, p_M_PriceList_Version_ID, "PriceStd");
    }

    static BigDecimal bomPrice(int p_M_Product_ID, int p_M_PriceList_Version_ID, String p_what) throws SQLException {
        BigDecimal price = null;
        String sql = "SELECT " + p_what + " FROM M_ProductPrice " + "WHERE M_PriceList_Version_ID=? AND M_Product_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_PriceList_Version_ID);
        pstmt.setInt(2, p_M_Product_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            price = rs.getBigDecimal(1);
        }
        rs.close();
        pstmt.close();
        if (price == null || price.signum() == 0) {
            price = Adempiere.ZERO;
            sql = "SELECT bl.M_Product_ID , CASE WHEN bl.IsQtyPercentage = 'N' THEN bl.QtyBOM ELSE bl.QtyBatch / 100 END AS Qty , p.IsBOM FROM PP_Product_BOM b INNER JOIN M_Product p ON (p.M_Product_ID=b.M_Product_ID) INNER JOIN PP_Product_BOMLine bl ON (bl.PP_Product_BOM_ID=b.PP_Product_BOM_ID) WHERE b.M_Product_ID = ?";
            pstmt = Adempiere.prepareStatement(sql);
            pstmt.setInt(1, p_M_Product_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int M_ProductBOM_ID = rs.getInt(1);
                BigDecimal qty = rs.getBigDecimal(2);
                BigDecimal productPrice = Product.bomPrice(M_ProductBOM_ID, p_M_PriceList_Version_ID, p_what);
                productPrice = productPrice.multiply(qty);
                price = price.add(productPrice);
            }
            rs.close();
            pstmt.close();
        }
        return price;
    }

    public static BigDecimal bomQtyAvailable(int p_M_Product_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQty(p_M_Product_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyOnHand").subtract(Product.bomQty(p_M_Product_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyReserved"));
    }

    public static BigDecimal bomQtyOnHand(int p_M_Product_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQty(p_M_Product_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyOnHand");
    }

    public static BigDecimal bomQtyOrdered(int p_M_Product_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQty(p_M_Product_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyOrdered");
    }

    public static BigDecimal bomQtyReserved(int p_M_Product_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQty(p_M_Product_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyReserved");
    }

    static BigDecimal bomQty(int p_M_Product_ID, int p_M_Warehouse_ID, int p_M_Locator_ID, String p_what) throws SQLException {
        int M_Warehouse_ID = p_M_Warehouse_ID;
        if (M_Warehouse_ID == 0) {
            if (p_M_Locator_ID == 0) {
                return Adempiere.ZERO;
            }
            String sql = "SELECT M_Warehouse_ID FROM M_Locator WHERE M_Locator_ID=?";
            M_Warehouse_ID = Adempiere.getSQLValue(sql, p_M_Locator_ID);
        }
        if (M_Warehouse_ID == 0 || M_Warehouse_ID == -1) {
            return Adempiere.ZERO;
        }
        boolean isBOM = false;
        String ProductType = null;
        boolean isStocked = false;
        String sql = "SELECT IsBOM, ProductType, IsStocked FROM M_Product WHERE M_Product_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            isBOM = "Y".equals(rs.getString(1));
            ProductType = rs.getString(2);
            isStocked = "Y".equals(rs.getString(3));
        }
        rs.close();
        pstmt.close();
        if (ProductType == null) {
            return Adempiere.ZERO;
        }
        if (!(isBOM || ProductType.equals("I") && isStocked)) {
            return UNLIMITED;
        }
        if (isStocked) {
            return Product.getStorageQty(p_M_Product_ID, M_Warehouse_ID, p_M_Locator_ID, p_what);
        }
        BigDecimal quantity = UNLIMITED;
        BigDecimal productQuantity = null;
        sql = "SELECT bl.M_Product_ID , CASE WHEN bl.IsQtyPercentage = 'N' THEN bl.QtyBOM ELSE bl.QtyBatch / 100 END AS Qty , p.IsBOM , p.IsStocked, p.ProductType FROM PP_Product_BOM b INNER JOIN M_Product p ON (p.M_Product_ID=b.M_Product_ID) INNER JOIN PP_Product_BOMLine bl ON (bl.PP_Product_BOM_ID=b.PP_Product_BOM_ID) WHERE b.M_Product_ID = ?";
        pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            int M_ProductBOM_ID = rs.getInt(1);
            BigDecimal bomQty = rs.getBigDecimal(2);
            isBOM = "Y".equals(rs.getString(3));
            isStocked = "Y".equals(rs.getString(4));
            ProductType = rs.getString(5);
            if (ProductType.equals("I") && isStocked) {
                productQuantity = Product.getStorageQty(M_ProductBOM_ID, M_Warehouse_ID, p_M_Locator_ID, p_what);
                int uomPrecision = Product.getUOMPrecision(M_ProductBOM_ID);
                if ((productQuantity = productQuantity.divide(bomQty, uomPrecision, 4)).compareTo(quantity) >= 0) continue;
                quantity = productQuantity;
                continue;
            }
            if (!isBOM || (productQuantity = Product.bomQty(M_ProductBOM_ID, M_Warehouse_ID, p_M_Locator_ID, p_what)).compareTo(quantity) >= 0) continue;
            quantity = productQuantity;
        }
        rs.close();
        pstmt.close();
        if (quantity.signum() != 0) {
            int uomPrecision = Product.getUOMPrecision(p_M_Product_ID);
            return quantity.setScale(uomPrecision, 4);
        }
        return Adempiere.ZERO;
    }

    static BigDecimal getStorageQty(int p_M_Product_ID, int M_Warehouse_ID, int p_M_Locator_ID, String p_what) throws SQLException {
        BigDecimal quantity = null;
        String sql = "SELECT SUM(" + p_what + ") " + "FROM M_Storage s " + "WHERE M_Product_ID=?";
        sql = p_M_Locator_ID != 0 ? sql + " AND s.M_Locator_ID=?" : sql + " AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID AND l.M_Warehouse_ID=?)";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        if (p_M_Locator_ID != 0) {
            pstmt.setInt(2, p_M_Locator_ID);
        } else {
            pstmt.setInt(2, M_Warehouse_ID);
        }
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            quantity = rs.getBigDecimal(1);
        }
        rs.close();
        pstmt.close();
        if (quantity == null) {
            return Adempiere.ZERO;
        }
        return quantity;
    }

    static int getUOMPrecision(int p_M_Product_ID) throws SQLException {
        int precision = 0;
        String sql = "SELECT u.StdPrecision FROM C_UOM u INNER JOIN M_Product p ON (u.C_UOM_ID=p.C_UOM_ID) WHERE p.M_Product_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            precision = rs.getInt(1);
        }
        rs.close();
        pstmt.close();
        return precision;
    }

    public static BigDecimal bomQtyAvailableASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQtyOnHandASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID).subtract(Product.bomQtyReservedASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID));
    }

    public static BigDecimal bomQtyOnHandASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQtyASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyOnHand");
    }

    public static BigDecimal bomQtyOrderedASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQtyASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyOrdered");
    }

    public static BigDecimal bomQtyReservedASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int p_M_Warehouse_ID, int p_M_Locator_ID) throws SQLException {
        return Product.bomQtyASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, "QtyReserved");
    }

    static BigDecimal bomQtyASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int p_M_Warehouse_ID, int p_M_Locator_ID, String p_what) throws SQLException {
        boolean isBOM = false;
        String ProductType = null;
        boolean isStocked = false;
        String sql = "SELECT IsBOM, ProductType, IsStocked FROM M_Product WHERE M_Product_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            isBOM = "Y".equals(rs.getString(1));
            ProductType = rs.getString(2);
            isStocked = "Y".equals(rs.getString(3));
        }
        rs.close();
        pstmt.close();
        if (ProductType == null) {
            return Compiere.ZERO;
        }
        if (!(isBOM || ProductType.equals("I") && isStocked)) {
            return UNLIMITED;
        }
        if (isStocked) {
            return Product.getStorageQtyASI(p_M_Product_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, p_what);
        }
        BigDecimal quantity = UNLIMITED;
        BigDecimal productQuantity = null;
        sql = "SELECT bl.M_Product_ID , CASE WHEN bl.IsQtyPercentage = 'N' THEN bl.QtyBOM ELSE bl.QtyBatch / 100 END AS Qty , p.IsBOM , p.IsStocked, p.ProductType FROM PP_Product_BOM b INNER JOIN M_Product p ON (p.M_Product_ID=b.M_Product_ID) INNER JOIN PP_Product_BOMLine bl ON (bl.PP_Product_BOM_ID=b.PP_Product_BOM_ID) WHERE b.M_Product_ID = ?";
        pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_M_Product_ID);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            int M_ProductBOM_ID = rs.getInt(1);
            BigDecimal bomQty = rs.getBigDecimal(2);
            isBOM = "Y".equals(rs.getString(3));
            isStocked = "Y".equals(rs.getString(4));
            ProductType = rs.getString(5);
            if (ProductType.equals("I") && isStocked) {
                productQuantity = Product.getStorageQtyASI(M_ProductBOM_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, p_what);
                int StdPrecision = Product.getUOMPrecision(M_ProductBOM_ID);
                if ((productQuantity = productQuantity.setScale(StdPrecision, 4).divide(bomQty, 4)).compareTo(quantity) >= 0) continue;
                quantity = productQuantity;
                continue;
            }
            if (!isBOM || (productQuantity = Product.bomQtyASI(M_ProductBOM_ID, p_M_AttributeSetInstance_ID, p_M_Warehouse_ID, p_M_Locator_ID, p_what)).compareTo(quantity) >= 0) continue;
            quantity = productQuantity;
        }
        rs.close();
        pstmt.close();
        if (quantity.signum() > 0) {
            int StdPrecision = Product.getUOMPrecision(p_M_Product_ID);
            return quantity.setScale(StdPrecision, 4);
        }
        return Adempiere.ZERO;
    }

    static BigDecimal getStorageQtyASI(int p_M_Product_ID, int p_M_AttributeSetInstance_ID, int M_Warehouse_ID, int p_M_Locator_ID, String p_what) throws SQLException {
        BigDecimal quantity = null;
        String sql = "SELECT SUM(" + p_what + ") " + "FROM M_Storage s " + "WHERE M_Product_ID=?";
        if (p_M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND s.M_AttributeSetInstance_ID = ?";
        }
        if (p_M_Locator_ID != 0) {
            sql = sql + " AND s.M_Locator_ID=?";
        } else if (M_Warehouse_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID AND l.M_Warehouse_ID=?)";
        }
        int index = 1;
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(index++, p_M_Product_ID);
        if (p_M_AttributeSetInstance_ID != 0) {
            pstmt.setInt(index++, p_M_AttributeSetInstance_ID);
        }
        if (p_M_Locator_ID != 0) {
            pstmt.setInt(index++, p_M_Locator_ID);
        } else if (M_Warehouse_ID != 0) {
            pstmt.setInt(index++, M_Warehouse_ID);
        }
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            quantity = rs.getBigDecimal(1);
        }
        rs.close();
        pstmt.close();
        if (quantity == null) {
            return Adempiere.ZERO;
        }
        return quantity;
    }
}

