/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import com.sun.faces.config.ConfigureListener;
import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.log4j.Priority;
import org.jboss.web.jsf.integration.config.Log4JConversionFilter;

public class JBossJSFConfigureListener
extends ConfigureListener {
    private static final String WAR_BUNDLES_JSF_IMPL = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";
    private static org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(JBossJSFConfigureListener.class);
    public static final String BASE_JSF_LOGGER = "javax.enterprise.resource.webcontainer.jsf";
    public static final String SHOULD_LOG_CONFIG_MESSAGES = "com.sun.faces.displayConfiguration";
    private ServletContext servletContext;

    public static boolean warBundlesJSFImpl(ServletContext servletContext) {
        String bundledJSFImpl = servletContext.getInitParameter(WAR_BUNDLES_JSF_IMPL);
        return bundledJSFImpl != null && bundledJSFImpl.equalsIgnoreCase("true");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        if (JBossJSFConfigureListener.warBundlesJSFImpl(this.servletContext)) {
            return;
        }
        if (System.getProperty("org.jboss.logging.Logger.pluginClass") == null) {
            this.setLog4J();
        }
        this.checkForMyFaces();
        JBossJSFConfigureListener.initializeJspRuntime();
        super.contextInitialized(event);
    }

    private static void initializeJspRuntime() {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void checkForMyFaces() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.myfaces.webapp.StartupServletContextListener");
            LOG.warn((Object)"MyFaces JSF implementation found!  This version of JBoss AS ships with the java.net implementation of JSF.  There are known issues when mixing JSF implementations.  This warning does not apply to MyFaces component libraries such as Tomahawk.  However, myfaces-impl.jar and myfaces-api.jar should not be used without disabling the built-in JSF implementation.  See the JBoss wiki for more details.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void setLevel(Logger julLogger) {
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)julLogger.getName());
        julLogger.setLevel(Level.OFF);
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.FATAL)) {
            julLogger.setLevel(Level.SEVERE);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR)) {
            julLogger.setLevel(Level.SEVERE);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.WARN)) {
            julLogger.setLevel(Level.WARNING);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.INFO)) {
            julLogger.setLevel(Level.INFO);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.DEBUG)) {
            julLogger.setLevel(Level.FINE);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.TRACE)) {
            julLogger.setLevel(Level.FINEST);
        }
        if (log4jLogger.isEnabledFor((Priority)org.apache.log4j.Level.ALL)) {
            julLogger.setLevel(Level.ALL);
        }
    }

    private void setLog4J() {
        Log4JConversionFilter conversionFilter = new Log4JConversionFilter(this.logConfigMessages());
        Logger julLogger = Logger.getLogger(BASE_JSF_LOGGER);
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.APPLICATION.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.CONFIG.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.CONTEXT.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.LIFECYCLE.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.MANAGEDBEAN.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.RENDERKIT.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.TAGLIB.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
        julLogger = FacesLogger.TIMING.getLogger();
        this.setLevel(julLogger);
        julLogger.setFilter(conversionFilter);
    }

    private boolean logConfigMessages() {
        String shouldLogConfigParam = this.servletContext.getInitParameter(SHOULD_LOG_CONFIG_MESSAGES);
        return shouldLogConfigParam != null && shouldLogConfigParam.equalsIgnoreCase("true");
    }
}

