/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.config.Option;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.marshall.RegionNotFoundException;
import org.jboss.cache.xml.XmlHelper;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.tree.ContextInUseException;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.id.GUID;
import org.w3c.dom.Element;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    private static final int FQN_SIZE = 3;
    private static final int DEFAULT_BUCKET_COUNT = 100;
    private static final String[] DEFAULT_HASH_BUCKETS = new String[100];
    private static Option LOCAL_ONLY_OPTION = new Option();
    private static Option GRAVITATE_OPTION = new Option();
    private ThreadLocal<Boolean> localActivity = new ThreadLocal();
    private Logger log = Logger.getLogger(StatefulTreeCache.class);
    private Pool pool;
    private WeakReference<ClassLoader> classloader;
    private TreeCache cache;
    private Fqn cacheNode;
    private ClusteredStatefulCacheListener listener;
    private RegionManager evictRegionManager;
    public static long MarkInUseWaitTime;
    protected String[] hashBuckets = DEFAULT_HASH_BUCKETS;
    protected int createCount = 0;
    protected int passivatedCount = 0;
    protected int removeCount = 0;
    protected long removalTimeout = 0L;
    protected RemovalTimeoutTask removalTask = null;
    protected boolean running = true;
    protected Map<Object, Long> beans = new ConcurrentHashMap<Object, Long>();
    protected EJBContainer ejbContainer;

    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ctx.getId() + " of type " + ctx.getClass()));
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            ++this.createCount;
            this.beans.put(ctx.getId(), ctx.lastUsed);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ctx.getId() + " of type " + ctx.getClass()));
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            ++this.createCount;
            this.beans.put(ctx.getId(), ctx.lastUsed);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        Fqn id = this.getFqn(key);
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            Option opt = new Option();
            opt.setForceDataGravitation(true);
            entry = (StatefulBeanContext)this.cache.get(id, (Object)"bean", opt);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
        finally {
            this.localActivity.set(active);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key);
        }
        if (markInUse && entry.isRemoved()) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed)");
        }
        entry.postReplicate();
        if (markInUse) {
            entry.setInUse(true);
            this.evictRegionManager.markNodeCurrentlyInUse(id, MarkInUseWaitTime);
            entry.lastUsed = System.currentTimeMillis();
            this.beans.put(key, entry.lastUsed);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("get: retrieved bean with cache id " + id.toString()));
        }
        return entry;
    }

    public void remove(Object key) {
        Fqn id = this.getFqn(key);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("remove: cache id " + id.toString()));
            }
            Option opt = new Option();
            opt.setForceDataGravitation(true);
            StatefulBeanContext ctx = (StatefulBeanContext)this.cache.get(id, (Object)"bean", opt);
            if (ctx != null) {
                if (!ctx.isRemoved()) {
                    this.pool.remove(ctx);
                }
                if (ctx.getCanRemoveFromCache()) {
                    this.cache.remove(id);
                } else {
                    this.putInCache(ctx);
                }
                ++this.removeCount;
                this.beans.remove(key);
            }
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), ctx.lastUsed);
            this.evictRegionManager.unmarkNodeCurrentlyInUse(this.getFqn(ctx.getId()));
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        if (ctx instanceof NestedStatefulBeanContext) {
            throw new IllegalArgumentException("Received unexpected replicate call for nested context " + ctx.getId());
        }
        try {
            this.putInCache(ctx);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    public void initialize(Container container) throws Exception {
        this.ejbContainer = (EJBContainer)container;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.ejbContainer.getEjbName()));
        this.pool = this.ejbContainer.getPool();
        ClassLoader cl = this.ejbContainer.getClassloader();
        this.classloader = new WeakReference<ClassLoader>(cl);
        CacheConfig config = (CacheConfig)this.ejbContainer.resolveAnnotation(CacheConfig.class);
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName cacheON = new ObjectName(config.name());
        TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (ObjectName)cacheON, (MBeanServer)server);
        this.cache = mbean.getInstance();
        this.cacheNode = new Fqn(new Object[]{this.ejbContainer.getDeploymentQualifiedName()});
        this.evictRegionManager = this.cache.getEvictionRegionManager();
        Element element = this.getElementConfig(this.cacheNode.toString(), config.idleTimeoutSeconds(), config.maxSize());
        Region region = this.evictRegionManager.createRegion(this.cacheNode, element);
        this.cleanBeanRegion();
        this.cache.registerClassLoader(this.cacheNode.toString(), cl);
        try {
            this.cache.activateRegion(this.cacheNode.toString());
        }
        catch (RegionNotEmptyException e) {
            this.cleanBeanRegion();
            this.cache.activateRegion(this.cacheNode.toString());
        }
        this.log.debug((Object)("initialize(): create eviction region: " + region + " for ejb: " + this.ejbContainer.getEjbName()));
        this.removalTimeout = config.removalTimeoutSeconds();
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + this.ejbContainer.getObjectName().getCanonicalName());
        }
    }

    protected Element getElementConfig(String regionName, long timeToLiveSeconds, int maxNodes) throws Exception {
        String xml = "<region name=\"" + regionName + "\" policyClass=\"org.jboss.ejb3.cache.tree.AbortableLRUPolicy\">\n" + "<attribute name=\"maxNodes\">" + maxNodes + "</attribute>\n" + "<attribute name=\"timeToLiveSeconds\">" + timeToLiveSeconds + "</attribute>\n" + "</region>";
        return XmlHelper.stringToElement((String)xml);
    }

    public void start() {
        this.listener = new ClusteredStatefulCacheListener();
        this.cache.addTreeCacheListener((TreeCacheListener)this.listener);
        if (this.removalTask != null) {
            this.removalTask.start();
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.cache.removeTreeCacheListener((TreeCacheListener)this.listener);
        this.cleanBeanRegion();
        try {
            this.cache.inactivateRegion(this.cacheNode.toString());
        }
        catch (Exception e) {
            this.log.error((Object)("Caught exception inactivating region " + this.cacheNode), (Throwable)e);
        }
        try {
            this.cache.unregisterClassLoader(this.cacheNode.toString());
        }
        catch (RegionNotFoundException e) {
            this.log.error((Object)("Caught exception unregistering classloader from  region " + this.cacheNode), (Throwable)e);
        }
        RegionManager rm = this.cache.getEvictionRegionManager();
        rm.removeRegion(this.cacheNode);
        this.log.debug((Object)("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode));
    }

    public int getCacheSize() {
        int count = 0;
        try {
            Set children = null;
            for (int i = 0; i < this.hashBuckets.length; ++i) {
                children = this.cache.getChildrenNames(new Fqn(this.cacheNode, (Object)this.hashBuckets[i]));
                count += children == null ? 0 : children.size();
            }
            count -= this.passivatedCount;
        }
        catch (CacheException e) {
            this.log.error((Object)"Caught exception calculating cache size", (Throwable)e);
            count = -1;
        }
        return count;
    }

    public int getTotalSize() {
        return this.beans.size();
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public int getPassivatedCount() {
        return this.passivatedCount;
    }

    public int getRemoveCount() {
        return this.removeCount;
    }

    public int getAvailableCount() {
        return -1;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getCurrentSize() {
        return this.getCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(StatefulBeanContext ctx) throws CacheException {
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            ctx.preReplicate();
            this.cache.put(this.getFqn(ctx.getId()), (Object)"bean", (Object)ctx);
            ctx.markedForReplication = false;
        }
        finally {
            this.localActivity.set(active);
        }
    }

    private Fqn getFqn(Object id) {
        String beanId = id.toString();
        int index = id instanceof GUID ? (id.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length : (beanId.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length;
        return new Fqn(this.cacheNode, (Object)this.hashBuckets[index], (Object)beanId);
    }

    private void cleanBeanRegion() {
        try {
            Option opt = new Option();
            opt.setCacheModeLocal(true);
            this.cache.remove(this.cacheNode, opt);
        }
        catch (CacheException e) {
            this.log.error((Object)"Stop(): can't remove bean from the underlying distributed cache");
        }
    }

    private RuntimeException convertToRuntimeException(CacheException e) {
        RuntimeException re = new RuntimeException(((Object)((Object)e)).getClass().getName() + " " + e.getMessage());
        re.setStackTrace(e.getStackTrace());
        return re;
    }

    static {
        LOCAL_ONLY_OPTION.setCacheModeLocal(true);
        GRAVITATE_OPTION.setForceDataGravitation(true);
        for (int i = 0; i < DEFAULT_HASH_BUCKETS.length; ++i) {
            StatefulTreeCache.DEFAULT_HASH_BUCKETS[i] = String.valueOf(i);
        }
        MarkInUseWaitTime = 15000L;
    }

    private class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        public void run() {
            while (StatefulTreeCache.this.running) {
                try {
                    Thread.sleep(StatefulTreeCache.this.removalTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    StatefulTreeCache.this.running = false;
                    return;
                }
                try {
                    long now = System.currentTimeMillis();
                    for (Map.Entry<Object, Long> entry : StatefulTreeCache.this.beans.entrySet()) {
                        long lastUsed = entry.getValue();
                        if (now - lastUsed < StatefulTreeCache.this.removalTimeout * 1000L) continue;
                        StatefulTreeCache.this.remove(entry.getKey());
                    }
                }
                catch (Exception ex) {
                    StatefulTreeCache.this.log.error((Object)"problem removing SFSB thread", (Throwable)ex);
                }
            }
        }
    }

    public class ClusteredStatefulCacheListener
    extends AbstractTreeCacheListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeActivate(Fqn fqn, boolean pre) {
            if (pre) {
                return;
            }
            if (fqn.size() != 3) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            if (Boolean.TRUE != StatefulTreeCache.this.localActivity.get()) {
                --StatefulTreeCache.this.passivatedCount;
                return;
            }
            StatefulBeanContext bean = null;
            try {
                bean = (StatefulBeanContext)StatefulTreeCache.this.cache.get(fqn, (Object)"bean");
            }
            catch (CacheException e) {
                StatefulTreeCache.this.log.error((Object)("nodeActivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)e)));
                return;
            }
            if (bean == null) {
                throw new IllegalStateException("nodeActivate(): null bean instance.");
            }
            --StatefulTreeCache.this.passivatedCount;
            if (StatefulTreeCache.this.log.isTraceEnabled()) {
                StatefulTreeCache.this.log.trace((Object)("nodeActivate(): sending postActivate event to bean at fqn: " + fqn));
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                bean.activateAfterReplication();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodePassivate(Fqn fqn, boolean pre) {
            block17: {
                if (!pre) {
                    return;
                }
                if (fqn.size() != 3) {
                    return;
                }
                if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                    return;
                }
                StatefulBeanContext bean = null;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Boolean active = (Boolean)StatefulTreeCache.this.localActivity.get();
                try {
                    StatefulTreeCache.this.localActivity.set(Boolean.TRUE);
                    DataNode node = StatefulTreeCache.this.cache.peek(fqn);
                    if (node != null && (bean = (StatefulBeanContext)node.get((Object)"bean")) != null) {
                        ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        if (!bean.getCanPassivate()) {
                            throw new ContextInUseException("Cannot passivate bean " + fqn + " -- it or one if its children is currently in use");
                        }
                        if (StatefulTreeCache.this.log.isTraceEnabled()) {
                            StatefulTreeCache.this.log.trace((Object)("nodePassivate(): send prePassivate event to bean at fqn: " + fqn));
                        }
                        bean.passivateAfterReplication();
                        ++StatefulTreeCache.this.passivatedCount;
                    }
                }
                catch (NoSuchEJBException e) {
                    if (bean instanceof ProxiedStatefulBeanContext) {
                        try {
                            bean.getContainedIn();
                            throw e;
                        }
                        catch (NoSuchEJBException n) {
                            StatefulTreeCache.this.log.debug((Object)("nodePassivate(): removing orphaned proxy at " + fqn));
                            try {
                                StatefulTreeCache.this.cache.remove(fqn);
                            }
                            catch (CacheException c) {
                                StatefulTreeCache.this.log.error((Object)("nodePassivate(): could not remove orphaned proxy at " + fqn), (Throwable)c);
                            }
                            break block17;
                        }
                    }
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                    StatefulTreeCache.this.localActivity.set(active);
                }
            }
        }
    }
}

