/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class StatelessRemoteProxy
extends BaseSessionRemoteProxy {
    private static final long serialVersionUID = 2583299153931800023L;
    private static final Logger log = Logger.getLogger(StatelessRemoteProxy.class);
    protected InvokerLocator uri;
    AsynchProvider provider;

    public StatelessRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri) {
        super(container, interceptors);
        this.uri = uri;
    }

    public StatelessRemoteProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, InvokerLocator uri) {
        super(containerId, containerGuid, interceptors);
        this.uri = uri;
        this.provider = provider;
    }

    protected StatelessRemoteProxy() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        long hash = MethodHashing.calculateHash((Method)method);
        Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        ret = this.handleEjb21CallLocally(method, args);
        if (ret != null) {
            return ret;
        }
        MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
        sri.setArguments(args);
        sri.setInstanceResolver((MetaDataResolver)this.metadata);
        sri.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", (Object)this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"IS_LOCAL", (Object)"GUID", (Object)this.containerGuid, PayloadKey.AS_IS);
        if (this.provider != null) {
            sri.getMetaData().addMetaData((Object)"ASYNCH", (Object)"INVOKE_ASYNCH", (Object)"YES", PayloadKey.AS_IS);
        }
        return sri.invokeNext();
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
            StatelessRemoteProxy handler = new StatelessRemoteProxy((AsynchProvider)mixin, this.containerId, this.containerGuid, newInterceptors, this.uri);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        return this.containerId.toString();
    }

    private Object handleEjb21CallLocally(Method method, Object[] args) {
        if (method.equals(ProxyUtils.GET_HOME_HANDLE)) {
            return this.homeHandle;
        }
        if (method.equals(ProxyUtils.GET_EJB_METADATA)) {
            return this.ejbMetaData;
        }
        if (method.equals(ProxyUtils.GET_HANDLE)) {
            return this.handle;
        }
        return null;
    }
}

