/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.eevolution.form.HRActionNotice;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;

public class VHRActionNotice
extends HRActionNotice
implements FormPanel,
ActionListener,
VetoableChangeListener {
    public static CTextField fieldDescription = new CTextField(22);
    public static VDate fieldValidFrom = new VDate();
    public static VNumber fieldQty = new VNumber();
    public static VNumber fieldAmount = new VNumber();
    public static VDate fieldDate = new VDate();
    public static CTextField fieldText = new CTextField(22);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    public static VComboBox fieldProcess = new VComboBox();
    public static VComboBox fieldEmployee = new VComboBox();
    public static VComboBox fieldConcept = new VComboBox();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VHRActionNotice.class);
    private CLabel labelProcess = new CLabel();
    private CLabel labelEmployee = new CLabel();
    private CLabel labelColumnType = new CLabel();
    private static CTextField fieldColumnType = new CTextField(18);
    private CLabel labelConcept = new CLabel();
    private JLabel labelValue = new JLabel();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private VNumber fieldRuleE = new VNumber();
    private static MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bOk = ConfirmPanel.createOKButton((boolean)true);
    private CLabel labelValidFrom = new CLabel();
    private CLabel labelDescription = new CLabel();
    private GridBagLayout parameterLayout = new GridBagLayout();

    public void init(int n, FormFrame formFrame) {
        log.info("");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        try {
            super.dynInit();
            this.dynInit();
            this.jbInit();
            formFrame.getContentPane().add((Component)this.mainPanel, "Center");
            formFrame.setSize(1000, 400);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "init", (Throwable)exception);
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void jbInit() {
        CompiereColor.setBackground((JComponent)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.mainPanel.setPreferredSize(new Dimension(1000, 400));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.labelProcess.setLabelFor((Component)fieldProcess);
        this.labelProcess.setText(Msg.translate((Properties)Env.getCtx(), (String)"HR_Process_ID"));
        this.labelEmployee.setLabelFor((Component)fieldEmployee);
        this.labelEmployee.setText(Msg.translate((Properties)Env.getCtx(), (String)"HR_Employee_ID"));
        this.labelConcept.setLabelFor((Component)fieldConcept);
        this.labelConcept.setText(Msg.translate((Properties)Env.getCtx(), (String)"HR_Concept_ID"));
        this.labelValidFrom.setLabelFor((Component)fieldValidFrom);
        this.labelValidFrom.setText(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        this.labelDescription.setLabelFor((Component)fieldDescription);
        this.labelDescription.setText(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        this.labelColumnType.setLabelFor((Component)fieldColumnType);
        this.labelColumnType.setText(Msg.translate((Properties)Env.getCtx(), (String)"ColumnType"));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.parameterPanel.add((Component)this.labelProcess, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldProcess, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelEmployee, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldEmployee, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValidFrom, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldValidFrom, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelConcept, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldConcept, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelColumnType, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldColumnType, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValue, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldQty, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldAmount, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldDate, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldText, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelDescription, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)fieldDescription, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bOk, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, (Object)"South");
        this.mainPanel.add((Component)this.dataPane, (Object)"Center");
        this.dataPane.getViewport().add((Component)miniTable, null);
        this.commandPanel.setLayout((LayoutManager)this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
    }

    @Override
    public void dynInit() throws Exception {
        fieldProcess = new VComboBox((Object[])VHRActionNotice.getProcess());
        fieldProcess.addActionListener((ActionListener)this);
        fieldProcess.setMandatory(true);
        fieldEmployee.addActionListener((ActionListener)this);
        fieldEmployee.setReadWrite(false);
        fieldEmployee.setMandatory(true);
        fieldConcept.addActionListener((ActionListener)this);
        fieldConcept.setReadWrite(false);
        fieldConcept.setMandatory(true);
        fieldValidFrom.setReadWrite(false);
        fieldValidFrom.setMandatory(true);
        fieldValidFrom.addVetoableChangeListener((VetoableChangeListener)this);
        fieldDescription.setValue((Object)"");
        fieldDescription.setReadWrite(false);
        fieldColumnType.setReadWrite(false);
        fieldQty.setReadWrite(false);
        fieldQty.setDisplayType(29);
        fieldQty.setVisible(true);
        fieldAmount.setDisplayType(12);
        fieldAmount.setVisible(false);
        fieldDate.setVisible(false);
        fieldText.setVisible(false);
        this.fieldRuleE.setVisible(false);
        this.bOk.addActionListener(this);
        this.configureMiniTable((IMiniTable)miniTable);
    }

    public static void executeQuery() {
        VHRActionNotice.executeQuery(Env.getCtx(), (IMiniTable)miniTable);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        fieldConcept.setReadWrite(true);
        log.fine("Event" + propertyChangeEvent);
        log.fine("Event Source " + propertyChangeEvent.getSource());
        log.fine("Event Property " + propertyChangeEvent.getPropertyName());
        Integer n = new MHRProcess(Env.getCtx(), (Integer)fieldProcess.getValue(), null).getHR_Period_ID();
        String string = DB.TO_DATE((Timestamp)((Timestamp)fieldValidFrom.getValue()));
        int n2 = DB.getSQLValueEx(null, (String)("SELECT HR_Period_ID FROM HR_Period WHERE " + string + " >= StartDate AND " + string + " <= EndDate AND HR_Period_ID = " + n), (Object[])new Object[0]);
        if (n2 < 0) {
            fieldConcept.setReadWrite(false);
            return;
        }
        if (fieldConcept != null) {
            sHR_Movement_ID = this.seekMovement((Timestamp)fieldValidFrom.getValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        log.fine("Event " + actionEvent);
        log.fine("Event Source " + actionEvent.getSource());
        if (actionEvent.getSource().equals(fieldProcess)) {
            KeyNamePair keyNamePair = (KeyNamePair)fieldProcess.getSelectedItem();
            if (keyNamePair != null) {
                m_HR_Process_ID = keyNamePair.getKey();
                m_process = new MHRProcess(Env.getCtx(), m_HR_Process_ID, null);
                if (m_process.getHR_Period_ID() > 0) {
                    MHRPeriod mHRPeriod = MHRPeriod.get(Env.getCtx(), m_process.getHR_Period_ID());
                    this.m_dateStart = mHRPeriod.getStartDate();
                    m_dateEnd = mHRPeriod.getEndDate();
                } else {
                    m_dateEnd = m_process.getDateAcct();
                }
                m_HR_Payroll_ID = m_process.getHR_Payroll_ID();
                fieldEmployee.removeAllItems();
                for (KeyNamePair keyNamePair2 : VHRActionNotice.getEmployeeValid(m_process)) {
                    fieldEmployee.addItem((Object)keyNamePair2);
                }
                fieldEmployee.setSelectedIndex(0);
                fieldEmployee.setReadWrite(true);
            }
        } else if (actionEvent.getSource().equals(fieldEmployee)) {
            KeyNamePair keyNamePair = (KeyNamePair)fieldEmployee.getSelectedItem();
            if (keyNamePair != null) {
                m_C_BPartner_ID = keyNamePair.getKey();
            }
            if (m_C_BPartner_ID > 0) {
                fieldValidFrom.setValue((Object)m_dateEnd);
                fieldValidFrom.setReadWrite(true);
                ArrayList<ValueNamePair> arrayList = this.getConcept(m_process, fieldProcess != null);
                for (ValueNamePair valueNamePair : arrayList) {
                    fieldConcept.addItem((Object)valueNamePair);
                }
                fieldConcept.setReadWrite(true);
                VHRActionNotice.executeQuery();
            }
        } else if (actionEvent.getSource().equals(fieldConcept)) {
            ValueNamePair valueNamePair = (ValueNamePair)fieldConcept.getSelectedItem();
            if (valueNamePair != null) {
                try {
                    m_HR_Concept_ID = Integer.parseInt(valueNamePair.getValue());
                }
                catch (Exception exception) {
                    m_HR_Concept_ID = 0;
                }
            }
            if (m_HR_Concept_ID > 0) {
                MHRConcept mHRConcept = MHRConcept.get(Env.getCtx(), m_HR_Concept_ID);
                fieldColumnType.setValue((Object)DB.getSQLValueStringEx(null, (String)VHRActionNotice.getSQL_ColumnType(Env.getCtx(), "?"), (Object[])new Object[]{mHRConcept.getColumnType()}));
                sHR_Movement_ID = this.seekMovement((Timestamp)fieldValidFrom.getValue());
                if (sHR_Movement_ID > 0) {
                    MHRMovement mHRMovement = new MHRMovement(Env.getCtx(), sHR_Movement_ID, null);
                    fieldDescription.setValue((Object)mHRMovement.getDescription());
                    fieldText.setValue((Object)"");
                    fieldDate.setValue(null);
                    fieldQty.setValue((Object)Env.ZERO);
                    fieldAmount.setValue((Object)Env.ZERO);
                    if (mHRConcept.getColumnType().equals("Q")) {
                        fieldQty.setValue((Object)mHRMovement.getQty());
                    } else if (mHRConcept.getColumnType().equals("A")) {
                        fieldAmount.setValue((Object)mHRMovement.getAmount());
                    } else if (mHRConcept.getColumnType().equals("T")) {
                        fieldText.setValue((Object)mHRMovement.getTextMsg());
                    } else if (mHRConcept.getColumnType().equals("D")) {
                        fieldDate.setValue((Object)mHRMovement.getServiceDate());
                    }
                }
                if (mHRConcept.getColumnType().equals("Q")) {
                    fieldQty.setVisible(true);
                    fieldQty.setReadWrite(true);
                    fieldAmount.setVisible(false);
                    fieldDate.setVisible(false);
                    fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (mHRConcept.getColumnType().equals("A")) {
                    fieldQty.setVisible(false);
                    fieldAmount.setVisible(true);
                    fieldAmount.setReadWrite(true);
                    fieldDate.setVisible(false);
                    fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (mHRConcept.getColumnType().equals("D")) {
                    fieldQty.setVisible(false);
                    fieldAmount.setVisible(false);
                    fieldDate.setVisible(true);
                    fieldDate.setReadWrite(true);
                    fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (mHRConcept.getColumnType().equals("T")) {
                    fieldText.setVisible(true);
                    fieldText.setReadWrite(true);
                    fieldAmount.setVisible(false);
                    fieldDate.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                }
                fieldDescription.setReadWrite(true);
            }
        } else if (actionEvent instanceof ActionEvent && actionEvent.getSource().equals(this.bOk)) {
            ValueNamePair valueNamePair = (ValueNamePair)fieldConcept.getSelectedItem();
            m_HR_Concept_ID = Integer.parseInt(valueNamePair.getValue());
            if (m_HR_Concept_ID <= 0 || fieldProcess.getValue() == null || (Integer)fieldProcess.getValue() <= 0 || fieldEmployee.getValue() == null || (Integer)fieldEmployee.getValue() <= 0) {
                ADialog.error((int)this.m_WindowNo, (Container)this.mainPanel, (String)(Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory") + Msg.translate((Properties)Env.getCtx(), (String)"HR_Process_ID") + ", " + Msg.translate((Properties)Env.getCtx(), (String)"HR_Employee_ID") + ", " + Msg.translate((Properties)Env.getCtx(), (String)"HR_Concept_ID")));
            } else {
                VHRActionNotice.saveMovement();
            }
        }
        VHRActionNotice.executeQuery();
    }

    public static void saveMovement() {
        MHRConcept mHRConcept = MHRConcept.get(Env.getCtx(), m_HR_Concept_ID);
        int n = sHR_Movement_ID > 0 ? sHR_Movement_ID : 0;
        MHRMovement mHRMovement = new MHRMovement(Env.getCtx(), n, null);
        mHRMovement.setDescription(fieldDescription.getValue() != null ? fieldDescription.getValue().toString() : "");
        mHRMovement.setHR_Process_ID((Integer)fieldProcess.getValue());
        mHRMovement.setC_BPartner_ID((Integer)fieldEmployee.getValue());
        mHRMovement.setHR_Concept_ID(Integer.parseInt((String)fieldConcept.getValue()));
        mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        mHRMovement.setColumnType(mHRConcept.getColumnType());
        mHRMovement.setQty(fieldQty.getValue() != null ? (BigDecimal)fieldQty.getValue() : Env.ZERO);
        mHRMovement.setAmount(fieldAmount.getValue() != null ? (BigDecimal)fieldAmount.getValue() : Env.ZERO);
        mHRMovement.setTextMsg(fieldText.getValue() != null ? fieldText.getValue().toString() : "");
        mHRMovement.setServiceDate(fieldDate.getValue() != null ? (Timestamp)fieldDate.getValue() : null);
        mHRMovement.setValidFrom(fieldValidFrom.getTimestamp());
        mHRMovement.setValidTo(fieldValidFrom.getTimestamp());
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(Env.getCtx(), mHRMovement.getC_BPartner_ID(), null);
        if (mHREmployee != null) {
            mHRMovement.setAD_Org_ID(mHREmployee.getAD_Org_ID());
            mHRMovement.setHR_Department_ID(mHREmployee.getHR_Department_ID());
            mHRMovement.setHR_Job_ID(mHREmployee.getHR_Job_ID());
            mHRMovement.setC_Activity_ID(mHREmployee.getC_Activity_ID() > 0 ? mHREmployee.getC_Activity_ID() : mHREmployee.getHR_Department().getC_Activity_ID());
        }
        mHRMovement.setIsManual(true);
        mHRMovement.saveEx();
        if (!(mHRMovement.getAmount() != null && Env.ZERO.compareTo(mHRMovement.getAmount()) != 0 || mHRMovement.getQty() != null && Env.ZERO.compareTo(mHRMovement.getQty()) != 0 || mHRMovement.getServiceDate() != null || mHRMovement.getTextMsg() != null && mHRMovement.getTextMsg().trim().length() != 0)) {
            mHRMovement.deleteEx(false);
        }
        VHRActionNotice.executeQuery();
        fieldValidFrom.setValue((Object)m_dateEnd);
        fieldColumnType.setValue((Object)"");
        fieldQty.setValue((Object)Env.ZERO);
        fieldAmount.setValue((Object)Env.ZERO);
        fieldQty.setReadWrite(false);
        fieldAmount.setReadWrite(false);
        fieldText.setReadWrite(false);
        fieldDescription.setReadWrite(false);
        sHR_Movement_ID = 0;
        fieldDescription.setValue((Object)"");
        fieldText.setValue((Object)"");
        fieldDate.setValue(null);
        fieldQty.setValue((Object)Env.ZERO);
        fieldAmount.setValue((Object)Env.ZERO);
        fieldConcept.setSelectedIndex(0);
    }
}

