/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MPaymentBatch;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.eevolution.form.HRPayPrint;
import org.eevolution.model.MHRPaySelectionCheck;

public class VHRPayPrint
extends HRPayPrint
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = -6359854263967310497L;
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private FlowLayout southLayout = new FlowLayout();
    private GridBagLayout centerLayout = new GridBagLayout();
    private JButton bPrint = ConfirmPanel.createPrintButton((boolean)true);
    private JButton bExport = ConfirmPanel.createExportButton((boolean)true);
    private JButton bCancel = ConfirmPanel.createCancelButton((boolean)true);
    private JButton bProcess = ConfirmPanel.createProcessButton((String)Msg.getMsg((Properties)Env.getCtx(), (String)"VHRPayPrintProcess"));
    private CLabel lPaySelect = new CLabel();
    private CComboBox fPaySelect = new CComboBox();
    private CLabel lBank = new CLabel();
    private CLabel fBank = new CLabel();
    private CLabel lPaymentRule = new CLabel();
    private CComboBox fPaymentRule = new CComboBox();
    private CLabel lDocumentNo = new CLabel();
    private VNumber fDocumentNo = new VNumber();
    private CLabel lNoPayments = new CLabel();
    private CLabel fNoPayments = new CLabel();
    private CLabel lBalance = new CLabel();
    private VNumber fBalance = new VNumber();
    private CLabel lCurrency = new CLabel();
    private CLabel fCurrency = new CLabel();

    public void init(int n, FormFrame formFrame) {
        log.info("");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        try {
            this.jbInit();
            this.dynInit();
            formFrame.getContentPane().add((Component)this.centerPanel, "Center");
            formFrame.getContentPane().add((Component)this.southPanel, "South");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "", (Throwable)exception);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)this.panel);
        this.southPanel.setLayout((LayoutManager)this.southLayout);
        this.southLayout.setAlignment(2);
        this.centerPanel.setLayout((LayoutManager)this.centerLayout);
        this.bPrint.addActionListener(this);
        this.bExport.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bProcess.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"EFT"));
        this.bProcess.setEnabled(false);
        this.bProcess.addActionListener(this);
        this.lPaySelect.setText(Msg.translate((Properties)Env.getCtx(), (String)"HR_PaySelection_ID"));
        this.fPaySelect.addActionListener((ActionListener)this);
        this.lBank.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.lPaymentRule.setText(Msg.translate((Properties)Env.getCtx(), (String)"PaymentRule"));
        this.fPaymentRule.addActionListener((ActionListener)this);
        this.lDocumentNo.setText(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        this.fDocumentNo.setDisplayType(11);
        this.lNoPayments.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"NoOfPayments"));
        this.fNoPayments.setText("0");
        this.lBalance.setText(Msg.translate((Properties)Env.getCtx(), (String)"CurrentBalance"));
        this.fBalance.setReadWrite(false);
        this.fBalance.setDisplayType(12);
        this.lCurrency.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.southPanel.add((Component)this.bCancel, null);
        this.southPanel.add((Component)this.bExport, null);
        this.southPanel.add((Component)this.bPrint, null);
        this.southPanel.add((Component)this.bProcess, null);
        this.centerPanel.add((Component)this.lPaySelect, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fPaySelect, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBank, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBank, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lPaymentRule, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fPaymentRule, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lDocumentNo, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fDocumentNo, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lNoPayments, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fNoPayments, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBalance, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBalance, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lCurrency, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.centerPanel.add((Component)this.fCurrency, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 12, 12), 0, 0));
    }

    private void dynInit() {
        ArrayList<KeyNamePair> arrayList = this.getPaySelectionData();
        for (KeyNamePair keyNamePair : arrayList) {
            this.fPaySelect.addItem((Object)keyNamePair);
        }
        if (this.fPaySelect.getItemCount() == 0) {
            ADialog.info((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintNoRecords");
        } else {
            this.fPaySelect.setSelectedIndex(0);
            this.loadPaySelectInfo();
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void setPaySelection(int n) {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < this.fPaySelect.getItemCount(); ++i) {
            KeyNamePair keyNamePair = (KeyNamePair)this.fPaySelect.getItemAt(i);
            if (keyNamePair.getKey() != n) continue;
            this.fPaySelect.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fPaySelect) {
            this.loadPaySelectInfo();
        } else if (actionEvent.getSource() == this.fPaymentRule) {
            this.loadPaymentRuleInfo();
        } else if (actionEvent.getSource() == this.bCancel) {
            this.dispose();
        } else if (actionEvent.getSource() == this.bExport) {
            this.cmd_export();
        } else if (actionEvent.getSource() == this.bProcess) {
            this.cmd_EFT();
        } else if (actionEvent.getSource() == this.bPrint) {
            this.cmd_print();
        }
    }

    private void loadPaySelectInfo() {
        log.info("VPayPrint.loadPaySelectInfo");
        if (this.fPaySelect.getSelectedIndex() == -1) {
            return;
        }
        int n = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        this.loadPaySelectInfo(n);
        this.fBank.setText(this.bank);
        this.fCurrency.setText(this.currency);
        this.fBalance.setValue((Object)this.balance);
        this.loadPaymentRule();
    }

    private void loadPaymentRule() {
        log.info("");
        if (this.m_C_BankAccount_ID == -1) {
            return;
        }
        this.fPaymentRule.removeAllItems();
        int n = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        ArrayList<ValueNamePair> arrayList = this.loadPaymentRule(n);
        for (ValueNamePair valueNamePair : arrayList) {
            this.fPaymentRule.addItem((Object)valueNamePair);
        }
        if (this.fPaymentRule.getItemCount() > 0) {
            this.fPaymentRule.setSelectedIndex(0);
        }
        this.loadPaymentRuleInfo();
    }

    private void loadPaymentRuleInfo() {
        ValueNamePair valueNamePair = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (valueNamePair == null) {
            return;
        }
        String string = valueNamePair.getValue();
        log.info("PaymentRule=" + string);
        this.fNoPayments.setText(" ");
        int n = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        String string2 = this.loadPaymentRuleInfo(n, string);
        if (this.noPayments != null) {
            this.fNoPayments.setText(this.noPayments);
        }
        this.bProcess.setEnabled(string.equals("T"));
        if (this.documentNo != null) {
            this.fDocumentNo.setValue((Object)this.documentNo);
        }
        if (string2 != null && string2.length() > 0) {
            ADialog.error((int)this.m_WindowNo, (Container)this.panel, (String)string2);
        }
    }

    private void cmd_export() {
        String string = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(string);
        if (!this.getChecks(string)) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Export"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(new File("paymentExport.txt"));
        if (jFileChooser.showSaveDialog((Component)this.panel) != 0) {
            return;
        }
        int n = MHRPaySelectionCheck.exportToFile(this.m_checks, jFileChooser.getSelectedFile());
        ADialog.info((int)this.m_WindowNo, (Container)this.panel, (String)"Saved", (String)(jFileChooser.getSelectedFile().getAbsolutePath() + "\n" + Msg.getMsg((Properties)Env.getCtx(), (String)"NoOfLines") + "=" + n));
        if (ADialog.ask((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintSuccess?")) {
            MHRPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch);
        }
        this.dispose();
    }

    private void cmd_EFT() {
        String string = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(string);
        if (!this.getChecks(string)) {
            return;
        }
        this.dispose();
    }

    private void cmd_print() {
        int n;
        String string = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(string);
        if (!this.getChecks(string)) {
            return;
        }
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = false;
        boolean bl2 = !Ini.isPropertyBool((String)"PrintPreview");
        for (Object object : this.m_checks) {
            boolean bl3 = ReportCtl.startDocumentPrint((int)10, (int)object.get_ID(), null, (int)Env.getWindowNo((Container)this.panel), (boolean)bl2);
            if (bl || !bl3) continue;
            bl = true;
        }
        if (bl && ADialog.ask((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintSuccess?") && (n = MHRPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch)) != 0) {
            Object object;
            object = new StringBuffer();
            ((StringBuffer)object).append("UPDATE C_BankAccountDoc SET CurrentNext=").append(++n).append(" WHERE C_BankAccount_ID=").append(this.m_C_BankAccount_ID).append(" AND PaymentRule='").append(string).append("'");
            DB.executeUpdate((String)((StringBuffer)object).toString(), null);
        }
        if (ADialog.ask((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintPrintRemittance")) {
            for (Object object : this.m_checks) {
                ReportCtl.startDocumentPrint((int)5, (int)object.get_ID(), null, (int)Env.getWindowNo((Container)this.panel), (boolean)bl2);
            }
        }
        this.panel.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    private boolean getChecks(String string) {
        if (this.fPaySelect.getSelectedIndex() == -1 || this.m_C_BankAccount_ID == -1 || this.fPaymentRule.getSelectedIndex() == -1 || this.fDocumentNo.getValue() == null) {
            ADialog.error((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintNoRecords", (String)("(" + Msg.translate((Properties)Env.getCtx(), (String)"HR_PaySelectionLine_ID") + "=0)"));
            return false;
        }
        int n = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        int n2 = ((Number)this.fDocumentNo.getValue()).intValue();
        log.config("HR_PaySelection_ID=" + n + ", PaymentRule=" + string + ", DocumentNo=" + n2);
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        this.m_checks = MHRPaySelectionCheck.get(Env.getCtx(), n, string, n2, null);
        this.panel.setCursor(Cursor.getDefaultCursor());
        if (this.m_checks == null || this.m_checks.size() == 0) {
            ADialog.error((int)this.m_WindowNo, (Container)this.panel, (String)"VPayPrintNoRecords", (String)("(" + Msg.translate((Properties)Env.getCtx(), (String)"HR_PaySelectionLine_ID") + " #0"));
            return false;
        }
        this.m_batch = MPaymentBatch.getForPaySelection((Properties)Env.getCtx(), (int)n, null);
        return true;
    }
}

