/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Employee;

public class MHREmployee
extends X_HR_Employee {
    private static final long serialVersionUID = -7083160315471023587L;
    private static CCache<Integer, MHREmployee> s_cache = new CCache("HR_Employee", 1000);

    public static MHREmployee get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MHREmployee mHREmployee = (MHREmployee)((Object)s_cache.get((Object)n));
        if (mHREmployee != null) {
            return mHREmployee;
        }
        mHREmployee = new MHREmployee(properties, n, null);
        if (mHREmployee.get_ID() == n) {
            s_cache.put((Object)n, (Object)mHREmployee);
        } else {
            mHREmployee = null;
        }
        return mHREmployee;
    }

    public static MBPartner[] getEmployees(MHRProcess mHRProcess) {
        Object object;
        ArrayList<Comparable<Boolean>> arrayList = new ArrayList<Comparable<Boolean>>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" C_BPartner.C_BPartner_ID IN (SELECT e.C_BPartner_ID FROM HR_Employee e WHERE e.IsActive=?");
        arrayList.add(Boolean.valueOf(true));
        if (mHRProcess.getHR_Payroll_ID() != 0 && mHRProcess.getHR_Period_ID() != 0) {
            stringBuffer.append(" AND (e.HR_Payroll_ID IS NULL OR e.HR_Payroll_ID=?) ");
            arrayList.add(Integer.valueOf(mHRProcess.getHR_Payroll_ID()));
        }
        if (mHRProcess.getHR_Period_ID() == 0) {
            stringBuffer.append(" AND e.StartDate <=? ");
            arrayList.add(mHRProcess.getDateAcct());
        } else {
            object = new MHRPeriod(mHRProcess.getCtx(), mHRProcess.getHR_Period_ID(), mHRProcess.get_TrxName());
            stringBuffer.append(" AND e.StartDate <=? ");
            arrayList.add(object.getEndDate());
            stringBuffer.append(" AND (e.EndDate IS NULL OR e.EndDate >=?) ");
            arrayList.add(object.getStartDate());
        }
        if (mHRProcess.getHR_Department_ID() != 0) {
            stringBuffer.append(" AND e.HR_Department_ID =? ");
            arrayList.add(Integer.valueOf(mHRProcess.getHR_Department_ID()));
        }
        if (mHRProcess.getHR_Job_ID() != 0) {
            stringBuffer.append(" AND e.HR_Job_ID =? ");
            arrayList.add(Integer.valueOf(mHRProcess.getHR_Job_ID()));
        }
        stringBuffer.append(" ) ");
        if (mHRProcess.getC_BPartner_ID() != 0) {
            stringBuffer.append(" AND C_BPartner_ID =? ");
            arrayList.add(Integer.valueOf(mHRProcess.getC_BPartner_ID()));
        }
        stringBuffer.append(" AND AD_Client_ID =? ");
        arrayList.add(Integer.valueOf(mHRProcess.getAD_Client_ID()));
        object = new Query(mHRProcess.getCtx(), "C_BPartner", stringBuffer.toString(), mHRProcess.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return object.toArray(new MBPartner[object.size()]);
    }

    public static MHREmployee getActiveEmployee(Properties properties, int n, String string) {
        return (MHREmployee)new Query(properties, "HR_Employee", "C_BPartner_ID=?", string).setOnlyActiveRecords(true).setParameters(new Object[]{n}).setOrderBy("HR_Employee_ID DESC").first();
    }

    public MHREmployee(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setClientOrg(Env.getAD_Client_ID((Properties)Env.getCtx()), Env.getAD_Org_ID((Properties)Env.getCtx()));
        }
    }

    public MHREmployee(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }
}

