/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_I_HR_Movement;

public class MHRMovement
extends X_HR_Movement {
    private static final long serialVersionUID = 9100478676337821603L;

    public MHRMovement(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRMovement(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRMovement(X_I_HR_Movement x_I_HR_Movement) {
        this(x_I_HR_Movement.getCtx(), 0, x_I_HR_Movement.get_TrxName());
        MHRConcept mHRConcept = new MHRConcept(this.getCtx(), x_I_HR_Movement.getHR_Concept_ID(), this.get_TrxName());
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), x_I_HR_Movement.getC_BPartner_ID(), this.get_TrxName());
        MHRProcess mHRProcess = new MHRProcess(this.getCtx(), x_I_HR_Movement.getHR_Process_ID(), this.get_TrxName());
        this.setAD_Org_ID(mHRProcess.getAD_Org_ID());
        this.setUpdatedBy(x_I_HR_Movement.getUpdatedBy());
        this.setHR_Process_ID(x_I_HR_Movement.getHR_Process_ID());
        this.setC_BPartner_ID(x_I_HR_Movement.getC_BPartner_ID());
        this.setHR_Concept_ID(x_I_HR_Movement.getHR_Concept_ID());
        this.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        this.setDescription(x_I_HR_Movement.getDescription());
        this.setHR_Job_ID(mHREmployee.getHR_Job_ID());
        this.setHR_Department_ID(mHREmployee.getHR_Department_ID());
        this.setC_Activity_ID(mHREmployee.getC_Activity_ID());
        this.setColumnType(mHRConcept.getColumnType());
        this.setValidFrom(x_I_HR_Movement.getValidFrom());
        this.setIsManual(mHRConcept.isManual());
        this.setIsPrinted(mHRConcept.isPrinted());
        this.setAmount(null);
        this.setQty(null);
        this.setServiceDate(null);
        this.setTextMsg(null);
        if (mHRConcept.getColumnType().equals("Q")) {
            this.setQty(x_I_HR_Movement.getQty());
        } else if (mHRConcept.getColumnType().equals("A")) {
            this.setAmount(x_I_HR_Movement.getAmount());
        } else if (mHRConcept.getColumnType().equals("D")) {
            this.setServiceDate(x_I_HR_Movement.getServiceDate());
        } else if (mHRConcept.getColumnType().equals("T")) {
            this.setTextMsg(x_I_HR_Movement.getTextMsg());
        }
    }

    public MHRMovement(MHRProcess mHRProcess, I_HR_Concept i_HR_Concept) {
        this(mHRProcess.getCtx(), 0, mHRProcess.get_TrxName());
        this.setHR_Process_ID(mHRProcess.getHR_Process_ID());
        this.setHR_Concept_Category_ID(i_HR_Concept.getHR_Concept_Category_ID());
        this.setHR_Concept_ID(i_HR_Concept.getHR_Concept_ID());
        this.setColumnType(i_HR_Concept.getColumnType());
    }

    public void addAmount(BigDecimal bigDecimal) {
        this.setAmount(this.getAmount().add(bigDecimal == null ? Env.ZERO : bigDecimal));
    }

    public void addQty(BigDecimal bigDecimal) {
        this.setQty(this.getAmount().add(bigDecimal == null ? Env.ZERO : bigDecimal));
    }

    public boolean isEmpty() {
        return this.getQty().signum() == 0 && this.getAmount().signum() == 0 && Util.isEmpty((String)this.getTextMsg());
    }

    public void setColumnValue(Object object) {
        block8: {
            try {
                String string = this.getColumnType();
                if ("Q".equals(string)) {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    this.setQty(bigDecimal);
                    this.setAmount(Env.ZERO);
                    break block8;
                }
                if ("A".equals(string)) {
                    int n = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)Env.getContextAsInt((Properties)this.p_ctx, (String)"#C_Currency_ID"));
                    BigDecimal bigDecimal = new BigDecimal(object.toString()).setScale(n, 4);
                    this.setAmount(bigDecimal);
                    this.setQty(Env.ZERO);
                    break block8;
                }
                if ("T".equals(string)) {
                    this.setTextMsg(object.toString().trim());
                    break block8;
                }
                if ("D".equals(string)) {
                    if (object instanceof Timestamp) {
                        this.setServiceDate((Timestamp)object);
                    } else {
                        this.setServiceDate(Timestamp.valueOf(object.toString().trim().substring(0, 10) + " 00:00:00.0"));
                    }
                    break block8;
                }
                throw new AdempiereException("@NotSupported@ @ColumnType@ - " + string);
            }
            catch (Exception exception) {
                throw new AdempiereException("@Script Error@");
            }
        }
    }

    protected boolean beforeSave(boolean bl) {
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(Env.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        if (mHREmployee != null) {
            this.setAD_Org_ID(mHREmployee.getAD_Org_ID());
        }
        this.setC_BP_Group_ID(this.getC_BPartner().getC_BP_Group_ID());
        int n = new Query(this.getCtx(), "C_BP_BankAccount", "C_BPartner_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{this.getC_BPartner_ID()}).setOrderBy("C_BP_BankAccount_ID DESC").firstId();
        if (n > 0) {
            this.setC_BP_BankAccount_ID(n);
        }
        this.setAccountSign(this.getHR_Concept().getAccountSign());
        return true;
    }

    public static List<MHRMovement> getLinesForProcess(MHRProcess mHRProcess) {
        return new Query(mHRProcess.getCtx(), "HR_Movement", "HR_Process_ID=?", mHRProcess.get_TrxName()).setClient_ID().setParameters(new Object[]{mHRProcess.getHR_Process_ID()}).list();
    }
}

