/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_PayrollConcept;

public class MHRPayrollConcept
extends X_HR_PayrollConcept {
    private static final long serialVersionUID = 7657163678402925513L;

    public MHRPayrollConcept(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRPayrollConcept(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPayrollConcept(MHRConcept mHRConcept, int n, String string) {
        super(mHRConcept.getCtx(), 0, string);
        this.setHR_Payroll_ID(n);
        this.setHR_Concept_ID(mHRConcept.get_ID());
        this.setName(mHRConcept.getName());
        this.setSeqNo(mHRConcept.getSeqNo());
        this.setIsPrinted(mHRConcept.isPrinted());
        if (mHRConcept.isManual() || "I".equals(mHRConcept.getType())) {
            this.setIsDisplayed(false);
        } else {
            this.setIsDisplayed(true);
        }
        this.setIsActive(true);
    }

    public static MHRPayrollConcept[] getPayrollConcepts(MHRProcess mHRProcess) {
        List list = new Query(mHRProcess.getCtx(), "HR_PayrollConcept", "HR_Payroll_ID=?", null).setOnlyActiveRecords(true).setParameters(new Object[]{mHRProcess.getHR_Payroll_ID()}).setOrderBy("SeqNo").list();
        return list.toArray(new MHRPayrollConcept[list.size()]);
    }

    protected boolean beforeSave(boolean bl) {
        if (this.getSeqNo() == 0) {
            String string = "SELECT COALESCE(MAX(SeqNo),0) FROM HR_PayrollConcept WHERE HR_Payroll_ID=?";
            int n = DB.getSQLValueEx((String)this.get_TrxName(), (String)string, (Object[])new Object[]{this.getHR_Payroll_ID()});
            if (n < 0) {
                n = 0;
            }
            this.setSeqNo(n + 10);
        }
        return true;
    }
}

