/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRConceptCategory;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.X_HR_Process;

public class MHRProcess
extends X_HR_Process
implements DocAction {
    private static final long serialVersionUID = -8553627333715790110L;
    public int m_C_BPartner_ID = 0;
    public int m_AD_User_ID = 0;
    public int m_HR_Concept_ID = 0;
    public int m_HR_Payroll_ID = 0;
    public int m_HR_Department_ID = 0;
    public int m_HR_Job_ID = 0;
    public String m_columnType = "";
    public Timestamp m_dateFrom;
    public Timestamp m_dateTo;
    public Hashtable<Integer, MHRMovement> m_movement = new Hashtable();
    public MHRPayrollConcept[] linesConcept;
    private MHREmployee m_employee;
    HashMap<String, Object> m_scriptCtx = new HashMap();
    private List<MHRConcept> activeConceptRule = new ArrayList<MHRConcept>();
    private static CLogger s_log = CLogger.getCLogger(MHRProcess.class);
    public static final String CONCEPT_PP_COST_COLLECTOR_LABOR = "PP_COST_COLLECTOR_LABOR";
    Object m_description = null;
    private static StringBuffer s_scriptImport = new StringBuffer(" import org.eevolution.model.*; import org.compiere.model.*; import org.adempiere.model.*; import org.compiere.util.*; import java.math.*; import java.sql.*;");
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static void addScriptImportPackage(String string) {
        s_scriptImport.append(" import ").append(string).append(";");
    }

    public MHRProcess(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setC_DocType_ID(0);
            this.set_ValueNoCheck("DocumentNo", null);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setHR_Department_ID(0);
            this.setC_BPartner_ID(0);
        }
    }

    public MHRProcess(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public final void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() <= 0) {
            return;
        }
        DB.executeUpdateEx((String)"UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?", (Object[])new Object[]{bl, this.get_ID()}, (String)this.get_TrxName());
    }

    protected boolean beforeSave(boolean bl) {
        if (this.getAD_Client_ID() == 0) {
            throw new AdempiereException("@AD_Client_ID@ = 0");
        }
        if (this.getAD_Org_ID() == 0) {
            int n = this.getAD_Org_ID();
            if (n == 0) {
                throw new AdempiereException("@AD_Org_ID@ = *");
            }
            this.setAD_Org_ID(n);
            this.log.warning("Changed Org to Context=" + n);
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        return true;
    }

    public boolean processIt(String string) {
        DocumentEngine documentEngine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info("prepareIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MHRPeriod mHRPeriod = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)(this.getHR_Period_ID() > 0 ? mHRPeriod.getDateAcct() : this.getDateAcct()), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        try {
            this.createMovements();
        }
        catch (Exception exception) {
            throw new AdempiereException((Throwable)exception);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public String completeIt() {
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean approveIt() {
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    public boolean postIt() {
        this.log.info("postIt - " + this.toString());
        return false;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            List<MHRMovement> list = MHRMovement.getLinesForProcess(this);
            for (MHRMovement mHRMovement : list) {
                BigDecimal bigDecimal = mHRMovement.getAmount();
                if (bigDecimal.signum() == 0) continue;
                mHRMovement.setAmount(Env.ZERO);
                mHRMovement.setDescription("Void (" + bigDecimal + ")");
                mHRMovement.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.setProcessed(true);
        this.setDocStatus("VO");
        this.saveEx();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        return this.m_processMsg == null;
    }

    public boolean closeIt() {
        if (this.isProcessed()) {
            this.log.info(this.toString());
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
            if (this.m_processMsg != null) {
                return false;
            }
            this.setProcessed(true);
            this.setDocAction("--");
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
            return this.m_processMsg == null;
        }
        return false;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"HRP", (int)this.getAD_Org_ID());
        MHRProcess mHRProcess = MHRProcess.copyFrom(this, this.getDateAcct(), this.getC_DocType_ID(), false, this.get_TrxName(), true);
        if (mHRProcess == null) {
            this.m_processMsg = "Could not create Payroll Process Reversal";
            return false;
        }
        mHRProcess.setReversal_ID(this.getHR_Process_ID());
        mHRProcess.setProcessing(false);
        mHRProcess.setDocStatus("RE");
        mHRProcess.setDocAction("--");
        mHRProcess.setProcessed(true);
        mHRProcess.setName("(" + mHRProcess.getDocumentNo() + " -> " + this.getDocumentNo() + ")");
        mHRProcess.saveEx(this.get_TrxName());
        this.m_processMsg = mHRProcess.getDocumentNo();
        this.setProcessed(true);
        this.setReversal_ID(mHRProcess.getHR_Process_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setDocAction("--");
        this.setName("(" + this.getName() + " <- " + mHRProcess.getDocumentNo() + ")");
        this.saveEx();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        return this.m_processMsg == null;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"HRP", (int)this.getAD_Org_ID());
        String string = "DELETE FROM HR_Movement WHERE HR_Process_ID =" + this.getHR_Process_ID() + " AND IsManual = 'N'";
        int n = DB.executeUpdateEx((String)string, (String)this.get_TrxName());
        this.log.fine("HR_Process deleted #" + n);
        n = MFactAcct.deleteEx((int)Table_ID, (int)this.getHR_Process_ID(), (String)this.get_TrxName());
        this.log.fine("Fact_Acct deleted #" + n);
        this.setDocAction("CO");
        this.setProcessed(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        return this.m_processMsg == null;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String getSummary() {
        return "";
    }

    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine reportEngine = ReportEngine.get((Properties)this.getCtx(), (int)0, (int)0);
        if (reportEngine == null) {
            return null;
        }
        return reportEngine.getPDF(file);
    }

    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    public MHRMovement[] getLines(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Process_ID=?");
        arrayList.add(this.getHR_Process_ID());
        stringBuffer.append("AND (Qty <> 0 OR Amount <> 0)");
        stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND c.IsActive=? AND c.AccountSign<>?)");
        arrayList.add(true);
        arrayList.add("N");
        stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Concept_Acct ca WHERE ca.HR_Concept_ID=HR_Movement.HR_Concept_ID AND ca.IsActive=? AND ca.IsBalancing<>?)");
        arrayList.add(true);
        arrayList.add(true);
        stringBuffer.append(" AND C_BPartner_ID IS NOT NULL");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(SELECT bp.C_BP_Group_ID FROM C_BPartner bp WHERE bp.C_BPartner_ID=HR_Movement.C_BPartner_ID)");
        List list = new Query(this.getCtx(), "HR_Movement", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy(stringBuffer2.toString()).list();
        return list.toArray(new MHRMovement[list.size()]);
    }

    private void loadMovements(Hashtable<Integer, MHRMovement> hashtable, int n) {
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Process_ID=? AND C_BPartner_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getHR_Process_ID(), n}).list();
        for (MHRMovement mHRMovement : list) {
            if (hashtable.containsKey(mHRMovement.getHR_Concept_ID())) {
                MHRMovement mHRMovement2 = hashtable.get(mHRMovement.getHR_Concept_ID());
                String string = mHRMovement2.getColumnType();
                if (string.equals("A")) {
                    mHRMovement.addAmount(mHRMovement2.getAmount());
                } else if (string.equals("Q")) {
                    mHRMovement.addQty(mHRMovement2.getQty());
                }
            }
            hashtable.put(mHRMovement.getHR_Concept_ID(), mHRMovement);
        }
    }

    private Object executeScript(int n, String string) {
        MRule mRule = MRule.get((Properties)this.getCtx(), (int)n);
        Object object = null;
        this.m_description = null;
        try {
            String string2 = "";
            if (mRule.getScript() != null) {
                string2 = mRule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
            }
            String string3 = "double";
            if ("D".equals(string)) {
                string3 = "Timestamp";
            } else if ("T".equals(string)) {
                string3 = "String";
            }
            String string4 = s_scriptImport.toString() + " " + string3 + " result = 0;" + " String description = null;" + string2;
            Scriptlet scriptlet = new Scriptlet("result", string4, this.m_scriptCtx);
            Exception exception = scriptlet.execute();
            if (exception != null) {
                throw exception;
            }
            object = scriptlet.getResult(false);
            this.m_description = scriptlet.getDescription();
        }
        catch (Exception exception) {
            throw new AdempiereException("Execution error - @AD_Rule_ID@=" + mRule.getValue());
        }
        return object;
    }

    private void createCostCollectorMovements(int n, MHRPeriod mHRPeriod) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS (SELECT 1 FROM AD_User u WHERE u.AD_User_ID=PP_Cost_Collector.AD_User_ID AND u.C_BPartner_ID=?)");
        arrayList.add(n);
        stringBuffer.append(" AND MovementDate>=?");
        arrayList.add(mHRPeriod.getStartDate());
        stringBuffer.append(" AND MovementDate<=?");
        arrayList.add(mHRPeriod.getEndDate());
        stringBuffer.append(" AND DocStatus IN (?,?)");
        arrayList.add("CO");
        arrayList.add("CL");
        List list = new Query(this.getCtx(), "PP_Cost_Collector", stringBuffer.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(arrayList).setOrderBy("PP_Cost_Collector_ID DESC").list();
        for (MPPCostCollector mPPCostCollector : list) {
            this.createMovementForCC(n, (I_PP_Cost_Collector)mPPCostCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MHRMovement createMovementForCC(int n, I_PP_Cost_Collector i_PP_Cost_Collector) {
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), CONCEPT_PP_COST_COLLECTOR_LABOR);
        ArrayList<Comparable<Date>> arrayList = new ArrayList<Comparable<Date>>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        arrayList.add(this.m_dateFrom);
        arrayList.add(this.m_dateTo);
        if (this.m_HR_Payroll_ID > 0) {
            stringBuffer.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(Integer.valueOf(this.m_HR_Payroll_ID));
        }
        if (this.m_HR_Department_ID > 0) {
            stringBuffer.append(" AND (HR_Department_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(Integer.valueOf(this.m_HR_Department_ID));
        }
        if (this.m_HR_Job_ID > 0) {
            stringBuffer.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            arrayList.add(Integer.valueOf(this.m_HR_Job_ID));
        }
        stringBuffer.append(" AND HR_Concept_ID = ? ");
        arrayList.add(Integer.valueOf(mHRConcept.get_ID()));
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (mHRAttribute == null) {
            throw new AdempiereException();
        }
        if ("E".equals(mHRConcept.getType())) {
            Object object = null;
            this.m_scriptCtx.put("_CostCollector", i_PP_Cost_Collector);
            try {
                object = this.executeScript(mHRAttribute.getAD_Rule_ID(), mHRAttribute.getColumnType());
            }
            finally {
                this.m_scriptCtx.remove("_CostCollector");
            }
            if (object == null) {
                this.log.warning("Variable (result) is null");
            }
            MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), n, this.get_TrxName());
            MHRMovement mHRMovement = new MHRMovement(this, (I_HR_Concept)mHRConcept);
            mHRMovement.setC_BPartner_ID(n);
            mHRMovement.setAD_Rule_ID(mHRAttribute.getAD_Rule_ID());
            mHRMovement.setHR_Job_ID(mHREmployee.getHR_Job_ID());
            mHRMovement.setHR_Department_ID(mHREmployee.getHR_Department_ID());
            mHRMovement.setC_Activity_ID(mHREmployee.getC_Activity_ID());
            mHRMovement.setValidFrom(this.m_dateFrom);
            mHRMovement.setValidTo(this.m_dateTo);
            mHRMovement.setPP_Cost_Collector_ID(i_PP_Cost_Collector.getPP_Cost_Collector_ID());
            mHRMovement.setIsManual(true);
            mHRMovement.setColumnValue(object);
            mHRMovement.setProcessed(true);
            mHRMovement.saveEx();
            return mHRMovement;
        }
        throw new AdempiereException();
    }

    private void createMovements() throws Exception {
        this.m_scriptCtx.clear();
        this.m_scriptCtx.put("process", (Object)this);
        this.m_scriptCtx.put("_Process", this.getHR_Process_ID());
        this.m_scriptCtx.put("_Period", this.getHR_Period_ID());
        this.m_scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.m_scriptCtx.put("_Department", this.getHR_Department_ID());
        this.log.info("info data -  Process: " + this.getHR_Process_ID() + ", Period: " + this.getHR_Period_ID() + ", Payroll: " + this.getHR_Payroll_ID() + ", Department: " + this.getHR_Department_ID());
        MHRPeriod mHRPeriod = null;
        if (this.getHR_Period_ID() > 0) {
            mHRPeriod = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        } else {
            mHRPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            MPeriod mPeriod = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID());
            if (mPeriod != null) {
                mHRPeriod.setStartDate(mPeriod.getStartDate());
                mHRPeriod.setEndDate(mPeriod.getEndDate());
            } else {
                mHRPeriod.setStartDate(this.getDateAcct());
                mHRPeriod.setEndDate(this.getDateAcct());
            }
        }
        this.m_dateFrom = mHRPeriod.getStartDate();
        this.m_dateTo = mHRPeriod.getEndDate();
        this.m_scriptCtx.put("_From", this.m_dateFrom);
        this.m_scriptCtx.put("_To", this.m_dateTo);
        if (this.getHR_Payroll_ID() > 0) {
            this.m_HR_Payroll_ID = this.getHR_Payroll_ID();
        }
        if (this.getHR_Department_ID() > 0) {
            this.m_HR_Department_ID = this.getHR_Department_ID();
        }
        if (this.getHR_Job_ID() > 0) {
            this.m_HR_Job_ID = this.getHR_Job_ID();
        }
        int n = DB.executeUpdateEx((String)"DELETE FROM HR_Movement m WHERE HR_Process_ID=? AND IsManual<>?", (Object[])new Object[]{this.getHR_Process_ID(), true}, (String)this.get_TrxName());
        this.log.info("HR_Movement deleted #" + n);
        this.linesConcept = MHRPayrollConcept.getPayrollConcepts(this);
        MBPartner[] mBPartnerArray = MHREmployee.getEmployees(this);
        int n2 = 1;
        for (MBPartner mBPartner : mBPartnerArray) {
            this.log.info("Employee " + n2 + "  ---------------------- " + mBPartner.getName());
            ++n2;
            this.m_C_BPartner_ID = mBPartner.get_ID();
            this.m_employee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            this.m_scriptCtx.remove("_DateStart");
            this.m_scriptCtx.remove("_DateEnd");
            this.m_scriptCtx.remove("_Days");
            this.m_scriptCtx.remove("_C_BPartner_ID");
            this.m_scriptCtx.put("_DateStart", this.m_employee.getStartDate());
            this.m_scriptCtx.put("_DateEnd", this.m_employee.getEndDate() == null ? TimeUtil.getDay((int)2999, (int)12, (int)31) : this.m_employee.getEndDate());
            this.m_scriptCtx.put("_Days", TimeUtil.getDaysBetween((Timestamp)mHRPeriod.getStartDate(), (Timestamp)mHRPeriod.getEndDate()) + 1);
            this.m_scriptCtx.put("_C_BPartner_ID", mBPartner.getC_BPartner_ID());
            if (this.getHR_Period_ID() > 0) {
                this.createCostCollectorMovements(mBPartner.get_ID(), mHRPeriod);
            }
            this.m_movement.clear();
            this.loadMovements(this.m_movement, this.m_C_BPartner_ID);
            for (MHRPayrollConcept mHRPayrollConcept : this.linesConcept) {
                this.m_HR_Concept_ID = mHRPayrollConcept.getHR_Concept_ID();
                MHRConcept mHRConcept = MHRConcept.get(this.getCtx(), this.m_HR_Concept_ID);
                boolean bl = mHRPayrollConcept.isPrinted() || mHRConcept.isPrinted();
                MHRMovement mHRMovement = this.m_movement.get(mHRConcept.get_ID());
                if (mHRMovement == null) {
                    mHRMovement = this.createMovementFromConcept(mHRConcept, bl);
                    mHRMovement = this.m_movement.get(mHRConcept.get_ID());
                }
                if (mHRMovement != null) continue;
                throw new AdempiereException("Concept " + mHRConcept.getValue() + " not created");
            }
            for (MHRMovement mHRMovement : this.m_movement.values()) {
                MHRConcept mHRConcept = (MHRConcept)mHRMovement.getHR_Concept();
                if (mHRConcept.isManual() || mHRMovement.isEmpty()) {
                    this.log.fine("Skip saving " + (Object)((Object)mHRMovement));
                    continue;
                }
                boolean bl = mHRMovement.isPrinted() || mHRConcept.isPaid() || mHRConcept.isPrinted();
                if (!bl) continue;
                mHRMovement.saveEx();
            }
        }
        if (this.getHR_Period_ID() > 0) {
            mHRPeriod.setProcessed(true);
            mHRPeriod.saveEx();
        }
    }

    private MHRMovement createMovementFromConcept(MHRConcept mHRConcept, boolean bl) {
        MHRAttribute mHRAttribute;
        this.log.info("Calculating concept " + mHRConcept.getValue());
        this.m_columnType = mHRConcept.getColumnType();
        ArrayList<Comparable<Date>> arrayList = new ArrayList<Comparable<Date>>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        arrayList.add(this.m_dateFrom);
        arrayList.add(this.m_dateTo);
        stringBuffer.append(" AND HR_Concept_ID = ? ");
        arrayList.add(Integer.valueOf(mHRConcept.getHR_Concept_ID()));
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        if (mHRConcept.isEmployee()) {
            stringBuffer.append(" AND C_BPartner_ID = ? AND (HR_Employee_ID = ? OR HR_Employee_ID IS NULL)");
            arrayList.add(Integer.valueOf(this.m_employee.getC_BPartner_ID()));
            arrayList.add(Integer.valueOf(this.m_employee.get_ID()));
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first()) == null || mHRConcept.isManual()) {
            this.log.info("Skip concept " + (Object)((Object)mHRConcept) + " - attribute not found");
            MHRMovement mHRMovement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            mHRMovement.setIsManual(true);
            this.m_movement.put(mHRConcept.getHR_Concept_ID(), mHRMovement);
            return mHRMovement;
        }
        this.log.info("Concept - " + mHRConcept.getName());
        MHRMovement mHRMovement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
        mHRMovement.setC_BPartner_ID(this.m_C_BPartner_ID);
        mHRMovement.setHR_Concept_ID(mHRConcept.getHR_Concept_ID());
        mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        mHRMovement.setHR_Process_ID(this.getHR_Process_ID());
        mHRMovement.setHR_Department_ID(this.m_employee.getHR_Department_ID());
        mHRMovement.setHR_Job_ID(this.m_employee.getHR_Job_ID());
        mHRMovement.setColumnType(this.m_columnType);
        mHRMovement.setAD_Rule_ID(mHRAttribute.getAD_Rule_ID());
        mHRMovement.setValidFrom(this.m_dateFrom);
        mHRMovement.setValidTo(this.m_dateTo);
        mHRMovement.setIsPrinted(bl);
        mHRMovement.setIsManual(mHRConcept.isManual());
        mHRMovement.setC_Activity_ID(this.m_employee.getC_Activity_ID());
        if ("E".equals(mHRConcept.getType())) {
            this.log.info("Executing rule for concept " + mHRConcept.getValue());
            if (this.activeConceptRule.contains((Object)mHRConcept)) {
                throw new AdempiereException("Recursion loop detected in concept " + mHRConcept.getValue());
            }
            this.activeConceptRule.add(mHRConcept);
            Object object = this.executeScript(mHRAttribute.getAD_Rule_ID(), mHRAttribute.getColumnType());
            this.activeConceptRule.remove((Object)mHRConcept);
            if (object == null) {
                this.log.warning("Variable (result) is null");
                return mHRMovement;
            }
            mHRMovement.setColumnValue(object);
            if (this.m_description != null) {
                mHRMovement.setDescription(this.m_description.toString());
            }
        } else {
            mHRMovement.setQty(mHRAttribute.getQty());
            mHRMovement.setAmount(mHRAttribute.getAmount());
            mHRMovement.setTextMsg(mHRAttribute.getTextMsg());
            mHRMovement.setServiceDate(mHRAttribute.getServiceDate());
        }
        mHRMovement.setProcessed(true);
        this.m_movement.put(mHRConcept.getHR_Concept_ID(), mHRMovement);
        return mHRMovement;
    }

    public double getConcept(String string) {
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string.trim());
        if (mHRConcept == null) {
            return 0.0;
        }
        MHRMovement mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        }
        if (mHRMovement == null) {
            throw new AdempiereException("Concept " + mHRConcept.getValue() + " not created");
        }
        String string2 = mHRMovement.getColumnType();
        if ("A".equals(string2)) {
            return mHRMovement.getAmount().doubleValue();
        }
        if ("Q".equals(string2)) {
            return mHRMovement.getQty().doubleValue();
        }
        return 0.0;
    }

    public String getConceptString(String string) {
        String string2;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string.trim());
        if (mHRConcept == null) {
            return null;
        }
        MHRMovement mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        }
        if ("T".equals(string2 = mHRMovement.getColumnType())) {
            return mHRMovement.getTextMsg();
        }
        return null;
    }

    public Timestamp getConceptDate(String string) {
        String string2;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string.trim());
        if (mHRConcept == null) {
            return null;
        }
        MHRMovement mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.m_movement.get(mHRConcept.get_ID());
        }
        if ("T".equals(string2 = mHRMovement.getColumnType())) {
            return mHRMovement.getServiceDate();
        }
        return null;
    }

    public void setConcept(String string, double d) {
        try {
            MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
            if (mHRConcept == null) {
                return;
            }
            MHRMovement mHRMovement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            mHRMovement.setColumnType(mHRConcept.getColumnType());
            mHRMovement.setColumnValue(BigDecimal.valueOf(d));
            mHRMovement.setHR_Process_ID(this.getHR_Process_ID());
            mHRMovement.setHR_Concept_ID(this.m_HR_Concept_ID);
            mHRMovement.setC_BPartner_ID(this.m_C_BPartner_ID);
            mHRMovement.setDescription("Added From Rule");
            mHRMovement.setValidFrom(this.m_dateTo);
            mHRMovement.setValidTo(this.m_dateTo);
            mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
            mHRMovement.setHR_Department_ID(mHREmployee.getHR_Department_ID());
            mHRMovement.setHR_Job_ID(mHREmployee.getHR_Job_ID());
            mHRMovement.setIsManual(mHRConcept.isManual());
            mHRMovement.setC_Activity_ID(mHREmployee.getC_Activity_ID() > 0 ? mHREmployee.getC_Activity_ID() : mHREmployee.getHR_Department().getC_Activity_ID());
            mHRMovement.saveEx();
        }
        catch (Exception exception) {
            s_log.warning(exception.getMessage());
        }
    }

    public void setConcept(String string, double d, boolean bl) {
        try {
            MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
            if (mHRConcept == null) {
                return;
            }
            MHRMovement mHRMovement = new MHRMovement(Env.getCtx(), 0, this.get_TrxName());
            MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            mHRMovement.setColumnType(mHRConcept.getColumnType());
            if (mHRConcept.getColumnType().equals("A")) {
                mHRMovement.setAmount(BigDecimal.valueOf(d));
            } else if (mHRConcept.getColumnType().equals("Q")) {
                mHRMovement.setQty(BigDecimal.valueOf(d));
            } else {
                return;
            }
            mHRMovement.setHR_Process_ID(this.getHR_Process_ID());
            mHRMovement.setHR_Concept_ID(mHRConcept.getHR_Concept_ID());
            mHRMovement.setC_BPartner_ID(this.m_C_BPartner_ID);
            mHRMovement.setDescription("Added From Rule");
            mHRMovement.setValidFrom(this.m_dateTo);
            mHRMovement.setValidTo(this.m_dateTo);
            mHRMovement.setIsManual(bl);
            mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
            mHRMovement.setHR_Department_ID(mHREmployee.getHR_Department_ID());
            mHRMovement.setHR_Job_ID(mHREmployee.getHR_Job_ID());
            mHRMovement.setIsManual(mHRConcept.isManual());
            mHRMovement.setC_Activity_ID(mHREmployee.getC_Activity_ID() > 0 ? mHREmployee.getC_Activity_ID() : mHREmployee.getHR_Department().getC_Activity_ID());
            mHRMovement.saveEx();
        }
        catch (Exception exception) {
            s_log.warning(exception.getMessage());
        }
    }

    public double getConceptGroup(String string) {
        MHRConceptCategory mHRConceptCategory = MHRConceptCategory.forValue(this.getCtx(), string);
        if (mHRConceptCategory == null) {
            return 0.0;
        }
        double d = 0.0;
        for (MHRPayrollConcept mHRPayrollConcept : this.linesConcept) {
            MHRConcept mHRConcept = MHRConcept.get(this.getCtx(), mHRPayrollConcept.getHR_Concept_ID());
            if (mHRConcept.getHR_Concept_Category_ID() != mHRConceptCategory.get_ID()) continue;
            MHRMovement mHRMovement = this.m_movement.get(mHRPayrollConcept.getHR_Concept_ID());
            if (mHRMovement == null) {
                this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
                mHRMovement = this.m_movement.get(mHRConcept.get_ID());
                continue;
            }
            String string2 = mHRMovement.getColumnType();
            if ("A".equals(string2)) {
                d += mHRMovement.getAmount().doubleValue();
                continue;
            }
            if (!"Q".equals(string2)) continue;
            d += mHRMovement.getQty().doubleValue();
        }
        return d;
    }

    public double getList(String string, double d, String string2) {
        BigDecimal bigDecimal = Env.ZERO;
        String string3 = string2;
        if (this.m_columnType.equals("A")) {
            string3 = string3.toString().length() == 1 ? "Col_" + string3 : "Amount" + string3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string4 = "SELECT " + string3 + " FROM HR_List l " + "INNER JOIN HR_ListVersion lv ON (lv.HR_List_ID=l.HR_List_ID) " + "INNER JOIN HR_ListLine ll ON (ll.HR_ListVersion_ID=lv.HR_ListVersion_ID) " + "WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND " + "l.AD_Client_ID = ? AND " + "(? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND " + "(? BETWEEN ll.MinValue AND\tll.MaxValue)";
            arrayList.add(string);
            arrayList.add(this.getAD_Client_ID());
            arrayList.add(this.m_dateFrom);
            arrayList.add(BigDecimal.valueOf(d));
            bigDecimal = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)string4, arrayList);
        }
        if (bigDecimal == null) {
            throw new IllegalStateException("getList Out of Range");
        }
        return bigDecimal.doubleValue();
    }

    public double getAttribute(String string) {
        MHRAttribute mHRAttribute;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return 0.0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidFrom<=?");
        arrayList.add(this.m_dateFrom);
        stringBuffer.append(" AND AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        if (this.m_HR_Payroll_ID > 0) {
            stringBuffer.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(this.m_HR_Payroll_ID);
        }
        if (this.m_HR_Department_ID > 0) {
            stringBuffer.append(" AND (HR_Department_ID=? OR HR_Department_ID IS NULL)");
            arrayList.add(this.m_HR_Department_ID);
        }
        if (this.m_HR_Job_ID > 0) {
            stringBuffer.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            arrayList.add(this.m_HR_Job_ID);
        }
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(string);
        if (!mHRConcept.getType().equals("I")) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(this.m_C_BPartner_ID);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").first()) == null) {
            return 0.0;
        }
        if (mHRConcept.getColumnType().equals("Q")) {
            return mHRAttribute.getQty().doubleValue();
        }
        if (mHRConcept.getColumnType().equals("A")) {
            return mHRAttribute.getAmount().doubleValue();
        }
        return 0.0;
    }

    public Timestamp getAttributeDate(String string) {
        MHRAttribute mHRAttribute;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(string);
        if (!mHRConcept.getType().equals("I")) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(this.m_C_BPartner_ID);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").first()) == null) {
            return null;
        }
        return mHRAttribute.getServiceDate();
    }

    public String getAttributeString(String string) {
        MHRAttribute mHRAttribute;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(string);
        if (!mHRConcept.getType().equals("I")) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(this.m_C_BPartner_ID);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").first()) == null) {
            return null;
        }
        return mHRAttribute.getTextMsg();
    }

    public int getDays(Timestamp timestamp, Timestamp timestamp2) {
        return TimeUtil.getDaysBetween((Timestamp)timestamp, (Timestamp)timestamp2) + 1;
    }

    public int getDays(String string, String string2) {
        Timestamp timestamp = Timestamp.valueOf(string);
        Timestamp timestamp2 = Timestamp.valueOf(string2);
        return this.getDays(timestamp, timestamp2);
    }

    public int getMonths(Timestamp timestamp, Timestamp timestamp2) {
        Comparable<Date> comparable;
        boolean bl = false;
        Comparable<Date> comparable2 = timestamp2;
        Timestamp timestamp3 = timestamp;
        if (comparable2.before(timestamp3)) {
            bl = true;
            comparable = timestamp3;
            timestamp3 = comparable2;
            comparable2 = comparable;
        }
        comparable = new GregorianCalendar();
        ((Calendar)comparable).setTime(timestamp3);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        ((Calendar)comparable).set(14, 0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)comparable2);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (((Calendar)comparable).get(1) == gregorianCalendar.get(1)) {
            if (bl) {
                return (gregorianCalendar.get(2) - ((Calendar)comparable).get(2)) * -1;
            }
            return gregorianCalendar.get(2) - ((Calendar)comparable).get(2);
        }
        int n = 0;
        while (gregorianCalendar.after(comparable)) {
            ((GregorianCalendar)comparable).add(2, 1);
            ++n;
        }
        if (bl) {
            return n * -1;
        }
        return n;
    }

    public double getConcept(String string, int n, int n2) {
        return this.getConcept(string, null, n, n2);
    }

    public double getConcept(String string, String string2, int n, int n2) {
        String string3;
        int n3 = string2 == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), string2).get_ID();
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod mHRPeriod = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(this.m_C_BPartner_ID);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        arrayList.add(n3);
        if (n < 0) {
            stringBuffer.append(" AND pr.PeriodNo >= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n);
        }
        if (n2 > 0) {
            stringBuffer.append(" AND pr.PeriodNo <= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n2);
        }
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(SUM(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public double getConcept(String string, String string2, Timestamp timestamp, Timestamp timestamp2) {
        String string3;
        int n = string2 == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), string2).get_ID();
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Comparable<Integer>> arrayList = new ArrayList<Comparable<Integer>>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID = ?");
        arrayList.add(Integer.valueOf(this.getAD_Client_ID()));
        stringBuffer.append(" AND HR_Concept_ID=?");
        arrayList.add(Integer.valueOf(mHRConcept.get_ID()));
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(Integer.valueOf(this.m_C_BPartner_ID));
        stringBuffer.append(" AND validTo BETWEEN ? AND ?");
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        arrayList.add(Integer.valueOf(n));
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(SUM(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public double getAttribute(Properties properties, String string, Timestamp timestamp, Timestamp timestamp2) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, Timestamp, Timestamp)");
        return 0.0;
    }

    public double getAttribute(Properties properties, String string, int n, int n2, String string2, String string3) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, int, int, String, String)");
        return 0.0;
    }

    public int getAttributeInvoice(String string) {
        MHRAttribute mHRAttribute;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return 0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidFrom<=?");
        arrayList.add(this.m_dateFrom);
        stringBuffer.append(" AND AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(string);
        if (!"I".equals(mHRConcept.getType())) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(this.m_C_BPartner_ID);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)mHRAttribute.get_Value("C_Invoice_ID");
        }
        return 0;
    }

    public int getAttributeDocType(String string) {
        MHRAttribute mHRAttribute;
        MHRConcept mHRConcept = MHRConcept.forValue(this.getCtx(), string);
        if (mHRConcept == null) {
            return 0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidFrom<=?");
        arrayList.add(this.m_dateFrom);
        stringBuffer.append(" AND AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(string);
        if (!"I".equals(mHRConcept.getType())) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(this.m_C_BPartner_ID);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)mHRAttribute.get_Value("C_DocType_ID");
        }
        return 0;
    }

    public double getDays(int n) {
        this.log.warning("instead of using getDays in the formula it's recommended to use _DaysPeriod+1");
        return Env.getContextAsInt((Properties)this.getCtx(), (String)"_DaysPeriod") + 1;
    }

    public static MHRProcess copyFrom(MHRProcess mHRProcess, Timestamp timestamp, int n, boolean bl, String string, boolean bl2) {
        MHRProcess mHRProcess2 = new MHRProcess(mHRProcess.getCtx(), 0, string);
        PO.copyValues((PO)mHRProcess, (PO)mHRProcess2, (int)mHRProcess.getAD_Client_ID(), (int)mHRProcess.getAD_Org_ID());
        mHRProcess2.set_ValueNoCheck("DocumentNo", null);
        mHRProcess2.setDocStatus("DR");
        mHRProcess2.setDocAction("CO");
        mHRProcess2.setName(mHRProcess.getDocumentNo());
        mHRProcess2.setC_DocType_ID(n);
        mHRProcess2.setC_DocTypeTarget_ID(n);
        mHRProcess2.setDateAcct(timestamp);
        mHRProcess2.setHR_Job_ID(mHRProcess.getHR_Job_ID());
        mHRProcess2.setHR_Department_ID(mHRProcess.getHR_Department_ID());
        mHRProcess2.setHR_Payroll_ID(mHRProcess.getHR_Payroll_ID());
        mHRProcess2.setHR_Period_ID(mHRProcess.getHR_Period_ID());
        mHRProcess2.setC_BPartner_ID(mHRProcess.getC_BPartner_ID());
        mHRProcess2.setHR_Employee_ID(mHRProcess.getHR_Employee_ID());
        mHRProcess2.setC_Charge_ID(mHRProcess.getC_Charge_ID());
        mHRProcess2.setPosted(false);
        mHRProcess2.setProcessed(false);
        mHRProcess2.setProcessing(false);
        mHRProcess2.saveEx(string);
        if (mHRProcess2.copyLinesFrom(mHRProcess) == 0) {
            throw new IllegalStateException("Could not create Payroll Lines");
        }
        return mHRProcess2;
    }

    public int copyLinesFrom(MHRProcess mHRProcess) {
        if (this.isProcessed() || this.isPosted() || mHRProcess == null) {
            return 0;
        }
        List<MHRMovement> list = MHRMovement.getLinesForProcess(mHRProcess);
        for (MHRMovement mHRMovement : list) {
            MHRMovement mHRMovement2 = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)mHRMovement, (PO)mHRMovement2, (int)mHRMovement.getAD_Client_ID(), (int)mHRMovement.getAD_Org_ID());
            mHRMovement2.setIsManual(mHRMovement.isManual());
            mHRMovement2.setHR_Concept_Category_ID(mHRMovement.getHR_Concept_Category_ID());
            mHRMovement2.setHR_Process_ID(this.getHR_Process_ID());
            mHRMovement2.setC_BPartner_ID(mHRMovement.getC_BPartner_ID());
            mHRMovement2.setHR_Concept_ID(mHRMovement.getHR_Concept_ID());
            mHRMovement2.setColumnType(mHRMovement.getColumnType());
            mHRMovement2.setDescription(mHRMovement.getDescription());
            mHRMovement2.setHR_Department_ID(mHRMovement.getHR_Department_ID());
            mHRMovement2.setHR_Job_ID(mHRMovement.getHR_Job_ID());
            mHRMovement2.setIsPrinted(mHRMovement.isPrinted());
            mHRMovement2.setQty(mHRMovement.getQty().negate());
            mHRMovement2.setServiceDate(mHRMovement.getServiceDate());
            mHRMovement2.setTextMsg(mHRMovement.getTextMsg());
            mHRMovement2.setValidFrom(mHRMovement.getValidFrom());
            mHRMovement2.setValidTo(mHRMovement.getValidTo());
            mHRMovement2.setAD_Rule_ID(mHRMovement.getAD_Rule_ID());
            mHRMovement2.setAmount(mHRMovement.getAmount().negate());
            mHRMovement2.setC_Activity_ID(mHRMovement.getC_Activity_ID());
            mHRMovement2.setC_Campaign_ID(mHRMovement.getC_Campaign_ID());
            mHRMovement2.setAD_OrgTrx_ID(mHRMovement.getAD_OrgTrx_ID());
            mHRMovement2.setC_ProjectPhase_ID(mHRMovement.getC_ProjectPhase_ID());
            mHRMovement2.setC_ProjectPhase_ID(mHRMovement.getC_ProjectPhase_ID());
            mHRMovement2.setC_Project_ID(mHRMovement.getC_Project_ID());
            mHRMovement2.setUser1_ID(mHRMovement.getUser1_ID());
            mHRMovement2.setUser2_ID(mHRMovement.getUser2_ID());
            mHRMovement2.setProcessed(false);
            mHRMovement2.saveEx();
        }
        return list.size();
    }
}

