/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MHRPaySelection;
import org.eevolution.model.MHRPaySelectionCheck;
import org.eevolution.model.MHRPaySelectionLine;

public class HRPaySelectionCreateCheck
extends SvrProcess {
    private String p_PaymentRule = null;
    private int p_HR_PaySelection_ID = 0;
    private ArrayList<MHRPaySelectionCheck> m_list = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("PaymentRule")) {
                this.p_PaymentRule = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
        this.p_HR_PaySelection_ID = this.getRecord_ID();
        if (this.p_PaymentRule != null && this.p_PaymentRule.equals("D")) {
            this.p_PaymentRule = null;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("HR_PaySelection_ID=" + this.p_HR_PaySelection_ID + ", PaymentRule=" + this.p_PaymentRule);
        MHRPaySelection mHRPaySelection = new MHRPaySelection(this.getCtx(), this.p_HR_PaySelection_ID, this.get_TrxName());
        if (mHRPaySelection.get_ID() == 0) {
            throw new IllegalArgumentException("Not found HR_PaySelection_ID=" + this.p_HR_PaySelection_ID);
        }
        if (mHRPaySelection.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        MHRPaySelectionLine[] mHRPaySelectionLineArray = mHRPaySelection.getLines(false);
        for (int i = 0; i < mHRPaySelectionLineArray.length; ++i) {
            MHRPaySelectionLine mHRPaySelectionLine = mHRPaySelectionLineArray[i];
            if (!mHRPaySelectionLine.isActive() || mHRPaySelectionLine.isProcessed()) continue;
            this.createCheck(mHRPaySelectionLine);
        }
        mHRPaySelection.setProcessed(true);
        mHRPaySelection.save();
        return "@C_PaySelectionCheck_ID@ - #" + this.m_list.size();
    }

    private void createCheck(MHRPaySelectionLine mHRPaySelectionLine) throws Exception {
        MHRPaySelectionCheck mHRPaySelectionCheck2;
        for (MHRPaySelectionCheck mHRPaySelectionCheck2 : this.m_list) {
            if (mHRPaySelectionCheck2.getC_BPartner_ID() != mHRPaySelectionLine.getHR_Movement().getC_BPartner_ID()) continue;
            mHRPaySelectionCheck2.addLine(mHRPaySelectionLine);
            if (!mHRPaySelectionCheck2.save()) {
                throw new IllegalStateException("Cannot save MHRPaySelectionCheck");
            }
            mHRPaySelectionLine.setHR_PaySelectionCheck_ID(mHRPaySelectionCheck2.getHR_PaySelectionCheck_ID());
            mHRPaySelectionLine.setProcessed(true);
            if (!mHRPaySelectionLine.save()) {
                throw new IllegalStateException("Cannot save MHRPaySelectionLine");
            }
            return;
        }
        Object object = mHRPaySelectionLine.getPaymentRule();
        if (this.p_PaymentRule != null && !"D".equals(object)) {
            object = this.p_PaymentRule;
        }
        if (!(mHRPaySelectionCheck2 = new MHRPaySelectionCheck(mHRPaySelectionLine, (String)object)).save()) {
            throw new IllegalStateException("Cannot save MHRPaySelectionCheck");
        }
        mHRPaySelectionLine.setHR_PaySelectionCheck_ID(mHRPaySelectionCheck2.getHR_PaySelectionCheck_ID());
        mHRPaySelectionLine.setProcessed(true);
        if (!mHRPaySelectionLine.save()) {
            throw new IllegalStateException("Cannot save MHRPaySelectionLine");
        }
        this.m_list.add(mHRPaySelectionCheck2);
    }
}

