/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPaySelection;
import org.eevolution.model.MHRPaySelectionLine;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRProcess;

public class HRPaySelectionCreateFrom
extends SvrProcess {
    private int p_HR_Process_ID = 0;
    private int p_HR_Payroll_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private String p_PaymentRule = null;
    private int p_HR_Concept_ID = 0;
    private int p_HR_Department_ID = 0;
    private int p_HR_Job_ID = 0;
    private int p_HR_PaySelection_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("HR_Process_ID")) {
                this.p_HR_Process_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("HR_Payroll_ID")) {
                this.p_HR_Payroll_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("PaymentRule")) {
                this.p_PaymentRule = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("HR_Concept_ID")) {
                this.p_HR_Concept_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("HR_Department_ID")) {
                this.p_HR_Department_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("HR_Job_ID")) {
                this.p_HR_Job_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
        this.p_HR_PaySelection_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("C_PaySelection_ID=" + this.p_HR_PaySelection_ID + ", Process=" + this.p_HR_Process_ID + ", Payroll=" + this.p_HR_Payroll_ID + ", BP Group=" + this.p_C_BP_Group_ID + ", PaymentRule=" + this.p_PaymentRule + ", Concept=" + this.p_HR_Concept_ID + ", Depatment=" + this.p_HR_Department_ID + ", Job=" + this.p_HR_Job_ID);
        MHRPaySelection mHRPaySelection = new MHRPaySelection(this.getCtx(), this.p_HR_PaySelection_ID, this.get_TrxName());
        MHRProcess mHRProcess = new MHRProcess(this.getCtx(), this.p_HR_Process_ID, this.get_TrxName());
        MHRPayroll mHRPayroll = new MHRPayroll(this.getCtx(), mHRProcess.getHR_Payroll_ID(), this.get_TrxName());
        if (mHRPaySelection.get_ID() == 0) {
            throw new IllegalArgumentException("Not found HR_PaySelection_ID=" + this.p_HR_PaySelection_ID);
        }
        if (mHRPaySelection.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        StringBuffer stringBuffer = new StringBuffer("HR_Process_ID=" + this.p_HR_Process_ID);
        stringBuffer.append(" AND HR_Concept_ID IN(SELECT HR_Concept_ID FROM HR_Concept WHERE IsPaid='Y')");
        stringBuffer.append(" AND HR_Movement_ID NOT IN(SELECT HR_Movement_ID  FROM HR_PaySelectionLine  WHERE HR_PaySelectionCheck_ID > 0 OR HR_PaySelection_ID=" + this.p_HR_PaySelection_ID + ")");
        if (this.p_C_BP_Group_ID > 0) {
            stringBuffer.append(" AND C_BPartner_ID IN(SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID=" + this.p_C_BP_Group_ID + ")");
        }
        if (this.p_C_BPartner_ID > 0) {
            stringBuffer.append(" AND C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        System.err.println("PaymentRule: " + this.p_PaymentRule);
        if (this.p_PaymentRule != null) {
            stringBuffer.append(" AND C_BPartner_ID IN(SELECT C_BPartner_ID FROM C_BPartner WHERE PaymentRulePO =" + this.p_PaymentRule + ")");
        }
        if (this.p_HR_Concept_ID > 0) {
            stringBuffer.append(" AND HR_Concept_ID=" + this.p_HR_Concept_ID);
        }
        if (this.p_HR_Department_ID > 0) {
            stringBuffer.append(" AND HR_Department_ID=" + this.p_HR_Department_ID);
        }
        if (this.p_HR_Job_ID > 0) {
            stringBuffer.append(" AND HR_Job_ID=" + this.p_HR_Job_ID);
        }
        int n = 0;
        List list = new Query(this.getCtx(), "HR_Movement", stringBuffer.toString(), this.get_TrxName()).list();
        for (MHRMovement mHRMovement : list) {
            MBPartner mBPartner = new MBPartner(this.getCtx(), mHRMovement.getC_BPartner_ID(), this.get_TrxName());
            String string = "";
            string = mBPartner.getPaymentRulePO() != null ? mBPartner.getPaymentRule() : mHRPayroll.getPaymentRule();
            if (string == null) {
                string = "D";
            }
            MHRPaySelectionLine mHRPaySelectionLine = new MHRPaySelectionLine(this.getCtx(), 0, this.get_TrxName());
            mHRPaySelectionLine.setHR_PaySelection_ID(this.p_HR_PaySelection_ID);
            mHRPaySelectionLine.setHR_Movement_ID(mHRMovement.getHR_Movement_ID());
            mHRPaySelectionLine.setPaymentRule(string);
            mHRPaySelectionLine.setAD_Org_ID(mHRPaySelection.getAD_Org_ID());
            mHRPaySelectionLine.setLine((n + 1) * 10);
            mHRPaySelectionLine.setOpenAmt(mHRMovement.getAmount().setScale(2, 5));
            mHRPaySelectionLine.setPayAmt(mHRMovement.getAmount().setScale(2, 5));
            mHRPaySelectionLine.setDescription(mBPartner.getName() + " " + mBPartner.getName2());
            mHRPaySelectionLine.setDifferenceAmt(Env.ZERO);
            mHRPaySelectionLine.setDiscountAmt(Env.ZERO);
            mHRPaySelectionLine.setIsManual(false);
            mHRPaySelectionLine.setIsSOTrx(false);
            mHRPaySelectionLine.setIsActive(true);
            mHRPaySelectionLine.saveEx();
            ++n;
        }
        return "@C_PaySelectionLine_ID@  - #" + n;
    }
}

