/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MHRProcess;

public class PayrollProcessing
extends SvrProcess {
    public static final String PARAM_HR_Process_ID = "HR_Process_ID";
    private int m_HR_Process_ID;

    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) {
                this.log.fine("Null Parameter: " + string);
                continue;
            }
            if (string.equals(PARAM_HR_Process_ID)) {
                this.m_HR_Process_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    protected String doIt() throws Exception {
        if (this.m_HR_Process_ID <= 0) {
            throw new FillMandatoryException(new String[]{PARAM_HR_Process_ID});
        }
        MHRProcess mHRProcess = new MHRProcess(this.getCtx(), this.m_HR_Process_ID, this.get_TrxName());
        long l = System.currentTimeMillis();
        boolean bl = mHRProcess.processIt("CO");
        mHRProcess.saveEx();
        if (!bl) {
            throw new AdempiereException(mHRProcess.getProcessMsg());
        }
        return "@Processed@ " + mHRProcess.getName() + " - " + (System.currentTimeMillis() - l) + "ms";
    }
}

