/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.jmx.connector.invoker.SecurityActions;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.security.SubjectSecurityManager;

public final class AuthenticationInterceptor
extends AbstractInterceptor {
    private SubjectSecurityManager securityMgr;

    public void setSecurityDomain(String securityDomain) throws Exception {
        block3: {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("setSecurityDomain=" + securityDomain));
                }
                InitialContext ctx = new InitialContext();
                this.securityMgr = (SubjectSecurityManager)ctx.lookup(securityDomain);
            }
            catch (Exception e) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace((Object)"Ignorable exception in setSecurityDomain=", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        String opName;
        String type = invocation.getType();
        Subject subject = null;
        if (type == "invoke" && this.securityMgr != null && (opName = invocation.getName()).equals("invoke")) {
            Object[] args = invocation.getArgs();
            org.jboss.invocation.Invocation inv = (org.jboss.invocation.Invocation)args[0];
            Principal caller = inv.getPrincipal();
            Object credential = inv.getCredential();
            subject = new Subject();
            boolean isValid = this.securityMgr.isValid(caller, credential, subject);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[Authentication for caller=" + caller + " and subject=" + subject + "]:result=" + isValid));
            }
            if (!isValid) {
                String msg = "Failed to authenticate principal=" + caller + ", securityDomain=" + this.securityMgr.getSecurityDomain();
                throw new SecurityException(msg);
            }
            SecurityActions.pushSubjectContext(caller, credential, subject);
        }
        try {
            AbstractInterceptor i = invocation.nextInterceptor();
            object = i.invoke(invocation);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var12_12 = null;
                if (this.log.isTraceEnabled() && subject != null) {
                    this.log.trace((Object)("pop out the subject:" + subject));
                }
                if (subject == null) break block8;
                SecurityActions.popSubjectContext();
            }
            throw throwable;
        }
        if (this.log.isTraceEnabled() && subject != null) {
            this.log.trace((Object)("pop out the subject:" + subject));
        }
        if (subject != null) {
            SecurityActions.popSubjectContext();
        }
        return object;
    }
}

