/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.jboss.deployment.cache.DeploymentStore;
import org.jboss.deployment.cache.FileDeploymentStoreMBean;
import org.jboss.system.ConfigurationException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.stream.Streams;

public class FileDeploymentStore
extends ServiceMBeanSupport
implements DeploymentStore,
FileDeploymentStoreMBean {
    protected File dir;
    protected File mapFile;
    protected Map urlMap;

    public void setDirectory(File dir) throws IOException {
        if (dir == null) {
            throw new NullArgumentException("dir");
        }
        if (!dir.isAbsolute()) {
            File serverHome = ServerConfigLocator.locate().getServerHomeDir();
            dir = new File(serverHome, dir.getPath());
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Given file reference is not a directory: " + dir);
        }
        if (!dir.canWrite()) {
            throw new IOException("Can not write to directory: " + dir);
        }
        if (!dir.canRead()) {
            throw new IOException("Can not read directory: " + dir);
        }
        this.dir = dir.getCanonicalFile();
        this.log.debug((Object)("Using directory for cache storage: " + dir));
        this.mapFile = new File(dir, "state-map.ser");
    }

    public File getDirectory() {
        return this.dir;
    }

    public void setDirectoryName(String dirname) throws IOException {
        if (dirname == null) {
            throw new NullArgumentException("dirname");
        }
        this.setDirectory(new File(dirname));
    }

    public String getDirectoryName() {
        return this.dir.getAbsolutePath();
    }

    protected URL getURLFromFile(File file) {
        try {
            return file.toURL();
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public URL get(URL url) {
        File file = (File)this.urlMap.get(url);
        if (file == null) {
            return null;
        }
        return this.getURLFromFile(file);
    }

    public URL put(URL url) throws Exception {
        File file;
        URL localURL = this.get(url);
        if (localURL == null) {
            CRC32 checksum = new CRC32();
            checksum.update(url.toString().getBytes());
            String prefix = Long.toString(checksum.getValue(), 36);
            String filename = url.getFile();
            filename = filename.substring(filename.lastIndexOf("/") + 1, filename.length());
            file = new File(this.dir, prefix + "-" + filename);
            this.urlMap.put(url, file);
            this.writeMap();
        } else {
            file = (File)this.urlMap.get(url);
        }
        this.copyURL(url, file);
        return this.getURLFromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyURL(URL source, File dest) throws IOException {
        BufferedInputStream is = new BufferedInputStream(source.openConnection().getInputStream());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            Streams.copy((InputStream)is, (OutputStream)os);
            ((OutputStream)os).flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)os).close();
            ((InputStream)is).close();
            throw throwable;
        }
        ((OutputStream)os).close();
        ((InputStream)is).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map readMap() throws ClassNotFoundException, IOException {
        if (this.mapFile.exists()) {
            Map map;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.mapFile));
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                map = (Map)ois.readObject();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ois.close();
                throw throwable;
            }
            ois.close();
            return map;
        }
        this.log.debug((Object)"Map file not found, creating new map");
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMap() throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.mapFile));
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(this.urlMap);
            oos.flush();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    protected void createService() throws Exception {
        if (this.dir == null) {
            throw new ConfigurationException("Missing attribute 'Directory'");
        }
        this.urlMap = this.readMap();
    }
}

