/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.xmlss.XmlssCellStyle;

public class XmlssStyleCache {
    private Writer styleWriter = null;
    private Set fontFaces = new HashSet();
    private Map cellStyles = new HashMap();
    private int cellStylesCounter = 0;

    public XmlssStyleCache(Writer styleWriter, Map fontMap) {
        this.styleWriter = styleWriter;
    }

    public Collection getFontFaces() {
        return this.fontFaces;
    }

    public String getCellStyle(JRPrintElement element, Color cellBackground, String pattern, boolean isShrinkToFit, JRFont defaultFont, Map fontMap) throws IOException {
        String cellStyleId;
        String cellStyleName;
        XmlssCellStyle xmlssCellStyle = new XmlssCellStyle(this.styleWriter, element, cellBackground, pattern, isShrinkToFit, defaultFont, fontMap);
        if (element instanceof JRBoxContainer) {
            xmlssCellStyle.setBox(((JRBoxContainer)((Object)element)).getLineBox());
        }
        if (element instanceof JRCommonGraphicElement) {
            xmlssCellStyle.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
        }
        if ((cellStyleName = (String)this.cellStyles.get(cellStyleId = xmlssCellStyle.getId())) == null) {
            cellStyleName = "C" + this.cellStylesCounter++;
            this.cellStyles.put(cellStyleId, cellStyleName);
            xmlssCellStyle.write(cellStyleName);
        }
        return cellStyleName;
    }
}

