/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.AccessibleObject;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ParseException;

public class JoinPointMatcher {
    Pointcut p;

    public JoinPointMatcher(String expr) throws ParseException {
        this.p = new PointcutExpression("test", expr);
    }

    public boolean matches(Invocation invocation) {
        if (invocation instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)invocation;
            return this.p.matchesExecution(mi.getAdvisor(), mi.getMethod());
        }
        if (invocation instanceof ConstructorInvocation) {
            ConstructorInvocation mi = (ConstructorInvocation)invocation;
            return this.p.matchesExecution(mi.getAdvisor(), mi.getConstructor());
        }
        if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation mi = (FieldReadInvocation)invocation;
            return this.p.matchesGet(mi.getAdvisor(), mi.getField());
        }
        if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation mi = (FieldWriteInvocation)invocation;
            return this.p.matchesSet(mi.getAdvisor(), mi.getField());
        }
        if (invocation instanceof MethodCalledByMethodInvocation) {
            MethodCalledByMethodInvocation mi = (MethodCalledByMethodInvocation)invocation;
            return this.p.matchesCall(mi.getAdvisor(), (AccessibleObject)mi.getCallingMethod(), mi.getCalledMethod().getDeclaringClass(), mi.getCalledMethod());
        }
        if (invocation instanceof MethodCalledByConstructorInvocation) {
            MethodCalledByConstructorInvocation mi = (MethodCalledByConstructorInvocation)invocation;
            return this.p.matchesCall(mi.getAdvisor(), (AccessibleObject)mi.getCalling(), mi.getCalledMethod().getDeclaringClass(), mi.getCalledMethod());
        }
        if (invocation instanceof ConstructorCalledByConstructorInvocation) {
            ConstructorCalledByConstructorInvocation mi = (ConstructorCalledByConstructorInvocation)invocation;
            return this.p.matchesCall(mi.getAdvisor(), (AccessibleObject)mi.getCallingConstructor(), mi.getCalledConstructor().getDeclaringClass(), mi.getCalledConstructor());
        }
        if (invocation instanceof ConstructorCalledByMethodInvocation) {
            ConstructorCalledByMethodInvocation mi = (ConstructorCalledByMethodInvocation)invocation;
            return this.p.matchesCall(mi.getAdvisor(), (AccessibleObject)mi.getCallingMethod(), mi.getCalledConstructor().getDeclaringClass(), mi.getCalledConstructor());
        }
        throw new RuntimeException("UNKNOWN JOINPOINT TYPE: " + invocation.getClass().getName());
    }
}

