/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.aop.instrument.HotSwapper;

class InstrumentationAdapter
implements HotSwapper {
    private Instrumentation instrumentation;
    private Collection<ClassDefinition> classDefinitions;

    public InstrumentationAdapter(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classDefinitions = new ArrayList<ClassDefinition>();
    }

    public synchronized void registerChange(Class clazz, byte[] classCode) {
        ClassDefinition classDef = new ClassDefinition(clazz, classCode);
        this.classDefinitions.add(classDef);
    }

    public synchronized void hotSwap() {
        ClassDefinition[] definitions = new ClassDefinition[this.classDefinitions.size()];
        definitions = this.classDefinitions.toArray(definitions);
        try {
            this.instrumentation.redefineClasses(definitions);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        this.classDefinitions.clear();
    }
}

