/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.install.Config;
import org.compiere.install.ConfigGlassfish;
import org.compiere.install.ConfigJBoss;
import org.compiere.install.ConfigMySQL;
import org.compiere.install.ConfigOracle;
import org.compiere.install.ConfigPostgreSQL;
import org.compiere.install.ConfigVMMac;
import org.compiere.install.ConfigVMOpenJDK;
import org.compiere.install.ConfigVMSun;
import org.compiere.install.ConfigurationPanel;
import org.compiere.install.KeyStoreMgt;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Ini;

public class ConfigurationData {
    protected ConfigurationPanel p_panel = null;
    protected Properties p_properties = new Properties();
    private File m_adempiereHome;
    static CLogger log = CLogger.getCLogger(ConfigurationData.class);
    public static final String ADEMPIERE_ENV_FILE = "AdempiereEnv.properties";
    public static final String ADEMPIERE_HOME = "ADEMPIERE_HOME";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String JAVA_TYPE = "ADEMPIERE_JAVA_TYPE";
    public static final String ADEMPIERE_JAVA_OPTIONS = "ADEMPIERE_JAVA_OPTIONS";
    public static final String KEYSTORE_PASSWORD = "myPassword";
    public static final String ADEMPIERE_APPS_TYPE = "ADEMPIERE_APPS_TYPE";
    public static final String ADEMPIERE_APPS_SERVER = "ADEMPIERE_APPS_SERVER";
    public static final String ADEMPIERE_APPS_DEPLOY = "ADEMPIERE_APPS_DEPLOY";
    public static final String ADEMPIERE_JNP_PORT = "ADEMPIERE_JNP_PORT";
    public static final String ADEMPIERE_WEB_PORT = "ADEMPIERE_WEB_PORT";
    public static final String ADEMPIERE_SSL_PORT = "ADEMPIERE_SSL_PORT";
    public static final String ADEMPIERE_WEB_ALIAS = "ADEMPIERE_WEB_ALIAS";
    public static final String ADEMPIERE_KEYSTORE = "ADEMPIERE_KEYSTORE";
    public static final String ADEMPIERE_KEYSTOREPASS = "ADEMPIERE_KEYSTOREPASS";
    public static final String ADEMPIERE_KEYSTORECODEALIAS = "ADEMPIERE_KEYSTORECODEALIAS";
    public static final String ADEMPIERE_KEYSTOREWEBALIAS = "ADEMPIERE_KEYSTOREWEBALIAS";
    public static final String ADEMPIERE_CERT_CN = "ADEMPIERE_CERT_CN";
    public static final String ADEMPIERE_CERT_ORG = "ADEMPIERE_CERT_ORG";
    public static final String ADEMPIERE_CERT_ORG_UNIT = "ADEMPIERE_CERT_ORG_UNIT";
    public static final String ADEMPIERE_CERT_LOCATION = "ADEMPIERE_CERT_LOCATION";
    public static final String ADEMPIERE_CERT_STATE = "ADEMPIERE_CERT_STATE";
    public static final String ADEMPIERE_CERT_COUNTRY = "ADEMPIERE_CERT_COUNTRY";
    public static final String ADEMPIERE_DB_TYPE = "ADEMPIERE_DB_TYPE";
    public static final String ADEMPIERE_DB_PATH = "ADEMPIERE_DB_PATH";
    public static final String ADEMPIERE_DB_SERVER = "ADEMPIERE_DB_SERVER";
    public static final String ADEMPIERE_DB_PORT = "ADEMPIERE_DB_PORT";
    public static final String ADEMPIERE_DB_NAME = "ADEMPIERE_DB_NAME";
    public static final String ADEMPIERE_DB_URL = "ADEMPIERE_DB_URL";
    public static final String ADEMPIERE_DB_USER = "ADEMPIERE_DB_USER";
    public static final String ADEMPIERE_DB_PASSWORD = "ADEMPIERE_DB_PASSWORD";
    public static final String ADEMPIERE_DB_SYSTEM = "ADEMPIERE_DB_SYSTEM";
    public static final String ADEMPIERE_MAIL_SERVER = "ADEMPIERE_MAIL_SERVER";
    public static final String ADEMPIERE_MAIL_USER = "ADEMPIERE_MAIL_USER";
    public static final String ADEMPIERE_MAIL_PASSWORD = "ADEMPIERE_MAIL_PASSWORD";
    public static final String ADEMPIERE_ADMIN_EMAIL = "ADEMPIERE_ADMIN_EMAIL";
    public static final String ADEMPIERE_MAIL_UPDATED = "ADEMPIERE_MAIL_UPDATED";
    public static final String ADEMPIERE_FTP_SERVER = "ADEMPIERE_FTP_SERVER";
    public static final String ADEMPIERE_FTP_USER = "ADEMPIERE_FTP_USER";
    public static final String ADEMPIERE_FTP_PASSWORD = "ADEMPIERE_FTP_PASSWORD";
    public static final String ADEMPIERE_FTP_PREFIX = "ADEMPIERE_FTP_PREFIX";
    public static final String ADEMPIERE_WEBSTORES = "ADEMPIERE_WEBSTORES";
    private static String JAVATYPE_SUN = "sun";
    private static String JAVATYPE_MAC = "mac";
    private static String JAVATYPE_IBM = "<ibm>";
    private static String JAVATYPE_OPENJDK = "OpenJDK";
    static String[] JAVATYPE = new String[]{JAVATYPE_SUN, JAVATYPE_OPENJDK, JAVATYPE_MAC, JAVATYPE_IBM};
    private Config[] m_javaConfig = new Config[]{new ConfigVMSun(this), new ConfigVMOpenJDK(this), new ConfigVMMac(this), null};
    protected static String APPSTYPE_JBOSS = "jboss";
    protected static String APPSTYPE_GLASSFISH = "glassfish";
    static String[] APPSTYPE = new String[]{APPSTYPE_JBOSS, APPSTYPE_GLASSFISH};
    private Config[] m_appsConfig = new Config[]{new ConfigJBoss(this), new ConfigGlassfish(this)};
    private static String DBTYPE_ORACLE = "oracle";
    private static String DBTYPE_ORACLEXE = "oracleXE";
    private static String DBTYPE_POSTGRESQL = "postgresql";
    private static String DBTYPE_MYSQL = "mysql";
    static String[] DBTYPE = new String[]{DBTYPE_ORACLEXE, DBTYPE_ORACLE, DBTYPE_POSTGRESQL, DBTYPE_MYSQL};
    private Config[] m_databaseConfig = new Config[]{new ConfigOracle(this, true), new ConfigOracle(this, false), new ConfigPostgreSQL(this), new ConfigMySQL(this)};

    public ConfigurationData(ConfigurationPanel panel) {
        this.p_panel = panel;
    }

    private void updateProperty(String property, String value) {
        String currentValue;
        if (value == null) {
            value = "";
        }
        if ((currentValue = (String)this.p_properties.get(property)) == null) {
            this.p_properties.put(property, value);
        } else if (!currentValue.equals(value)) {
            this.p_properties.put(property, value);
        }
    }

    public boolean load() {
        String adempiereHome = System.getProperty(ADEMPIERE_HOME);
        if (adempiereHome == null || adempiereHome.length() == 0) {
            adempiereHome = System.getProperty("user.dir");
        }
        boolean envLoaded = false;
        String fileName = adempiereHome + File.separator + ADEMPIERE_ENV_FILE;
        File env = new File(fileName);
        if (env.exists()) {
            try {
                FileInputStream fis = new FileInputStream(env);
                this.p_properties.load(fis);
                fis.close();
            }
            catch (Exception e) {
                log.warning(e.toString());
            }
            log.info(env.toString());
            if (this.p_properties.size() > 5) {
                envLoaded = true;
            }
            Properties loaded = new Properties();
            loaded.putAll((Map<?, ?>)this.p_properties);
            int javaIndex = this.setJavaType((String)this.p_properties.get(JAVA_TYPE));
            this.initJava(javaIndex);
            if (loaded.containsKey(JAVA_HOME)) {
                this.setJavaHome((String)loaded.get(JAVA_HOME));
            }
            this.setAdempiereHome((String)this.p_properties.get(ADEMPIERE_HOME));
            String s = (String)this.p_properties.get(ADEMPIERE_KEYSTOREPASS);
            if (s == null || s.length() == 0) {
                s = KEYSTORE_PASSWORD;
                this.p_properties.put(ADEMPIERE_KEYSTOREPASS, s);
            }
            this.setKeyStore(s);
            int appServerIndex = this.setAppsServerType((String)this.p_properties.get(ADEMPIERE_APPS_TYPE));
            this.initAppsServer(appServerIndex);
            if (loaded.containsKey(ADEMPIERE_APPS_SERVER)) {
                this.setAppsServer((String)loaded.get(ADEMPIERE_APPS_SERVER));
            }
            if (loaded.containsKey(ADEMPIERE_APPS_DEPLOY)) {
                this.setAppsServerDeployDir((String)loaded.get(ADEMPIERE_APPS_DEPLOY));
            }
            if (loaded.containsKey(ADEMPIERE_JNP_PORT)) {
                this.setAppsServerJNPPort((String)loaded.get(ADEMPIERE_JNP_PORT));
            }
            if (loaded.containsKey(ADEMPIERE_WEB_PORT)) {
                this.setAppsServerWebPort((String)loaded.get(ADEMPIERE_WEB_PORT));
            }
            if (loaded.containsKey(ADEMPIERE_SSL_PORT)) {
                this.setAppsServerSSLPort((String)loaded.get(ADEMPIERE_SSL_PORT));
            }
            int dbTypeIndex = this.setDatabaseType((String)this.p_properties.get(ADEMPIERE_DB_TYPE));
            this.initDatabase((String)this.p_properties.get(ADEMPIERE_DB_NAME), dbTypeIndex);
            if (loaded.containsKey(ADEMPIERE_DB_NAME)) {
                this.setDatabaseDiscovered((String)loaded.get(ADEMPIERE_DB_NAME));
            }
            if (loaded.containsKey(ADEMPIERE_DB_SERVER)) {
                this.setDatabaseServer((String)loaded.get(ADEMPIERE_DB_SERVER));
            }
            if (loaded.containsKey(ADEMPIERE_DB_PORT)) {
                this.setDatabasePort((String)loaded.get(ADEMPIERE_DB_PORT));
            }
            if (loaded.containsKey(ADEMPIERE_DB_NAME)) {
                this.setDatabaseName((String)loaded.get(ADEMPIERE_DB_NAME));
            }
            if (loaded.containsKey(ADEMPIERE_DB_USER)) {
                this.setDatabaseUser((String)loaded.get(ADEMPIERE_DB_USER));
            }
            if (loaded.containsKey(ADEMPIERE_DB_PASSWORD)) {
                this.setDatabasePassword((String)loaded.get(ADEMPIERE_DB_PASSWORD));
            }
            if (loaded.containsKey(ADEMPIERE_DB_SYSTEM)) {
                this.setDatabaseSystemPassword((String)loaded.get(ADEMPIERE_DB_SYSTEM));
            }
            if (this.p_panel != null) {
                this.p_panel.fMailServer.setText((String)this.p_properties.get(ADEMPIERE_MAIL_SERVER));
                this.p_panel.fMailUser.setText((String)this.p_properties.get(ADEMPIERE_MAIL_USER));
                this.p_panel.fMailPassword.setText((String)this.p_properties.get(ADEMPIERE_MAIL_PASSWORD));
                this.p_panel.fAdminEMail.setText((String)this.p_properties.get(ADEMPIERE_ADMIN_EMAIL));
            }
        }
        InetAddress localhost = null;
        String hostName = "unknown";
        try {
            localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
        }
        catch (Exception e) {
            log.severe("Cannot get local host name");
        }
        if (!envLoaded) {
            log.info("Defaults");
            this.initJava();
            this.setAdempiereHome(adempiereHome);
            this.setKeyStore(KEYSTORE_PASSWORD);
            this.initAppsServer();
            this.setAppsServer(hostName);
            this.initDatabase("");
            String connectionName = this.getDatabaseDiscovered();
            if (connectionName != null) {
                this.setDatabaseName(this.resolveDatabaseName(connectionName));
            }
            this.setDatabaseSystemPassword("");
            this.setDatabaseServer(hostName);
            this.setDatabaseUser("adempiere");
            this.setDatabasePassword("adempiere");
            if (this.p_panel != null) {
                this.p_panel.fMailServer.setText(hostName);
                this.p_panel.fMailUser.setText("info");
                this.p_panel.fMailPassword.setText("");
                this.p_panel.fAdminEMail.setText("info@" + hostName);
            }
        }
        if (!this.p_properties.containsKey(ADEMPIERE_FTP_SERVER)) {
            this.p_properties.setProperty(ADEMPIERE_FTP_SERVER, "localhost");
            this.p_properties.setProperty(ADEMPIERE_FTP_USER, "anonymous");
            this.p_properties.setProperty(ADEMPIERE_FTP_PASSWORD, "user@host.com");
            this.p_properties.setProperty(ADEMPIERE_FTP_PREFIX, "my");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_JAVA_OPTIONS)) {
            this.p_properties.setProperty(ADEMPIERE_JAVA_OPTIONS, "-Xms64M -Xmx512M");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_WEB_ALIAS) && localhost != null) {
            this.p_properties.setProperty(ADEMPIERE_WEB_ALIAS, localhost.getCanonicalHostName());
        }
        if (!this.p_properties.containsKey(ADEMPIERE_KEYSTORECODEALIAS)) {
            this.p_properties.setProperty(ADEMPIERE_KEYSTORECODEALIAS, "adempiere");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_KEYSTOREWEBALIAS)) {
            this.p_properties.setProperty(ADEMPIERE_KEYSTOREWEBALIAS, "adempiere");
        }
        return true;
    }

    public String resolveDatabaseName(String connectionName) {
        int index = this.p_panel.fDatabaseType.getSelectedIndex();
        if (index < 0 || index >= DBTYPE.length) {
            log.warning("DatabaseType Index invalid: " + index);
        } else if (this.m_databaseConfig[index] == null) {
            log.warning("DatabaseType Config missing: " + DBTYPE[index]);
        } else {
            return this.m_databaseConfig[index].getDatabaseName(connectionName);
        }
        return connectionName;
    }

    public boolean test() {
        String error = this.testJava();
        if (error != null) {
            log.severe(error);
            return false;
        }
        error = this.testAdempiere();
        if (error != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lAppsServer.getText());
        }
        if ((error = this.testAppsServer()) != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lDatabaseServer.getText());
        }
        if ((error = this.testDatabase()) != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lMailServer.getText());
        }
        if ((error = this.testMail()) != null) {
            log.warning(error);
            return false;
        }
        return true;
    }

    private String testAdempiere() {
        this.m_adempiereHome = new File(this.getAdempiereHome());
        boolean pass = this.m_adempiereHome.exists();
        String error = "Not found: AdempiereHome = " + this.m_adempiereHome;
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okAdempiereHome, "ErrorAdempiereHome", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        log.info("OK: AdempiereHome = " + this.m_adempiereHome);
        this.p_properties.setProperty(ADEMPIERE_HOME, this.m_adempiereHome.getAbsolutePath());
        System.setProperty(ADEMPIERE_HOME, this.m_adempiereHome.getAbsolutePath());
        String fileName = KeyStoreMgt.getKeystoreFileName(this.m_adempiereHome.getAbsolutePath());
        this.p_properties.setProperty(ADEMPIERE_KEYSTORE, fileName);
        String pw = this.p_panel != null ? new String(this.p_panel.fKeyStore.getPassword()) : (String)this.p_properties.get(ADEMPIERE_KEYSTOREPASS);
        pass = pw != null && pw.length() > 0;
        error = "Invalid Key Store Password = " + pw;
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        this.p_properties.setProperty(ADEMPIERE_KEYSTOREPASS, pw);
        KeyStoreMgt ks = this.p_panel != null ? new KeyStoreMgt(fileName, this.p_panel.fKeyStore.getPassword()) : new KeyStoreMgt(fileName, pw.toCharArray());
        ks.setCommonName(this.p_properties.getProperty(ADEMPIERE_CERT_CN));
        ks.setOrganization(this.p_properties.getProperty(ADEMPIERE_CERT_ORG));
        ks.setOrganizationUnit(this.p_properties.getProperty(ADEMPIERE_CERT_ORG_UNIT));
        ks.setLocation(this.p_properties.getProperty(ADEMPIERE_CERT_LOCATION));
        ks.setState(this.p_properties.getProperty(ADEMPIERE_CERT_STATE));
        ks.setCountry(this.p_properties.getProperty(ADEMPIERE_CERT_COUNTRY));
        error = this.p_panel != null ? ks.verify((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this.p_panel))) : ks.verify(null);
        boolean bl = pass = error == null;
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        log.info("OK: KeyStore = " + fileName);
        return null;
    }

    private String testMail() {
        String server = this.p_panel != null ? this.p_panel.fMailServer.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_SERVER);
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Error Mail Server = " + server;
        InetAddress mailServer = null;
        try {
            if (pass) {
                mailServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", pass, true, error);
        }
        if (!pass) {
            this.p_properties.setProperty(ADEMPIERE_MAIL_SERVER, "");
            return error;
        }
        this.p_properties.setProperty(ADEMPIERE_MAIL_SERVER, mailServer.getHostName());
        String mailUser = this.p_panel != null ? this.p_panel.fMailUser.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_USER);
        String mailPassword = this.p_panel != null ? new String(this.p_panel.fMailPassword.getPassword()) : (String)this.p_properties.get(ADEMPIERE_MAIL_PASSWORD);
        String adminEMailString = this.p_panel != null ? this.p_panel.fAdminEMail.getText() : (String)this.p_properties.get(ADEMPIERE_ADMIN_EMAIL);
        InternetAddress adminEMail = null;
        try {
            adminEMail = new InternetAddress(adminEMailString);
        }
        catch (Exception e) {
            error = "Not valid: " + adminEMailString + " - " + e.getMessage();
            pass = false;
        }
        if (pass) {
            error = "Not verified EMail = " + adminEMail;
            pass = this.testMailServer(mailServer, adminEMail, mailUser, mailPassword);
        }
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okMailUser, "ErrorMail", pass, false, error);
        }
        if (pass) {
            log.info("OK: EMail = " + adminEMail);
            this.p_properties.setProperty(ADEMPIERE_ADMIN_EMAIL, adminEMail.toString());
            this.p_properties.setProperty(ADEMPIERE_MAIL_USER, mailUser);
            this.p_properties.setProperty(ADEMPIERE_MAIL_PASSWORD, mailPassword);
            this.p_properties.setProperty(ADEMPIERE_MAIL_UPDATED, "No");
        } else {
            log.warning(error);
            this.p_properties.setProperty(ADEMPIERE_ADMIN_EMAIL, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_USER, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_PASSWORD, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_UPDATED, "");
        }
        return null;
    }

    private boolean testMailServer(InetAddress mailServer, InternetAddress adminEMail, String mailUser, String mailPassword) {
        boolean isGmail = mailServer.getHostName().equalsIgnoreCase("smtp.gmail.com");
        boolean smtpOK = false;
        boolean imapOK = false;
        if (this.testPort(mailServer, isGmail ? 587 : 25, true)) {
            log.config("OK: SMTP Server contacted");
            smtpOK = true;
        } else {
            log.info("SMTP Server NOT available");
        }
        if (this.testPort(mailServer, isGmail ? 995 : 110, true)) {
            log.config("OK: POP3 Server contacted");
        } else {
            log.info("POP3 Server NOT available");
        }
        if (this.testPort(mailServer, isGmail ? 993 : 143, true)) {
            log.config("OK: IMAP4 Server contacted");
            imapOK = true;
        } else {
            log.info("IMAP4 Server NOT available");
        }
        if (!smtpOK) {
            String error = "No active Mail Server";
            if (this.p_panel != null) {
                this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", false, false, error);
            }
            log.warning(error);
            return false;
        }
        try {
            EMail email = new EMail(new Properties(), mailServer.getHostName(), adminEMail.toString(), adminEMail.toString(), "Adempiere Server Setup Test", "Test: " + this.getProperties());
            email.createAuthenticator(mailUser, mailPassword);
            if ("OK".equals(email.send())) {
                log.info("OK: Send Test Email to " + adminEMail);
            } else {
                log.warning("Could NOT send Email to " + adminEMail);
            }
        }
        catch (Exception ex) {
            log.severe(ex.getLocalizedMessage());
            return false;
        }
        if (!imapOK) {
            return false;
        }
        Properties props = new Properties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", mailServer.getHostName());
        props.put("mail.user", mailUser);
        props.put("mail.smtp.auth", "true");
        if (isGmail) {
            props.put("impa.smtp.port", "993");
            props.put("mail.store.protocol", "imaps");
        }
        log.config("Connecting to " + mailServer.getHostName());
        Session session = null;
        Store store = null;
        try {
            EMailAuthenticator auth = new EMailAuthenticator(mailUser, mailPassword);
            session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
            session.setDebug(CLogMgt.isLevelFinest());
            log.config("Session=" + session);
            store = session.getStore(isGmail ? "imaps" : "imap");
            log.config("Store=" + store);
        }
        catch (NoSuchProviderException nsp) {
            log.warning("Mail IMAP Provider - " + nsp.getMessage());
            return false;
        }
        catch (Exception e) {
            log.warning("Mail IMAP - " + e.getMessage());
            return false;
        }
        try {
            store.connect(mailServer.getHostName(), mailUser, mailPassword);
            log.config("Store - connected");
            Folder folder = store.getDefaultFolder();
            Folder inbox = folder.getFolder("INBOX");
            log.info("OK: Mail Connect to " + inbox.getFullName() + " #Msg=" + inbox.getMessageCount());
            store.close();
        }
        catch (MessagingException mex) {
            log.severe("Mail Connect " + mex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean testPort(String protocol, String server, int port, String file) {
        System.out.println("testPort[" + protocol + "," + server + ", " + port + ", " + file + "]");
        URL url = null;
        try {
            url = new URL(protocol, server, port, file);
        }
        catch (MalformedURLException ex) {
            log.severe("No URL for Protocol=" + protocol + ", Server=" + server + ": " + ex.getMessage());
            return false;
        }
        try {
            URLConnection c = url.openConnection();
            Object o = c.getContent();
            if (o == null) {
                log.warning("In use=" + url);
            } else {
                log.warning("In Use=" + url);
            }
        }
        catch (Exception ex) {
            log.fine("Not used=" + url);
            return false;
        }
        return true;
    }

    protected boolean testServerPort(int port) {
        System.out.println("testServerPort: " + port);
        try {
            ServerSocket ss = new ServerSocket(port);
            log.fine(ss.getInetAddress() + ":" + ss.getLocalPort() + " - created");
            ss.close();
        }
        catch (Exception ex) {
            log.warning("Port " + port + ": " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean testPort(InetAddress host, int port, boolean shouldBeUsed) {
        System.out.println("testPort[" + host.getHostAddress() + ", " + port + "]");
        Socket pingSocket = null;
        try {
            pingSocket = new Socket(host, port);
        }
        catch (Exception e) {
            if (shouldBeUsed) {
                log.warning("Open Socket " + host + ":" + port + " - " + e.getMessage());
            } else {
                log.fine(host + ":" + port + " - " + e.getMessage());
            }
            return false;
        }
        if (!shouldBeUsed) {
            log.warning("Open Socket " + host + ":" + port + " - " + pingSocket);
        }
        log.fine(host + ":" + port + " - " + pingSocket);
        if (pingSocket == null) {
            return false;
        }
        try {
            pingSocket.close();
        }
        catch (IOException e) {
            log.warning("close socket=" + e.toString());
        }
        return true;
    }

    public boolean save() {
        this.p_properties.setProperty("ADEMPIERE_MAIN_VERSION", Adempiere.MAIN_VERSION);
        this.p_properties.setProperty("ADEMPIERE_DATE_VERSION", Adempiere.DATE_VERSION);
        this.p_properties.setProperty("ADEMPIERE_DB_VERSION", Adempiere.DB_VERSION);
        log.finest(this.p_properties.toString());
        Ini.setClient((boolean)false);
        String fileName = this.m_adempiereHome.getAbsolutePath() + File.separator + "Adempiere.properties";
        Ini.loadProperties((String)fileName);
        fileName = this.m_adempiereHome.getAbsolutePath() + File.separator + ADEMPIERE_ENV_FILE;
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            this.p_properties.store(fos, ADEMPIERE_ENV_FILE);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.severe("Cannot save Properties to " + fileName + " - " + e.toString());
            if (this.p_panel != null) {
                JOptionPane.showConfirmDialog((Component)((Object)this.p_panel), ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
            } else {
                System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
            }
            return false;
        }
        catch (Throwable t) {
            log.severe("Cannot save Properties to " + fileName + " - " + t.toString());
            if (this.p_panel != null) {
                JOptionPane.showConfirmDialog((Component)((Object)this.p_panel), ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
            } else {
                System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
            }
            return false;
        }
        log.info(fileName);
        return this.saveIni();
    }

    private boolean saveIni() {
        Ini.setAdempiereHome((String)this.m_adempiereHome.getAbsolutePath());
        String ccType = Database.DB_ORACLE;
        if (this.getDatabaseType().equals(DBTYPE_POSTGRESQL)) {
            ccType = Database.DB_POSTGRESQL;
        } else if (this.getDatabaseType().equals(DBTYPE_MYSQL)) {
            ccType = Database.DB_MYSQL;
        }
        CConnection cc = null;
        try {
            cc = CConnection.get((String)ccType, (String)this.getDatabaseServer(), (int)this.getDatabasePort(), (String)this.getDatabaseName(), (String)this.getDatabaseUser(), (String)this.getDatabasePassword());
            cc.setAppsHost(this.getAppsServer());
            cc.setAppsPort(this.getAppsServerJNPPort());
            cc.setConnectionProfile("L");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "connection", (Throwable)e);
            return false;
        }
        if (cc == null) {
            log.warning("No Connection");
            return false;
        }
        Ini.setProperty((String)"Connection", (String)cc.toStringLong());
        Ini.saveProperties((boolean)false);
        return true;
    }

    Properties getProperties() {
        return this.p_properties;
    }

    public String getAdempiereHome() {
        return this.p_panel != null ? this.p_panel.fAdempiereHome.getText() : (String)this.p_properties.get(ADEMPIERE_HOME);
    }

    public void setAdempiereHome(String adempiereHome) {
        if (this.p_panel != null) {
            this.p_panel.fAdempiereHome.setText(adempiereHome);
        } else {
            this.updateProperty(ADEMPIERE_HOME, adempiereHome);
        }
    }

    public String getKeyStore() {
        char[] pw = this.p_panel.fKeyStore.getPassword();
        if (pw != null) {
            return new String(pw);
        }
        return "";
    }

    public void setKeyStore(String password) {
        if (this.p_panel != null) {
            this.p_panel.fKeyStore.setText(password);
        } else {
            this.updateProperty(ADEMPIERE_KEYSTOREPASS, password);
        }
    }

    public void initJava() {
        int index = this.p_panel != null ? this.p_panel.fJavaType.getSelectedIndex() : 0;
        this.initJava(index);
    }

    private void initJava(int index) {
        if (index < 0 || index >= JAVATYPE.length) {
            log.warning("JavaType Index invalid: " + index);
        } else if (this.m_javaConfig[index] == null) {
            log.warning("JavaType Config missing: " + JAVATYPE[index]);
            if (this.p_panel != null) {
                this.p_panel.fJavaType.setSelectedIndex(0);
            }
        } else {
            this.m_javaConfig[index].init();
        }
    }

    public String testJava() {
        int index;
        int n = index = this.p_panel != null ? this.p_panel.fJavaType.getSelectedIndex() : this.setJavaType((String)this.p_properties.get(JAVA_TYPE));
        if (index < 0 || index >= JAVATYPE.length) {
            return "JavaType Index invalid: " + index;
        }
        if (this.m_javaConfig[index] == null) {
            return "JavaType Config class missing: " + index;
        }
        return this.m_javaConfig[index].test();
    }

    public int setJavaType(String javaType) {
        int index = -1;
        for (int i = 0; i < JAVATYPE.length; ++i) {
            if (!JAVATYPE[i].equals(javaType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid JavaType=" + javaType);
        }
        if (this.p_panel != null) {
            this.p_panel.fJavaType.setSelectedIndex(index);
        } else {
            this.updateProperty(JAVA_TYPE, javaType);
        }
        return index;
    }

    public String getJavaType() {
        if (this.p_panel != null) {
            return (String)this.p_panel.fJavaType.getSelectedItem();
        }
        return (String)this.p_properties.get(JAVA_TYPE);
    }

    public String getJavaHome() {
        if (this.p_panel != null) {
            return this.p_panel.fJavaHome.getText();
        }
        return (String)this.p_properties.get(JAVA_HOME);
    }

    public void setJavaHome(String javaHome) {
        if (this.p_panel != null) {
            this.p_panel.fJavaHome.setText(javaHome);
        } else {
            this.updateProperty(JAVA_HOME, javaHome);
        }
    }

    public void initAppsServer() {
        int index = this.p_panel != null ? this.p_panel.fAppsType.getSelectedIndex() : 0;
        this.initAppsServer(index);
    }

    private void initAppsServer(int index) {
        if (index < 0 || index >= APPSTYPE.length) {
            log.warning("AppsServerType Index invalid: " + index);
        } else if (this.m_appsConfig[index] == null) {
            log.warning("AppsServerType Config missing: " + APPSTYPE[index]);
            this.p_panel.fAppsType.setSelectedIndex(0);
        } else {
            this.m_appsConfig[index].init();
        }
    }

    public String testAppsServer() {
        int index;
        int n = index = this.p_panel != null ? this.p_panel.fAppsType.getSelectedIndex() : this.setAppsServerType((String)this.p_properties.get(ADEMPIERE_APPS_TYPE));
        if (index < 0 || index >= APPSTYPE.length) {
            return "AppsServerType Index invalid: " + index;
        }
        if (this.m_appsConfig[index] == null) {
            return "AppsServerType Config class missing: " + index;
        }
        return this.m_appsConfig[index].test();
    }

    public int setAppsServerType(String appsType) {
        int index = -1;
        for (int i = 0; i < APPSTYPE.length; ++i) {
            if (!APPSTYPE[i].equals(appsType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid AppsType=" + appsType);
        }
        if (this.p_panel != null) {
            this.p_panel.fAppsType.setSelectedIndex(index);
        } else {
            this.updateProperty(ADEMPIERE_APPS_TYPE, appsType);
        }
        return index;
    }

    public String getAppsServerType() {
        return this.p_panel != null ? (String)this.p_panel.fAppsType.getSelectedItem() : (String)this.p_properties.get(ADEMPIERE_APPS_TYPE);
    }

    public String getAppsServer() {
        return this.p_panel != null ? this.p_panel.fAppsServer.getText() : (String)this.p_properties.get(ADEMPIERE_APPS_SERVER);
    }

    public void setAppsServer(String appsServer) {
        if (this.p_panel != null) {
            this.p_panel.fAppsServer.setText(appsServer);
        } else {
            this.updateProperty(ADEMPIERE_APPS_SERVER, appsServer);
        }
    }

    public String getAppsServerDeployDir() {
        return this.p_panel != null ? this.p_panel.fDeployDir.getText() : (String)this.p_properties.get(ADEMPIERE_APPS_DEPLOY);
    }

    public void setAppsServerDeployDir(String appsServerDeployDir) {
        if (this.p_panel != null) {
            this.p_panel.fDeployDir.setText(appsServerDeployDir);
        } else {
            this.updateProperty(ADEMPIERE_APPS_DEPLOY, appsServerDeployDir);
        }
    }

    public void setAppsServerDeployDir(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fDeployDir.setEnabled(enable);
            this.p_panel.bDeployDir.setEnabled(enable);
        }
    }

    public int getAppsServerJNPPort() {
        String port = this.p_panel != null ? this.p_panel.fJNPPort.getText() : (String)this.p_properties.get(ADEMPIERE_JNP_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            this.setAppsServerJNPPort("0");
            return 0;
        }
    }

    public void setAppsServerJNPPort(String appsServerJNPPort) {
        if (this.p_panel != null) {
            this.p_panel.fJNPPort.setText(appsServerJNPPort);
        } else {
            this.updateProperty(ADEMPIERE_JNP_PORT, appsServerJNPPort);
        }
    }

    public void setAppsServerJNPPort(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fJNPPort.setEnabled(enable);
        }
    }

    public int getAppsServerSSLPort() {
        String port = this.p_panel != null ? this.p_panel.fSSLPort.getText() : (String)this.p_properties.get(ADEMPIERE_SSL_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            this.setAppsServerSSLPort("0");
            return 0;
        }
    }

    public void setAppsServerSSLPort(String appsServerSSLPort) {
        if (this.p_panel != null) {
            this.p_panel.fSSLPort.setText(appsServerSSLPort);
        } else {
            this.updateProperty(ADEMPIERE_SSL_PORT, appsServerSSLPort);
        }
    }

    public void setAppsServerSSLPort(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fSSLPort.setEnabled(enable);
        }
    }

    public int getAppsServerWebPort() {
        String port = this.p_panel != null ? this.p_panel.fWebPort.getText() : (String)this.p_properties.get(ADEMPIERE_WEB_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            this.setAppsServerWebPort("0");
            return 0;
        }
    }

    public void setAppsServerWebPort(String appsServerWebPort) {
        if (this.p_panel != null) {
            this.p_panel.fWebPort.setText(appsServerWebPort);
        } else {
            this.updateProperty(ADEMPIERE_WEB_PORT, appsServerWebPort);
        }
    }

    public void setAppsServerWebPort(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fWebPort.setEnabled(enable);
        }
    }

    public void initDatabase(String selected) {
        int index = this.p_panel != null ? this.p_panel.fDatabaseType.getSelectedIndex() : 0;
        this.initDatabase(selected, index);
    }

    private void initDatabase(String selected, int index) {
        if (index < 0 || index >= DBTYPE.length) {
            log.warning("DatabaseType Index invalid: " + index);
        } else if (this.m_databaseConfig[index] == null) {
            log.warning("DatabaseType Config missing: " + DBTYPE[index]);
            if (this.p_panel != null) {
                this.p_panel.fDatabaseType.setSelectedIndex(0);
            }
        } else {
            this.m_databaseConfig[index].init();
            if (this.p_panel != null) {
                String[] databases = this.m_databaseConfig[index].discoverDatabases(selected);
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(databases);
                this.p_panel.fDatabaseDiscovered.setModel(model);
                this.p_panel.fDatabaseDiscovered.setEnabled(databases.length != 0);
                if (databases.length > 0) {
                    this.p_panel.fDatabaseName.setText(databases[0]);
                }
            }
        }
    }

    public String testDatabase() {
        int index;
        int n = index = this.p_panel != null ? this.p_panel.fDatabaseType.getSelectedIndex() : this.setDatabaseType((String)this.p_properties.get(ADEMPIERE_DB_TYPE));
        if (index < 0 || index >= DBTYPE.length) {
            return "DatabaseType Index invalid: " + index;
        }
        if (this.m_databaseConfig[index] == null) {
            return "DatabaseType Config class missing: " + index;
        }
        return this.m_databaseConfig[index].test();
    }

    public int setDatabaseType(String databaseType) {
        int index = -1;
        for (int i = 0; i < DBTYPE.length; ++i) {
            if (!DBTYPE[i].equals(databaseType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid DatabaseType=" + databaseType);
        }
        if (this.p_panel != null) {
            this.p_panel.fDatabaseType.setSelectedIndex(index);
        } else {
            this.updateProperty(ADEMPIERE_DB_TYPE, databaseType);
        }
        return index;
    }

    public String getDatabaseType() {
        return this.p_panel != null ? (String)this.p_panel.fDatabaseType.getSelectedItem() : (String)this.p_properties.get(ADEMPIERE_DB_TYPE);
    }

    public String getDatabaseDiscovered() {
        return (String)this.p_panel.fDatabaseDiscovered.getSelectedItem();
    }

    public void setDatabaseDiscovered(String databaseDiscovered) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseDiscovered.setSelectedItem((Object)databaseDiscovered);
        }
    }

    public String getDatabaseName() {
        return this.p_panel != null ? this.p_panel.fDatabaseName.getText() : (String)this.p_properties.get(ADEMPIERE_DB_NAME);
    }

    public void setDatabaseName(String databaseName) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseName.setText(databaseName);
        } else {
            this.updateProperty(ADEMPIERE_DB_NAME, databaseName);
        }
    }

    public String getDatabasePassword() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fDatabasePassword.getPassword();
            if (pw != null) {
                return new String(pw);
            }
            return "";
        }
        String pw = (String)this.p_properties.get(ADEMPIERE_DB_PASSWORD);
        return pw != null ? pw : "";
    }

    public void setDatabasePassword(String databasePassword) {
        if (this.p_panel != null) {
            this.p_panel.fDatabasePassword.setText(databasePassword);
        } else {
            this.updateProperty(ADEMPIERE_DB_PASSWORD, databasePassword);
        }
    }

    public int getDatabasePort() {
        String port = this.p_panel != null ? this.p_panel.fDatabasePort.getText() : (String)this.p_properties.get(ADEMPIERE_DB_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            this.setDatabasePort("0");
            return 0;
        }
    }

    public void setDatabasePort(String databasePort) {
        if (this.p_panel != null) {
            this.p_panel.fDatabasePort.setText(databasePort);
        } else {
            this.updateProperty(ADEMPIERE_DB_PORT, databasePort);
        }
    }

    public String getDatabaseServer() {
        return this.p_panel != null ? this.p_panel.fDatabaseServer.getText() : (String)this.p_properties.get(ADEMPIERE_DB_SERVER);
    }

    public void setDatabaseServer(String databaseServer) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseServer.setText(databaseServer);
        } else {
            this.updateProperty(ADEMPIERE_DB_SERVER, databaseServer);
        }
    }

    public String getDatabaseSystemPassword() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fSystemPassword.getPassword();
            if (pw != null) {
                return new String(pw);
            }
            return "";
        }
        String pw = (String)this.p_properties.get(ADEMPIERE_DB_SYSTEM);
        return pw != null ? pw : "";
    }

    public void setDatabaseSystemPassword(String databaseSystemPassword) {
        if (this.p_panel != null) {
            this.p_panel.fSystemPassword.setText(databaseSystemPassword);
        } else {
            this.updateProperty(ADEMPIERE_DB_SYSTEM, databaseSystemPassword);
        }
    }

    public void setDatabaseSystemPassword(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fSystemPassword.setEnabled(enable);
        }
    }

    public String getDatabaseUser() {
        return this.p_panel != null ? this.p_panel.fDatabaseUser.getText() : (String)this.p_properties.get(ADEMPIERE_DB_USER);
    }

    public void setDatabaseUser(String databaseUser) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseUser.setText(databaseUser);
        } else {
            this.updateProperty(ADEMPIERE_DB_USER, databaseUser);
        }
    }
}

