/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultCheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultTreeCheckingModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckboxTree
extends JTree {
    private TreeCheckingModel checkingModel;

    public CheckboxTree() {
        super(CheckboxTree.getDefaultTreeModel());
        this.initialize();
    }

    public CheckboxTree(TreeNode root) {
        super(root);
        this.initialize();
    }

    public CheckboxTree(TreeModel treemodel) {
        super(treemodel);
        this.initialize();
    }

    private void initialize() {
        this.setCheckingModel(new DefaultTreeCheckingModel(this.treeModel));
        this.setCellRenderer(new DefaultCheckboxTreeCellRenderer());
        this.addMouseListener(new NodeCheckListener());
        this.selectionModel.setSelectionMode(4);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public void setCellRenderer(CheckboxTreeCellRenderer x) {
        super.setCellRenderer(x);
    }

    @Override
    @Deprecated
    public void setCellRenderer(TreeCellRenderer x) {
        super.setCellRenderer(x);
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        if (this.checkingModel != null) {
            this.checkingModel.setTreeModel(newModel);
        }
    }

    public TreeCheckingModel getCheckingModel() {
        return this.checkingModel;
    }

    public void setCheckingModel(TreeCheckingModel newCheckingModel) {
        TreeCheckingModel oldCheckingModel = this.checkingModel;
        if (oldCheckingModel != null) {
            oldCheckingModel.setTreeModel(null);
        }
        this.checkingModel = newCheckingModel;
        if (newCheckingModel != null) {
            newCheckingModel.setTreeModel(this.getModel());
            newCheckingModel.addTreeCheckingListener(new TreeCheckingListener(){

                @Override
                public void valueChanged(TreeCheckingEvent e) {
                    CheckboxTree.this.repaint();
                }
            });
        }
    }

    public TreePath[] getCheckingPaths() {
        return this.getCheckingModel().getCheckingPaths();
    }

    public TreePath[] getCheckingRoots() {
        return this.getCheckingModel().getCheckingRoots();
    }

    public void clearChecking() {
        this.getCheckingModel().clearChecking();
    }

    public void addCheckingPaths(TreePath[] paths) {
        this.getCheckingModel().addCheckingPaths(paths);
    }

    public void addCheckingPath(TreePath path) {
        this.getCheckingModel().addCheckingPath(path);
    }

    public void setCheckingPath(TreePath path) {
        this.getCheckingModel().setCheckingPath(path);
    }

    public void setCheckingPaths(TreePath[] paths) {
        this.getCheckingModel().setCheckingPaths(paths);
    }

    public TreePath[] getGreyingPaths() {
        return this.getCheckingModel().getGreyingPaths();
    }

    public void addTreeCheckingListener(TreeCheckingListener tsl) {
        this.checkingModel.addTreeCheckingListener(tsl);
    }

    public void removeTreeCheckingListener(TreeCheckingListener tsl) {
        this.checkingModel.removeTreeCheckingListener(tsl);
    }

    public void expandAll() {
        this.expandSubTree(this.getPathForRow(0));
    }

    private void expandSubTree(TreePath path) {
        this.expandPath(path);
        Object node = path.getLastPathComponent();
        int childrenNumber = this.getModel().getChildCount(node);
        TreePath[] childrenPath = new TreePath[childrenNumber];
        for (int childIndex = 0; childIndex < childrenNumber; ++childIndex) {
            childrenPath[childIndex] = path.pathByAddingChild(this.getModel().getChild(node, childIndex));
            this.expandSubTree(childrenPath[childIndex]);
        }
    }

    @Override
    public String toString() {
        String retVal = super.toString();
        TreeCheckingModel tcm = this.getCheckingModel();
        if (tcm != null) {
            return retVal + "\n" + tcm.toString();
        }
        return retVal;
    }

    private class NodeCheckListener
    extends MouseAdapter {
        private NodeCheckListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = CheckboxTree.this.getRowForLocation(x, y = e.getY());
            if (row == -1) {
                return;
            }
            Rectangle rect = CheckboxTree.this.getRowBounds(row);
            if (rect == null) {
                return;
            }
            if (((CheckboxTreeCellRenderer)CheckboxTree.this.getCellRenderer()).isOnHotspot(x - rect.x, y - rect.y)) {
                CheckboxTree.this.getCheckingModel().toggleCheckingPath(CheckboxTree.this.getPathForRow(row));
            }
        }
    }
}

