/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.eevolution.form.TreeBOM;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class VTreeBOM
extends TreeBOM
implements FormPanel,
ActionListener,
ListSelectionListener,
PropertyChangeListener,
VetoableChangeListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private JTree m_tree;
    private static CLogger log = CLogger.getCLogger(VTreeBOM.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct;
    private CCheckBox implosion = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane dataPane = new JScrollPane();
    private JScrollPane treePane = new JScrollPane();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected StatusBar statusBar = new StatusBar();
    private MiniTable tableBOM = new MiniTable();
    private Vector<Vector<Object>> dataBOM = new Vector();
    private Vector<String> columnNames;
    private final int DIVIDER_LOCATION = 240;

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.panel, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", (Throwable)ex);
        }
    }

    private void preInit() throws Exception {
        Properties ctx = this.getCtx();
        Language language = Language.getLoginLanguage();
        MLookup m_fieldProduct = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)MColumn.getColumn_ID((String)"M_Product", (String)"M_Product_ID"), (int)30, (Language)language, (String)"M_Product_ID", (int)0, (boolean)false, (String)" M_Product.IsSummary = 'N'");
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, (Lookup)m_fieldProduct){
            private static final long serialVersionUID = 1L;

            public void setValue(Object value) {
                super.setValue(value);
                VTreeBOM.this.action_loadBOM();
            }
        };
        this.implosion.addActionListener((ActionListener)this);
        this.splitPane.add((Component)this.dataPane, "right");
        this.splitPane.add((Component)this.treePane, "left");
    }

    private void loadTableBOM() {
        this.columnNames = new Vector(18);
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"Select"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"IsActive"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"Line"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"ValidFrom"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"ValidTo"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"M_Product_ID"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"C_UOM_ID"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"IsQtyPercentage"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"QtyBatch"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"QtyBOM"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"IsCritical"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"LeadTimeOffset"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"Assay"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"Scrap"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"IssueMethod"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"BackflushGroup"));
        this.columnNames.add(Msg.translate((Properties)this.getCtx(), (String)"Forecast"));
        this.tableBOM.getModel().removeTableModelListener(this);
        this.tableBOM.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(this.dataBOM, this.columnNames);
        model.addTableModelListener(this);
        this.tableBOM.setModel((TableModel)model);
        this.tableBOM.setColumnClass(0, Boolean.class, false);
        this.tableBOM.setColumnClass(1, Boolean.class, false);
        this.tableBOM.setColumnClass(2, Integer.class, false);
        this.tableBOM.setColumnClass(3, Timestamp.class, false);
        this.tableBOM.setColumnClass(4, Timestamp.class, false);
        this.tableBOM.setColumnClass(5, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(6, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(7, Boolean.class, false);
        this.tableBOM.setColumnClass(8, BigDecimal.class, false);
        this.tableBOM.setColumnClass(9, BigDecimal.class, false);
        this.tableBOM.setColumnClass(10, Boolean.class, false);
        this.tableBOM.setColumnClass(11, BigDecimal.class, false);
        this.tableBOM.setColumnClass(12, BigDecimal.class, false);
        this.tableBOM.setColumnClass(13, Integer.class, false);
        this.tableBOM.setColumnClass(14, String.class, false);
        this.tableBOM.setColumnClass(15, String.class, false);
        this.tableBOM.setColumnClass(16, BigDecimal.class, false);
        this.tableBOM.autoSize();
    }

    private void jbInit() {
        this.panel.setLayout((LayoutManager)this.mainLayout);
        this.panel.setPreferredSize(new Dimension(640, 480));
        this.labelProduct.setText(Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID"));
        this.implosion.setText(Msg.getElement((Properties)this.getCtx(), (String)"Implosion"));
        this.northPanel.setLayout((LayoutManager)this.northLayout);
        this.northLayout.setAlignment(0);
        this.panel.add((Component)this.northPanel, (Object)"North");
        this.northPanel.add((Component)this.labelProduct, null);
        this.northPanel.add((Component)this.fieldProduct, null);
        this.northPanel.add((Component)this.implosion, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.panel.add((Component)this.southPanel, (Object)"South");
        this.southPanel.setLayout((LayoutManager)this.southLayout);
        this.confirmPanel.addActionListener((ActionListener)this);
        this.southPanel.add((Component)this.confirmPanel, (Object)"South");
        this.panel.add((Component)this.splitPane, (Object)"Center");
        this.splitPane.setDividerLocation(240);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.info("VAllocation.vetoableChange - " + name + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("M_Product_ID") && this.fieldProduct != null) {
            this.action_loadBOM();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.implosion) {
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Ok")) {
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private void action_loadBOM() {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return;
        }
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(this.productSummary(product, false));
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MPPProductBOMLine bomline : MPPProductBOMLine.getByProduct((MProduct)product)) {
                parent.add(this.parent(bomline));
            }
            this.m_tree = new JTree(parent);
        } else {
            for (MPPProductBOM bom : MPPProductBOM.getProductBOMs((MProduct)product)) {
                parent.add(this.parent(bom));
            }
            this.m_tree = new JTree(parent);
        }
        this.m_tree.addTreeSelectionListener(this);
        this.treePane.getViewport().add((Component)this.m_tree, null);
        this.loadTableBOM();
        this.dataPane.getViewport().add((Component)this.tableBOM, null);
        this.splitPane.setDividerLocation(240);
    }

    public DefaultMutableTreeNode parent(MPPProductBOMLine bomline) {
        MProduct M_Product = MProduct.get((Properties)this.getCtx(), (int)bomline.getM_Product_ID());
        MPPProductBOM bomproduct = new MPPProductBOM(this.getCtx(), bomline.getPP_Product_BOM_ID(), null);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(this.productSummary(M_Product, false));
        Vector<Object> line = new Vector<Object>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(true));
        line.add(new Integer(bomline.getLine()));
        line.add(bomline.getValidFrom());
        line.add(bomline.getValidTo());
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getName());
        line.add(pp);
        KeyNamePair uom = new KeyNamePair(bomline.getC_UOM_ID(), bomline.getC_UOM().getUOMSymbol());
        line.add(uom);
        line.add(new Boolean(bomline.isQtyPercentage()));
        line.add(bomline.getQtyBatch());
        line.add(bomline.getQtyBOM() != null ? bomline.getQtyBOM() : new BigDecimal(0));
        line.add(new Boolean(bomline.isCritical()));
        line.add(bomline.getLeadTimeOffset());
        line.add(bomline.getAssay());
        line.add(bomline.getScrap());
        line.add(bomline.getIssueMethod());
        line.add(bomline.getBackflushGroup());
        line.add(bomline.getForecast());
        this.dataBOM.add(line);
        Iterator i$ = MPPProductBOM.getProductBOMs((MProduct)((MProduct)bomproduct.getM_Product())).iterator();
        if (i$.hasNext()) {
            MPPProductBOM bom = (MPPProductBOM)i$.next();
            MProduct component = MProduct.get((Properties)this.getCtx(), (int)bom.getM_Product_ID());
            return this.component(component);
        }
        return parent;
    }

    public DefaultMutableTreeNode parent(MPPProductBOM bom) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(this.productSummary(bom));
        for (MPPProductBOMLine bomline : bom.getLines()) {
            MProduct component = MProduct.get((Properties)this.getCtx(), (int)bomline.getM_Product_ID());
            Vector<Object> line = new Vector<Object>(17);
            line.add(new Boolean(false));
            line.add(new Boolean(true));
            line.add(new Integer(bomline.getLine()));
            line.add(bomline.getValidFrom());
            line.add(bomline.getValidTo());
            KeyNamePair pp = new KeyNamePair(component.getM_Product_ID(), component.getName());
            line.add(pp);
            KeyNamePair uom = new KeyNamePair(bomline.getC_UOM_ID(), bomline.getC_UOM().getUOMSymbol());
            line.add(uom);
            line.add(new Boolean(bomline.isQtyPercentage()));
            line.add(bomline.getQtyBatch());
            line.add(bomline.getQtyBOM());
            line.add(new Boolean(bomline.isCritical()));
            line.add(bomline.getLeadTimeOffset());
            line.add(bomline.getAssay());
            line.add(bomline.getScrap());
            line.add(bomline.getIssueMethod());
            line.add(bomline.getBackflushGroup());
            line.add(bomline.getForecast());
            this.dataBOM.add(line);
            parent.add(this.component(component));
        }
        return parent;
    }

    public DefaultMutableTreeNode component(MProduct product) {
        if (this.isImplosion()) {
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(this.productSummary(product, false));
            for (MPPProductBOMLine bomline : MPPProductBOMLine.getByProduct((MProduct)product)) {
                parent.add(this.parent(bomline));
            }
            return parent;
        }
        Iterator i$ = MPPProductBOM.getProductBOMs((MProduct)product).iterator();
        if (i$.hasNext()) {
            MPPProductBOM bom = (MPPProductBOM)i$.next();
            return this.parent(bom);
        }
        return new DefaultMutableTreeNode(this.productSummary(product, true));
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    private void action_treeAdd(ListItem item) {
        log.info("VTreeMaintenance.action_treeAdd " + item);
        if (item != null) {
            // empty if block
        }
    }

    private void action_treeDelete(ListItem item) {
        log.info("VTreeMaintenance.action_treeDelete" + item);
        if (item != null) {
            // empty if block
        }
    }

    private void action_treeAddAll() {
        log.info("VTreeMaintenance.action_treeAddAll");
    }

    private void action_treeDeleteAll() {
        log.info("VTreeMaintenance.action_treeDeleteAll");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    private boolean isImplosion() {
        return this.implosion.isSelected();
    }

    private int getM_Product_ID() {
        Integer Product = (Integer)this.fieldProduct.getValue();
        if (Product == null) {
            return 0;
        }
        return Product;
    }

    class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int id, String name, String description, boolean isSummary, String imageIndicator) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.isSummary = isSummary;
            this.imageIndicator = imageIndicator;
        }

        public String toString() {
            String retValue = this.name;
            if (this.description != null && this.description.length() > 0) {
                retValue = retValue + " (" + this.description + ")";
            }
            return retValue;
        }
    }
}

