/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MDocType;
import org.compiere.model.MForecastLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResource;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Forecast;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.exceptions.NoPlantForWarehouseException;
import org.eevolution.model.I_PP_Product_Planning;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;
import org.eevolution.model.X_PP_MRP;

public class MPPMRP
extends X_PP_MRP {
    private static final long serialVersionUID = 6831223361306903297L;
    private static CLogger s_log = CLogger.getCLogger(MPPMRP.class);
    private static HashMap<String, String[]> s_sourceColumnNames = new HashMap();

    public static MPPOrder createMOMakeTo(MOrderLine ol, BigDecimal qty) {
        MPPOrder order = MPPOrder.forC_OrderLine_ID(ol.getCtx(), ol.get_ID(), ol.get_TrxName());
        if (order == null) {
            String whereClause = "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?";
            MPPProductBOM bom = (MPPProductBOM)new Query(ol.getCtx(), "PP_Product_BOM", "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?", ol.get_TrxName()).setParameters(new Object[]{"O", "K", "M", ol.getM_Product_ID()}).firstOnly();
            MPPProductPlanning pp = null;
            if (bom == null && (pp = MPPProductPlanning.find((Properties)ol.getCtx(), (int)ol.getAD_Org_ID(), (int)0, (int)0, (int)ol.getM_Product_ID(), null)) != null && (bom = pp.getPP_Product_BOM()) != null && !"O".equals(bom.getBOMType()) && !"K".equals(bom.getBOMType())) {
                bom = null;
            }
            if (bom != null) {
                MProduct product = MProduct.get((Properties)ol.getCtx(), (int)ol.getM_Product_ID());
                int plant_id = MPPProductPlanning.getPlantForWarehouse((int)ol.getM_Warehouse_ID());
                if (plant_id <= 0) {
                    throw new NoPlantForWarehouseException(ol.getM_Warehouse_ID());
                }
                MWorkflow workflow = MWorkflow.get((Properties)ol.getCtx(), (int)MWorkflow.getWorkflowSearchKey((MProduct)product));
                if (workflow == null && pp != null) {
                    workflow = pp.getAD_Workflow();
                }
                if (plant_id > 0 && workflow != null) {
                    String description = Msg.translate((Properties)ol.getCtx(), (String)MRefList.getListName((Properties)ol.getCtx(), (int)347, (String)bom.getBOMType())) + " " + Msg.translate((Properties)ol.getCtx(), (String)"C_Order_ID") + " : " + ol.getParent().getDocumentNo();
                    pp = new MPPProductPlanning(ol.getCtx(), 0, ol.get_TrxName());
                    pp.setAD_Org_ID(ol.getAD_Org_ID());
                    pp.setM_Product_ID(product.getM_Product_ID());
                    pp.setPlanner_ID(ol.getParent().getSalesRep_ID());
                    pp.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
                    pp.setAD_Workflow_ID(workflow.getAD_Workflow_ID());
                    pp.setM_Warehouse_ID(ol.getM_Warehouse_ID());
                    pp.setS_Resource_ID(plant_id);
                    order = MPPMRP.createMO(pp, ol.getC_OrderLine_ID(), ol.getM_AttributeSetInstance_ID(), qty, ol.getDateOrdered(), ol.getDatePromised(), description);
                    description = "";
                    if (ol.getDescription() != null) {
                        description = ol.getDescription();
                    }
                    description = description + " " + Msg.translate((Properties)ol.getCtx(), (String)MRefList.getListName((Properties)ol.getCtx(), (int)347, (String)bom.getBOMType())) + " " + Msg.translate((Properties)ol.getCtx(), (String)"PP_Order_ID") + " : " + order.getDocumentNo();
                    ol.setDescription(description);
                    ol.saveEx();
                }
            }
        } else if (!order.isProcessed()) {
            if (order.getM_Product_ID() != ol.getM_Product_ID()) {
                order.setDescription("");
                order.setQtyEntered(Env.ZERO);
                order.setC_OrderLine_ID(0);
                order.voidIt();
                order.setDocStatus("VO");
                order.setDocAction("--");
                order.save();
                ol.setDescription("");
                ol.saveEx();
            }
            if (order.getQtyEntered().compareTo(ol.getQtyEntered()) != 0) {
                order.setQty(ol.getQtyEntered());
                order.saveEx();
            }
            if (order.getDatePromised().compareTo(ol.getDatePromised()) != 0) {
                order.setDatePromised(ol.getDatePromised());
                order.saveEx();
            }
        }
        return order;
    }

    public static MPPOrder createMO(MPPProductPlanning pp, int C_OrderLine_ID, int M_AttributeSetInstance_ID, BigDecimal qty, Timestamp dateOrdered, Timestamp datePromised, String description) {
        MPPProductBOM bom = pp.getPP_Product_BOM();
        MWorkflow wf = pp.getAD_Workflow();
        if (pp.getS_Resource_ID() > 0 && bom != null && wf != null) {
            RoutingService routingService = RoutingServiceFactory.get().getRoutingService(pp.getCtx());
            int duration = routingService.calculateDuration((I_AD_Workflow)wf, (I_S_Resource)MResource.get((Properties)pp.getCtx(), (int)pp.getS_Resource_ID()), qty).intValueExact();
            MPPOrder order = new MPPOrder(pp.getCtx(), 0, pp.get_TrxName());
            order.setAD_Org_ID(pp.getAD_Org_ID());
            order.setDescription(description);
            order.setC_OrderLine_ID(C_OrderLine_ID);
            order.setS_Resource_ID(pp.getS_Resource_ID());
            order.setM_Warehouse_ID(pp.getM_Warehouse_ID());
            order.setM_Product_ID(pp.getM_Product_ID());
            order.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
            order.setPP_Product_BOM_ID(pp.getPP_Product_BOM_ID());
            order.setAD_Workflow_ID(pp.getAD_Workflow_ID());
            order.setPlanner_ID(pp.getPlanner_ID());
            order.setLine(10);
            order.setDateOrdered(dateOrdered);
            order.setDatePromised(datePromised);
            order.setDateStartSchedule(TimeUtil.addDays((Timestamp)datePromised, (int)(0 - duration)));
            order.setDateFinishSchedule(datePromised);
            order.setC_UOM_ID(pp.getM_Product().getC_UOM_ID());
            order.setQty(qty);
            order.setPriorityRule("3");
            order.saveEx();
            order.setDocStatus(order.prepareIt());
            order.setDocAction("CO");
            order.saveEx();
            return order;
        }
        return null;
    }

    public static boolean isChanged(PO po) {
        String[] columnNames = s_sourceColumnNames.get(po.get_TableName());
        if (columnNames == null || columnNames.length == 0) {
            return false;
        }
        if (po.is_new() || po.is_ValueChanged("IsActive")) {
            return true;
        }
        for (String columnName : columnNames) {
            if (!po.is_ValueChanged(columnName)) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> getSourceTableNames() {
        return s_sourceColumnNames.keySet();
    }

    public static void deleteMRP(PO po) {
        MOrderLine ol;
        MPPOrder order;
        String tableName = po.get_TableName();
        int no = DB.executeUpdateEx((String)("DELETE FROM PP_MRP WHERE " + tableName + "_ID=? AND AD_Client_ID=?"), (Object[])new Object[]{po.get_ID(), po.getAD_Client_ID()}, (String)po.get_TrxName());
        s_log.finest("Deleted " + tableName + " #" + no);
        if (po instanceof MOrderLine && (order = MPPOrder.forC_OrderLine_ID((ol = (MOrderLine)po).getCtx(), ol.get_ID(), ol.get_TrxName())) != null && !order.isProcessed()) {
            order.deleteEx(true);
        }
    }

    private static Query getQuery(PO po, String typeMRP, String orderType) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID=?");
        params.add(po.getAD_Client_ID());
        whereClause.append(" AND ").append(po.get_TableName()).append("_ID=?");
        params.add(po.get_ID());
        if (typeMRP != null) {
            whereClause.append(" AND ").append("TypeMRP").append("=?");
            params.add(typeMRP);
        }
        if (orderType != null) {
            whereClause.append(" AND ").append("OrderType").append("=?");
            params.add(orderType);
        }
        if (po instanceof MPPOrder && "S".equals(typeMRP)) {
            whereClause.append(" AND ").append("PP_Order_BOMLine_ID").append(" IS NULL");
        }
        return new Query(po.getCtx(), "PP_MRP", whereClause.toString(), po.get_TrxName()).setParameters(params);
    }

    public MPPMRP(Properties ctx, int PP_MRP_ID, String trxName) {
        super(ctx, PP_MRP_ID, trxName);
        if (PP_MRP_ID == 0) {
            this.setValue("MRP");
            this.setName("MRP");
            this.setDateSimulation(new Timestamp(System.currentTimeMillis()));
            this.setIsAvailable(false);
        }
    }

    public MPPMRP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setPP_Order(MPPOrder o) {
        this.setPP_Order_ID(o.getPP_Order_ID());
        this.setOrderType("MOP");
        this.setName(o.getDocumentNo());
        this.setDescription(o.getDescription());
        this.setDatePromised(o.getDatePromised());
        this.setDateOrdered(o.getDateOrdered());
        this.setDateStartSchedule(o.getDateStartSchedule());
        this.setDateFinishSchedule(o.getDateFinishSchedule());
        this.setS_Resource_ID(o.getS_Resource_ID());
        this.setDocStatus(o.getDocStatus());
    }

    public void setC_Order(MOrder o) {
        this.setC_Order_ID(o.get_ID());
        this.setC_BPartner_ID(o.getC_BPartner_ID());
        this.setDocStatus(o.getDocStatus());
        if (o.isSOTrx()) {
            this.setOrderType("SOO");
            this.setTypeMRP("D");
        } else {
            this.setOrderType("POO");
            this.setTypeMRP("S");
        }
    }

    public void setDD_Order(MDDOrder o) {
        this.setDD_Order_ID(o.get_ID());
        this.setC_BPartner_ID(o.getC_BPartner_ID());
        this.setDocStatus(o.getDocStatus());
    }

    public void setM_Requisition(MRequisition r) {
        this.setM_Requisition_ID(r.get_ID());
        this.setOrderType("POR");
        this.setTypeMRP("S");
        this.setDateOrdered(r.getDateRequired());
        this.setDatePromised(r.getDateRequired());
        this.setDateStartSchedule(r.getDateRequired());
        this.setDateFinishSchedule(r.getDateRequired());
        this.setM_Warehouse_ID(r.getM_Warehouse_ID());
    }

    public void setM_Forecast(X_M_Forecast f) {
        this.setOrderType("FCT");
        this.setTypeMRP("D");
        this.setM_Forecast_ID(f.getM_Forecast_ID());
        this.setDescription(f.getDescription());
    }

    public boolean isReleased() {
        String docStatus = this.getDocStatus();
        if (docStatus == null) {
            return false;
        }
        return "IP".equals(docStatus) || "CO".equals(docStatus);
    }

    public static void M_Forecast(X_M_Forecast f) {
        List list = MPPMRP.getQuery((PO)f, null, null).list();
        for (MPPMRP mrp : list) {
            mrp.setM_Forecast(f);
        }
    }

    public static void M_ForecastLine(MForecastLine fl) {
        String trxName = fl.get_TrxName();
        Properties ctx = fl.getCtx();
        X_M_Forecast f = new X_M_Forecast(ctx, fl.getM_Forecast_ID(), trxName);
        MPPMRP mrp = (MPPMRP)MPPMRP.getQuery((PO)fl, null, null).firstOnly();
        if (mrp == null) {
            mrp = new MPPMRP(ctx, 0, trxName);
            mrp.setM_ForecastLine_ID(fl.getM_ForecastLine_ID());
        }
        mrp.setM_Forecast(f);
        mrp.setName("MRP");
        mrp.setAD_Org_ID(fl.getAD_Org_ID());
        mrp.setDatePromised(fl.getDatePromised());
        mrp.setDateStartSchedule(fl.getDatePromised());
        mrp.setDateFinishSchedule(fl.getDatePromised());
        mrp.setDateOrdered(fl.getDatePromised());
        mrp.setM_Warehouse_ID(fl.getM_Warehouse_ID());
        mrp.setM_Product_ID(fl.getM_Product_ID());
        mrp.setQty(fl.getQty());
        mrp.setDocStatus("IP");
        mrp.saveEx();
    }

    public static void C_Order(MOrder o) {
        MDocType dt = MDocType.get((Properties)o.getCtx(), (int)o.getC_DocTypeTarget_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if ("SO".equals(DocSubTypeSO) || !o.isSOTrx()) {
            if (o.getDocStatus().equals("IP") || o.getDocStatus().equals("CO") || !o.isSOTrx()) {
                for (MOrderLine line : o.getLines()) {
                    MPPMRP.C_OrderLine(line);
                }
            }
            if (o.is_ValueChanged("DocStatus") || o.is_ValueChanged("C_BPartner_ID")) {
                List list = MPPMRP.getQuery((PO)o, null, null).list();
                for (MPPMRP mrp : list) {
                    mrp.setC_Order(o);
                    mrp.saveEx();
                }
            }
        }
    }

    public static void C_OrderLine(MOrderLine ol) {
        MPPMRP mrp = (MPPMRP)MPPMRP.getQuery((PO)ol, null, null).firstOnly();
        if (mrp == null) {
            mrp = new MPPMRP(ol.getCtx(), 0, ol.get_TrxName());
            mrp.setC_OrderLine_ID(ol.getC_OrderLine_ID());
        }
        mrp.setAD_Org_ID(ol.getAD_Org_ID());
        mrp.setC_Order(ol.getParent());
        mrp.setDescription(ol.getDescription());
        mrp.setName("MRP");
        mrp.setDatePromised(ol.getDatePromised());
        mrp.setDateStartSchedule(ol.getDatePromised());
        mrp.setDateFinishSchedule(ol.getDatePromised());
        mrp.setDateOrdered(ol.getDateOrdered());
        mrp.setM_Warehouse_ID(ol.getM_Warehouse_ID());
        mrp.setM_Product_ID(ol.getM_Product_ID());
        mrp.setQty(ol.getQtyOrdered().subtract(ol.getQtyDelivered()));
        mrp.saveEx();
        MOrder o = ol.getParent();
        MDocType dt = MDocType.get((Properties)o.getCtx(), (int)o.getC_DocTypeTarget_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if ("SO".equals(DocSubTypeSO)) {
            MPPMRP.createMOMakeTo(ol, ol.getQtyOrdered());
        }
    }

    public static void PP_Order(MPPOrder o) {
        Properties ctx = o.getCtx();
        String trxName = o.get_TrxName();
        MPPMRP mrpSupply = (MPPMRP)MPPMRP.getQuery((PO)o, "S", "MOP").firstOnly();
        if (mrpSupply == null) {
            mrpSupply = new MPPMRP(ctx, 0, trxName);
            mrpSupply.setAD_Org_ID(o.getAD_Org_ID());
            mrpSupply.setTypeMRP("S");
        }
        mrpSupply.setPP_Order(o);
        mrpSupply.setM_Product_ID(o.getM_Product_ID());
        mrpSupply.setM_Warehouse_ID(o.getM_Warehouse_ID());
        mrpSupply.setQty(o.getQtyOrdered().subtract(o.getQtyDelivered()));
        mrpSupply.saveEx();
        List mrpDemandList = MPPMRP.getQuery((PO)o, "D", "MOP").list();
        for (MPPMRP mrpDemand : mrpDemandList) {
            mrpDemand.setPP_Order(o);
            mrpDemand.saveEx();
        }
    }

    public static void PP_Order_BOMLine(MPPOrderBOMLine obl) {
        MPPMRP mrp;
        String trxName = obl.get_TrxName();
        Properties ctx = obl.getCtx();
        String typeMRP = "D";
        BigDecimal qty = obl.getQtyRequired().subtract(obl.getQtyDelivered());
        if (obl.isCoProduct() || obl.isByProduct()) {
            typeMRP = "S";
            qty = qty.negate();
        }
        if ((mrp = (MPPMRP)MPPMRP.getQuery((PO)obl, null, "MOP").firstOnly()) == null) {
            mrp = new MPPMRP(ctx, 0, trxName);
            mrp.setPP_Order_BOMLine_ID(obl.getPP_Order_BOMLine_ID());
        }
        mrp.setAD_Org_ID(obl.getAD_Org_ID());
        mrp.setTypeMRP(typeMRP);
        mrp.setPP_Order(obl.getParent());
        mrp.setM_Warehouse_ID(obl.getM_Warehouse_ID());
        mrp.setM_Product_ID(obl.getM_Product_ID());
        mrp.setQty(qty);
        mrp.saveEx();
    }

    public static void DD_Order(MDDOrder o) {
        if ("IP".equals(o.getDocStatus()) || "CO".equals(o.getDocStatus())) {
            for (MDDOrderLine line : o.getLines()) {
                MPPMRP.DD_OrderLine(line);
            }
        }
        if (o.is_ValueChanged("DocStatus") || o.is_ValueChanged("C_BPartner_ID")) {
            List list = MPPMRP.getQuery((PO)o, null, null).list();
            for (MPPMRP mrp : list) {
                mrp.setDD_Order(o);
                mrp.saveEx();
            }
        }
    }

    public static void DD_OrderLine(MDDOrderLine ol) {
        String trxName = ol.get_TrxName();
        Properties m_ctx = ol.getCtx();
        MPPMRP mrp = (MPPMRP)MPPMRP.getQuery((PO)ol, "D", "DOO").firstOnly();
        MLocator source = MLocator.get((Properties)m_ctx, (int)ol.getM_Locator_ID());
        MLocator target = MLocator.get((Properties)m_ctx, (int)ol.getM_LocatorTo_ID());
        if (mrp != null) {
            mrp.setAD_Org_ID(source.getAD_Org_ID());
            mrp.setName("MRP");
            mrp.setDescription(ol.getDescription());
            mrp.setDatePromised(ol.getDatePromised());
            mrp.setDateOrdered(ol.getDateOrdered());
            mrp.setM_Warehouse_ID(source.getM_Warehouse_ID());
            mrp.setM_Product_ID(ol.getM_Product_ID());
            mrp.setQty(ol.getQtyOrdered().subtract(ol.getQtyDelivered()));
            mrp.setDocStatus(ol.getParent().getDocStatus());
            mrp.saveEx();
        } else {
            mrp = new MPPMRP(m_ctx, 0, trxName);
            mrp.setAD_Org_ID(source.getAD_Org_ID());
            mrp.setName("MRP");
            mrp.setDescription(ol.getDescription());
            mrp.setDD_Order_ID(ol.getDD_Order_ID());
            mrp.setDD_OrderLine_ID(ol.getDD_OrderLine_ID());
            mrp.setDatePromised(ol.getDatePromised());
            mrp.setDateOrdered(ol.getDateOrdered());
            mrp.setM_Warehouse_ID(source.getM_Warehouse_ID());
            mrp.setM_Product_ID(ol.getM_Product_ID());
            mrp.setQty(ol.getQtyOrdered().subtract(ol.getQtyDelivered()));
            mrp.setDocStatus(ol.getParent().getDocStatus());
            mrp.setOrderType("DOO");
            mrp.setTypeMRP("D");
            mrp.saveEx();
        }
        mrp = (MPPMRP)MPPMRP.getQuery((PO)ol, "S", "DOO").firstOnly();
        if (mrp != null) {
            mrp.setAD_Org_ID(target.getAD_Org_ID());
            mrp.setName("MRP");
            mrp.setDescription(ol.getDescription());
            mrp.setDatePromised(ol.getDatePromised());
            mrp.setDateOrdered(ol.getDateOrdered());
            mrp.setM_Product_ID(ol.getM_Product_ID());
            mrp.setM_Warehouse_ID(target.getM_Warehouse_ID());
            mrp.setQty(ol.getQtyOrdered().subtract(ol.getQtyDelivered()));
            mrp.setDocStatus(ol.getParent().getDocStatus());
            mrp.saveEx();
        } else {
            mrp = new MPPMRP(m_ctx, 0, trxName);
            mrp.setAD_Org_ID(target.getAD_Org_ID());
            mrp.setName("MRP");
            mrp.setDescription(ol.getDescription());
            mrp.setDD_Order_ID(ol.getDD_Order_ID());
            mrp.setDD_OrderLine_ID(ol.getDD_OrderLine_ID());
            mrp.setDatePromised(ol.getDatePromised());
            mrp.setDateOrdered(ol.getDateOrdered());
            mrp.setM_Product_ID(ol.getM_Product_ID());
            mrp.setM_Warehouse_ID(target.getM_Warehouse_ID());
            mrp.setQty(ol.getQtyOrdered().subtract(ol.getQtyDelivered()));
            mrp.setDocStatus(ol.getParent().getDocStatus());
            mrp.setOrderType("DOO");
            mrp.setTypeMRP("S");
            mrp.saveEx();
        }
    }

    public static void M_Requisition(MRequisition r) {
        List mrpList = MPPMRP.getQuery((PO)r, null, null).list();
        for (MPPMRP mrp : mrpList) {
            mrp.setM_Requisition(r);
            mrp.saveEx();
        }
    }

    public static void M_RequisitionLine(MRequisitionLine rl) {
        MPPMRP mrp = (MPPMRP)MPPMRP.getQuery((PO)rl, null, null).firstOnly();
        MRequisition r = rl.getParent();
        if (mrp == null) {
            mrp = new MPPMRP(rl.getCtx(), 0, rl.get_TrxName());
            mrp.setM_Requisition_ID(rl.getM_Requisition_ID());
            mrp.setM_RequisitionLine_ID(rl.getM_RequisitionLine_ID());
        }
        mrp.setM_Requisition(r);
        mrp.setAD_Org_ID(rl.getAD_Org_ID());
        mrp.setName("MRP");
        mrp.setDescription(rl.getDescription());
        mrp.setM_Product_ID(rl.getM_Product_ID());
        mrp.setQty(rl.getQty().subtract(rl.getQtyOrdered()));
        mrp.setDocStatus("DR");
        mrp.saveEx();
    }

    public static boolean hasProductRecords(MProduct product) {
        String whereClause = "M_Product_ID=? AND Qty<>0";
        return new Query(product.getCtx(), "PP_MRP", "M_Product_ID=? AND Qty<>0", product.get_TrxName()).setParameters(new Object[]{product.getM_Product_ID()}).match();
    }

    public static BigDecimal getQtyOnHand(Properties ctx, int M_Warehouse_ID, int M_Product_ID, String trxName) {
        String sql = "SELECT COALESCE(bomQtyOnHand (M_Product_ID,?,0),0) FROM M_Product WHERE AD_Client_ID=? AND M_Product_ID=?";
        return DB.getSQLValueBDEx((String)trxName, (String)"SELECT COALESCE(bomQtyOnHand (M_Product_ID,?,0),0) FROM M_Product WHERE AD_Client_ID=? AND M_Product_ID=?", (Object[])new Object[]{M_Warehouse_ID, Env.getAD_Client_ID((Properties)ctx), M_Product_ID});
    }

    public static BigDecimal getQtyReserved(Properties ctx, int M_Warehouse_ID, int M_Product_ID, Timestamp To, String trxName) {
        String sql = "SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP=? AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND M_Warehouse_ID =? AND M_Product_ID=? AND DatePromised <=?";
        BigDecimal qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP=? AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND M_Warehouse_ID =? AND M_Product_ID=? AND DatePromised <=?", (Object[])new Object[]{"D", Env.getAD_Client_ID((Properties)ctx), M_Warehouse_ID, M_Product_ID, To});
        if (qty == null) {
            return Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyReserved(Properties ctx, int M_Warehouse_ID, int M_Product_ID, String trxName) {
        return MPPMRP.getQtyReserved(ctx, M_Warehouse_ID, M_Product_ID, new Timestamp(System.currentTimeMillis()), trxName);
    }

    public static BigDecimal getQtyOrdered(Properties ctx, int M_Warehouse_ID, int M_Product_ID, Timestamp To, String trxName) {
        String sql = "SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP='S' AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND DatePromised <=? AND M_Warehouse_ID =? AND M_Product_ID=?";
        BigDecimal qty = DB.getSQLValueBDEx((String)trxName, (String)"SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP='S' AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND DatePromised <=? AND M_Warehouse_ID =? AND M_Product_ID=?", (Object[])new Object[]{Env.getAD_Client_ID((Properties)ctx), To, M_Warehouse_ID, M_Product_ID});
        if (qty == null) {
            return Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOrdered(Properties ctx, int M_Warehouse_ID, int M_Product_ID, String trxName) {
        return MPPMRP.getQtyOrdered(ctx, M_Warehouse_ID, M_Product_ID, new Timestamp(System.currentTimeMillis()), trxName);
    }

    public static int getMaxLowLevel(Properties ctx, String trxName) {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        String sql = "SELECT MAX(LowLevel) FROM M_Product WHERE AD_Client_ID=? AND LowLevel IS NOT NULL";
        int LowLevel = DB.getSQLValueEx((String)trxName, (String)"SELECT MAX(LowLevel) FROM M_Product WHERE AD_Client_ID=? AND LowLevel IS NOT NULL", (Object[])new Object[]{AD_Client_ID});
        return LowLevel + 1;
    }

    public static int getDurationDays(BigDecimal qty, I_PP_Product_Planning pp) {
        Properties ctx = null;
        ctx = pp instanceof PO ? ((PO)pp).getCtx() : Env.getCtx();
        MProduct product = MProduct.get((Properties)ctx, (int)pp.getM_Product_ID());
        BigDecimal leadtime = pp.getDeliveryTime_Promised();
        if (leadtime.signum() == 0 && !product.isPurchased()) {
            if (pp.getS_Resource_ID() > 0 && pp.getAD_Workflow_ID() > 0) {
                RoutingService routingService = RoutingServiceFactory.get().getRoutingService(ctx);
                leadtime = routingService.calculateDuration(pp.getAD_Workflow(), pp.getS_Resource(), qty);
            } else {
                throw new AdempiereException("Cannot calculate leadtime for " + pp);
            }
        }
        return leadtime.add(pp.getTransfertTime()).intValue();
    }

    public static String getDocumentNo(int PP_MRP_ID) {
        return DB.getSQLValueStringEx(null, (String)"SELECT documentNo(PP_MRP_ID) AS DocumentNo FROM PP_MRP WHERE PP_MRP_ID = ?", (Object[])new Object[]{PP_MRP_ID});
    }

    public String toString() {
        String description = this.getDescription();
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + ", TypeMRP=" + this.getTypeMRP() + ", DocStatus=" + this.getDocStatus() + ", Qty=" + this.getQty() + ", DatePromised=" + this.getDatePromised() + ", Schedule=" + this.getDateStartSchedule() + "/" + this.getDateFinishSchedule() + ", IsAvailable=" + this.isAvailable() + (!Util.isEmpty((String)description, (boolean)true) ? ", Description=" + description : "") + ", ID=" + this.get_ID() + "]";
    }

    static {
        s_sourceColumnNames.put("C_Order", new String[]{"DatePromised", "DocStatus"});
        s_sourceColumnNames.put("C_OrderLine", new String[]{"AD_Org_ID", "DateOrdered", "DatePromised", "C_BPartner_ID", "M_Warehouse_ID", "M_Product_ID", "C_UOM_ID", "QtyOrdered", "QtyDelivered"});
        s_sourceColumnNames.put("M_Requisition", new String[]{"DateRequired", "M_Warehouse_ID"});
        s_sourceColumnNames.put("M_RequisitionLine", new String[]{"AD_Org_ID", "M_Product_ID", "Qty", "C_OrderLine_ID"});
        s_sourceColumnNames.put("M_Forecast", new String[0]);
        s_sourceColumnNames.put("M_ForecastLine", new String[]{"AD_Org_ID", "DatePromised", "M_Warehouse_ID", "M_Product_ID", "Qty"});
        s_sourceColumnNames.put("DD_Order", new String[]{"DocStatus", "C_BPartner_ID"});
        s_sourceColumnNames.put("DD_OrderLine", new String[]{"AD_Org_ID", "M_Product_ID", "C_UOM_ID", "DatePromised", "QtyOrdered", "QtyDelivered", "ConfirmedQty", "M_Locator_ID", "M_LocatorTo_ID", "ConfirmedQty"});
        s_sourceColumnNames.put("PP_Order", new String[]{"AD_Org_ID", "M_Product_ID", "C_UOM_ID", "DatePromised", "QtyOrdered", "QtyDelivered", "PP_Product_BOM_ID", "AD_Workflow_ID", "DocStatus"});
        s_sourceColumnNames.put("PP_Order_BOMLine", new String[]{"M_Product_ID", "C_UOM_ID", "M_Warehouse_ID", "QtyEntered", "QtyDelivered"});
    }
}

