/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model.reasoner;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.wrapper.BOMLineWrapper;

public class StorageReasoner {
    public MPPOrderWorkflow getPPOrderWorkflow(MPPOrder order) {
        int[] ids = PO.getAllIDs((String)"PP_Order_Workflow", (String)("PP_Order_ID = " + order.get_ID()), null);
        if (ids.length != 1) {
            return null;
        }
        return new MPPOrderWorkflow(Env.getCtx(), ids[0], null);
    }

    public boolean equalAttributeInstanceValue(MAttributeInstance ai1, MAttributeInstance ai2) {
        if (ai1.getM_Attribute_ID() != ai2.getM_Attribute_ID()) {
            return false;
        }
        boolean equal = true;
        MAttribute a = new MAttribute(Env.getCtx(), ai1.getM_Attribute_ID(), null);
        if ("N".equals(a.getAttributeValueType())) {
            equal = ai1.getValue() == null ? ai2.getValueNumber() == null : ai1.getValueNumber().compareTo(ai2.getValueNumber()) == 0;
        } else if ("S".equals(a.getAttributeValueType())) {
            equal = ai1.getValue() == null ? ai2.getValue() == null : ai1.getValue().equals(ai2.getValue());
        } else if ("L".equals(a.getAttributeValueType())) {
            equal = ai1.getM_AttributeValue_ID() == ai2.getM_AttributeValue_ID();
        }
        return equal;
    }

    public int[] getAttributeIDs(MAttributeSetInstance asi) {
        MAttributeSet as = new MAttributeSet(Env.getCtx(), asi.getM_AttributeSet_ID(), null);
        return this.getPOIDs("M_Attribute", "M_Attribute_ID IN (SELECT M_Attribute_ID FROM M_AttributeUse WHERE M_AttributeSet_ID = " + as.get_ID() + ")", null);
    }

    public BigDecimal getSumQtyAvailable(MProduct p, MAttributeSetInstance asi) {
        int[] ids = this.getPOIDs("M_Locator", null, null);
        MStorage storage = null;
        Object obj = null;
        BigDecimal sumQtyAvailable = BigDecimal.ZERO;
        int count = 0;
        for (int i = 0; i < ids.length; ++i) {
            storage = MStorage.get((Properties)Env.getCtx(), (int)ids[i], (int)p.get_ID(), (int)asi.get_ID(), null);
            if (storage == null) continue;
            ++count;
            sumQtyAvailable = sumQtyAvailable.add(storage.getQtyOnHand().subtract(storage.getQtyReserved()));
        }
        return sumQtyAvailable;
    }

    public BigDecimal getSumQtyRequired(BOMLineWrapper line) {
        MProduct p = new MProduct(Env.getCtx(), line.getM_Product_ID(), null);
        MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), line.getM_AttributeSetInstance_ID(), null);
        return this.getSumQtyAvailable(p, asi).subtract(line.getQtyBOM()).negate();
    }

    public MStorage getAvailableQtyLocator(MProduct p, MAttributeSetInstance asi, BigDecimal qtyRequired) {
        int[] ids = this.getPOIDs("M_Locator", null, null);
        MStorage storage = null;
        BigDecimal qtyAvailable = BigDecimal.ZERO;
        BigDecimal qtyOnHand = BigDecimal.ZERO;
        BigDecimal qtyReserved = BigDecimal.ZERO;
        for (int i = 0; i < ids.length; ++i) {
            storage = MStorage.get((Properties)Env.getCtx(), (int)ids[i], (int)p.get_ID(), (int)asi.get_ID(), null);
            if (storage == null) continue;
            qtyOnHand = storage.getQtyOnHand() == null ? BigDecimal.ZERO : storage.getQtyOnHand();
            qtyAvailable = qtyOnHand.subtract(qtyReserved = storage.getQtyReserved() == null ? BigDecimal.ZERO : storage.getQtyReserved());
            if (qtyRequired.compareTo(qtyAvailable) <= 0 && qtyOnHand.compareTo(BigDecimal.ZERO) > 0) break;
            storage = null;
        }
        return storage;
    }

    public boolean isQtyAvailable(BOMLineWrapper line) {
        MProduct p = new MProduct(Env.getCtx(), line.getM_Product_ID(), null);
        MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), line.getM_AttributeSetInstance_ID(), null);
        return this.isQtyAvailable(p, asi);
    }

    public boolean isQtyAvailable(MProduct p, MAttributeSetInstance asi) {
        int[] ids = this.getPOIDs("M_Locator", null, null);
        MStorage storage = null;
        BigDecimal sumQtyOnHand = BigDecimal.ZERO;
        BigDecimal sumQtyReserved = BigDecimal.ZERO;
        int count = 0;
        for (int i = 0; i < ids.length; ++i) {
            storage = MStorage.get((Properties)Env.getCtx(), (int)ids[i], (int)p.get_ID(), (int)asi.get_ID(), null);
            if (storage == null) continue;
            ++count;
            sumQtyOnHand = sumQtyOnHand.add(storage.getQtyOnHand());
            sumQtyReserved = sumQtyReserved.add(storage.getQtyReserved());
        }
        double available = sumQtyOnHand.subtract(sumQtyReserved).setScale(2, 4).doubleValue();
        return count != 0 && !(available <= 0.0);
    }

    public int[] getPOIDs(String from, String where, String trx) {
        String client = "AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx());
        String w = null;
        w = where == null || where.length() == 0 ? client : where + " AND " + client;
        return PO.getAllIDs((String)from, (String)w, (String)trx);
    }
}

