/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.util.logging.Level;
import org.compiere.ldap.LdapResult;
import org.compiere.util.CLogger;

public class LdapMessage {
    public static final int BIND_REQUEST = 96;
    public static final int BIND_RESPONSE = 97;
    public static final int UNBIND_REQUEST = 98;
    public static final int SEARCH_REQUEST = 99;
    public static final int SEARCH_REP_ENTRY = 100;
    public static final int SEARCH_RES_RESULT = 101;
    public static final int SIMPLE_AUTHENTICATION = 128;
    public static final int FILTER_AND = 160;
    public static final int FILTER_OR = 161;
    public static final int FILTER_NOT = 162;
    public static final int FILTER_EQUALITYMATCH = 163;
    public static final int SEQUENCE = 48;
    private BerDecoder decoder = null;
    private static CLogger log = CLogger.getCLogger(LdapMessage.class);
    private int m_protocolOp = -1;
    private int msgId;
    private String dn = null;
    private String org = null;
    private String orgUnit = null;
    private String userId = null;
    private String passwd = null;
    private String baseObj = null;
    private LdapResult result = null;

    public void reset(LdapResult result) {
        this.result = result;
        this.decoder = null;
        this.m_protocolOp = -1;
        this.msgId = -1;
        this.dn = null;
        this.org = null;
        this.orgUnit = null;
        this.userId = null;
        this.passwd = null;
        this.baseObj = null;
    }

    public void decode(byte[] data, int length) {
        try {
            this.decoder = new BerDecoder(data, 0, length);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, data.toString(), e);
            return;
        }
        try {
            this.decoder.parseSeq(null);
            this.msgId = this.decoder.parseInt();
            this.m_protocolOp = this.decoder.parseSeq(null);
            if (this.m_protocolOp == 96) {
                this.handleBind();
            } else if (this.m_protocolOp == 98) {
                log.info("#" + this.msgId + ": unbind");
            } else if (this.m_protocolOp == 99) {
                this.handleSearch();
            } else {
                this.result.setErrorNo(2);
                this.result.setErrorString(": Unsupported Request");
                log.warning("#" + this.msgId + ": Unknown Op + " + this.m_protocolOp);
            }
        }
        catch (Exception ex) {
            this.result.setErrorNo(2);
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void handleSearch() {
        try {
            this.baseObj = this.decoder.parseString(true);
            this.parseDN(this.baseObj);
            this.decoder.parseEnumeration();
            this.decoder.parseEnumeration();
            this.decoder.parseInt();
            this.decoder.parseInt();
            this.decoder.parseBoolean();
            boolean equalityFilter = false;
            while (true) {
                int filter;
                if ((filter = this.decoder.parseSeq(null)) == 163) {
                    this.decoder.parseString(true);
                    this.userId = this.decoder.parseString(true);
                    equalityFilter = true;
                    break;
                }
                if (filter == 160) {
                    this.decoder.parseStringWithTag(135, true, null);
                    continue;
                }
                if (filter == 48) break;
            }
            if (!equalityFilter) {
                this.result.setErrorNo(2);
                this.result.setErrorString("Can't can't Filter - EqualityMatch");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void handleBind() {
        try {
            int version = this.decoder.parseInt();
            if (version != 3) {
                this.result.setErrorNo(2);
                this.result.setErrorString("Unsupported LDAP version");
                log.info("#" + this.msgId + ": unsupported LDAP version - " + version);
                return;
            }
            this.dn = this.decoder.parseString(true);
            int auth = this.decoder.peekByte();
            if (auth != 128) {
                this.result.setErrorNo(7);
                log.info("#" + this.msgId + ": unsupported authentication method - " + auth);
                return;
            }
            this.passwd = this.decoder.parseStringWithTag(128, true, null);
            if (this.passwd != null && this.passwd.length() > 0) {
                this.parseDN(this.dn);
                if (this.userId == null || this.userId.length() <= 0) {
                    this.result.setErrorNo(32);
                    this.result.setErrorString(": \"cn\" not defined");
                    log.info("#" + this.msgId + ": \"cn\" not defined");
                    return;
                }
            }
            log.info("#" + this.msgId + ": bind - version=" + version + ", userId=" + this.userId);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void parseDN(String dName) {
        String[] dnArray = dName.split(",");
        for (int i = 0; i < dnArray.length; ++i) {
            if (dnArray[i].startsWith("cn=")) {
                this.userId = dnArray[i].split("=")[1];
                continue;
            }
            if (dnArray[i].startsWith("o=")) {
                this.org = dnArray[i].split("=")[1];
                continue;
            }
            if (!dnArray[i].startsWith("ou=")) continue;
            this.orgUnit = dnArray[i].split("=")[1];
        }
    }

    public int getOperation() {
        return this.m_protocolOp;
    }

    public int getMsgId() {
        return this.msgId;
    }

    public String getDN() {
        return this.dn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserPasswd() {
        return this.passwd;
    }

    public String getBaseObj() {
        return this.baseObj;
    }

    public String getOrg() {
        return this.org;
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }
}

