/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.ldap;

import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.ldap.LdapConnectionHandler;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MLdapProcessorLog;
import org.compiere.server.AdempiereServer;
import org.compiere.util.TimeUtil;

public class LdapProcessor
extends AdempiereServer {
    private MLdapProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private ServerSocket m_serverSocket = null;
    private int m_counter = 0;

    public LdapProcessor(MLdapProcessor model) {
        super(model, 300);
        this.m_model = model;
    }

    protected void doWork() {
        if (this.m_serverSocket != null) {
            try {
                this.m_serverSocket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.m_counter = 0;
        this.m_summary = new StringBuffer(this.m_model.toString()).append(" - ");
        try {
            this.m_serverSocket = new ServerSocket(this.m_model.getLdapPort());
            this.log.log(Level.INFO, "Opened Port=" + this.m_model.getLdapPort());
            while (!this.isInterrupted()) {
                Socket socket = this.m_serverSocket.accept();
                this.log.log(Level.FINE, "Connection on Port=" + this.m_model.getLdapPort());
                LdapConnectionHandler handler = new LdapConnectionHandler(socket, this.m_model);
                handler.start();
                ++this.m_counter;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Port=" + this.m_model.getLdapPort(), e);
            this.m_summary.append(e.toString());
        }
        this.m_summary.append("; ").append(this.m_model.getInfo());
        int no = this.m_model.deleteLog();
        this.m_summary.append("; Logs deleted=").append(no);
        MLdapProcessorLog pLog = new MLdapProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString() + "; Counter=" + this.m_counter + "; " + this.m_model.getInfo();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        new LdapProcessor(new MLdapProcessor(new Properties(), 100, null)).doWork();
    }
}

