/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.util.logging.Level;
import org.compiere.ldap.LdapMessage;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MLdapUser;
import org.compiere.util.CLogger;

public class LdapResult {
    private LdapMessage ldapMsg = null;
    private BerEncoder m_encoder = null;
    private static CLogger log = CLogger.getCLogger(LdapResult.class);
    private int errNo = 0;
    private String errStr = "";
    private MLdapUser ldapUser = null;
    private boolean disconnect = false;
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_OPERATIONS_ERROR = 1;
    static final int LDAP_PROTOCOL_ERROR = 2;
    static final int LDAP_TIME_LIMIT_EXCEEDED = 3;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_COMPARE_FALSE = 5;
    static final int LDAP_COMPARE_TRUE = 6;
    static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    static final int LDAP_PARTIAL_RESULTS = 9;
    static final int LDAP_REFERRAL = 10;
    static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    static final int LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17;
    static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    static final int LDAP_CONSTRAINT_VIOLATION = 19;
    static final int LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20;
    static final int LDAP_INVALID_ATTRIBUTE_SYNTAX = 21;
    static final int LDAP_NO_SUCH_OBJECT = 32;
    static final int LDAP_ALIAS_PROBLEM = 33;
    static final int LDAP_INVALID_DN_SYNTAX = 34;
    static final int LDAP_IS_LEAF = 35;
    static final int LDAP_ALIAS_DEREFERENCING_PROBLEM = 36;
    static final int LDAP_INAPPROPRIATE_AUTHENTICATION = 48;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50;
    static final int LDAP_BUSY = 51;
    static final int LDAP_UNAVAILABLE = 52;
    static final int LDAP_UNWILLING_TO_PERFORM = 53;
    static final int LDAP_LOOP_DETECT = 54;
    static final int LDAP_NAMING_VIOLATION = 64;
    static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    static final int LDAP_NOT_ALLOWED_ON_NON_LEAF = 66;
    static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    static final int LDAP_ENTRY_ALREADY_EXISTS = 68;
    static final int LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69;
    static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    static final int LDAP_OTHER = 80;
    static final String[] ldapErrorMessage = new String[]{"Success", "Operations Error", "Protocol Error", "Timelimit Exceeded", "Sizelimit Exceeded", "Compare False", "Compare True", "Authentication Method Not Supported", "Strong Authentication Required", null, "Referral", "Administrative Limit Exceeded", "Unavailable Critical Extension", "Confidentiality Required", "SASL Bind In Progress", null, "No Such Attribute", "Undefined Attribute Type", "Inappropriate Matching", "Constraint Violation", "Attribute Or Value Exists", "Invalid Attribute Syntax", null, null, null, null, null, null, null, null, null, null, "No Such Object", "Alias Problem", "Invalid DN Syntax", null, "Alias Dereferencing Problem", null, null, null, null, null, null, null, null, null, null, null, "Inappropriate Authentication", "Invalid Credentials", "Insufficient Access Rights", "Busy", "Unavailable", "Unwilling To Perform", "Loop Detect", null, null, null, null, null, null, null, null, null, "Naming Violation", "Object Class Violation", "Not Allowed On Non-leaf", "Not Allowed On RDN", "Entry Already Exists", "Object Class Modifications Prohibited", null, "Affects Multiple DSAs", null, null, null, null, null, null, null, null, "Other", null, null, null, null, null, null, null, null, null, null};

    public void reset(LdapMessage ldapMsg, MLdapUser ldapUser) {
        this.ldapMsg = ldapMsg;
        this.m_encoder = new BerEncoder();
        this.errNo = 0;
        this.errStr = "";
        this.ldapUser = ldapUser;
    }

    public byte[] getResult(MLdapProcessor model) {
        if (this.errNo != 0) {
            this.generateResult("", this.ldapMsg.getOperation() == 96 ? 97 : 101, this.errNo, ldapErrorMessage[this.errNo] + this.errStr);
            this.m_encoder.getTrimmedBuf();
        }
        try {
            String usrId = this.ldapMsg.getUserId();
            String o = this.ldapMsg.getOrg();
            String ou = this.ldapMsg.getOrgUnit();
            if (this.ldapMsg.getOperation() == 96) {
                String pwd = this.ldapMsg.getUserPasswd();
                if (pwd == null || pwd.length() <= 0) {
                    this.generateResult(this.ldapMsg.getDN(), 97, 0, null);
                    log.info("Success");
                    return this.m_encoder.getTrimmedBuf();
                }
                if (this.ldapUser.getUserId() == null) {
                    this.ldapUser.reset();
                    model.authenticate(this.ldapUser, usrId, o, ou);
                    if (this.ldapUser.getErrorMsg() != null) {
                        this.errNo = 32;
                        this.generateResult(this.ldapMsg.getBaseObj(), 101, 32, ldapErrorMessage[32] + this.ldapUser.getErrorMsg());
                        log.info("Failed");
                        return this.m_encoder.getTrimmedBuf();
                    }
                }
                if (usrId.compareTo(this.ldapUser.getUserId()) == 0 && pwd.compareTo(this.ldapUser.getPassword()) == 0) {
                    this.generateResult("", 97, 0, null);
                    this.disconnect = true;
                    log.info("Success");
                } else {
                    this.errNo = 48;
                    this.generateResult("", 97, 48, ldapErrorMessage[48]);
                    log.info("Failed : " + ldapErrorMessage[48]);
                }
            } else if (this.ldapMsg.getOperation() == 99) {
                this.ldapUser.reset();
                model.authenticate(this.ldapUser, usrId, o, ou);
                if (this.ldapUser.getErrorMsg() != null) {
                    this.errNo = 32;
                    this.generateResult(this.ldapMsg.getBaseObj(), 101, 32, ldapErrorMessage[32] + this.ldapUser.getErrorMsg());
                    log.info("Failed");
                    return this.m_encoder.getTrimmedBuf();
                }
                this.m_encoder.beginSeq(48);
                this.m_encoder.encodeInt(this.ldapMsg.getMsgId());
                this.m_encoder.beginSeq(100);
                this.m_encoder.encodeString("cn=" + this.ldapMsg.getUserId(), true);
                this.m_encoder.beginSeq(48);
                this.m_encoder.endSeq();
                this.m_encoder.endSeq();
                this.m_encoder.endSeq();
                this.generateResult(this.ldapMsg.getBaseObj(), 101, 0, null);
                log.info("Success");
            }
            return this.m_encoder.getTrimmedBuf();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return this.m_encoder.getTrimmedBuf();
        }
    }

    private void generateResult(String dn, int resultProtocol, int resultCode, String errMsg) {
        try {
            this.m_encoder.beginSeq(48);
            this.m_encoder.encodeInt(this.ldapMsg.getMsgId());
            this.m_encoder.beginSeq(resultProtocol);
            this.m_encoder.encodeInt(resultCode, 10);
            this.m_encoder.encodeString(dn, true);
            this.m_encoder.encodeString(errMsg == null ? "" : errMsg, true);
            this.m_encoder.endSeq();
            this.m_encoder.endSeq();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    public boolean getDone() {
        if (this.errNo != 0) {
            return true;
        }
        return this.disconnect;
    }

    public void setErrorNo(int errNo) {
        this.errNo = errNo;
    }

    public int getErrorNo() {
        return this.errNo;
    }

    public void setErrorString(String errStr) {
        this.errStr = errStr;
    }
}

