/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class AcctProcessor
extends AdempiereServer {
    private MAcctProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;
    private MAcctSchema[] m_ass = null;

    public AcctProcessor(MAcctProcessor model) {
        super(model, 30);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.m_ass = this.m_model.getC_AcctSchema_ID() == 0 ? MAcctSchema.getClientAcctSchema(this.getCtx(), this.m_model.getAD_Client_ID()) : new MAcctSchema[]{new MAcctSchema(this.getCtx(), this.m_model.getC_AcctSchema_ID(), null)};
        this.postSession();
        MCost.create(this.m_client);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAcctProcessorLog pLog = new MAcctProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postSession() {
        ArrayList<BigDecimal> listProcessedOn = new ArrayList<BigDecimal>();
        listProcessedOn.add(Env.ZERO);
        Timestamp ts = DB.getSQLValueTS(null, "SELECT CURRENT_TIMESTAMP FROM DUAL", new Object[0]);
        long ms = ts.getTime() - 2000L;
        ts = new Timestamp(ms);
        long mili = ts.getTime();
        BigDecimal value = new BigDecimal(Long.toString(mili));
        int[] documentsTableID = Doc.getDocumentsTableID();
        String[] documentsTableName = Doc.getDocumentsTableName();
        for (int i = 0; i < documentsTableID.length; ++i) {
            int AD_Table_ID = documentsTableID[i];
            String TableName = documentsTableName[i];
            if (this.m_model.getAD_Table_ID() != 0 && this.m_model.getAD_Table_ID() != AD_Table_ID) continue;
            StringBuffer sql = new StringBuffer("SELECT DISTINCT ProcessedOn FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND ProcessedOn<?").append(" AND Processed='Y' AND Posted='N' AND IsActive='Y'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                pstmt.setBigDecimal(2, value);
                rs = pstmt.executeQuery();
                while (!this.isInterrupted() && rs.next()) {
                    BigDecimal processedOn = rs.getBigDecimal(1);
                    if (listProcessedOn.contains(processedOn)) continue;
                    listProcessedOn.add(processedOn);
                }
                DB.close(rs, pstmt);
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
                continue;
            }
            finally {
                DB.close(rs, pstmt);
            }
        }
        int[] count = new int[documentsTableID.length];
        int[] countError = new int[documentsTableID.length];
        for (int i = 0; i < count.length; ++i) {
            count[i] = 0;
            countError[i] = 0;
        }
        Collections.sort(listProcessedOn);
        for (BigDecimal processedOn : listProcessedOn) {
            for (int i = 0; i < documentsTableID.length; ++i) {
                int AD_Table_ID = documentsTableID[i];
                String TableName = documentsTableName[i];
                if (this.m_model.getAD_Table_ID() != 0 && this.m_model.getAD_Table_ID() != AD_Table_ID) continue;
                StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND (ProcessedOn");
                if (processedOn.compareTo(Env.ZERO) != 0) {
                    sql.append("=?");
                } else {
                    sql.append(" IS NULL OR ProcessedOn=0");
                }
                sql.append(") AND Processed='Y' AND Posted='N' AND IsActive='Y'").append(" ORDER BY Created");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, this.m_model.getAD_Client_ID());
                    if (processedOn.compareTo(Env.ZERO) != 0) {
                        pstmt.setBigDecimal(2, processedOn);
                    }
                    rs = pstmt.executeQuery();
                    while (!this.isInterrupted() && rs.next()) {
                        int n = i;
                        count[n] = count[n] + 1;
                        boolean ok = true;
                        try {
                            Doc doc = Doc.get(this.m_ass, AD_Table_ID, rs, null);
                            if (doc == null) {
                                this.log.severe(this.getName() + ": No Doc for " + TableName);
                                ok = false;
                            } else {
                                String error = doc.post(false, false);
                                ok = error == null;
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, this.getName() + ": " + TableName, e);
                            ok = false;
                        }
                        if (ok) continue;
                        int n2 = i;
                        countError[n2] = countError[n2] + 1;
                    }
                    rs.close();
                    DB.close(rs, pstmt);
                    continue;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    continue;
                }
                finally {
                    DB.close(rs, pstmt);
                }
            }
        }
        for (int i = 0; i < documentsTableID.length; ++i) {
            String TableName = documentsTableName[i];
            if (count[i] > 0) {
                this.m_summary.append(TableName).append("=").append(count[i]);
                if (countError[i] > 0) {
                    this.m_summary.append("(Errors=").append(countError[i]).append(")");
                }
                this.m_summary.append(" - ");
                this.log.finer(this.getName() + ": " + this.m_summary.toString());
                continue;
            }
            this.log.finer(this.getName() + ": " + TableName + " - no work");
        }
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

