/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.adempiere.impexp.ArrayExcelExporter;
import org.compiere.Adempiere;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.MAlertRule;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertProcessor
extends AdempiereServer {
    private MAlertProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private StringBuffer m_errors = new StringBuffer();
    private MClient m_client = null;

    public AlertProcessor(MAlertProcessor model) {
        super(model, 180);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    @Override
    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.m_errors = new StringBuffer();
        int count = 0;
        int countError = 0;
        MAlert[] alerts = this.m_model.getAlerts(false);
        for (int i = 0; i < alerts.length; ++i) {
            if (!this.processAlert(alerts[i])) {
                ++countError;
            }
            ++count;
        }
        String summary = "Total=" + count;
        if (countError > 0) {
            summary = summary + ", Not processed=" + countError;
        }
        summary = summary + " - ";
        this.m_summary.insert(0, summary);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAlertProcessorLog pLog = new MAlertProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.setTextMsg(this.m_errors.toString());
        pLog.save();
    }

    private boolean processAlert(MAlert alert) {
        if (!alert.isValid()) {
            return false;
        }
        this.log.info("" + alert);
        StringBuffer message = new StringBuffer(alert.getAlertMessage()).append(Env.NL);
        boolean valid = true;
        boolean processed = false;
        ArrayList<File> attachments = new ArrayList<File>();
        MAlertRule[] rules = alert.getRules(false);
        for (int i = 0; i < rules.length; ++i) {
            Trx trx;
            int no;
            String sql;
            MAlertRule rule;
            String trxName;
            block9: {
                int no2;
                if (i > 0) {
                    message.append(Env.NL);
                }
                trxName = null;
                rule = rules[i];
                if (!rule.isValid()) continue;
                this.log.fine("" + rule);
                sql = rule.getPreProcessing();
                if (sql != null && sql.length() > 0 && (no2 = DB.executeUpdate(sql, false, trxName)) == -1) {
                    ValueNamePair error = CLogger.retrieveError();
                    rule.setErrorMsg("Pre=" + error.getName());
                    this.m_errors.append("Pre=" + error.getName());
                    rule.setIsValid(false);
                    rule.save();
                    valid = false;
                    break;
                }
                sql = rule.getSql(true);
                try {
                    String text = null;
                    text = MSysConfig.getBooleanValue("ALERT_SEND_ATTACHMENT_AS_XLS", true, Env.getAD_Client_ID(this.getCtx())) ? this.getExcelReport(rule, sql, trxName, attachments) : this.getPlainTextReport(rule, sql, trxName, attachments);
                    if (text == null || text.length() <= 0) break block9;
                    message.append(text);
                    processed = true;
                }
                catch (Exception e) {
                    rule.setErrorMsg("Select=" + e.getLocalizedMessage());
                    this.m_errors.append("Select=" + e.getLocalizedMessage());
                    rule.setIsValid(false);
                    rule.save();
                    valid = false;
                    break;
                }
            }
            sql = rule.getPostProcessing();
            if (sql != null && sql.length() > 0 && (no = DB.executeUpdate(sql, false, trxName)) == -1) {
                ValueNamePair error = CLogger.retrieveError();
                rule.setErrorMsg("Post=" + error.getName());
                this.m_errors.append("Post=" + error.getName());
                rule.setIsValid(false);
                rule.save();
                valid = false;
                break;
            }
            if (trxName == null || (trx = Trx.get(trxName, false)) == null) continue;
            trx.commit();
            trx.close();
        }
        if (!valid) {
            alert.setIsValid(false);
            alert.save();
            return false;
        }
        if (!processed) {
            this.m_summary.append(alert.getName()).append("=No Result - ");
            return true;
        }
        SimpleDateFormat df = DisplayType.getDateFormat(16);
        message.append("\n\n");
        message.append(Msg.translate(this.getCtx(), "Date")).append(" : ").append(df.format(new Timestamp(System.currentTimeMillis())));
        Collection<Integer> users = alert.getRecipientUsers();
        int countMail = this.notifyUsers(users, alert.getAlertSubject(), message.toString(), attachments);
        this.m_summary.append(alert.getName()).append(" (EMails+Notes=").append(countMail).append(") - ");
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int notifyUsers(Collection<Integer> users, String subject, String message, Collection<File> attachments) {
        int countMail = 0;
        for (int user_id : users) {
            MUser user = MUser.get(this.getCtx(), user_id);
            if (user.isNotificationEMail() && this.m_client.sendEMailAttachments(user_id, subject, message, attachments)) {
                ++countMail;
            }
            if (!user.isNotificationNote()) continue;
            Trx trx = null;
            try {
                trx = Trx.get(Trx.createTrxName("AP_NU"), true);
                int AD_Message_ID = 52244;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, user_id, trx.getTrxName());
                note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                note.setTextMsg(message);
                note.saveEx();
                MAttachment attachment = new MAttachment(this.getCtx(), MNote.Table_ID, note.getAD_Note_ID(), trx.getTrxName());
                for (File f : attachments) {
                    attachment.addEntry(f);
                }
                attachment.setTextMsg(message);
                attachment.saveEx();
                ++countMail;
                trx.commit();
            }
            catch (Throwable e) {
                if (trx == null) continue;
                trx.rollback();
            }
            finally {
                if (trx == null) continue;
                trx.close();
            }
        }
        return countMail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArrayList<Object>> getData(String sql, String trxName) throws Exception {
        ArrayList<ArrayList<Object>> data = new ArrayList<ArrayList<Object>>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception error = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            rs = pstmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            boolean isFirstRow = true;
            while (rs.next()) {
                ArrayList<String> header = isFirstRow ? new ArrayList<String>() : null;
                ArrayList<Object> row = new ArrayList<Object>();
                for (int col = 1; col <= meta.getColumnCount(); ++col) {
                    if (isFirstRow) {
                        String columnName = meta.getColumnLabel(col);
                        header.add(columnName);
                    }
                    Object o = rs.getObject(col);
                    row.add(o);
                }
                if (isFirstRow) {
                    data.add(header);
                }
                data.add(row);
                isFirstRow = false;
            }
        }
        catch (Throwable e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPlainTextReport(MAlertRule rule, String sql, String trxName, Collection<File> attachments) throws Exception {
        Exception error;
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuffer result;
        block7: {
            result = new StringBuffer();
            pstmt = null;
            rs = null;
            error = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                rs = pstmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                while (rs.next()) {
                    result.append("------------------").append(Env.NL);
                    for (int col = 1; col <= meta.getColumnCount(); ++col) {
                        result.append(meta.getColumnLabel(col)).append(" = ");
                        result.append(rs.getString(col));
                        result.append(Env.NL);
                    }
                }
                if (result.length() != 0) break block7;
                this.log.fine("No rows selected");
            }
            catch (Throwable e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return result.toString();
    }

    private String getExcelReport(MAlertRule rule, String sql, String trxName, Collection<File> attachments) throws Exception {
        ArrayList<ArrayList<Object>> data = this.getData(sql, trxName);
        if (data.size() <= 1) {
            return null;
        }
        File file = rule.createReportFile("xls");
        ArrayExcelExporter exporter = new ArrayExcelExporter(this.getCtx(), data);
        exporter.export(file, null, false);
        attachments.add(file);
        String msg = rule.getName() + " (@SeeAttachment@ " + file.getName() + ")" + Env.NL;
        return Msg.parseTranslation(Env.getCtx(), msg);
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MAlertProcessor model = new MAlertProcessor(Env.getCtx(), 100, null);
        AlertProcessor ap = new AlertProcessor(model);
        ap.start();
    }
}

