/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMailAuthenticator;

public class EMailProcessor {
    private String m_host = null;
    private String m_user = null;
    private String m_pass = null;
    private Session m_session = null;
    private Store m_store = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static final int ERROR = 0;
    private static final int REQUEST = 1;
    private static final int WORKFLOW = 2;
    private static final int DELIVERY = 9;

    public EMailProcessor(MClient client) {
        this(client.getSMTPHost(), client.getRequestUser(), client.getRequestUserPW());
    }

    public EMailProcessor(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.m_pass = password;
    }

    public int processMessages() {
        int processed = 0;
        try {
            this.getSession();
            this.getStore();
            processed = this.processInBox();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processInBox", e);
        }
        try {
            if (this.m_store.isConnected()) {
                this.m_store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_store = null;
        return processed;
    }

    private Session getSession() throws Exception {
        if (this.m_session != null) {
            return this.m_session;
        }
        Properties props = System.getProperties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", this.m_host);
        props.put("mail.smtp.auth", "true");
        EMailAuthenticator auth = new EMailAuthenticator(this.m_user, this.m_pass);
        this.m_session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        this.m_session.setDebug(CLogMgt.isLevelFinest());
        this.log.fine("getSession - " + this.m_session);
        return this.m_session;
    }

    private Store getStore() throws Exception {
        if (this.m_store != null) {
            return this.m_store;
        }
        if (this.getSession() == null) {
            throw new IllegalStateException("No Session");
        }
        this.m_store = this.m_session.getStore("imap");
        this.m_store.connect();
        this.log.fine("getStore - " + this.m_store);
        return this.m_store;
    }

    private int processInBox() throws Exception {
        Folder folder = this.m_store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default folder");
        }
        Folder inbox = folder.getFolder("INBOX");
        if (!inbox.exists()) {
            throw new IllegalStateException("No Inbox");
        }
        inbox.open(2);
        this.log.fine("processInBox - " + inbox.getName() + "; Messages Total=" + inbox.getMessageCount() + "; New=" + inbox.getNewMessageCount());
        Folder requestFolder = folder.getFolder("CRequest");
        if (!requestFolder.exists() && !requestFolder.create(1)) {
            throw new IllegalStateException("Cannot create Request Folder");
        }
        requestFolder.open(2);
        Folder workflowFolder = folder.getFolder("CWorkflow");
        if (!workflowFolder.exists() && !workflowFolder.create(1)) {
            throw new IllegalStateException("Cannot create Workflow Folder");
        }
        workflowFolder.open(2);
        Folder errorFolder = folder.getFolder("AdempiereError");
        if (!errorFolder.exists() && !errorFolder.create(1)) {
            throw new IllegalStateException("Cannot create Error Folder");
        }
        errorFolder.open(2);
        Message[] messages = inbox.getMessages();
        int noProcessed = 0;
        int noError = 0;
        for (int i = 0; i < messages.length; ++i) {
            Message msg = messages[i];
            int result = this.processMessage(msg);
            if (result == 1) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
                requestFolder.appendMessages(new Message[]{msg});
            } else if (result == 2) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
                workflowFolder.appendMessages(new Message[]{msg});
            } else if (result == 9) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
            } else {
                errorFolder.appendMessages(new Message[]{msg});
                ++noError;
            }
            ++noProcessed;
        }
        this.log.info("processInBox - Total=" + noProcessed + " - Errors=" + noError);
        errorFolder.close(false);
        requestFolder.close(false);
        workflowFolder.close(false);
        inbox.close(true);
        return noProcessed;
    }

    private int processMessage(Message msg) throws Exception {
        this.dumpEnvelope(msg);
        this.dumpBody((Part)msg);
        EMailProcessor.printOut(":::::::::::::::");
        EMailProcessor.printOut(this.getSubject(msg));
        EMailProcessor.printOut(":::::::::::::::");
        EMailProcessor.printOut(this.getMessage((Part)msg));
        EMailProcessor.printOut(":::::::::::::::");
        String delivery = this.getDeliveryReport((Part)msg);
        EMailProcessor.printOut(delivery);
        EMailProcessor.printOut(":::::::::::::::");
        return 0;
    }

    private String getSubject(Message msg) {
        try {
            String str = msg.getSubject();
            if (str != null) {
                return str.trim();
            }
        }
        catch (MessagingException e) {
            this.log.log(Level.SEVERE, "getSubject", e);
        }
        return "";
    }

    private String getMessage(Part msg) {
        StringBuffer sb = new StringBuffer();
        try {
            if (msg.isMimeType("text/plain")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("text/*")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("message/rfc822")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("multipart/alternative")) {
                String plainText = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content == null || content.toString().trim().length() == 0) continue;
                    if (part.isMimeType("text/plain")) {
                        plainText = content.toString();
                        continue;
                    }
                    otherStuff = content.toString();
                }
                if (plainText != null) {
                    sb.append(plainText);
                } else if (otherStuff != null) {
                    sb.append(otherStuff);
                }
            } else if (msg.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    String str = this.getMessage((Part)mp.getBodyPart(i));
                    if (str.length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append("\n-----\n");
                    }
                    sb.append(str);
                }
            } else {
                Object o = msg.getContent();
                if (o instanceof String) {
                    sb.append(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getMessage", e);
        }
        return sb.toString().trim();
    }

    private String getDeliveryReport(Part msg) {
        try {
            if (msg.isMimeType("multipart/report")) {
                String deliveryMessage = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content == null) continue;
                    if (part.isMimeType("message/*")) {
                        deliveryMessage = this.getDeliveredReportDetail((Part)part);
                        continue;
                    }
                    otherStuff = content.toString().trim();
                }
                if (deliveryMessage != null) {
                    return deliveryMessage;
                }
                return otherStuff;
            }
            if (msg.isMimeType("message/*")) {
                return this.getDeliveredReportDetail(msg);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getDeliveryReport", e);
        }
        return null;
    }

    private String getDeliveredReportDetail(Part part) throws Exception {
        String finalRecipient;
        int atIndex;
        Object content = part.getContent();
        if (content == null) {
            return null;
        }
        String deliveryMessage = null;
        if (content instanceof InputStream) {
            int c;
            StringBuffer sb = new StringBuffer();
            InputStream is = (InputStream)content;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            deliveryMessage = sb.toString().trim();
        } else {
            deliveryMessage = content.toString().trim();
        }
        if (deliveryMessage == null) {
            return null;
        }
        int index = deliveryMessage.indexOf("Final-Recipient:");
        if (index != -1 && (atIndex = (finalRecipient = deliveryMessage.substring(index)).indexOf(64)) != -1) {
            index = finalRecipient.lastIndexOf(32, atIndex);
            if (index != -1) {
                finalRecipient = finalRecipient.substring(index + 1);
            }
            if ((atIndex = finalRecipient.indexOf(64)) != -1) {
                index = finalRecipient.indexOf(32, atIndex);
            }
            if (index != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            if ((index = finalRecipient.indexOf(10)) != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            return finalRecipient.trim();
        }
        return deliveryMessage;
    }

    private void dumpEnvelope(Message m) throws Exception {
        int i;
        StringBuffer sb1;
        int j;
        EMailProcessor.printOut("-----------------------------------------------------------------");
        Address[] a = m.getFrom();
        if (a != null) {
            for (j = 0; j < a.length; ++j) {
                EMailProcessor.printOut("FROM: " + a[j].toString());
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a.length; ++j) {
                EMailProcessor.printOut("TO: " + a[j].toString());
            }
        }
        EMailProcessor.printOut("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        EMailProcessor.printOut("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i2 = 0; i2 < sf.length; ++i2) {
            String s;
            Flags.Flag f = sf[i2];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i3 = 0; i3 < uf.length; ++i3) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i3]);
        }
        EMailProcessor.printOut("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            sb1 = new StringBuffer("X-Mailer: ");
            for (i = 0; i < hdrs.length; ++i) {
                sb1.append(hdrs[i]).append("  ");
            }
            EMailProcessor.printOut(sb1.toString());
        } else {
            EMailProcessor.printOut("X-Mailer NOT available");
        }
        hdrs = m.getHeader("Message-ID");
        if (hdrs != null) {
            sb1 = new StringBuffer("Message-ID: ");
            for (i = 0; i < hdrs.length; ++i) {
                sb1.append(hdrs[i]).append("  ");
            }
            EMailProcessor.printOut(sb1.toString());
        } else {
            EMailProcessor.printOut("Message-ID NOT available");
        }
        EMailProcessor.printOut("ALL HEADERs:");
        Enumeration en = m.getAllHeaders();
        while (en.hasMoreElements()) {
            Header hdr = (Header)en.nextElement();
            EMailProcessor.printOut("  " + hdr.getName() + " = " + hdr.getValue());
        }
        EMailProcessor.printOut("-----------------------------------------------------------------");
    }

    private void dumpBody(Part p) throws Exception {
        EMailProcessor.printOut("=================================================================");
        EMailProcessor.printOut("CONTENT-TYPE: " + p.getContentType());
        if (p.isMimeType("text/plain")) {
            EMailProcessor.printOut("Plain text ---------------------------");
            System.out.println((String)p.getContent());
        } else if (p.getContentType().toUpperCase().startsWith("TEXT")) {
            EMailProcessor.printOut("Other text ---------------------------");
            System.out.println((String)p.getContent());
        } else if (p.isMimeType("multipart/*")) {
            EMailProcessor.printOut("Multipart ---------------------------");
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.dumpBody((Part)mp.getBodyPart(i));
            }
        } else if (p.isMimeType("message/rfc822")) {
            EMailProcessor.printOut("Nested ---------------------------");
            this.dumpBody((Part)p.getContent());
        } else {
            Object o = p.getContent();
            if (o instanceof String) {
                EMailProcessor.printOut("This is a string ---------------------------");
                System.out.println((String)o);
            } else if (o instanceof InputStream) {
                int c;
                EMailProcessor.printOut("This is just an input stream ---------------------------");
                InputStream is = (InputStream)o;
                while ((c = is.read()) != -1) {
                    System.out.write(c);
                }
            } else {
                EMailProcessor.printOut("This is an unknown type ---------------------------");
                EMailProcessor.printOut(o.toString());
            }
        }
        EMailProcessor.printOut("=================================================================");
    }

    private static void printOut(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        EMailProcessor m = new EMailProcessor("admin", "test", "testadempiere");
        m.processMessages();
    }
}

