/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import org.adempiere.server.rpl.IImportProcessor;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.model.X_IMP_Processor_Type;
import org.compiere.server.AdempiereServer;
import org.compiere.util.TimeUtil;

public class ReplicationProcessor
extends AdempiereServer {
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;
    private MIMPProcessor mImportProcessor = null;
    private boolean isProcessRunning = false;

    protected ReplicationProcessor(AdempiereProcessor model, int initialNap) {
        super(model, initialNap);
        this.mImportProcessor = (MIMPProcessor)model;
        this.m_client = MClient.get(this.mImportProcessor.getCtx(), this.mImportProcessor.getAD_Client_ID());
    }

    protected ReplicationProcessor(AdempiereProcessor model) {
        super(model, 30);
        this.mImportProcessor = (MIMPProcessor)model;
        this.m_client = MClient.get(this.mImportProcessor.getCtx(), this.mImportProcessor.getAD_Client_ID());
    }

    protected void doWork() {
        if (!this.isProcessRunning) {
            MIMPProcessorLog pLog;
            this.m_summary = new StringBuffer();
            String trxName = this.mImportProcessor.get_TrxName();
            if (trxName == null || "".equals(trxName)) {
                // empty if block
            }
            this.log.fine("trxName = " + trxName);
            this.log.fine("ImportProcessor = " + this.mImportProcessor);
            int IMP_ProcessorType_ID = 0;
            IMP_ProcessorType_ID = this.mImportProcessor.getIMP_Processor_Type_ID();
            X_IMP_Processor_Type impProcessor_Type = new X_IMP_Processor_Type(this.mImportProcessor.getCtx(), IMP_ProcessorType_ID, trxName);
            this.log.fine("impProcessor_Type = " + impProcessor_Type);
            String javaClass = impProcessor_Type.getJavaClass();
            IImportProcessor importProcessor = null;
            try {
                Class<?> clazz = Class.forName(javaClass);
                importProcessor = (IImportProcessor)clazz.newInstance();
                importProcessor.process(this.mImportProcessor.getCtx(), this, trxName);
            }
            catch (Exception e) {
                this.isProcessRunning = false;
                this.log.fine("ReplicationProcessor caught an exception !!!");
                e.printStackTrace();
                this.log.severe(e.getMessage());
                pLog = new MIMPProcessorLog(this.mImportProcessor, e.getMessage());
                pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
                pLog.saveEx();
                try {
                    importProcessor.stop();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MIMPProcessorLog pLog2 = new MIMPProcessorLog(this.mImportProcessor, e1.getMessage());
                    pLog2.saveEx();
                }
            }
            int no = this.mImportProcessor.deleteLog();
            this.m_summary.append("Logs Records deleted=").append(no).append("; ");
            pLog = new MIMPProcessorLog(this.mImportProcessor, this.m_summary.toString());
            pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
            pLog.saveEx();
        }
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public boolean isProcessRunning() {
        return this.isProcessRunning;
    }

    public void setProcessRunning(boolean isProcessRunning) {
        this.isProcessRunning = isProcessRunning;
    }

    public MIMPProcessor getMImportProcessor() {
        return this.mImportProcessor;
    }

    public void setMImportProcessor(MIMPProcessor importProcessor) {
        this.mImportProcessor = importProcessor;
    }
}

