/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.SchedulingPattern;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MUser;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.server.AdempiereServer;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class Scheduler
extends AdempiereServer {
    private MScheduler m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private Trx m_trx = null;
    private it.sauronsoftware.cron4j.Scheduler cronScheduler;
    private Predictor predictor;
    Properties m_schedulerctx = new Properties();

    public Scheduler(MScheduler model) {
        super(model, 240);
        this.m_model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        MOrgInfo schedorg;
        this.m_summary = new StringBuffer(this.m_model.toString()).append(" - ");
        this.m_schedulerctx.clear();
        MClient schedclient = MClient.get(this.getCtx(), this.m_model.getAD_Client_ID());
        Env.setContext(this.m_schedulerctx, "#AD_Client_ID", schedclient.getAD_Client_ID());
        Env.setContext(this.m_schedulerctx, "#AD_Language", schedclient.getAD_Language());
        Env.setContext(this.m_schedulerctx, "#AD_Org_ID", this.m_model.getAD_Org_ID());
        if (this.m_model.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get(this.getCtx(), this.m_model.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
            Env.setContext(this.m_schedulerctx, "#M_Warehouse_ID", schedorg.getM_Warehouse_ID());
        }
        Env.setContext(this.m_schedulerctx, "#AD_User_ID", this.getAD_User_ID());
        Env.setContext(this.m_schedulerctx, "#SalesRep_ID", this.getAD_User_ID());
        MUser scheduser = MUser.get(this.getCtx(), this.getAD_User_ID());
        MRole[] schedroles = scheduser.getRoles(this.m_model.getAD_Org_ID());
        if (schedroles != null && schedroles.length > 0) {
            Env.setContext(this.m_schedulerctx, "#AD_Role_ID", schedroles[0].getAD_Role_ID());
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext(this.m_schedulerctx, "#Date", dateFormat4Timestamp.format(ts) + " 00:00:00");
        Properties currentctx = Env.getCtx();
        Env.setCtx(this.m_schedulerctx);
        MProcess process = new MProcess(this.m_schedulerctx, this.m_model.getAD_Process_ID(), null);
        try {
            this.m_trx = Trx.get(Trx.createTrxName("Scheduler"), true);
            this.m_summary.append(this.runProcess(process));
            this.m_trx.commit(true);
        }
        catch (Exception e) {
            if (this.m_trx != null) {
                this.m_trx.rollback();
            }
            this.log.log(Level.WARNING, process.toString(), e);
            this.m_summary.append(e.toString());
        }
        finally {
            if (this.m_trx != null) {
                this.m_trx.close();
            }
        }
        Env.setCtx(currentctx);
        int no = this.m_model.deleteLog();
        this.m_summary.append(" Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    private String runProcess(MProcess process) throws Exception {
        ProcessInfo pi;
        block13: {
            MUser from;
            int Record_ID;
            int AD_Table_ID;
            boolean isReport;
            block12: {
                this.log.info(process.toString());
                isReport = process.isReport() || process.getAD_ReportView_ID() > 0;
                AD_Table_ID = this.m_model.getAD_Table_ID();
                Record_ID = this.m_model.getRecord_ID();
                MPInstance pInstance = new MPInstance(process, Record_ID);
                this.fillParameter(pInstance);
                pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
                pi.setAD_User_ID(this.getAD_User_ID());
                pi.setAD_Client_ID(this.m_model.getAD_Client_ID());
                pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
                from = new MUser(this.getCtx(), pi.getAD_User_ID(), null);
                if (process.processIt(pi, this.m_trx)) break block12;
                int supervisor = this.m_model.getSupervisor_ID();
                if (supervisor <= 0) break block13;
                MUser user = new MUser(this.getCtx(), supervisor, null);
                boolean email = user.isNotificationEMail();
                boolean notice = user.isNotificationNote();
                if (email || notice) {
                    ProcessInfoUtil.setLogFromDB(pi);
                }
                if (email) {
                    MClient client = MClient.get(this.m_model.getCtx(), this.m_model.getAD_Client_ID());
                    client.sendEMail(from, user, process.getName(), pi.getSummary() + " " + pi.getLogInfo(), null);
                }
                if (!notice) break block13;
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor, null);
                note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                note.setTextMsg(pi.getSummary());
                note.setRecord(MPInstance.Table_ID, pi.getAD_PInstance_ID());
                note.save();
                break block13;
            }
            Integer[] userIDs = this.m_model.getRecipientAD_User_IDs();
            if (userIDs.length > 0) {
                ProcessInfoUtil.setLogFromDB(pi);
                for (int i = 0; i < userIDs.length; ++i) {
                    MUser user = new MUser(this.getCtx(), userIDs[i], null);
                    boolean email = user.isNotificationEMail();
                    boolean notice = user.isNotificationNote();
                    File report = null;
                    if (isReport) {
                        ReportEngine re = ReportEngine.get(this.m_schedulerctx, pi);
                        if (re == null) {
                            return "Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName();
                        }
                        report = re.getPDF();
                    }
                    if (notice) {
                        int AD_Message_ID = 441;
                        if (isReport) {
                            AD_Message_ID = 884;
                        }
                        MNote note = new MNote(this.getCtx(), AD_Message_ID, (int)userIDs[i], null);
                        note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                        if (isReport) {
                            note.setTextMsg(this.m_model.getName());
                            note.setDescription(this.m_model.getDescription());
                            note.setRecord(AD_Table_ID, Record_ID);
                        } else {
                            note.setTextMsg(pi.getSummary());
                            note.setRecord(MPInstance.Table_ID, pi.getAD_PInstance_ID());
                        }
                        if (note.save() && isReport) {
                            MAttachment attachment = new MAttachment(this.getCtx(), MNote.Table_ID, note.getAD_Note_ID(), null);
                            attachment.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                            attachment.addEntry(report);
                            attachment.setTextMsg(this.m_model.getName());
                            attachment.save();
                        }
                    }
                    if (!email) continue;
                    MClient client = MClient.get(this.m_model.getCtx(), this.m_model.getAD_Client_ID());
                    if (isReport) {
                        client.sendEMail(from, user, this.m_model.getName(), this.m_model.getDescription(), report);
                        continue;
                    }
                    client.sendEMail(from, user, process.getName(), pi.getSummary() + " " + pi.getLogInfo(), null);
                }
            }
        }
        return pi.getSummary();
    }

    private int getAD_User_ID() {
        int AD_User_ID = this.m_model.getSupervisor_ID() > 0 ? this.m_model.getSupervisor_ID() : (this.m_model.getCreatedBy() > 0 ? this.m_model.getCreatedBy() : (this.m_model.getUpdatedBy() > 0 ? this.m_model.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    private void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = this.m_model.getParameters(false);
        MPInstancePara[] iParams = pInstance.getParameters();
        block2: for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            for (int np = 0; np < sParams.length; ++np) {
                MSchedulerPara sPara = sParams[np];
                if (!iPara.getParameterName().equals(sPara.getColumnName())) continue;
                String paraDesc = sPara.getDescription();
                if (paraDesc != null && paraDesc.trim().length() > 0) {
                    iPara.setInfo(sPara.getDescription());
                }
                String variable = sPara.getParameterDefault();
                this.log.fine(sPara.getColumnName() + " = " + variable);
                String value = variable;
                if (variable == null || variable != null && variable.length() == 0) {
                    value = null;
                } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
                    int index = variable.indexOf(64);
                    String columnName = variable.substring(index + 1);
                    if ((index = columnName.indexOf(64)) == -1) {
                        this.log.warning(sPara.getColumnName() + " - cannot evaluate=" + variable);
                        continue block2;
                    }
                    String env = Env.getContext(this.m_schedulerctx, columnName = columnName.substring(0, index));
                    if (env == null || env.length() == 0) {
                        env = Env.getContext(this.getCtx(), columnName);
                    }
                    if (env.length() == 0) {
                        this.log.warning(sPara.getColumnName() + " - not in environment =" + columnName + "(" + variable + ")");
                        continue block2;
                    }
                    value = env;
                }
                if (value == null) {
                    this.log.fine(sPara.getColumnName() + " - empty");
                    continue block2;
                }
                try {
                    if (DisplayType.isNumeric(sPara.getDisplayType()) || DisplayType.isID(sPara.getDisplayType())) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + bd + "=)");
                    } else if (DisplayType.isDate(sPara.getDisplayType())) {
                        Timestamp ts = null;
                        ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        iPara.setP_Date(ts);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + ts + "=)");
                    } else {
                        iPara.setP_String(value.toString());
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (iPara.save()) continue block2;
                    this.log.warning("Not Saved - " + sPara.getColumnName());
                }
                catch (Exception e) {
                    this.log.warning(sPara.getColumnName() + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
                continue block2;
            }
        }
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public void run() {
        String cronPattern = this.m_model.getCronPattern();
        if (cronPattern != null && cronPattern.trim().length() > 0 && SchedulingPattern.validate((String)cronPattern)) {
            this.cronScheduler = new it.sauronsoftware.cron4j.Scheduler();
            this.cronScheduler.schedule(cronPattern, new Runnable(){

                public void run() {
                    Scheduler.this.runNow();
                    long next = Scheduler.this.predictor.nextMatchingTime();
                    Scheduler.this.p_model.setDateNextRun(new Timestamp(next));
                    Scheduler.this.p_model.save();
                }
            });
            this.predictor = new Predictor(cronPattern);
            long next = this.predictor.nextMatchingTime();
            this.p_model.setDateNextRun(new Timestamp(next));
            this.p_model.save();
            this.cronScheduler.start();
            do {
                if (this.sleep()) continue;
                this.cronScheduler.stop();
                break;
            } while (this.cronScheduler.isStarted());
        } else {
            super.run();
        }
    }
}

