/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.session;

import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.annotation.security.PermitAll;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.interfaces.StatusLocal;
import org.compiere.interfaces.StatusRemote;
import org.compiere.util.CLogger;

@Stateless(mappedName="adempiere/Status", name="adempiereStatus")
@Local(value={StatusLocal.class})
@Remote(value={StatusRemote.class})
@PermitAll
public class StatusBean
implements StatusRemote,
StatusLocal {
    private static final String ALLOW_CLIENT_QUERY_DB_PWD = "adempiere.client.getDBPwd";
    private static CLogger log = CLogger.getCLogger(StatusBean.class);
    private static int s_no = 0;
    private int m_no = 0;
    private int m_versionCount = 0;
    private int m_databaseCount = 0;

    public String getDateVersion() {
        ++this.m_versionCount;
        log.info("getDateVersion " + this.m_versionCount);
        return Adempiere.DATE_VERSION;
    }

    public String getMainVersion() {
        return Adempiere.MAIN_VERSION;
    }

    public String getDbType() {
        return CConnection.get().getType();
    }

    public String getDbHost() {
        ++this.m_databaseCount;
        log.info("getDbHost " + this.m_databaseCount);
        return CConnection.get().getDbHost();
    }

    public int getDbPort() {
        return CConnection.get().getDbPort();
    }

    public String getDbName() {
        return CConnection.get().getDbName();
    }

    public String getConnectionURL() {
        return CConnection.get().getConnectionURL();
    }

    public String getDbUid() {
        return CConnection.get().getDbUid();
    }

    public String getDbPwd() {
        String f = System.getProperty(ALLOW_CLIENT_QUERY_DB_PWD);
        if ("false".equalsIgnoreCase(f)) {
            return "";
        }
        return CConnection.get().getDbPwd();
    }

    public String getFwHost() {
        return CConnection.get().getFwHost();
    }

    public int getFwPort() {
        return CConnection.get().getFwPort();
    }

    public int getVersionCount() {
        return this.m_versionCount;
    }

    public int getDatabaseCount() {
        return this.m_databaseCount;
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer("StatusBean[No=");
        sb.append(this.m_no).append(",VersionCount=").append(this.m_versionCount).append(",DatabaseCount=").append(this.m_versionCount).append("]");
        return sb.toString();
    }

    public String toString() {
        return this.getStatus();
    }

    @PostConstruct
    public void ejbCreate() {
        this.m_no = ++s_no;
        try {
            if (!Adempiere.startup(false)) {
                throw new CreateException("Compiere could not start");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        log.info("#" + this.m_no + " - " + this.getStatus());
    }
}

