/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.model.MSystem;
import org.compiere.server.AdempiereServer;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CMemoryUsage;
import org.compiere.util.CacheMgt;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;

public class AdempiereMonitor
extends HttpServlet {
    private static final long serialVersionUID = -1821229399092760008L;
    private static CLogger log = CLogger.getCLogger(AdempiereMonitor.class);
    private AdempiereServerMgr m_serverMgr = null;
    private p m_message = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.m_message = null;
        if (this.processLogParameter(request, response)) {
            return;
        }
        if (this.processTraceParameter(request, response)) {
            return;
        }
        if (this.processEMailParameter(request, response)) {
            return;
        }
        if (this.processCacheParameter(request, response)) {
            return;
        }
        if (!this.processRunNowParameter(request)) {
            this.processActionParameter(request);
        }
        this.createSummaryPage(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private boolean processLogParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String serverID = WebUtil.getParameter(request, "Log");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        log.info("ServerID=" + serverID);
        AdempiereServer server = this.m_serverMgr.getServer(serverID);
        if (server == null) {
            this.m_message = new p();
            this.m_message.addElement((Element)new strong("Server not found: "));
            this.m_message.addElement(serverID);
            return false;
        }
        WebDoc doc = WebDoc.create("Adempiere Server Monitor Log");
        body b = doc.getBody();
        p para = new p();
        a link = new a("adempiereMonitor#" + serverID, "Return");
        para.addElement((Element)link);
        b.addElement((Element)para);
        b.addElement((Element)new h2(server.getName()));
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement("Created"));
        line.addElement((Element)new th().addElement("Summary"));
        line.addElement((Element)new th().addElement("Reference"));
        line.addElement((Element)new th().addElement("TextMsg"));
        table2.addElement((Element)line);
        AdempiereProcessorLog[] logs = server.getLogs();
        for (int i = 0; i < logs.length; ++i) {
            AdempiereProcessorLog pLog = logs[i];
            line = new tr();
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(pLog.getCreated())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(pLog.getSummary())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(pLog.getReference())));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(pLog.getTextMsg())));
            table2.addElement((Element)line);
        }
        b.addElement((Element)table2);
        link = new a("#top", "Top");
        b.addElement((Element)link);
        WebUtil.createResponse(request, response, this, null, doc, false);
        return true;
    }

    private boolean processRunNowParameter(HttpServletRequest request) throws ServletException, IOException {
        String serverID = WebUtil.getParameter(request, "RunNow");
        if (serverID == null || serverID.length() == 0) {
            return false;
        }
        log.info("ServerID=" + serverID);
        AdempiereServer server = this.m_serverMgr.getServer(serverID);
        if (server == null) {
            this.m_message = new p();
            this.m_message.addElement((Element)new strong("Server not found: "));
            this.m_message.addElement(serverID);
            return false;
        }
        server.runNow();
        return true;
    }

    private void processActionParameter(HttpServletRequest request) {
        String action = WebUtil.getParameter(request, "Action");
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("Action=" + action);
        try {
            boolean start = action.startsWith("Start");
            this.m_message = new p();
            String msg = (start ? "Started" : "Stopped") + ": ";
            this.m_message.addElement((Element)new strong(msg));
            String serverID = action.substring(action.indexOf(95) + 1);
            boolean ok = false;
            if (serverID.equals("All")) {
                ok = start ? this.m_serverMgr.startAll() : this.m_serverMgr.stopAll();
                this.m_message.addElement("All");
            } else {
                AdempiereServer server = this.m_serverMgr.getServer(serverID);
                if (server == null) {
                    this.m_message = new p();
                    this.m_message.addElement((Element)new strong("Server not found: "));
                    this.m_message.addElement(serverID);
                    return;
                }
                ok = start ? this.m_serverMgr.start(serverID) : this.m_serverMgr.stop(serverID);
                this.m_message.addElement(server.getName());
            }
            this.m_message.addElement(ok ? " - OK" : " - Error!");
        }
        catch (Exception e) {
            this.m_message = new p();
            this.m_message.addElement((Element)new strong("Error processing parameter: " + action));
            this.m_message.addElement((Element)new br());
            this.m_message.addElement(e.toString());
        }
    }

    private boolean processTraceParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        String traceCmd = WebUtil.getParameter(request, "Trace");
        String traceLevel = WebUtil.getParameter(request, "TraceLevel");
        if (traceLevel != null && traceLevel.length() > 0) {
            log.info("New Level: " + traceLevel);
            CLogMgt.setLevel(traceLevel);
            Ini.setProperty("TraceLevel", traceLevel);
            Ini.saveProperties(false);
            return false;
        }
        if (traceCmd == null || traceCmd.length() == 0) {
            return false;
        }
        log.info("Command: " + traceCmd);
        CLogFile fileHandler = CLogFile.get(false, null, false);
        if (traceCmd.equals("ROTATE")) {
            if (fileHandler != null) {
                fileHandler.rotateLog();
            }
            return false;
        }
        if (traceCmd.equals("DELETE")) {
            File logDir = fileHandler.getLogDirectory();
            if (logDir != null && logDir.isDirectory()) {
                File[] logs = logDir.listFiles();
                for (int i = 0; i < logs.length; ++i) {
                    String fileName = logs[i].getAbsolutePath();
                    if (fileName.equals(fileHandler.getFileName())) continue;
                    if (logs[i].delete()) {
                        log.warning("Deleted: " + fileName);
                        continue;
                    }
                    log.warning("Not Deleted: " + fileName);
                }
            }
            return false;
        }
        if (fileHandler != null && fileHandler.getFileName().equals(traceCmd)) {
            fileHandler.flush();
        }
        if (!(file = new File(traceCmd)).exists()) {
            log.warning("Did not find File: " + traceCmd);
            return false;
        }
        if (file.length() == 0L) {
            log.warning("File Length=0: " + traceCmd);
            return false;
        }
        log.info("Streaming: " + traceCmd);
        try {
            long time = System.currentTimeMillis();
            int fileLength = (int)file.length();
            int bufferSize = 2048;
            byte[] buffer = new byte[bufferSize];
            response.setContentType("text/plain");
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            FileInputStream fis = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            int read = 0;
            while ((read = fis.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            fis.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            log.info("length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec");
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "stream" + ex);
        }
        return true;
    }

    private boolean processEMailParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String email = WebUtil.getParameter(request, "EMail");
        if (email == null || email.length() == 0) {
            return false;
        }
        int AD_Client_ID = -1;
        try {
            AD_Client_ID = Integer.parseInt(email);
        }
        catch (Exception e) {
            log.warning("Parsing: " + email + " - " + e.toString());
        }
        if (AD_Client_ID < 0) {
            this.m_message = new p();
            this.m_message.addElement("No EMail: " + email);
            return false;
        }
        MClient client = MClient.get(new Properties(), AD_Client_ID);
        log.info("Test: " + client);
        this.m_message = new p();
        this.m_message.addElement(client.getName() + ": " + client.testEMail());
        return false;
    }

    private boolean processCacheParameter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = WebUtil.getParameter(request, "CacheReset");
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        String tableName = WebUtil.getParameter(request, "CacheTableName");
        String record_ID = WebUtil.getParameter(request, "CacheRecord_ID");
        this.m_message = new p();
        try {
            if (tableName == null || tableName.length() == 0) {
                CacheMgt.get().reset();
                this.m_message.addElement("Cache Reset: All");
            } else if (record_ID == null || record_ID.length() == 0) {
                CacheMgt.get().reset(tableName);
                this.m_message.addElement("Cache Reset: " + tableName);
            } else {
                CacheMgt.get().reset(tableName, Integer.parseInt(record_ID));
                this.m_message.addElement("Cache Reset: " + tableName + ", Record_ID=" + record_ID);
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            this.m_message.addElement("Error: " + e.toString());
        }
        return false;
    }

    private void createSummaryPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AdempiereServer server;
        int i;
        WebDoc doc = WebDoc.create("Adempiere Server Monitor");
        body bb = doc.getBody();
        if (this.m_message != null) {
            bb.addElement((Element)new hr());
            bb.addElement((Element)this.m_message);
            bb.addElement((Element)new hr());
        }
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        tr line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getName()));
        line.addElement((Element)new td().addElement(Adempiere.getVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement(Adempiere.getImplementationVendor()));
        line.addElement((Element)new td().addElement(Adempiere.getImplementationVersion()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Manager"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent(this.m_serverMgr.getDescription())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Start - Elapsed"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent(this.m_serverMgr.getStartTime()) + " - " + TimeUtil.formatElapsed(this.m_serverMgr.getStartTime())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Servers"));
        line.addElement((Element)new td().addElement(WebEnv.getCellContent(this.m_serverMgr.getServerCount())));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Last Updated"));
        line.addElement((Element)new td().addElement(new Timestamp(System.currentTimeMillis()).toString()));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p para = new p();
        a link = new a("adempiereMonitor?Action=Start_All", "Start All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("adempiereMonitor?Action=Stop_All", "Stop All");
        para.addElement((Element)link);
        para.addElement(" - ");
        link = new a("adempiereMonitor", "Refresh");
        para.addElement((Element)link);
        bb.addElement((Element)para);
        bb.addElement((Element)new hr());
        para = new p();
        AdempiereServer[] servers = this.m_serverMgr.getAll();
        for (i = 0; i < servers.length; ++i) {
            if (i > 0) {
                para.addElement((Element)new br());
            }
            server = servers[i];
            link = new a("#" + server.getServerID(), server.getName());
            para.addElement((Element)link);
            font status = null;
            status = server.isAlive() ? new font().setColor("#008000").addElement(" (Running)") : new font().setColor("#FF0000").addElement(" (Stopped)");
            para.addElement((Element)status);
        }
        bb.addElement((Element)para);
        this.createLogMgtPage(bb);
        for (i = 0; i < servers.length; ++i) {
            String msg;
            server = servers[i];
            bb.addElement((Element)new hr());
            bb.addElement((Element)new a().setName(server.getServerID()));
            bb.addElement((Element)new h2(server.getName()));
            table2 = new table();
            table2.setBorder(1);
            table2.setCellSpacing(2);
            table2.setCellPadding(2);
            line = new tr();
            if (server.isAlive()) {
                msg = "Stop";
                if (server.isInterrupted()) {
                    msg = msg + " (Interrupted)";
                }
                link = new a("adempiereMonitor?Action=Stop_" + server.getServerID(), msg);
                if (server.isSleeping()) {
                    line.addElement((Element)new th().addElement("Sleeping"));
                    line.addElement((Element)new td().addElement((Element)link));
                } else {
                    line.addElement((Element)new th().addElement("Running"));
                    line.addElement((Element)new td().addElement((Element)link));
                }
                table2.addElement((Element)line);
                line = new tr();
                line.addElement((Element)new th().addElement("Start - Elapsed"));
                line.addElement((Element)new td().addElement(WebEnv.getCellContent(server.getStartTime()) + " - " + TimeUtil.formatElapsed(server.getStartTime())));
            } else {
                msg = "Start";
                if (server.isInterrupted()) {
                    msg = msg + " (Interrupted)";
                }
                line.addElement((Element)new th().addElement("Not Started"));
                link = new a("adempiereMonitor?Action=Start_" + server.getServerID(), msg);
                line.addElement((Element)new td().addElement((Element)link));
            }
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Description"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(server.getDescription())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Last Run"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(server.getDateLastRun())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Info"));
            line.addElement((Element)new td().addElement(WebEnv.getCellContent(server.getServerInfo())));
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Next Run"));
            td td2 = new td();
            td2.addElement(WebEnv.getCellContent(server.getDateNextRun(false)));
            td2.addElement(" - ");
            link = new a("adempiereMonitor?RunNow=" + server.getServerID(), "(Run Now)");
            td2.addElement((Element)link);
            line.addElement((Element)td2);
            table2.addElement((Element)line);
            line = new tr();
            line.addElement((Element)new th().addElement("Statistics"));
            line.addElement((Element)new td().addElement(server.getStatistics()));
            table2.addElement((Element)line);
            bb.addElement((Element)table2);
            link = new a("#top", "Top");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("adempiereMonitor?Log=" + server.getServerID(), "Log");
            bb.addElement((Element)link);
            bb.addElement(" - ");
            link = new a("adempiereMonitor", "Refresh");
            bb.addElement((Element)link);
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private void createLogMgtPage(body bb) {
        int i;
        Trx[] trxs;
        bb.addElement((Element)new hr());
        table table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        Properties ctx = new Properties();
        MSystem system = MSystem.get(ctx);
        tr line = new tr();
        line.addElement((Element)new th().addElement(system.getDBAddress()));
        line.addElement((Element)new td().addElement(Ini.getAdempiereHome()));
        table2.addElement((Element)line);
        line = new tr();
        String info = System.getProperty("os.name") + " " + System.getProperty("os.version");
        String s = System.getProperty("sun.os.patch.level");
        if (s != null && s.length() > 0) {
            info = info + " (" + s + ")";
        }
        line.addElement((Element)new th().addElement(info));
        info = system.getName();
        if (system.getCustomPrefix() != null) {
            info = info + " (" + system.getCustomPrefix() + ")";
        }
        line.addElement((Element)new td().addElement(info));
        table2.addElement((Element)line);
        line = new tr();
        info = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        line.addElement((Element)new th().addElement(info));
        line.addElement((Element)new td().addElement(system.getUserName()));
        table2.addElement((Element)line);
        line = new tr();
        CConnection cc = CConnection.get();
        AdempiereDatabase db = cc.getDatabase();
        info = db.getDescription();
        line.addElement((Element)new th().addElement(info));
        line.addElement((Element)new td().addElement(cc.getConnectionURL()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Processor/Support"));
        line.addElement((Element)new td().addElement(system.getNoProcessors() + "/" + system.getSupportUnits()));
        table2.addElement((Element)line);
        line = new tr();
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        line.addElement((Element)new th().addElement("VM Memory"));
        line.addElement((Element)new td().addElement(new CMemoryUsage(memory.getNonHeapMemoryUsage()).toString()));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement("Heap Memory"));
        line.addElement((Element)new td().addElement(new CMemoryUsage(memory.getHeapMemoryUsage()).toString()));
        table2.addElement((Element)line);
        line = new tr();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        line.addElement((Element)new th().addElement("Runtime " + rt.getName()));
        line.addElement((Element)new td().addElement(TimeUtil.formatElapsed(rt.getUptime())));
        table2.addElement((Element)line);
        line = new tr();
        ThreadMXBean th2 = ManagementFactory.getThreadMXBean();
        line.addElement((Element)new th().addElement("Threads " + th2.getThreadCount()));
        line.addElement((Element)new td().addElement("Peak=" + th2.getPeakThreadCount() + ", Demons=" + th2.getDaemonThreadCount() + ", Total=" + th2.getTotalStartedThreadCount()));
        table2.addElement((Element)line);
        for (Trx trx : trxs = Trx.getActiveTransactions()) {
            if (trx == null || !trx.isActive()) continue;
            line = new tr();
            line.addElement((Element)new th().addElement("Active Transaction "));
            line.addElement((Element)new td().addElement("Name=" + trx.getTrxName() + ", StartTime=" + trx.getStartTime()));
            table2.addElement((Element)line);
        }
        line = new tr();
        line.addElement((Element)new th().addElement(CacheMgt.get().toStringX()));
        line.addElement((Element)new td().addElement((Element)new a("adempiereMonitor?CacheReset=Yes", "Reset Cache")));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new th().addElement((Element)new label("TraceLevel").addElement("Trace Log Level")));
        form myForm = new form("adempiereMonitor", "post", "application/x-www-form-urlencoded");
        option[] options = new option[CLogMgt.LEVELS.length];
        for (int i2 = 0; i2 < options.length; ++i2) {
            options[i2] = new option(CLogMgt.LEVELS[i2].getName());
            options[i2].addElement(CLogMgt.LEVELS[i2].getName());
            if (CLogMgt.LEVELS[i2] != CLogMgt.getLevel()) continue;
            options[i2].setSelected(true);
        }
        select sel = new select("TraceLevel", options);
        myForm.addElement((Element)sel);
        myForm.addElement((Element)new input("submit", "Set", "Set"));
        line.addElement((Element)new td().addElement((Element)myForm));
        table2.addElement((Element)line);
        line = new tr();
        CLogFile fileHandler = CLogFile.get(true, null, false);
        line.addElement((Element)new th().addElement("Trace File"));
        line.addElement((Element)new td().addElement((Element)new a("adempiereMonitor?Trace=" + fileHandler.getFileName(), "Current")));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)new a("adempiereMonitor?Trace=ROTATE", "Rotate Trace Log")));
        line.addElement((Element)new td().addElement((Element)new a("adempiereMonitor?Trace=DELETE", "Delete all Trace Logs")));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
        p p2 = new p();
        p2.addElement((Element)new b("All Log Files: "));
        File logDir = fileHandler.getLogDirectory();
        if (logDir != null && logDir.isDirectory()) {
            File[] logs = logDir.listFiles();
            for (i = 0; i < logs.length; ++i) {
                if (!logs[i].isFile()) continue;
                if (i != 0) {
                    p2.addElement(" - ");
                }
                String fileName = logs[i].getAbsolutePath();
                a link = new a("adempiereMonitor?Trace=" + fileName, fileName);
                p2.addElement((Element)link);
                int size = (int)(logs[i].length() / 1024L);
                if (size < 1024) {
                    p2.addElement(" (" + size + "k)");
                    continue;
                }
                p2.addElement(" (" + size / 1024 + "M)");
            }
        }
        bb.addElement((Element)p2);
        table2 = new table();
        table2.setBorder(1);
        table2.setCellSpacing(2);
        table2.setCellPadding(2);
        line = new tr();
        MClient[] clients = MClient.getAll(ctx);
        line.addElement((Element)new th().addElement("Client #" + clients.length + " - EMail Test:"));
        p2 = new p();
        for (i = 0; i < clients.length; ++i) {
            MClient client = clients[i];
            if (i > 0) {
                p2.addElement(" - ");
            }
            p2.addElement((Element)new a("adempiereMonitor?EMail=" + client.getAD_Client_ID(), client.getName()));
        }
        if (clients.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        line = new tr();
        MStore[] wstores = MStore.getActive();
        line.addElement((Element)new th().addElement("Active Web Stores #" + wstores.length));
        p2 = new p();
        for (int i3 = 0; i3 < wstores.length; ++i3) {
            MStore store = wstores[i3];
            if (i3 > 0) {
                p2.addElement(" - ");
            }
            a a2 = new a(store.getWebContext(), store.getName());
            a2.setTarget("t" + i3);
            p2.addElement((Element)a2);
        }
        if (wstores.length == 0) {
            p2.addElement("&nbsp;");
        }
        line.addElement((Element)new td().addElement((Element)p2));
        table2.addElement((Element)line);
        bb.addElement((Element)table2);
    }

    public void init(ServletConfig config) throws ServletException {
        WebEnv.initWeb(config);
        log.info("");
        this.m_serverMgr = AdempiereServerMgr.get();
    }

    public void destroy() {
        log.info("destroy");
        this.m_serverMgr = null;
    }

    public void log(String message, Throwable e) {
        if (e == null) {
            log.warning(message);
        }
        log.log(Level.SEVERE, message, e);
    }

    public void log(String message) {
        log.fine(message);
    }

    public String getServletName() {
        return "AdempiereMonitor";
    }

    public String getServletInfo() {
        return "Adempiere Server Monitor";
    }
}

