/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.Invariant;
import org.jboss.aspects.dbc.StaticInvariant;
import org.jboss.aspects.dbc.condition.InvariantCondition;

public class ConditionManager {
    public static HashMap preConditions = new HashMap();
    public static HashMap postConditions = new HashMap();
    public static HashMap invariants = new HashMap();

    public static synchronized InvariantCondition[] getInvariants(Class clazz) {
        InvariantCondition[] inv = (InvariantCondition[])invariants.get(clazz);
        if (inv != null) {
            return inv;
        }
        ConditionManager.initialise(clazz);
        return (InvariantCondition[])invariants.get(clazz);
    }

    protected static void initialise(Class clazz) {
        ArrayList invConds = new ArrayList();
        if (invariants.get(clazz) != null && DesignByContractAspect.verbose) {
            System.out.println("[dbc] Already have invariants for class: " + clazz);
        }
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] ===== Initialising invariants for class: " + clazz);
        }
        for (Class curClazz = clazz; curClazz != null; curClazz = curClazz.getSuperclass()) {
            ConditionManager.addInvariantConditions(invConds, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ConditionManager.addInvariantConditions(invConds, interfaces[i]);
            }
        }
        InvariantCondition[] inv = invConds.toArray(new InvariantCondition[invConds.size()]);
        invariants.put(clazz, inv);
    }

    private static void addInvariantConditions(ArrayList conditions, Class clazz) {
        StaticInvariant statinv;
        Invariant inv = (Invariant)AnnotationElement.getAnyAnnotation((Class)clazz, (Class)Invariant.class);
        if (inv != null) {
            String[] exprs;
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found non-static invariants in class: " + clazz);
            }
            if ((exprs = inv.value()) != null) {
                for (int i = 0; i < exprs.length; ++i) {
                    conditions.add(new InvariantCondition(clazz, exprs[i], false));
                }
            }
        }
        if ((statinv = (StaticInvariant)AnnotationElement.getAnyAnnotation((Class)clazz, (Class)StaticInvariant.class)) != null) {
            String[] exprs;
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found static invariants in class: " + clazz);
            }
            if ((exprs = statinv.value()) != null) {
                for (int i = 0; i < exprs.length; ++i) {
                    conditions.add(new InvariantCondition(clazz, exprs[i], true));
                }
            }
        }
    }
}

