/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.logging;

import java.util.Arrays;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.logging.LoggingConstants;
import org.jboss.logging.Logger;

public final class CallLoggingInterceptor
implements Interceptor,
LoggingConstants {
    protected Logger log = Logger.getLogger(this.getClass());

    public String getName() {
        return "CallLoggingInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        boolean callLogging = this.log.isDebugEnabled();
        if (callLogging) {
            callLogging = Boolean.valueOf((String)invocation.getMetaData((Object)"logging", (Object)"call-logging"));
        }
        if (callLogging) {
            this.log.debug((Object)("Invoking: " + this.dumpInvocation(invocation)));
        }
        Object response = null;
        try {
            Object object = response = invocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            if (callLogging) {
                this.log.debug((Object)("Throwing: " + this.dumpInvocation(invocation)), t);
            }
            throw t;
        }
        finally {
            if (callLogging) {
                this.log.debug((Object)("Response: " + this.dumpInvocationResponse(response) + " for " + this.dumpInvocation(invocation)));
            }
        }
    }

    public String dumpInvocation(Invocation invocation) {
        StringBuffer buffer = new StringBuffer();
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            buffer.append("Method@").append(System.identityHashCode(invocation)).append("{");
            buffer.append("method=").append(methodInvocation.getMethod());
        } else if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            buffer.append("FieldRead@").append(System.identityHashCode(invocation)).append("{");
            buffer.append("field=").append(fieldInvocation.getField());
        } else if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
            buffer.append("FieldWrite@").append(System.identityHashCode(invocation)).append("{");
            buffer.append("field=").append(fieldInvocation.getField());
            buffer.append(" value=").append(fieldInvocation.getValue());
        } else if (invocation instanceof ConstructorInvocation) {
            ConstructorInvocation cInvocation = (ConstructorInvocation)invocation;
            buffer.append("Construct@").append(System.identityHashCode(invocation)).append("{");
            buffer.append("constructor=").append(cInvocation.getConstructor());
            buffer.append(" args=").append(Arrays.asList(cInvocation.getArguments()));
        } else {
            return "Unknown " + invocation;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String dumpInvocationResponse(Object response) {
        if (response == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(response);
        return buffer.toString();
    }
}

