/*
 *  ADP (Another Data Processor)
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */
#include "adp.h"
#include "adp_builtin.h"
#include "adp_builtin_db.h"
#include "adp_builtin_string.h"
#include "adp_builtin_file.h"
#include "adp_builtin_list.h"
#include "adp_builtin_net.h"
#include "adp_builtin_graphic.h"
#include "adp_builtin_debug.h"

// create functions 
ExecContextRoot *newExecContext_Err_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Err( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Err( newExecContext_Err_Function);
ExecContextRoot *newExecContext_ErrN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_ErrN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_ErrN( newExecContext_ErrN_Function);

ExecContextRoot *newExecContext_Print_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Print( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Print( newExecContext_Print_Function);
ExecContextRoot *newExecContext_PrintN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_PrintN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_PrintN( newExecContext_PrintN_Function);
ExecContextRoot *newExecContext_Prt_htmlescape_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Prt_htmlescape( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Prt_htmlescape( newExecContext_Prt_htmlescape_Function);
ExecContextRoot *newExecContext_Prt_awpescape_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Prt_awpescape( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Prt_awpescape( newExecContext_Prt_awpescape_Function);
ExecContextRoot *newExecContext_Prt_urlencode_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Prt_urlencode( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Prt_urlencode( newExecContext_Prt_urlencode_Function);
ExecContextRoot *newExecContext_Ppout_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Ppout( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Ppout( newExecContext_Ppout_Function);
ExecContextRoot *newExecContext_Ppout_htmlescape_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Ppout_htmlescape( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Ppout_htmlescape( newExecContext_Ppout_htmlescape_Function);
ExecContextRoot *newExecContext_Ppout_awpescape_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Ppout_awpescape( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Ppout_awpescape( newExecContext_Ppout_awpescape_Function);
ExecContextRoot *newExecContext_Ppout_urlencode_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Ppout_urlencode( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Ppout_urlencode( newExecContext_Ppout_urlencode_Function);
ExecContextRoot *newExecContext_Add_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Add( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Add( newExecContext_Add_Function);
ExecContextRoot *newExecContext_Sub_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Sub( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Sub( newExecContext_Sub_Function);
ExecContextRoot *newExecContext_Neg_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Neg( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Neg( newExecContext_Neg_Function);
ExecContextRoot *newExecContext_Mul_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Mul( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Mul( newExecContext_Mul_Function);
ExecContextRoot *newExecContext_Div_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Div( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Div( newExecContext_Div_Function);
ExecContextRoot *newExecContext_Mod_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Mod( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Mod( newExecContext_Mod_Function);
ExecContextRoot *newExecContext_Equ_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Equ( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Equ( newExecContext_Equ_Function);
ExecContextRoot *newExecContext_Neq_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Neq( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Neq( newExecContext_Neq_Function);
ExecContextRoot *newExecContext_CMP_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CMP( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CMP( newExecContext_CMP_Function);
ExecContextRoot *newExecContext_LT_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LT( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LT( newExecContext_LT_Function);
ExecContextRoot *newExecContext_LE_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LE( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LE( newExecContext_LE_Function);
ExecContextRoot *newExecContext_GT_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_GT( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_GT( newExecContext_GT_Function);
ExecContextRoot *newExecContext_GE_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_GE( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_GE( newExecContext_GE_Function);

ExecContextRoot *newExecContext_And_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_And( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_And( newExecContext_And_Function);
ExecContextRoot *newExecContext_Xor_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Xor( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Xor( newExecContext_Xor_Function);
ExecContextRoot *newExecContext_Or_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Or( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Or( newExecContext_Or_Function);
ExecContextRoot *newExecContext_Not_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Not( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Not( newExecContext_Xor_Function);

ExecContextRoot *newExecContext_Let_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Let( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Let( newExecContext_Let_Function);

ExecContextRoot *newExecContext_LetAdd_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetAdd( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetAdd( newExecContext_LetAdd_Function);
ExecContextRoot *newExecContext_LetSub_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetSub( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetSub( newExecContext_LetSub_Function);
ExecContextRoot *newExecContext_LetMul_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetMul( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetMul( newExecContext_LetMul_Function);
ExecContextRoot *newExecContext_LetDiv_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetDiv( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetDiv( newExecContext_LetDiv_Function);
ExecContextRoot *newExecContext_LetMod_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetMod( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetMod( newExecContext_LetMod_Function);
ExecContextRoot *newExecContext_LetAnd_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetAnd( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetAnd( newExecContext_LetAnd_Function);
ExecContextRoot *newExecContext_LetOr_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetOr( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetOr( newExecContext_LetOr_Function);
ExecContextRoot *newExecContext_LetXor_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LetXor( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LetXor( newExecContext_LetXor_Function);

ExecContextRoot *newExecContext_Now_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Now( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Now( newExecContext_Now_Function);
ExecContextRoot *newExecContext_Spawnp_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Spawnp( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Spawnp( newExecContext_Spawnp_Function);
ExecContextRoot *newExecContext_Env_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Env( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Env( newExecContext_Env_Function);
ExecContextRoot *newExecContext_Arg_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Arg( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Arg( newExecContext_Arg_Function);
ExecContextRoot *newExecContext_CStr_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CStr( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CStr( newExecContext_CStr_Function);
ExecContextRoot *newExecContext_Cdbl_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Cdbl( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Cdbl( newExecContext_Cdbl_Function);
ExecContextRoot *newExecContext_Cint_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Cint( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Cint( newExecContext_Cint_Function);
ExecContextRoot *newExecContext_GetHash_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_GetHash( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_GetHash( newExecContext_GetHash_Function);
ExecContextRoot *newExecContext_Counter_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Counter( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Counter( newExecContext_Counter_Function);
ExecContextRoot *newExecContext_Times_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Times( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Times( newExecContext_Times_Function);
ExecContextRoot *newExecContext_Cut_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Cut( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Cut( newExecContext_Cut_Function);

ExecContextRoot *newExecContext_Fail_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Fail( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Fail( newExecContext_Fail_Function);

ExecContextRoot *newExecContext_Raise_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Raise( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Raise( newExecContext_Raise_Function);

ExecContextRoot *newExecContext_Next_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Next( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Next( newExecContext_Next_Function);
ExecContextRoot *newExecContext_Catch_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Catch( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Catch( newExecContext_Catch_Function);

ExecContextRoot *newExecContext_LastResult_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_LastResult( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_LastResult( newExecContext_LastResult_Function);

ExecContextRoot *newExecContext_Pipe_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Pipe( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Pipe( newExecContext_Pipe_Function);


ExecContextRoot *newExecContext_SRand_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SRand( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SRand( newExecContext_SRand_Function);
ExecContextRoot *newExecContext_Rand_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Rand( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Rand( newExecContext_Rand_Function);

ExecContextRoot *newExecContext_Rkey_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Rkey( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Rkey( newExecContext_Rkey_Function);

ExecContextRoot *newExecContext_Sleep_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Sleep( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Sleep( newExecContext_Sleep_Function);
ExecContextRoot *newExecContext_Exit_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Exit( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Exit( newExecContext_Exit_Function);

ExecContextRoot *newExecContext_Transfer_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Transfer( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Transfer( newExecContext_Transfer_Function);

ExecContextRoot *newExecContext_Platform_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Platform( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Platform( newExecContext_Platform_Function);

ExecContextRoot *newExecContext_Pathsep_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Pathsep( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Pathsep( newExecContext_Pathsep_Function);

ExecContextRoot *newExecContext_AddAllowTag_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_AddAllowTag( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_AddAllowTag( newExecContext_AddAllowTag_Function);
ExecContextRoot *newExecContext_RemoveAllowTag_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_RemoveAllowTag( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_RemoveAllowTag( newExecContext_RemoveAllowTag_Function);

ExecContextRoot *newExecContext_Select_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Select( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Select( newExecContext_Select_Function);
ExecContextRoot *newExecContext_SQL_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SQL( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SQL( newExecContext_SQL_Function);
ExecContextRoot *newExecContext_Insert_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Insert( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Insert( newExecContext_Insert_Function);
ExecContextRoot *newExecContext_Update_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Update( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Update( newExecContext_Update_Function);
ExecContextRoot *newExecContext_Save_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Save( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Save( newExecContext_Save_Function);
ExecContextRoot *newExecContext_Delete_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Delete( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Delete( newExecContext_Delete_Function);
ExecContextRoot *newExecContext_Commit_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Commit( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Commit( newExecContext_Commit_Function);
ExecContextRoot *newExecContext_Rollback_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Rollback( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Rollback( newExecContext_Rollback_Function);
ExecContextRoot *newExecContext_Tables_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Tables( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Tables( newExecContext_Tables_Function);
ExecContextRoot *newExecContext_Columns_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Columns( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Columns( newExecContext_Columns_Function);

ExecContextRoot *newExecContext_SetDBQuote_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SetDBQuote( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SetDBQuote( newExecContext_SetDBQuote_Function);

ExecContextRoot *newExecContext_SetDBDefaultQuote_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SetDBDefaultQuote( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SetDBDefaultQuote( newExecContext_SetDBDefaultQuote_Function);

ExecContextRoot *newExecContext_Fread_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Fread( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Fread( newExecContext_Fread_Function);
ExecContextRoot *newExecContext_FreadN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_FreadN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_FreadN( newExecContext_FreadN_Function);

ExecContextRoot *newExecContext_WriteFile_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_WriteFile( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_WriteFile( newExecContext_WriteFile_Function);

ExecContextRoot *newExecContext_Fwrite_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Fwrite( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Fwrite( newExecContext_Fwrite_Function);
ExecContextRoot *newExecContext_FwriteN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_FwriteN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_FwriteN( newExecContext_FwriteN_Function);

ExecContextRoot *newExecContext_AppendFile_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_AppendFile( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_AppendFile( newExecContext_AppendFile_Function);

ExecContextRoot *newExecContext_Fappend_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Fappend( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Fappend( newExecContext_Fappend_Function);

ExecContextRoot *newExecContext_AppendFileN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_AppendFileN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_AppendFileN( newExecContext_AppendFileN_Function);

ExecContextRoot *newExecContext_FappendN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_FappendN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_FappendN( newExecContext_FappendN_Function);
ExecContextRoot *newExecContext_Mkdir_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Mkdir( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Mkdir( newExecContext_Mkdir_Function);
ExecContextRoot *newExecContext_CSV_Read_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CSV_Read( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CSV_Read( newExecContext_CSV_Read_Function);
ExecContextRoot *newExecContext_CSVH_Read_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CSVH_Read( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CSVH_Read( newExecContext_CSVH_Read_Function);
ExecContextRoot *newExecContext_Apachelog_Read_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Apachelog_Read( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Apachelog_Read( newExecContext_Apachelog_Read_Function);
ExecContextRoot *newExecContext_Make_Temp_Path_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Make_Temp_Path( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Make_Temp_Path( newExecContext_Make_Temp_Path_Function);

ExecContextRoot *newExecContext_unlink_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_unlink( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_unlink( newExecContext_unlink_Function);
ExecContextRoot *newExecContext_rmdir_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_rmdir( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_rmdir( newExecContext_rmdir_Function);
ExecContextRoot *newExecContext_remove_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_remove( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_remove( newExecContext_unlink_Function);


ExecContextRoot *newExecContext_Bload_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Bload( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Bload( newExecContext_Bload_Function);
ExecContextRoot *newExecContext_Bsave_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Bsave( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Bsave( newExecContext_Bsave_Function);
ExecContextRoot *newExecContext_Regex_Search_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Regex_Search( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Regex_Search( newExecContext_Regex_Search_Function);
ExecContextRoot *newExecContext_Cat_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Cat( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Cat( newExecContext_Cat_Function);
ExecContextRoot *newExecContext_Left_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Left( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Left( newExecContext_Left_Function);
ExecContextRoot *newExecContext_Right_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Right( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Right( newExecContext_Right_Function);
ExecContextRoot *newExecContext_Mid_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Mid( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Mid( newExecContext_Mid_Function);
ExecContextRoot *newExecContext_Trim_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Trim( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Trim( newExecContext_Trim_Function);

ExecContextRoot *newExecContext_Chr_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Chr( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Chr( newExecContext_Chr_Function);
ExecContextRoot *newExecContext_Ascii_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Ascii( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Ascii( newExecContext_Ascii_Function);

ExecContextRoot *newExecContext_Instr_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Instr( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Instr( newExecContext_Instr_Function);

ExecContextRoot *newExecContext_InstrRev_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_InstrRev( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_InstrRev( newExecContext_InstrRev_Function);

ExecContextRoot *newExecContext_Replace_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Replace( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Replace( newExecContext_Replace_Function);
ExecContextRoot *newExecContext_ReplaceFirst_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_ReplaceFirst( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_ReplaceFirst( newExecContext_ReplaceFirst_Function);

ExecContextRoot *newExecContext_RegexReplace_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_RegexReplace( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_RegexReplace( newExecContext_RegexReplace_Function);
ExecContextRoot *newExecContext_RegexReplaceFirst_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_RegexReplaceFirst( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_RegexReplaceFirst( newExecContext_RegexReplaceFirst_Function);

ExecContextRoot *newExecContext_Sprintf_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Sprintf( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Sprintf( newExecContext_Sprintf_Function);
ExecContextRoot *newExecContext_Split_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Split( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Split( newExecContext_Split_Function);
ExecContextRoot *newExecContext_Euc2sjis_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Euc2sjis( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Euc2sjis( newExecContext_Euc2sjis_Function);
ExecContextRoot *newExecContext_FromUTF8_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_FromUTF8( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_FromUTF8( newExecContext_FromUTF8_Function);

ExecContextRoot *newExecContext_CSV_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CSV( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CSV( newExecContext_CSV_Function);

ExecContextRoot *newExecContext_JSON_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_JSON( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_JSON( newExecContext_JSON_Function);

ExecContextRoot *newExecContext_ParseJSON_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_ParseJSON( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_ParseJSON( newExecContext_ParseJSON_Function);

ExecContextRoot *newExecContext_SHA1_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SHA1( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SHA1( newExecContext_SHA1_Function);
ExecContextRoot *newExecContext_MakeSessionID_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_MakeSessionID( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_MakeSessionID( newExecContext_MakeSessionID_Function);

ExecContextRoot *newExecContext_CTimeStr_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_CTimeStr( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_CTimeStr( newExecContext_CTimeStr_Function);

ExecContextRoot *newExecContext_Item_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Item( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Item( newExecContext_Item_Function);

ExecContextRoot *newExecContext_Global_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Global( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Global( newExecContext_Global_Function);

ExecContextRoot *newExecContext_Session_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Session( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Session( newExecContext_Session_Function);

ExecContextRoot *newExecContext_SetGlobal_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SetGlobal( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SetGlobal( newExecContext_SetGlobal_Function);

ExecContextRoot *newExecContext_SetSession_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SetSession( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SetSession( newExecContext_SetSession_Function);

ExecContextRoot *newExecContext_SetSessionCookie_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SetSessionCookie( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SetSessionCookie( newExecContext_SetSessionCookie_Function);

ExecContextRoot *newExecContext_Each_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Each( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Each( newExecContext_Each_Function);
ExecContextRoot *newExecContext_Size_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Size( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Size( newExecContext_Size_Function);

ExecContextRoot *newExecContext_Keys_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Keys( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Keys( newExecContext_Keys_Function);

ExecContextRoot *newExecContext_Remap_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Remap( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Remap( newExecContext_Remap_Function);

ExecContextRoot *newExecContext_ReArray_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_ReArray( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_ReArray( newExecContext_ReArray_Function);

ExecContextRoot *newExecContext_Mkmap_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Mkmap( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Mkmap( newExecContext_Mkmap_Function);

ExecContextRoot *newExecContext_Slmap_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Slmap( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Slmap( newExecContext_Slmap_Function);

ExecContextRoot *newExecContext_Get_Html_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Get_Html( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Get_Html( newExecContext_Get_Html_Function);
ExecContextRoot *newExecContext_Query_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Query( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Query( newExecContext_Query_Function);

ExecContextRoot *newExecContext_Cookie_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Cookie( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Cookie( newExecContext_Cookie_Function);
ExecContextRoot *newExecContext_Response_Header_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Response_Header( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Response_Header( newExecContext_Response_Header_Function);
ExecContextRoot *newExecContext_Add_Response_Header_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Add_Response_Header( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Add_Response_Header( newExecContext_Add_Response_Header_Function);
ExecContextRoot *newExecContext_Set_Cookie_Row_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Set_Cookie_Row( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Set_Cookie_Row( newExecContext_Set_Cookie_Row_Function);
ExecContextRoot *newExecContext_URLencode_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_URLencode( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_URLencode( newExecContext_URLencode_Function);
ExecContextRoot *newExecContext_URLdecode_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_URLdecode( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_URLdecode( newExecContext_URLdecode_Function);
ExecContextRoot *newExecContext_WOL_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_WOL( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_WOL( newExecContext_WOL_Function);

ExecContextRoot *newExecContext_SendMail_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_SendMail( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_SendMail( newExecContext_SendMail_Function);

ExecContextRoot *newExecContext_Graph_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Graph( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Graph( newExecContext_Graph_Function);
ExecContextRoot *newExecContext_Debug_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_Debug( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_Debug( newExecContext_Debug_Function);
ExecContextRoot *newExecContext_DebugN_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext_DebugN( p_, f_, pred_, l); }
ExecContext_Factory newExecContext_DebugN( newExecContext_DebugN_Function);
ExecContextRoot *newExecContext_Function(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { return new ExecContext( p_, f_, pred_, l); }

ExecContext_Factory newExecContext( newExecContext_Function);

typedef map<string,ExecContext_Factory*>	ExecContext_Factory_Map;
typedef pair<string,ExecContext_Factory*>	ExecContext_Factory_Pair;

static ExecContext_Factory_Map	factory_map;

void init_ExecContext_Factory_Map(void)
{
	factory_map.insert(ExecContext_Factory_Pair( string("err"),					&newExecContext_Err));
	factory_map.insert(ExecContext_Factory_Pair( string("errn"),				&newExecContext_ErrN));
	factory_map.insert(ExecContext_Factory_Pair( string("print"),				&newExecContext_Print));
	factory_map.insert(ExecContext_Factory_Pair( string("prt"),					&newExecContext_Print));
	factory_map.insert(ExecContext_Factory_Pair( string("printn"),				&newExecContext_PrintN));
	factory_map.insert(ExecContext_Factory_Pair( string("prtn"),				&newExecContext_PrintN));
	factory_map.insert(ExecContext_Factory_Pair( string("_prt_htmlescape"),		&newExecContext_Prt_htmlescape));
	factory_map.insert(ExecContext_Factory_Pair( string("_prt_awpescape"),		&newExecContext_Prt_awpescape));
	factory_map.insert(ExecContext_Factory_Pair( string("_prt_urlencode"),		&newExecContext_Prt_urlencode));
	factory_map.insert(ExecContext_Factory_Pair( string("_ppout"),				&newExecContext_Ppout));
	factory_map.insert(ExecContext_Factory_Pair( string("_ppout_htmlescape"),	&newExecContext_Ppout_htmlescape));
	factory_map.insert(ExecContext_Factory_Pair( string("_ppout_awpescape"),	&newExecContext_Ppout_awpescape));
	factory_map.insert(ExecContext_Factory_Pair( string("_ppout_urlencode"),	&newExecContext_Ppout_urlencode));
	factory_map.insert(ExecContext_Factory_Pair( string("_add"),				&newExecContext_Add));
	factory_map.insert(ExecContext_Factory_Pair( string("_sub"),				&newExecContext_Sub));
	factory_map.insert(ExecContext_Factory_Pair( string("_neg"),				&newExecContext_Neg));
	factory_map.insert(ExecContext_Factory_Pair( string("_mul"),				&newExecContext_Mul));
	factory_map.insert(ExecContext_Factory_Pair( string("_div"),				&newExecContext_Div));
	factory_map.insert(ExecContext_Factory_Pair( string("_mod"),				&newExecContext_Mod));
	factory_map.insert(ExecContext_Factory_Pair( string("_equ"),				&newExecContext_Equ));
	factory_map.insert(ExecContext_Factory_Pair( string("_neq"),				&newExecContext_Neq));
	factory_map.insert(ExecContext_Factory_Pair( string("cmp"),					&newExecContext_CMP));
	factory_map.insert(ExecContext_Factory_Pair( string("_lt"),					&newExecContext_LT));
	factory_map.insert(ExecContext_Factory_Pair( string("_le"),					&newExecContext_LE));
	factory_map.insert(ExecContext_Factory_Pair( string("_gt"),					&newExecContext_GT));
	factory_map.insert(ExecContext_Factory_Pair( string("_ge"),					&newExecContext_GE));

	factory_map.insert(ExecContext_Factory_Pair( string("_and"),				&newExecContext_And));
	factory_map.insert(ExecContext_Factory_Pair( string("_xor"),				&newExecContext_Xor));
	factory_map.insert(ExecContext_Factory_Pair( string("_or"),					&newExecContext_Or));
	factory_map.insert(ExecContext_Factory_Pair( string("_not"),				&newExecContext_Not));

	factory_map.insert(ExecContext_Factory_Pair( string("_let"),				&newExecContext_Let));
	factory_map.insert(ExecContext_Factory_Pair( string("_letadd"),				&newExecContext_LetAdd));
	factory_map.insert(ExecContext_Factory_Pair( string("_letsub"),				&newExecContext_LetSub));
	factory_map.insert(ExecContext_Factory_Pair( string("_letmul"),				&newExecContext_LetMul));
	factory_map.insert(ExecContext_Factory_Pair( string("_letdiv"),				&newExecContext_LetDiv));
	factory_map.insert(ExecContext_Factory_Pair( string("_letmod"),				&newExecContext_LetMod));
	factory_map.insert(ExecContext_Factory_Pair( string("_letand"),				&newExecContext_LetAnd));
	factory_map.insert(ExecContext_Factory_Pair( string("_letor"),				&newExecContext_LetOr));
	factory_map.insert(ExecContext_Factory_Pair( string("_letxor"),				&newExecContext_LetXor));

	factory_map.insert(ExecContext_Factory_Pair( string("now"),					&newExecContext_Now));
	factory_map.insert(ExecContext_Factory_Pair( string("spawnp"),				&newExecContext_Spawnp));
	factory_map.insert(ExecContext_Factory_Pair( string("env"),					&newExecContext_Env));
	factory_map.insert(ExecContext_Factory_Pair( string("arg"),					&newExecContext_Arg));
	factory_map.insert(ExecContext_Factory_Pair( string("str"),					&newExecContext_CStr));
	factory_map.insert(ExecContext_Factory_Pair( string("dbl"),					&newExecContext_Cdbl));
	factory_map.insert(ExecContext_Factory_Pair( string("int"),					&newExecContext_Cint));
	factory_map.insert(ExecContext_Factory_Pair( string("hash"),				&newExecContext_GetHash));
	factory_map.insert(ExecContext_Factory_Pair( string("counter"),				&newExecContext_Counter));
	factory_map.insert(ExecContext_Factory_Pair( string("times"),				&newExecContext_Times));
	factory_map.insert(ExecContext_Factory_Pair( string("!"),					&newExecContext_Cut));
	factory_map.insert(ExecContext_Factory_Pair( string("fail"),				&newExecContext_Fail));
	factory_map.insert(ExecContext_Factory_Pair( string("raise"),				&newExecContext_Raise));
	factory_map.insert(ExecContext_Factory_Pair( string("next"),				&newExecContext_Next));
	factory_map.insert(ExecContext_Factory_Pair( string("catch"),				&newExecContext_Catch));
	factory_map.insert(ExecContext_Factory_Pair( string("last"),				&newExecContext_LastResult));
	factory_map.insert(ExecContext_Factory_Pair( string("pipe"),				&newExecContext_Pipe));

	factory_map.insert(ExecContext_Factory_Pair( string("srand"),				&newExecContext_SRand));
	factory_map.insert(ExecContext_Factory_Pair( string("rand"),				&newExecContext_Rand));
	factory_map.insert(ExecContext_Factory_Pair( string("rkey"),				&newExecContext_Rkey));
	factory_map.insert(ExecContext_Factory_Pair( string("sleep"),				&newExecContext_Sleep));
	factory_map.insert(ExecContext_Factory_Pair( string("exit"),				&newExecContext_Exit));
	factory_map.insert(ExecContext_Factory_Pair( string("transfer"),			&newExecContext_Transfer));
	factory_map.insert(ExecContext_Factory_Pair( string("platform"),			&newExecContext_Platform));
	factory_map.insert(ExecContext_Factory_Pair( string("pathsep"),				&newExecContext_Pathsep));

	factory_map.insert(ExecContext_Factory_Pair( string("add_allowtag"),		&newExecContext_AddAllowTag));
	factory_map.insert(ExecContext_Factory_Pair( string("remove_allowtag"),		&newExecContext_RemoveAllowTag));

	factory_map.insert(ExecContext_Factory_Pair( string("select"),				&newExecContext_Select));
	factory_map.insert(ExecContext_Factory_Pair( string("sql"),					&newExecContext_SQL));
	factory_map.insert(ExecContext_Factory_Pair( string("insert"),				&newExecContext_Insert));
	factory_map.insert(ExecContext_Factory_Pair( string("update"),				&newExecContext_Update));
	factory_map.insert(ExecContext_Factory_Pair( string("save"),				&newExecContext_Save));
	factory_map.insert(ExecContext_Factory_Pair( string("delete"),				&newExecContext_Delete));
	factory_map.insert(ExecContext_Factory_Pair( string("commit"),				&newExecContext_Commit));
	factory_map.insert(ExecContext_Factory_Pair( string("rollback"),			&newExecContext_Rollback));
	factory_map.insert(ExecContext_Factory_Pair( string("tables"),				&newExecContext_Tables));
	factory_map.insert(ExecContext_Factory_Pair( string("columns"),				&newExecContext_Columns));
	factory_map.insert(ExecContext_Factory_Pair( string("_db_quote"),			&newExecContext_SetDBQuote));
	factory_map.insert(ExecContext_Factory_Pair( string("_db_default_quote"),	&newExecContext_SetDBDefaultQuote));
	factory_map.insert(ExecContext_Factory_Pair( string("file"),				&newExecContext_Fread));
	factory_map.insert(ExecContext_Factory_Pair( string("fread"),				&newExecContext_Fread));
	factory_map.insert(ExecContext_Factory_Pair( string("freadn"),				&newExecContext_FreadN));
	factory_map.insert(ExecContext_Factory_Pair( string("_file"),				&newExecContext_WriteFile));
	factory_map.insert(ExecContext_Factory_Pair( string("fwrite"),				&newExecContext_Fwrite));
	factory_map.insert(ExecContext_Factory_Pair( string("fwriten"),				&newExecContext_FwriteN));
	factory_map.insert(ExecContext_Factory_Pair( string("log"),					&newExecContext_AppendFile));
	factory_map.insert(ExecContext_Factory_Pair( string("fappend"),				&newExecContext_Fappend));
	factory_map.insert(ExecContext_Factory_Pair( string("logn"),				&newExecContext_AppendFileN));
	factory_map.insert(ExecContext_Factory_Pair( string("fappendn"),			&newExecContext_FappendN));
	factory_map.insert(ExecContext_Factory_Pair( string("mkdir"),				&newExecContext_Mkdir));
	factory_map.insert(ExecContext_Factory_Pair( string("rcsvf"),				&newExecContext_CSV_Read));
	factory_map.insert(ExecContext_Factory_Pair( string("rcsvfh"),				&newExecContext_CSVH_Read));
	factory_map.insert(ExecContext_Factory_Pair( string("apachelog"),			&newExecContext_Apachelog_Read));
	factory_map.insert(ExecContext_Factory_Pair( string("_temp_path"),			&newExecContext_Make_Temp_Path));
	factory_map.insert(ExecContext_Factory_Pair( string("unlink"),				&newExecContext_unlink));
	factory_map.insert(ExecContext_Factory_Pair( string("rmdir"),				&newExecContext_rmdir));
	factory_map.insert(ExecContext_Factory_Pair( string("remove"),				&newExecContext_remove));

	factory_map.insert(ExecContext_Factory_Pair( string("bload"),				&newExecContext_Bload));
	factory_map.insert(ExecContext_Factory_Pair( string("bsave"),				&newExecContext_Bsave));
	factory_map.insert(ExecContext_Factory_Pair( string("search"),				&newExecContext_Regex_Search));
	factory_map.insert(ExecContext_Factory_Pair( string("cat"),					&newExecContext_Cat));
	factory_map.insert(ExecContext_Factory_Pair( string("left"),				&newExecContext_Left));
	factory_map.insert(ExecContext_Factory_Pair( string("right"),				&newExecContext_Right));
	factory_map.insert(ExecContext_Factory_Pair( string("mid"),					&newExecContext_Mid));
	factory_map.insert(ExecContext_Factory_Pair( string("trim"),				&newExecContext_Trim));
	factory_map.insert(ExecContext_Factory_Pair( string("chr"),					&newExecContext_Chr));
	factory_map.insert(ExecContext_Factory_Pair( string("ascii"),				&newExecContext_Ascii));

	factory_map.insert(ExecContext_Factory_Pair( string("instr"),				&newExecContext_Instr));
	factory_map.insert(ExecContext_Factory_Pair( string("instrrev"),			&newExecContext_InstrRev));
	factory_map.insert(ExecContext_Factory_Pair( string("replace"),				&newExecContext_Replace));
	factory_map.insert(ExecContext_Factory_Pair( string("replace_first"),		&newExecContext_ReplaceFirst));
	factory_map.insert(ExecContext_Factory_Pair( string("regex_replace"),		&newExecContext_RegexReplace));
	factory_map.insert(ExecContext_Factory_Pair( string("regex_replace_first"),	&newExecContext_RegexReplaceFirst));
	factory_map.insert(ExecContext_Factory_Pair( string("sprintf"),				&newExecContext_Sprintf));
	factory_map.insert(ExecContext_Factory_Pair( string("split"),				&newExecContext_Split));
	factory_map.insert(ExecContext_Factory_Pair( string("euc2sjis"),			&newExecContext_Euc2sjis));
	factory_map.insert(ExecContext_Factory_Pair( string("futf8"),				&newExecContext_FromUTF8));
	factory_map.insert(ExecContext_Factory_Pair( string("csv"),					&newExecContext_CSV));
	factory_map.insert(ExecContext_Factory_Pair( string("json"),				&newExecContext_JSON));
	factory_map.insert(ExecContext_Factory_Pair( string("_json"),				&newExecContext_ParseJSON));
	factory_map.insert(ExecContext_Factory_Pair( string("sha1"),				&newExecContext_SHA1));
	factory_map.insert(ExecContext_Factory_Pair( string("make_session_id"),		&newExecContext_MakeSessionID));
	factory_map.insert(ExecContext_Factory_Pair( string("ctimestr"),			&newExecContext_CTimeStr));
	factory_map.insert(ExecContext_Factory_Pair( string("item"),				&newExecContext_Item));
	factory_map.insert(ExecContext_Factory_Pair( string("global"),				&newExecContext_Global));
	factory_map.insert(ExecContext_Factory_Pair( string("_global"),				&newExecContext_SetGlobal));
	factory_map.insert(ExecContext_Factory_Pair( string("session"),				&newExecContext_Session));
	factory_map.insert(ExecContext_Factory_Pair( string("_session"),			&newExecContext_SetSession));
	factory_map.insert(ExecContext_Factory_Pair( string("_session_cookie"),		&newExecContext_SetSessionCookie));
	factory_map.insert(ExecContext_Factory_Pair( string("each"),				&newExecContext_Each));
	factory_map.insert(ExecContext_Factory_Pair( string("size"),				&newExecContext_Size));
	factory_map.insert(ExecContext_Factory_Pair( string("keys"),				&newExecContext_Keys));
	factory_map.insert(ExecContext_Factory_Pair( string("remap"),				&newExecContext_Remap));
	factory_map.insert(ExecContext_Factory_Pair( string("rearray"),				&newExecContext_ReArray));
	factory_map.insert(ExecContext_Factory_Pair( string("mkmap"),				&newExecContext_Mkmap));
	factory_map.insert(ExecContext_Factory_Pair( string("slmap"),				&newExecContext_Slmap));
	factory_map.insert(ExecContext_Factory_Pair( string("html"),				&newExecContext_Get_Html));
	factory_map.insert(ExecContext_Factory_Pair( string("query"),				&newExecContext_Query));
	factory_map.insert(ExecContext_Factory_Pair( string("cookie"),				&newExecContext_Cookie));
	factory_map.insert(ExecContext_Factory_Pair( string("response_header"),		&newExecContext_Response_Header));
	factory_map.insert(ExecContext_Factory_Pair( string("add_response_header"),	&newExecContext_Add_Response_Header));
	factory_map.insert(ExecContext_Factory_Pair( string("_cookie"),				&newExecContext_Set_Cookie_Row));
	factory_map.insert(ExecContext_Factory_Pair( string("urlencode"),			&newExecContext_URLencode));
	factory_map.insert(ExecContext_Factory_Pair( string("urldecode"),			&newExecContext_URLdecode));
	factory_map.insert(ExecContext_Factory_Pair( string("wol"),					&newExecContext_WOL));
	factory_map.insert(ExecContext_Factory_Pair( string("sendmail"),			&newExecContext_SendMail));
	factory_map.insert(ExecContext_Factory_Pair( string("graph"),				&newExecContext_Graph));
	factory_map.insert(ExecContext_Factory_Pair( string("debug"),				&newExecContext_Debug));
	factory_map.insert(ExecContext_Factory_Pair( string("debugn"),				&newExecContext_DebugN));
}

ExecContext_Factory *search_ExecContext_Factory(const string *name, const string &nspace)
{
	if ( name == 0 ) return &newExecContext;
	if ( nspace.empty() || strcmp( nspace.c_str(), "sys") == 0 ) {
		if ( nspace.empty() ) {
			if ( gc->hbase.upHorns(*name) != 0 ) return &newExecContext;
		}
		ExecContext_Factory_Map::iterator i = factory_map.find(*name);
		if ( i != factory_map.end() ) {
			return i->second;
		}
	}
	return &newExecContext;
}

bool check_ExecContext_Factory(const string *name)
{
	if ( name == 0 ) return true;
	ExecContext_Factory_Map::iterator i = factory_map.find(*name);
	if ( i != factory_map.end() ) {
		return true;
	}
	return false;
}
