/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#ifndef ADP_BUILTIN_DB_H
#define ADP_BUILTIN_DB_H

struct ExecContext_DB_Base : public ExecContextBase {
	// db connector
	kz_odbc					*con;
	kz_stmt					stmt;			/* stmt SQLɑΉʂ */
	char					quote_s;		/* NI[giJnj */
	char					quote_e;		/* NI[giIj */
	PArray					*result_type;	/* ߂f[^̃^CviJ̃nbV) */
	Array<SQLLEN>			buflens;		/* INPUTobt@̃OXioCif[^̂ݎgpj */

	void init() { 
		stmt.freestmt(); 
		if ( result_type ) 
			result_type->del(); 
		result_type=0; 
		buflens.clear(); 
	}

	// recreate@}l[Wxł̃IuWFNg̃TCN 
	virtual void recreate(const PPredicate *pred_, VLocal *l) { ExecContextBase::recreate(pred_, l); init(); }
	virtual void recreate(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { ExecContextBase::recreate(p_, f_, pred_, l); init(); }
	// reinit@Executerxł̃IuWFNg̃TCN 
	virtual void reinit(const PPredicate *pred_, VLocal *l) { ExecContextBase::reinit(pred_, l); init(); }
	virtual void reinit(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) { ExecContextBase::reinit(p_, f_, pred_, l); init(); }
	// RXgN^ 
	ExecContext_DB_Base(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContextBase(p_, f_, pred_, l) { result_type = 0; }

	virtual void cleanup() { ExecContextBase::cleanup(); init(); }
	~ExecContext_DB_Base() { init(); }


	bool setODBC() {
		const PObject *constr = get<PObject>(0);
		if ( !constr->c_str() ) return false;
		con = db_connect(constr->c_str(), &quote_s, &quote_e);
		stmt.setODBC(con);
		return true;
	}

	void setParameter(const PObject *parameter) {
		buflens.push_back(0);
		if ( parameter == &pnil ) {
			stmt, kz_odbc_null;
		} else if ( parameter->c_str() != 0 ) {
			const PString *str = dynamic_cast<const PString*>(parameter);
			Array<const PString*> &binarycol = get_gc()->binarycol;
			if ( str && find(binarycol.begin(),binarycol.end(), str) != binarycol.end() ) {
				SQLLEN &blen = buflens.back();
				blen = str->value.size();
				stmt.bind( SQL_C_BINARY, SQL_LONGVARBINARY, str->value.data(), str->value.size(), 0, &blen);
			} else {
				stmt, str->value.c_str();
				//stmt.bind( SQL_C_CHAR, SQL_VARCHAR, str->value.c_str(), str->value.size());
			}
		} else if ( parameter->c_double() ) {
			stmt,  *parameter->c_double();
		} else if ( parameter->c_integer32(this) ) {
			stmt,  *parameter->c_integer32(this);
		} else if ( parameter->c_integer() ) {
			stmt,  *parameter->c_integer();
		} else {
			stmt, kz_odbc_null;
		}
	}

	void setParameterList(const PObject *parameters) {
		if ( typeid(*parameters) == typeid(PList) ) {
			while ( typeid(*parameters) == typeid(PList) ) {
				const PList *l = dynamic_cast<const PList*>(parameters);
				if ( l->lval() == &pnil && l->rval() == &pnil ) return;
				const PObject *lval = l->lval();
				setParameter(lval);
				parameters = l->rval();
			}
		} else if ( typeid(*parameters) == typeid(PArray) ) {
			const PArray *pa = dynamic_cast<const PArray*>(parameters);
			for ( size_t i = 0; i < pa->size(); i++ ) {
				setParameter((*pa)[i]);
			}
		}
	}

	void setParameterArray(vector<const PObject*> &parameters) {
		for ( vector<const PObject*>::iterator i = parameters.begin(); i < parameters.end(); i++ ) {
			setParameter(*i);
		}
	}

	bool checkError(PException &excp) {
		string msg;
		msg.clear();
		if ( stmt.iserr() ) {
			kz_string_array	errs = stmt.errors();
			kz_string_array::iterator j;
			for ( j = errs.begin(); j < errs.end(); j++ ) {
				msg += *j;
				msg += "\n";
			}
			stmt.errclear();
		}
		if ( con->iserr() ) {
			kz_string_array	errs = con->errors();
			kz_string_array::iterator j;
			for ( j = errs.begin(); j < errs.end(); j++ ) {
				msg += *j;
				msg += "\n";
			}
			con->errclear();
		}
		if ( !msg.empty() ) {
			return RERR(excp,msg);
		}
		return true;
	}

	bool checkConError() {
		if ( con->iserr() ) return false;
		return true;
	}

	bool prtError() {
		if ( stmt.iserr() ) return false;
		return true;
	}

	bool prtConError() {
		if ( con->iserr() ) {
			kz_string_array	errs = con->errors();
			kz_string_array::iterator j;
			for ( j = errs.begin(); j < errs.end(); j++ ) {
				get_gc()->err(*j);
				get_gc()->err("\n");
			}
			return false;
		}
		return true;
	}

	bool setResultAll(int vidx, PException &excp) {
		const PVeriable *v = dynamic_cast<const PVeriable*>(pred->back());
		if ( v == 0 ) return RERR_argment_type(excp, vidx);
		PArray *result_ary = pmm.newPArray(pobjs);
		bool nothing = true;
		vector< describe_col > &colinfo = stmt.cinfo();
		if ( !checkError(excp) ) return false;
		bool result = 0;

		while ( (result = stmt.fetch()) == true ) {
			nothing = false;

			PArray *alloc_ary = pmm.newPArray(pobjs, colinfo.size(), &pnil, true);
			if ( result_type != 0 ) {
				alloc_ary->hamap = result_type->hamap;
			}			
			kz_string_array::iterator i;
			bool nflg;
			for ( size_t i = 0; i < colinfo.size(); i++, vidx++ ) {
				const PObject *po = 0;
				switch ( colinfo[i].typ ) {
					case SQL_INTEGER :
					case SQL_SMALLINT :
						int intval;
						intval = 0;
						stmt.get( i+1,intval,nflg);
						if ( !nflg ) {
							po = pmm.newPInteger(pobjs,intval);
						}
						break;
					case SQL_FLOAT :
					case SQL_REAL :
					case SQL_DOUBLE :
						double dblval;
						stmt.get( i+1,dblval,nflg);
						if ( !nflg ) {
							po = pmm.newPDouble(pobjs,dblval);
						}
						break;
					// NUMERICDECIMAL͍ő10^28܂ł̐l̂łƂ肠^ƂiIɓl̐xlT|[gɐl^ɕϊ 
					case SQL_NUMERIC :
					case SQL_DECIMAL :
					default :
						PString *s =  pmm.newPString(pobjs);
						stmt.get( i+1, s->value,nflg);
						if ( !nflg ) {
							po = s;
						}
						break;
				}
				if ( nflg ) {
					po = &pnil;
				}
				if ( po != 0 ) {
					if ( result_type != 0 ) {
						alloc_ary->set(i,po);
					} else {
						alloc_ary->set(i,po, &colinfo[i].name);
					}				
				}
			}

			if ( result_type == 0 && alloc_ary != 0 ) {
				result_type = new PArray();
				result_type->type = true;
				result_type->hamap_ = alloc_ary->hamap_;
			}
			result_ary->push_back(alloc_ary);
		}
		
		if ( nothing ) return false;
		return v->unify( *result_ary, this);
	}

	bool setResult(int vidx, PException &excp) {
		//kz_string_array result = stmt.next();
		bool result = stmt.fetch();
		vector< describe_col > &colinfo = stmt.cinfo();
		if ( !checkError(excp) ) return false;
		if ( !result ) return false;

		PArray *alloc_ary = 0;

		if ( !size_check_and_alloc_array(colinfo.size() + vidx, excp, &alloc_ary, result_type) ) return false;
		kz_string_array::iterator i;
		bool nflg;
		for ( size_t i = 0; i < colinfo.size(); i++, vidx++ ) {
			switch ( colinfo[i].typ ) {
				case SQL_INTEGER :
				case SQL_SMALLINT :
					int intval;
					intval = 0;
					stmt.get( i+1,intval,nflg);
					if ( !nflg ) {
						const PInteger *po = pmm.newPInteger(pobjs,intval);
						if ( !unify<PInteger>( vidx, po, excp, &colinfo[i].name, alloc_ary, result_type) ) return false;
					}
					break;
				case SQL_FLOAT :
				case SQL_REAL :
				case SQL_DOUBLE :
					double dblval;
					stmt.get( i+1,dblval,nflg);
					if ( !nflg ) {
						const PDouble *po = pmm.newPDouble(pobjs,dblval);
						if ( !unify<PDouble>( vidx, po, excp, &colinfo[i].name, alloc_ary, result_type) ) return false;
					}
					break;
				case SQL_NUMERIC :
				case SQL_DECIMAL :
				default :
					PString *po = pmm.newPString(pobjs);
					stmt.get( i+1, po->value,nflg);
					if ( !nflg ) {
						if ( !unify<PString>( vidx, po, excp, &colinfo[i].name, alloc_ary, result_type) ) return false;
					}
					break;
			}
			if ( nflg ) {
				if ( !unify<PNil>( vidx, &pnil, excp, &colinfo[i].name, alloc_ary, result_type) ) return false;
			}
		}

		if ( result_type == 0 && alloc_ary != 0 ) {
			result_type = new PArray();
			result_type->type = true;
			result_type->hamap_ = alloc_ary->hamap_;
		}

		return true;
	}



	void makColValues(const PArray *param, const PArray *filter, kz_resultset_array &cols, vector<string> &col_names, vector<const PObject *> &col_values) {
		for ( kz_resultset_array::iterator i = cols.begin(); i < cols.end(); i++ ) {
			const string &key = (*i)["COLUMN_NAME"];
			if ( filter != 0 && filter->find_value(key) != -1 ) continue;
			if ( filter == 0 && strcmp( key.c_str(), "ID") == 0 ) continue;
			const PObject *col_value = (*param)[key];
			if ( col_value != &pnil ) {
				col_names.push_back(key);
				col_values.push_back(col_value);
			}
		}
	};

	bool addWhereAND( string &sql, const PArray *param, const PArray *filter, vector<const PObject *> &col_values, PException &excp) {
		string fstr;
		if ( filter != 0 ) {
			if ( filter->size() != 0 ) {
				// filterŎw肳ꂽparam̃nbVWhereɂ
				for ( size_t i = 0; i < filter->size(); i++ ) {
					const PObject *col_name = (*filter)[i];
					if ( col_name->c_str() == 0 ) RERR_argment_type( excp, 3);
					const PObject *col_value = (*param)[col_name->c_str()];
					col_values.push_back(col_value);
					if ( i != 0 ) {
						fstr += " AND ";
					}
					fstr += quote_s;
					fstr += col_name->c_str();
					fstr += quote_e;
					fstr += " = ? ";
				}
			} else {
				// param̃nbVSWhereɂ
				bool first = true;
				if ( param == 0 ) return false;
				for ( PHashArrayMap::const_iterator ki = param->hamap->begin(); ki != param->hamap->end(); ki++ ) {
					col_values.push_back( (*param)[ki->second] );
					if ( !first ) {
						fstr += " AND ";
					} else {
						first = false;
					}
					fstr += quote_s;
					fstr += ki->first;
					fstr += quote_e;
					fstr += " = ? ";
				}
			}
		} else {
			// IDparam̃nbVWhereɂ
			const PObject *col_value = (*param)["ID"];
			if ( col_value == 0 || col_value == &pnil ) return false;
			col_values.push_back( col_value);
			fstr += quote_s;
			fstr += "ID";
			fstr += quote_e;
			fstr += " = ? ";
		}
		if ( !fstr.empty() ) {
			sql += " WHERE " + fstr;
		} else if ( !filter || filter->size() != 0) {
			return false;	// WhereȂfilterz{}̂Ƃ̂݋Bselect/delete͏ォz񂪓n
		}
		return true;
	};
};

struct ExecContext_Select : public ExecContext_DB_Base {
	PArray	filter; // _~[̋z
	int		ridx;
	ExecContext_Select(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l),ridx(0) {}

	bool setup(PException &excp, bool args = false) {
		if ( !setODBC() ) return RERR_argment_type(excp,0); 
		const PArray *param = get<PArray>(1);
		const PObject *table = get<PObject>(2);
		if ( !table->c_str() ) return RERR_argment_type(excp,2); 
		const PEVeriable *v = get<PEVeriable>(3);
		const PArray *a = get<PArray>(3);

		// e[ũ`FbN `ĂG[ACWFNV΍j
		if ( strchr( table->c_str(), quote_e) != 0 ) return RERR_DB_Cannot_Used_Quote_Char(excp);
		string sql("SELECT ");
		// SQL̑gݗ
		ridx = 3;
		if ( pred->size() == 4 && v && (v->isargs() || args) ) {
			sql += "* ";
		} else if ( pred->size() == 5 && a ) {
			ridx = 4;
			for ( size_t i = 0; i < a->size(); i++ ) {
				if ( (*a)[i]->c_str() == 0 ) return RERR_argment_type( excp, 3);

				sql += quote_s;
				sql += (*a)[i]->c_str();
				sql += quote_e;

				if ( i != a->size() - 1 ) {
					sql += ", ";
				}
			}
		} else {
			for ( size_t i = 3; i < pred->size(); i++ ) {
				const PObject *item = (*pred)[i];
				if ( typeid(*item) != typeid(PVeriable) ) return RERR_argment_type( excp, i);
				sql += dynamic_cast<const PVeriable*>(item)->getName();
				if ( i != pred->size() - 1) {
					sql += ", ";
				}
			}
		}
		sql += " FROM ";
		sql += quote_s;
		sql += table->c_str();
		sql += quote_e; // e[uNI[gň͂(CWFNV΍j

		// Jƒl̃}bv̍쐬iۂ͕ʕϐj
		vector<const PObject *> col_values;
		if ( !addWhereAND( sql, param, &filter, col_values, excp) ) return RERR_argment_type( excp, 1);

		if ( this->pred->opt.debug ) fputs( sql.c_str(), stderr);

		stmt, sql.c_str();
		setParameterArray(col_values);
		stmt, endsql;
		return true;
	}


	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 4 ) return RERR_argment_number(excp, 4);
		
		if ( !setup(excp) ) return false;
		return setResult(ridx, excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return setResult(ridx, excp);
	};
};

struct ExecContext_SelectALL : public ExecContext_Select {
	ExecContext_SelectALL(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_Select(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 4 ) return RERR_argment_number(excp, 4);
		if ( !setup(excp,true) ) return false;
		return setResultAll(ridx, excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};

struct ExecContext_SQL : public ExecContext_DB_Base {
	ExecContext_SQL(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}

	bool setup(PException &excp) { 
		if ( !setODBC() ) return RERR_argment_type(excp,0); 
		const PObject *sql = get<PObject>(1);
		if ( !sql->c_str() ) return RERR_argment_type(excp,1); 
		const PObject *parameters = get<PObject>(2);

		if ( this->pred->opt.debug ) fputs( sql->c_str(), stderr);

		stmt, sql->c_str();
		setParameterList(parameters);
		stmt, endsql;
		return true;
	};


	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 3 ) return RERR_argment_number(excp, 3);
		if ( !setup(excp) ) return false;
		if ( pred->size() == 3 ) {
			return checkError(excp);
		} else {
			return backtrack(excp);
		}
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() == 3 ) {
			return false;
		} else {
			return setResult(3, excp);
		}
	};
};

struct ExecContext_SQLALL : public ExecContext_SQL {
	ExecContext_SQLALL(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_SQL(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 4 ) return RERR_argment_number(excp, 4);
		if ( !setup(excp) ) return false;
		return setResultAll(3, excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};



struct ExecContext_Insert : public ExecContext_DB_Base {
	string		cache_constr;
	string		cache_table_name;
	kz_resultset_array	cols;

	ExecContext_Insert(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}

	// J̒`̎擾
	void getCols(const char *table_name) {
		if ( strcmp( con->get_constr(), cache_constr.c_str()) == 0 &&
			strcmp( table_name, cache_table_name.c_str()) == 0 ) {
			return;
		}
		cache_constr = string(con->get_constr());
		cache_table_name = string(table_name);
		kz_stmt	col(con);
		cols = col.columns(table_name);
		col.freestmt();
	}
	
	bool insert( const PArray *param, const PObject *table, PException &excp) {
		getCols(table->c_str());
		int colcnt = 0;
		string sql("INSERT INTO ");

		sql += quote_s;
		sql += table->c_str();
		sql += quote_e; // e[uNI[gň͂(CWFNV΍j
		sql += " (";

		// Jƒl̃}bv̍쐬iۂ͕ʕϐj
		vector<string> col_names;
		vector<const PObject *> col_values;
		for ( kz_resultset_array::iterator i = cols.begin(); i < cols.end(); i++ ) {
			const string key = (*i)["COLUMN_NAME"];
			const PObject *col_value = (*param)[key];
			if ( col_value != &pnil ) {
				col_names.push_back(key);
				col_values.push_back(col_value);
			}
		}

		for ( vector<string>::iterator i = col_names.begin(); i < col_names.end(); i++ ) {
			if ( i != col_names.begin() ) {
				sql += ",";
			}
			sql += quote_s;
			sql += *i;
			sql += quote_e;			
		}
		sql += ") Values ( ";
		sql += "?";
		for ( size_t i = 1; i < col_names.size(); i++ ) {
			sql += ", ?";
		}
		sql += ") ";

		if ( this->pred->opt.debug ) fputs( sql.c_str(), stderr);

		stmt, sql.c_str();
		setParameterArray(col_values);
		stmt, endsql;

		bool result = checkError(excp);
		stmt.freestmt();
		return result;
	};
	
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 3 ) return RERR_argment_number(excp, 3);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 

		const PArray *param = get<PArray>(1);
		if ( param == 0 ) return RERR_argment_type( excp, 1);

		const PObject *table = get<PObject>(2);
		if ( !table->c_str() ) return RERR_argment_type(excp,2); 
		// e[ũ`FbN `ĂG[ACWFNV΍j
		if ( strchr( table->c_str(), quote_e) != 0 ) return RERR_DB_Cannot_Used_Quote_Char(excp);

		return insert( param, table, excp);

	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};

struct ExecContext_Update : public ExecContext_Insert {
	ExecContext_Update(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_Insert(p_, f_, pred_, l) {}

	bool update( const PArray *param, const PObject *table, const PArray *filter, PException &excp) {
		getCols(table->c_str());
		
		int colcnt = 0;
		string sql("UPDATE ");
		sql += quote_s;
		sql += table->c_str();
		sql += quote_e; // e[uNI[gň͂(CWFNV΍j
		sql += " SET ";

		// Jƒl̃}bv̍쐬iۂ͕ʕϐj
		vector<string> col_names;
		vector<const PObject *> col_values;
		makColValues(param, filter, cols, col_names, col_values);

		for ( vector<string>::iterator i = col_names.begin(); i < col_names.end(); i++ ) {
			if ( i != col_names.begin() ) {
				sql += ",";
			}
			sql += quote_s;
			sql += *i;
			sql += quote_e;			
			sql += " = ? ";
		}

		if ( !addWhereAND( sql, param, filter, col_values, excp) ) return RERR_argment_type( excp, 3);

		if ( this->pred->opt.debug ) fputs( sql.c_str(), stderr);

		stmt, sql.c_str();
		setParameterArray(col_values);
		stmt, endsql;

		bool result = checkError(excp);
		stmt.freestmt();
		return result;
	};

	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 3 ) return RERR_argment_number(excp, 3);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 

		const PArray *param = get<PArray>(1);
		if ( param == 0 ) return RERR_argment_type( excp, 1);

		const PObject *table = get<PObject>(2);
		if ( !table->c_str() ) return RERR_argment_type(excp,2); 
		// e[ũ`FbN `ĂG[ACWFNV΍j
		if ( strchr( table->c_str(), quote_e) != 0 ) return RERR_DB_Cannot_Used_Quote_Char(excp);

		// Where
		const PArray *filter = 0;
		if ( pred->size() > 3 ) {
			filter = get<PArray>(3);
			if ( filter == 0 ) return RERR_argment_type( excp, 3);
		}
		
		return update( param, table, filter, excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};


struct ExecContext_Save : public ExecContext_Update {
	ExecContext_Save(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_Update(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 3 ) return RERR_argment_number(excp, 3);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 

		const PArray *param = get<PArray>(1);
		if ( param == 0 ) return RERR_argment_type( excp, 1);

		const PObject *table = get<PObject>(2);
		if ( !table->c_str() ) return RERR_argment_type(excp,2); 
		// e[ũ`FbN `ĂG[ACWFNV΍j
		if ( strchr( table->c_str(), quote_e) != 0 ) return RERR_DB_Cannot_Used_Quote_Char(excp);

		// Where
		const PArray *filter = 0;
		if ( pred->size() > 3 ) {
			filter = get<PArray>(3);
			if ( filter == 0 ) return RERR_argment_type( excp, 3);
		}

		string sql("SELECT COUNT(*) FROM ");
		sql += quote_s;
		sql += table->c_str();
		sql += quote_e; // e[uNI[gň͂(CWFNV΍j

		// Jƒl̃}bv̍쐬iۂ͕ʕϐj
		vector<const PObject *> col_values;
		// Where̍쐬ifilterꍇAYIDŌsAꂪUpdate  Insertsj
		if ( !addWhereAND( sql, param, filter, col_values, excp) ) {
			return insert( param, table, excp);	
		}

		if ( this->pred->opt.debug ) fputs( sql.c_str(), stderr);

		stmt, sql.c_str();
		setParameterArray(col_values);
		stmt, endsql;

		int cnum;
		bool nflg;
		cnum = 1;
		stmt.fetch();
		stmt.get( 1, cnum, nflg);
		if ( cnum == 0 ) {
			return insert( param, table, excp);	
		} else {
			return update( param, table, filter, excp);
		
		}
		return checkError(excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};


struct ExecContext_Delete : public ExecContext_Update {
	PArray	filter; // _~[̋z
	ExecContext_Delete(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_Update(p_, f_, pred_, l) {}

	bool dbdelete( const PArray *param, const PObject *table, PException &excp) {
		getCols(table->c_str());
		
		int colcnt = 0;
		string sql("DELETE FROM ");
		sql += quote_s;
		sql += table->c_str();
		sql += quote_e; // e[uNI[gň͂(CWFNV΍j
		sql += " ";

		// Jƒl̃}bv̍쐬iۂ͕ʕϐj
		vector<string> col_names;
		vector<const PObject *> col_values;
		makColValues(param, &filter, cols, col_names, col_values);

		if ( !addWhereAND( sql, param, &filter, col_values, excp) ) return RERR_argment_type( excp, 3);

		if ( this->pred->opt.debug ) fputs( sql.c_str(), stderr);

		stmt, sql.c_str();
		setParameterArray(col_values);
		stmt, endsql;

		bool result = checkError(excp);
		stmt.freestmt();
		return result;
	};

	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 3 ) return RERR_argment_number(excp, 3);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 

		const PArray *param = get<PArray>(1);
		if ( param == 0 ) return RERR_argment_type( excp, 1);

		const PObject *table = get<PObject>(2);
		if ( !table->c_str() ) return RERR_argment_type(excp,2); 
		// e[ũ`FbN `ĂG[ACWFNV΍j
		if ( strchr( table->c_str(), quote_e) != 0 ) return RERR_DB_Cannot_Used_Quote_Char(excp);

		return dbdelete( param, table, excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};



struct ExecContext_Commit : public ExecContext_DB_Base {
	ExecContext_Commit(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 1 ) return RERR_argment_number(excp, 1);
		if ( !setODBC() ) return RERR_argment_type(excp,0); 
		con->Commit();
		get_gc()->binarycol.clear();
		return checkConError();
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};

struct ExecContext_Rollback : public ExecContext_DB_Base {
	ExecContext_Rollback(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 1 ) return RERR_argment_number(excp, 1);
		if ( !setODBC() ) return RERR_argment_type(excp,0); 
		con->Rollback();
		get_gc()->binarycol.clear();
		return checkConError();
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return false;
	};
};

struct ExecContext_SetBinary : public ExecContextRoot {
	ExecContext_SetBinary(ExecContext *p_,  void *f_, const PPredicate *pred_, VLocal *l) : ExecContextRoot(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( pred->size() != 1 && pred->size() != 2) return RERR_argment_number(excp, 1);
		const PString	*cmd = get<PString>(0);
		if ( cmd == 0 || !cmd->c_str() ) return RERR_argment_type(excp, 0);
		get_gc()->binarycol.push_back(cmd);
		const PObject **args = &pred->arglist.value.front();
		return args[0]->unify( *args[1], this);
	}
};

struct ExecContext_Tables : public ExecContext_DB_Base {
	ExecContext_Tables(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 2 ) return RERR_argment_number(excp, 2);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 

		stmt.tables_();

		return backtrack(excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return setResult(1, excp);
	};
};

struct ExecContext_Columns : public ExecContext_DB_Base {
	ExecContext_Columns(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_DB_Base(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() < 3 ) return RERR_argment_number(excp, 3);

		if ( !setODBC() ) return RERR_argment_type(excp,0); 
		const PObject *table = get<PObject>(1);
		if ( !table->c_str() ) return RERR_argment_type(excp,1); 

		stmt.columns_(table->c_str());

		return backtrack(excp);
	};

	virtual bool backtrack(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		return setResult(2, excp);
	};
};


struct ExecContext_SetDBQuote : public ExecContextRoot {
	ExecContext_SetDBQuote(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContextRoot(p_, f_, pred_, l) {}

	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 2 && pred->size() != 3 ) return RERR_argment_number(excp, 1);
		string s0,s1,s2;
		string constr = cnv_charp(0,s0);
		const char *p_quote_s = cnv_charp(1,s1);
		const char *p_quote_e = p_quote_s;
		if ( pred->size() > 2 ) {
			p_quote_e = cnv_charp(2,s2);
		}
		
		quote_s[constr] = *p_quote_s;
		quote_e[constr] = *p_quote_e;
		return true;
	}
};

struct ExecContext_SetDBDefaultQuote : public ExecContextRoot {
	ExecContext_SetDBDefaultQuote(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContextRoot(p_, f_, pred_, l) {}

	virtual bool first(PException &excp) { 
		if ( get_gc()->issandbox() ) return RERR_Sandbox(excp);
		if ( pred->size() != 1 && pred->size() != 2 ) return RERR_argment_number(excp, 1);
		string s1,s2;
		const char *quote_s = cnv_charp(0,s1);
		const char *quote_e = quote_s;
		if ( pred->size() > 1 ) {
			quote_e = cnv_charp(1,s2);
		}
		default_quote_s = *quote_s;
		default_quote_e = *quote_e;
		return true;
	}
};


#endif
