#! /usr/local/bin/perl -w

require 5.005;
use strict;
use Getopt::Long;
use LWP::UserAgent;
use Time::Local;
JCODE:{ my $path=$0; $path=~s/[^\/\\]+$//; require $path.'jcode.pl'; }

#---------------------------------------------------------------------

# output code $OCODE can be any of "jis", "sjis" or "euc".
my $OCODE			= 'sjis';	# windows
#my $OCODE			= 'euc';	# unix, linux

#---------------------------------------------------------------------

# flush
$| = 1;

# script name
my $SCRIPT			= 'age2ch.pl';
my $VERSION			= '0.03.38';

# global
my ($DEBUG, $QUIET, $VERBOSE, $MYPID, $PROGRESS, $PROXY_CHECK, $CONFIG,
	$RAND, $LOG_DIR, $NAME, $MAIL, $BODY, $NUMBER, $WAIT, $EXIT_ERROR_COUNT,
	$PROXY, $GET_PROXY, $TIMEOUT, $GET_TIMEOUT, $USER_AGENT, $SERVER,
	$BBS, $THREAD, $ERROR_COUNT, $URL, $EUC, @BODY, @PROXY, $POST_TIME,
	$POST_COOKIE, $POST_CHECK, $START_TIME, $POST_NUM);

# default settings
$VERBOSE			= 1;
$NAME				= "$SCRIPT $VERSION";
$MAIL				= 'sage';
$BODY				= 'test';
$NUMBER				= 1;
$WAIT				= 6;
$EXIT_ERROR_COUNT	= 2;
$ERROR_COUNT		= 0;
$TIMEOUT			= 30;
$GET_TIMEOUT		= 5;
$USER_AGENT			= 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)';

# get options
GETOPT:{
	my ($debug, $quiet, $verbose, $mypid, $progress, $proxy_check,
	$config, $rand, $log_dir, $name, $mail, $body, $number, $wait,
	$exit_error_count, $proxy, $get_proxy, $timeout, $get_timeout,
	$user_agent) = get_options ();

	$CONFIG				= $config			if defined $config;
	$RAND				= $rand				if defined $rand;

	$DEBUG				= $debug			if defined $debug;
	$QUIET				= $quiet			if defined $quiet;
	$VERBOSE			= $verbose			if defined $verbose;
	$MYPID				= $mypid			if defined $mypid;
	$PROGRESS			= $progress			if defined $progress;

	# mode setting
	if ($QUIET) { $DEBUG = 0; $VERBOSE = 0; $MYPID = 0; $PROGRESS = 0 }
	elsif ($DEBUG) { $QUIET = 0; $VERBOSE = 0; $MYPID = 0; $PROGRESS = 0 }
	elsif ($MYPID) { $DEBUG = 0; $QUIET = 1; $VERBOSE = 0; $PROGRESS = 0 }
	elsif ($PROGRESS) { $DEBUG = 0; $QUIET = 1; $MYPID = 0; $VERBOSE = 0 }
	elsif ($VERBOSE) { $DEBUG = 0; $QUIET = 0; $MYPID = 0; $PROGRESS = 0 }

	read_config_file () if $CONFIG;
	read_thread_html () if $RAND;

	$PROXY_CHECK		= $proxy_check		if defined $proxy_check;
	$LOG_DIR			= $log_dir			if defined $log_dir;

	$NAME				= $name				if defined $name;
	$MAIL				= $mail				if defined $mail;
	$BODY				= $body				if defined $body;
	$NUMBER				= $number			if defined $number;
	$WAIT				= $wait				if defined $wait;
	$EXIT_ERROR_COUNT	= $exit_error_count	if defined $exit_error_count;

	$PROXY				= $proxy			if defined $proxy;
	$GET_PROXY			= $get_proxy		if defined $get_proxy;
	$TIMEOUT			= $timeout			if defined $timeout;
	$GET_TIMEOUT		= $get_timeout		if defined $get_timeout;
	$USER_AGENT			= $user_agent		if defined $user_agent;
}

$MAIL = '' if $MAIL eq '0';
@PROXY = split (/[\/\s]+/, $PROXY) if defined $PROXY;

$POST_TIME = time;
$POST_COOKIE = '';
$POST_CHECK = 0;

# proxy check mode
if ($PROXY_CHECK and @PROXY) {
	my $path = $0;
	$path =~ s/[^\/\\]+$//;
	if (!$LOG_DIR) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime;
		$LOG_DIR = $path.$BBS.sprintf("%02d%02d%02d%02d", $mon + 1, $mday, $hour, $min);
	} else {
		$LOG_DIR = $path.$LOG_DIR;
	}
	mkdir $LOG_DIR, 0777;
}

# search.pl child process mode
if ($MYPID and @PROXY) {
	my $path = $0;
	$path =~ s/[^\/\\]+$//;
	$LOG_DIR = $path.$LOG_DIR;
}

if ($THREAD) {
	post_thread($BBS, $THREAD);
} elsif ($BBS) {
	post_bbs($BBS);
} else {
	disp_init_error('missing URL');
}

exit; # unreachable

#---------------------------------------------------------------------

# get options
sub get_options {
	my ($disp_version, $disp_help, $debug, $quiet, $verbose, $mypid,
	$progress, $proxy_check, $config, $rand, $log_dir, $name, $mail,
	$body, $number, $wait, $exit_error_count, $proxy, $get_proxy,
	$timeout, $get_timeout, $user_agent);

	Getopt::Long::Configure ("bundling");
	GetOptions (
		'V|version'		=> \$disp_version,
		'h|help'		=> \$disp_help,

		'd|debug'		=> \$debug,
		'q|quiet'		=> \$quiet,
		'v|verbose'		=> \$verbose,
		'P|pid'			=> \$mypid,
		'S|progress'	=> \$progress,
		'c|check'		=> \$proxy_check,
		'l|load=s'		=> \$config,
		's|source=s'	=> \$rand,
		'o|output=s'	=> \$log_dir,

		'n|name=s'		=> \$name,
		'm|mail=s'		=> \$mail,
		'b|body=s'		=> \$body,
		't|tries=i'		=> \$number,
		'w|wait=s'		=> \$wait,
		'e|error=i'		=> \$exit_error_count,

		'p|proxy=s'		=> \$proxy,
		'g|get-proxy=s'	=> \$get_proxy,
		'T|timeout=i'	=> \$timeout,
		'G|get-timeout=s'=>\$get_timeout,
		'U|user-agent=s'=> \$user_agent,

		'<>'			=> \&parse_url
	);

	if ($disp_version) {
		disp_version();
	} elsif ($disp_help) {
		disp_help();
	}

	($debug, $quiet, $verbose, $mypid, $progress, $proxy_check,
	$config, $rand, $log_dir, $name, $mail, $body, $number, $wait,
	$exit_error_count, $proxy, $get_proxy, $timeout, $get_timeout,
	$user_agent);
}

# display help and exit
sub disp_help {
	print <<EOF;
$SCRIPT $VERSION, a non-interactive maintenance tool for 2ch.
Usage: $SCRIPT [OPTION]... [URL]

Mandatory arguments to long options are mandatory for short options too.

Startup:
  -V,  --version   display the version of $SCRIPT and exit.
  -h,  --help      print this help.

Logging and input file:
  -d,  --debug        print debug output.
  -q,  --quiet        quiet (no output).
  -v,  --verbose      be verbose (this is the default).
  -P,  --pid          print pid and progress.
  -S,  --progress     print progress.
  -c,  --check        check proxies.
  -l,  --load=FILE    load settings from FILE before session.
  -s,  --source=URL   load message bodies from URL before session.
  -o,  --output=DIR   output proxies to DIR.

Post:
  -n,  --name=NAME      set name to NAME (0 blank).
  -m,  --mail=MAIL      set mail address to MAIL (0 blank).
  -b,  --body=BODY      set message body to BODY.
  -t,  --tries=NUMBER   set number of retries to NUMBER (0 unlimits).
  -w,  --wait=SECONDS   wait SECONDS between posts.
  -e,  --error=NUMBER   exit if error occurred NUMBER times (0 unlimits).

HTTP options:
  -p,  --proxy=PROXY          set http proxy to PROXY (post).
  -g,  --get-proxy=PROXY      set http proxy to PROXY (get).
  -T,  --timeout=SECONDS      set the read timeout to SECONDS (post).
  -G,  --get-timeout=SECONDS  set the read timeout to SECONDS (get).
  -U,  --user-agent=AGENT     identify as AGENT instead of Mozzila.
EOF

	exit;
}

# parse input url
sub parse_url {
	my ($url) = @_;

	$URL = $url;

	if ($url =~ /^http:\/\/([^\/]+\.(?:2ch\.net|bbspink\.com))\/test\/read\.cgi\/([^\/]+)\/(\d+)\//) {
		($SERVER, $BBS, $THREAD) = ($1, $2, $3);
	} elsif ($url =~ /^http:\/\/([^\/]+\.(?:2ch\.net|bbspink\.com))\/([^\/]+)\//) {
		($SERVER, $BBS) = ($1, $2);
	} else {
		disp_init_error("$url: Invalid URL.");
	}
}

# read config file
sub read_config_file {
	my $path = $0;
	$path =~ s/[^\/\\]+$//;

	my ($buf, $block_name, %config);

	if (-e "$path$CONFIG") { 
		open INI, "$path$CONFIG" or disp_error ("Can't open: $!");

		foreach $buf (<INI>) {
			next if $buf =~ /^\#/;
			chomp $buf;
			if ($buf =~ /\[(\w+)\]/i) {
				$block_name = uc $1;
			} elsif ($block_name) {
				$config{$block_name} .= "$buf\n";
			}
		}

		close INI;
	} else {
		disp_error ("No exist: $path$CONFIG");
	}

	while ($buf = each %config) {
		$config{$buf} =~ s/\s+$//;
	}

	$NAME	= ($config{NAME} =~ /^([^\r\n]+)/)[0]
				if ($config{NAME} or $config{NAME} eq '0');
	$MAIL	= ($config{MAIL} =~ /^([^\r\n]+)/)[0]
				if ($config{MAIL} or $config{MAIL} eq '0');
	$BODY	= $config{BODY}		if $config{BODY};
	$PROXY	= $config{PROXY}	if $config{PROXY};
	$RAND	= $config{SOURCE}	if $config{SOURCE};
	$LOG_DIR= $config{OUTPUT}	if $config{OUTPUT};
	$NUMBER	= $config{NUMBER}
				if ($config{NUMBER} or $config{NUMBER} eq '0');
	$EXIT_ERROR_COUNT = $config{ERROR}
				if ($config{ERROR} or $config{ERROR} eq '0');
	if ($config{URL}) {
		($SERVER, $BBS, $THREAD) = (undef, undef, undef);
		parse_url((split(/\n/, $config{URL}))[0]);
	}
}

# read thread html
sub read_thread_html {
	if (!$QUIET) { print time_stamp()."Getting thread html..." }

	my $ua = LWP::UserAgent->new();
	my $h;
	if ($GET_PROXY) {
		$ua->proxy("http", "http://$GET_PROXY/");
		$h = HTTP::Headers->new('Pragma' => 'no-cache');
	}
	$ua->agent($USER_AGENT);
	$ua->timeout($GET_TIMEOUT);

	my $req = HTTP::Request->new("GET", $RAND, $h);
	my $res = $ua->request($req);

	my $content;
	if ($res->is_success) {
		$content = $res->content;
	}
	if (!$QUIET) { print " done.\n" }

	if (!$content) { disp_error("No content: $RAND") }
	jcode::sjis2euc(\$content);
	my ($front, $foot);
	if ($RAND =~ /\.html$/) {
		($front, $content) = split(/<\/font><\/b>\n<dt>/, $content, 2);
	} else {
		($front, $content) = split(/<dl><dt>/, $content, 2);
	}
	if (!$content) { disp_error("No content: $RAND") }
	($content, $foot) = split(/<\/dl>/, $content, 2);
	if (!$content) { disp_error("No content: $RAND") }

	if (!$QUIET) { print time_stamp()."Parsing thread html..." }

	foreach my $line (split(/<dt>/, $content)) {
		my $body;
		$body = $1 if $line =~ /<dd>(.+)$/;
		$body =~ s/<br><br>\s*$//gi;
		$body =~ s/ *<br> */\n/gi;
		$body =~ s/ +/ /g;
		$body =~ s/<a [^>]*>>>[^<]+<\/a>\s*//gi;
		$body =~ s/&gt;&gt;[\d\-]+\s*//gi;
		$body =~ s/>>[\d\-]+\s*//gi;
		$body =~ s/<a [^>]*>//gi;
		$body =~ s/<\/a>//gi;
		$body =~ s/&gt;/>/gi;
		$body =~ s/&lt;/</gi;
		$body =~ s/&quot;/"/gi;
		$body =~ s/&nbsp;/ /gi;
		$body =~ s/&amp;/&/gi;
		$body =~ s/ $//;
		jcode::euc2sjis(\$body) if $body;
		push @BODY, $body;
	}

	if (!$QUIET) { print " done.\n" }
}

# read subback.html
sub read_subback_html {
	my ($url) = @_;
	my (@thread);

	if (!$QUIET) { print time_stamp()."Getting subback.html..." }

	my $ua = LWP::UserAgent->new();
	my $h;
	if ($GET_PROXY) {
		$ua->proxy("http", "http://$GET_PROXY/");
		$h = HTTP::Headers->new('Pragma' => 'no-cache');
	}
	$ua->agent($USER_AGENT);
	$ua->timeout($GET_TIMEOUT);

	my $req = HTTP::Request->new("GET", $url, $h);
	my $res = $ua->request($req);

	my $content;
	if ($res->is_success) {
		$content = $res->content;
	}

	if (!$QUIET) { print " done.\n" }
	if (!$QUIET) { print time_stamp()."Parsing subback.html..." }

	my @lines = split(/[\r\n]/, $content);

	foreach my $buf (@lines) {
		push @thread, $1 if ($buf =~ m{<a href="(\d+)/l50">[^<>]*\((?:\d{1,2}|[1-8]\d\d)\)</a>});
	}

	if (!$QUIET) { print " done.\n" }

	return \@thread;
}

#---------------------------------------------------------------------

# display initial error and exit
sub disp_init_error {
	my ($message) = @_;

	print <<EOF;
$SCRIPT: $message
Usage: $SCRIPT [OPTION]... [URL]

Try `$SCRIPT --help' for more options.
EOF

	exit;
}

# display version and exit
sub disp_version {
	print <<EOF;
$SCRIPT $VERSION

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
EOF

	exit;
}

# display error and exit
sub disp_error {
	my ($message) = @_;

	if ($message) {
		print time_stamp();
		print "$message\n";
	} else {
		print "\n";
	}

	exit;
}

# display list
sub disp_list {
	if (!$QUIET) {
		print time_stamp();
		if ($RAND) {
			print "$RAND\n";
		} else {
			print "Fixed form sentence\n";
		}
		print "                => $URL\n";
	}
	if ($VERBOSE) {
		print "\n";
		print "  Connection:   ./success(may be forged) x/fail */error ?/check miss\n";
		print "  BBS error:    2/twice l/long m/many lines w/unwritable t/time\n";
		print "  Proxy error:  o/open b/blacklist s/strange r/referer c/cookie e/etc\n";
	}
}

#---------------------------------------------------------------------

# post thread
sub post_thread {
	my ($bbs, $thread) = @_;

	disp_list();

	$POST_NUM = 0;
	while (1) {
		$POST_CHECK = 0;
		$BODY = $BODY[$POST_NUM%($#BODY+1)] if $RAND;
		if ($VERBOSE) {
			print sprintf("\n %4d ->", $POST_NUM) if $POST_NUM % 50 == 0;
			print " " if $POST_NUM % 10 == 0;
		}
		if (@PROXY) {
			$START_TIME = time;
			post_message($bbs, $thread, $PROXY[$POST_NUM % ($#PROXY + 1)]);
		} else {
			post_message($bbs, $thread);
		}
		last if (++$POST_NUM >= $NUMBER) and $NUMBER;
		if (!$RAND) {
			$BODY .= " ";
			$BODY =~ s/ +$// if $POST_NUM % 47 == 0;
		}
		if ($DEBUG) { print time_stamp()."Sleeping $WAIT sec..." }
		select(undef, undef, undef, $WAIT);
		if ($DEBUG) { print " done.\n" }
	}

	if ($VERBOSE) { print "\n\n" }
	if (!$QUIET) {
		print time_stamp()."$POST_NUM messages sent.\n";
		print time_stamp()."All done.\n";
	}
}

# post bbs
sub post_bbs {
	my ($bbs) = @_;
	my ($threadref, $thread);

	$threadref = read_subback_html("http://$SERVER/$bbs/subback.html");

	disp_list();

	$POST_NUM = 0;
	foreach $thread (@$threadref) {
		$POST_CHECK = 0;
		$BODY = $BODY[$POST_NUM%($#BODY+1)] if $RAND;
		if ($VERBOSE) {
			print sprintf("\n %4d ->", $POST_NUM) if $POST_NUM % 50 == 0;
			print " " if $POST_NUM % 10 == 0;
		}
		if (@PROXY) {
			$START_TIME = time;
			post_message($bbs, $thread, $PROXY[$POST_NUM % ($#PROXY + 1)]);
		} else {
			post_message($bbs, $thread);
		}
		last if (++$POST_NUM >= $NUMBER) and $NUMBER;
		if (!$RAND) {
			$BODY .= " ";
			$BODY =~ s/ +$// if $POST_NUM % 47 == 0;
		}
		if ($DEBUG) { print time_stamp()."Sleeping $WAIT sec..." }
		select(undef, undef, undef, $WAIT);
		if ($DEBUG) { print " done.\n" }
	}

	if ($VERBOSE) { print "\n\n" }
	if (!$QUIET) {
		print time_stamp()."$POST_NUM messages sent.\n";
		print time_stamp()."All done.\n";
	}
}

#---------------------------------------------------------------------

# post one message to one thread
sub post_message {
	my ($bbs, $thread, $proxy) = @_;

	if ($DEBUG) { print time_stamp()."Setting contents to send..." }

	my $content	= "submit=%8F%91%82%AB%8D%9E%82%DE".
		"&FROM=".url_escape($NAME).
		"&mail=".url_escape($MAIL).
		"&MESSAGE=".url_escape($BODY).
		"&bbs=$bbs&key=$thread&time=".$POST_TIME;

	my $ua = LWP::UserAgent->new();
	$ua->proxy("http", "http://$proxy/") if $proxy;
	$ua->agent($USER_AGENT);
	$ua->timeout($TIMEOUT);

    my $h;
	if ($POST_COOKIE) {
		$h = HTTP::Headers->new(
			'Referer'	=> "http://$SERVER/test/read.cgi/$bbs/$thread/",
			'Cookie'	=> "NAME=".url_escape($NAME)."; MAIL=".url_escape($MAIL),
			'Cookie'	=> "PON=$POST_COOKIE");
	} else {
		$h = HTTP::Headers->new(
			'Referer'	=> "http://$SERVER/test/read.cgi/$bbs/$thread/",
			'Cookie'	=> "NAME=".url_escape($NAME)."; MAIL=".url_escape($MAIL));
	}

	# create a request
	my $req = HTTP::Request->new("POST", "http://$SERVER/test/bbs.cgi", $h, $content);

	if ($DEBUG) {
		print " done.\n";
		print "\tProxy:\t$proxy\n" if $proxy;
		print "\tServer:\t$SERVER\n";
		print "\tBBS:\t$bbs\n";
		print "\tThread:\t$thread\n";
		print "\tCookie:\t$POST_COOKIE\n";
		print "\tTime:\t$POST_TIME\n";
		print time_stamp()."Sending request...";
	}

	# pass request to the user agent and get a response back
	my $res;
	eval { $res = $ua->request($req) };
	if ($@) { disp_error ("Connection failed.") }

	if ($DEBUG) { print " done.\n" }

	# check the outcome of the response
	if ($res->is_success) {
		# cookie
		if ($res->content =~ /<title>( ݊mF |emF)<\/title>/) {
			$POST_COOKIE = $1 if ($res->headers->as_string =~ /(?:PON|SPID)=([^\s;]+)/);
			if ($DEBUG) { print time_stamp()."Retry.\n" }
			if ($POST_CHECK < 2) {
				$POST_CHECK++;
				post_message($bbs, $thread, $proxy);
			} else {
				if ($VERBOSE) { print 'c' }
				elsif ($DEBUG) { print time_stamp()."Cookie error.\n" }
				elsif ($MYPID) { print 'c' }
				elsif ($PROGRESS) { print time_stamp()."$proxy: cookie error.\n" }
			}
		# error
		} elsif ($res->content =~ /<title>dqqnqI<\/title>/) {
			# parse html
			my $message = $1 if ($res->content =~ /<font size=\+1 color=\#FF0000><b>(.+)<\/b><\/font><ul>(.+)<\/ul>/);
			if (!$message) {
				$message = $1 if ($res->content =~ />([^<>]+)<ul>/);
			}
			$message =~ s/<br>/ \- /gi;

			# charset convert
			my $emes = $message;
			jcode::convert(\$emes, $OCODE, 'sjis') if $OCODE ne 'sjis';

			# parse error
			my $mark;
			if ($message =~ /oqnwxK/)	{ $mark = 'o'; $ERROR_COUNT++ }
			elsif ($message =~ /ANZXK/)	{ $mark = 'b'; $ERROR_COUNT++ }
			elsif ($message =~ /ςȃzXg/)	{ $mark = 's'; $ERROR_COUNT++ }
			elsif ($message =~ /uEU/)	{ $mark = 'r'; $ERROR_COUNT++ }
			elsif ($message =~ /(?:|グ)/)	{
				if ($res->headers->as_string =~ /Date: *([^\r\n]+)/) {
					my $time = time_rfc822($1);
					$POST_TIME = $time - 30 if ($POST_TIME > $time);
				}
				if ($DEBUG) { print time_stamp()."Retry.\n" }
				if ($POST_CHECK < 2) {
					$POST_CHECK++;
					post_message($bbs, $thread, $proxy);
				} else {
					if ($VERBOSE) { print 't' }
					elsif ($DEBUG) { print time_stamp()."Time error.\n" }
					elsif ($MYPID) { print 't' }
					elsif ($PROGRESS) { print time_stamp()."$proxy: time error.\n" }
				}
				return;
			}
			elsif ($message =~ /QdJLR/)	{ $mark = '2' }
			elsif ($message =~ /{/)	{ $mark = 'l' }
			elsif ($message =~ /s/)	{ $mark = 'm' }
			elsif ($message =~ /܂/ and !$THREAD) { $mark = 'w' }
			else {
				$ERROR_COUNT++;
				$mark = 'e';
				open ERR, ">>$LOG_DIR/error.txt";
				print ERR time_stamp()."$emes\n";
				close ERR;
			}

			# print
			if ($VERBOSE) { print $mark }
			elsif ($DEBUG) { print time_stamp()."Error : $emes\n" }
			elsif ($MYPID) { print $mark }
			elsif ($PROGRESS) { print time_stamp()."$proxy: error : $emes\n" }

			# error exit
			if ($message =~ /(?:Ae|܂)/ or ($EXIT_ERROR_COUNT and $ERROR_COUNT >= $EXIT_ERROR_COUNT)) {
				if ($VERBOSE) { print "\n\n".time_stamp()."Exit for $emes\n" }
				exit;
			}
		# success?
		} elsif ($res->content =~ m{<title>݂܂B</title>}) {
			if ($proxy and $PROXY_CHECK) {
				# check success
				my $success = check_thread($bbs, $thread, $proxy);
				if (!$success) {
					if ($success eq '?') {
						if ($VERBOSE) { print "?" }
						elsif ($DEBUG) { print time_stamp()."Unidentified.\n" }
						elsif ($MYPID) { print "?" }
						elsif ($PROGRESS) { print time_stamp()."$proxy: unidentified.\n" }
						return;
					}
					if ($VERBOSE) { print "b" }
					elsif ($DEBUG) { print time_stamp()."Blacklisted.\n" }
					elsif ($MYPID) { print "b" }
					elsif ($PROGRESS) { print time_stamp()."$proxy: blacklisted.\n" }
					return;
				}
				# log
				my ($left, $suf);
				$left = time - $START_TIME;
				if ($left < 3) { $suf = "-03"; }
				elsif ($left < 5) { $suf = "-05"; }
				elsif ($left < 10) { $suf = "-10"; }
				else { $suf = "-mt10"; } # more than(w
				open PXY, ">>$LOG_DIR/okproxy$suf.txt";
				print PXY "$proxy\n";
				close PXY;
			}
			if ($VERBOSE) { print "." }
			elsif ($DEBUG) { print time_stamp()."Succeeded.\n" }
			elsif ($MYPID) { print "." }
			elsif ($PROGRESS) { print time_stamp()."$proxy: succeeded.\n" }
		# unknown error
		} else {
			if ($VERBOSE) { print "*" }
			elsif ($DEBUG) { print time_stamp()."Proxy error.\n" }
			elsif ($MYPID) { print "*" }
			elsif ($PROGRESS) { print time_stamp()."$proxy: proxy error.\n" }
		}
	# connection fail
	} else {
		if ($VERBOSE) { print "x" }
		elsif ($DEBUG) { print time_stamp()."Connection failure.\n" }
		elsif ($MYPID) { print "x" }
		elsif ($PROGRESS) { print time_stamp()."$proxy: connection failure.\n" }
	}
}

sub check_thread {
	my ($bbs, $thread, $proxy) = @_;

	if ($DEBUG) { print time_stamp()."Checking target thread.\n" }
	if ($DEBUG) { print time_stamp()."Getting target thread..." }

	my $ua = LWP::UserAgent->new();
	my $h;
	if ($GET_PROXY) {
		$ua->proxy("http", "http://$GET_PROXY/");
		$h = HTTP::Headers->new('Pragma' => 'no-cache');
	}
	$ua->agent($USER_AGENT);
	$ua->timeout($GET_TIMEOUT);

	my $req = HTTP::Request->new("GET", "http://$SERVER/test/read.cgi/$bbs/$thread/l1n", $h);
	my $res = $ua->request($req);

	if ($res->is_success) {
		if ($DEBUG) { print " done.\n" }
		if ($res->headers->as_string =~ /Last-Modified: *([^\r\n]+)/) {
			my $time = time_rfc822($1);
			my $now;
			if ($res->headers->as_string =~ /Date: *([^\r\n]+)/) {
				$now = time_rfc822($1);
			} else {
				if ($DEBUG) {
					print time_stamp()."Date header was not found.\n";
					print $res->headers->as_string;
				}
				return '?';
			}
			if ($DEBUG) {
				print "\tLast-Modified: $time\n";
				print "\tDate:          $now\n";
			}
			if ($now - $time < $TIMEOUT) {
				return 1;
			} else {
				return 0;
			}
		} else {
			if ($DEBUG) {
				print time_stamp()."Last-Modified header was not found.\n";
				print $res->headers->as_string;
			}
		}
	} else {
		if ($DEBUG) {
			print " done.\n";
			print time_stamp()."connection fail.\n";
		}
	}
	return '?';
}

#---------------------------------------------------------------------

sub time_rfc822 {
	my ($str) = @_;
	my ($mday, $mon, $year, $hour, $min, $sec);
	my %mhash = ('Jan' => 0, 'Feb' => 1, 'Mar' => 2, 'Apr' => 3, 'May' => 4,
				 'Jun' => 5, 'Jul' => 6, 'Aug' => 7, 'Sep' => 8, 'Oct' => 9,
				 'Nov' => 10, 'Dec' => 11);

	if ($str =~ /^\w+, *(\d+) +(\w+) +(\d+) +(\d+):(\d+):(\d+) +GMT$/) {
		($mday, $mon, $year, $hour, $min, $sec) = ($1, $2, $3, $4, $5, $6);
	} else {
		return 0;
	}
	return timegm($sec, $min, $hour, $mday, $mhash{$mon}, $year - 1900);
}

# time stamp
sub time_stamp {
	sprintf("--%02d:%02d:%02d--	", reverse((localtime)[0..2]));
}

# url escape
sub url_escape {
	my $ret = $_[0];
	$ret =~ s/(\W)/'%' . unpack('H2', $1)/eg if $ret;

	return $ret;
}
