#! /usr/local/bin/perl -w

require 5.005;
use strict;
use Net::Ping;
use Getopt::Long;
use LWP::UserAgent;

# flush
$| = 1;

# script name
my $SCRIPT			= "scan.pl";
my $VERSION			= "0.01.02";

# global
my ($REMOTE_HOST, $REMOTE_ADDR, $PATH, $OUT_DIR, $INDEPENDENT, $PING,
	$PING_TIMEOUT, $PORTS, $TIMEOUT, $USER_AGENT, $ADDRESS);

$PING_TIMEOUT	= 2;
$PORTS			= '80/81/82/3128/8000/8001/8002/8080/8081/8082';
$TIMEOUT		= 30;
$USER_AGENT		= 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)';

# get options
GETOPT:{
	my ($independent, $ping, $ping_timeout, $ports, $timeout,
	$user_agent) = get_options ();

	$INDEPENDENT	= $independent	if defined $independent;
	$PING			= $ping			if defined $ping;
	$PING_TIMEOUT	= $ping_timeout	if defined $ping_timeout;
	$PORTS			= $ports		if defined $ports;
	$TIMEOUT		= $timeout		if defined $timeout;
	$USER_AGENT		= $user_agent	if defined $user_agent;
}

#---------------------------------------------------------------------

# get options
sub get_options {
	my ($disp_version, $disp_help, $independent, $ping, $ping_timeout,
	$ports, $timeout, $user_agent);

	Getopt::Long::Configure ("bundling");
	GetOptions (
		'V|version'		=> \$disp_version,
		'h|help'		=> \$disp_help,

		'I|independent'	=> \$independent,

		'P|ping'		=> \$ping,
		't|ping-timeout=i'=>\$ping_timeout,

		'p|port=s'		=> \$ports,
		'T|timeout=i'	=> \$timeout,
		'U|user-agent=s'=> \$user_agent,

		'<>'			=> \&parse_address
	);

	if ($disp_version) { disp_version() }
	elsif ($disp_help) { disp_help() }

	($independent, $ping, $ping_timeout, $ports, $timeout, $user_agent);
}

# display help and exit
sub disp_help {
	print <<EOF;
$SCRIPT $VERSION, an advanced proxy host search tool for 2ch.
Usage: $SCRIPT [OPTION]... [ADDRESS]

Mandatory arguments to long options are mandatory for short options too.

Startup:
  -V,  --version   display the version of $SCRIPT and exit.
  -h,  --help      print this help.

Ping options:
  -P,  --ping                  ping before get.
  -t,  --ping-timeout=SECONDS  set the ping timeout to SECONDS.

HTTP options:
  -p,  --port=PORT[/PORT]...   set the remote host's ports to PORT.
  -T,  --timeout=SECONDS       set the read timeout to SECONDS.
  -U,  --user-agent=AGENT      identify as AGENT instead of Mozzila.
EOF

	exit;
}

# display version and exit
sub disp_version {
	print <<EOF;
$SCRIPT $VERSION

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
EOF

	exit;
}

# display initial error and exit
sub disp_init_error {
	my ($message) = @_;

	print <<EOF;
$SCRIPT: $message
Usage: $SCRIPT [OPTION]... [ADDRESS]

Try `$SCRIPT --help' for more options.
EOF

	exit;
}

sub parse_address {
	my ($addr) = @_;

	if ($addr =~ m{^((?:25[0-5]|2[0-4]\d|1\d\d|\d{1,2})\.(?:25[0-5]|2[0-4]\d|1\d\d|\d{1,2})\.(?:25[0-5]|2[0-4]\d|1\d\d|\d{1,2}))}) {
		$ADDRESS = $1;
	} else {
		disp_init_error('invalid ADDRESS.');
	}
}

#---------------------------------------------------------------------

MAIN:{
	disp_init_error('missing ADDRESS') if not defined $ADDRESS;

	$PATH = $0;
	$PATH =~ s/[^\/\\]+$//;

	if (!$INDEPENDENT) {
		my @port = split(/\//, $PORTS);
		for (my $i = 0; $i <= $#port; $i += 2) {
			if ($i+1 <= $#port) {
				if ($PING) {
					system 1, 'perl "'.$PATH.$SCRIPT.'" -I -P -p'.$port[$i].'/'.$port[$i+1].' '.$ADDRESS;
				} else {
					system 1, 'perl "'.$PATH.$SCRIPT.'" -I -p'.$port[$i].'/'.$port[$i+1].' '.$ADDRESS;
				}
			} else {
				if ($PING) {
					system 1, 'perl "'.$PATH.$SCRIPT.'" -I -P -p'.$port[$i].' '.$ADDRESS;
				} else {
					system 1, 'perl "'.$PATH.$SCRIPT.'" -I -p'.$port[$i].' '.$ADDRESS;
				}
			}
			sleep 2;
		}
		exit;
	}

	my ($sec, $min, $hour, $mday, $mon, $year) = localtime;
	$OUT_DIR = sprintf("search%02d%02d%02d%02d", $mon + 1, $mday, $hour, $min);

	mkdir $PATH.$OUT_DIR, 0777;

	check_my_host();

	# 0: network address, 255: broadcast address
	for (my $i = 1; $i < 255; $i++) {
		if ($PING) {
			next unless ping("$ADDRESS.$i");
		}
		foreach my $port (split(/\//, $PORTS)) {
			check_proxy("$ADDRESS.$i", $port);
		}
	}
}

#---------------------------------------------------------------------

sub check_my_host {
	my $ua = LWP::UserAgent->new();
	$ua->agent($USER_AGENT);
	$ua->timeout($TIMEOUT);

	my $req = HTTP::Request->new("GET", "http://www.taruo.net/e/");
	my $res = $ua->request($req);

	disp_error("Connection failure.") if (!$res->is_success);

	if ($res->content =~ m{<TD nowrap>REMOTE_HOST</TD>\s+<TD><tt>([^<>]+)</tt>}) {
		$REMOTE_HOST = $1;
		print time_stamp()."REMOTE_HOST: $REMOTE_HOST.\n";
	} else {
		disp_error("No exist: REMOTE_HOST.")
	}

	if ($res->content =~ m{<TD nowrap>REMOTE_ADDR</TD>\s+<TD><tt>([0-9\.]+).*</tt>}) {
		$REMOTE_ADDR = $1;
		print time_stamp()."REMOTE_ADDR: $REMOTE_ADDR.\n";
	} else {
		disp_error("No exist: REMOTE_ADDR.")
	}
}

sub ping {
	my ($host) = @_;

	my $p = Net::Ping->new("icmp");
	my $alive;
	$alive = 1 if $p->ping($host, $PING_TIMEOUT);
	$p->close();

	if (!$alive) {
		print time_stamp()."$host is unreachable.\n";
		return 0;
	}

	1;
}
sub check_proxy {
	my ($host, $port) = @_;

	my $ua = LWP::UserAgent->new();
	$ua->proxy("http", "http://$host:$port/");
	$ua->agent($USER_AGENT);
	$ua->timeout($TIMEOUT);

	my $req = HTTP::Request->new("GET", "http://www.taruo.net/e/");
	my $res = $ua->request($req);

	if (!$res->is_success) {
		print time_stamp()."$host:$port is not proxy.\n";
		return;
	}

	my $content = $res->content;

	if ($content !~ m{<a href="http://eieweb\.yz\.yamagata\-u\.ac\.jp/~taruo/">Home</a>}) {
		print time_stamp()."$host:$port is not opened proxy.\n";
		return;
	}

	if ($content =~ /(?:$REMOTE_HOST|$REMOTE_ADDR)/) {
		print time_stamp()."$host:$port is not anonymous proxy.\n";
		open (PXY, ">>$PATH$OUT_DIR/nonanonymous.txt");
		print PXY "$host:$port\n";
		close PXY;
		return;
	}

	print time_stamp()."$host:$port is anonymous proxy.\n";
	open (PXY, ">>$PATH$OUT_DIR/anonymous.txt");
	print PXY "$host:$port\n";
	close PXY;

	system 'perl "'.$PATH.'age2ch.pl" -c -p'.$host.':'.$port.' -S -o'.$OUT_DIR.' http://pc2.2ch.net/software/';
}

#---------------------------------------------------------------------

# display error and exit
sub disp_error {
	my ($message) = @_;

	if ($message) {
		print time_stamp();
		print "$message\n";
	} else {
		print "\n";
	}

	exit;
}

#---------------------------------------------------------------------

# time stamp
sub time_stamp {
	sprintf("--%02d:%02d:%02d--	", reverse((localtime)[0..2]));
}
