﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace nispi
{
    class AnchorMethod
    {
        public AnchorMethod()
        {
        }

        public static bool GetAnchor(string number, ref string type, ref string begin, ref string end)
        {
            //コマンドがある場合。
            if ((number.Contains('l') == true) || (number.Contains('n') == true))
            {
                if (number.StartsWith("ln") == true)
                {
                    begin = number.Substring(2, number.Length - 2);
                    type = "ln";
                }
                else if (number.StartsWith("n") == true)
                {
                    begin = number.Substring(1, number.Length - 1);
                    type = "one";
                }
                else if (number.StartsWith("l") == true)
                {
                    begin = number.Substring(1, number.Length - 1);
                    type = "l";
                }
                else
                    return false;

                int temp;
                if (Int32.TryParse(begin, out temp) == false)
                    return false;

                return true;
            }
            //コマンドがない場合
            else
            {
                string[] row = number.Split('-');

                if (row.Length == 1)
                {
                    //23 数字のみ
                    type = "one";
                    begin = end = number;
                }
                else if ((row[0].Length == 0) && (row.Length == 2))
                {
                    //-23 始まりがマイナスで２番目が数字
                    type = "fromTop";
                    begin = "0";
                    end = row[1];
                }
                else if ((row[1].Length == 0) && (row.Length == 2))
                {
                    //23- 始まりが数字で２番目がマイナス
                    type = "toBottom";
                    begin = row[0];
                    end = "0";
                }
                else if ((row[1].StartsWith(">>") == true) && (row.Length == 2))
                {
                    //23-24 始まりと、３番目が数字で、２番目がマイナス
                    type = "between";
                    begin = row[0];
                    end = row[1].Substring(2, row[1].Length - 2);
                }
                else if (row.Length == 2)
                {
                    //23-24 始まりと、３番目が数字で、２番目がマイナス
                    type = "between";
                    begin = row[0];
                    end = row[1];
                }
                else
                {
                    return false;
                }
                int temp;
                if (Int32.TryParse(begin, out temp) == false)
                    return false;
                if (Int32.TryParse(end, out temp) == false)
                    return false;

                return true;
            }
        }
    }
}
